/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.DefinitionSite;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.OptimizeCalls;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.SpecializationAwareCompilerPass;
import com.google.javascript.jscomp.SpecializeModule;
import com.google.javascript.jscomp.UseSite;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

class DevirtualizePrototypeMethods
implements OptimizeCalls.CallGraphCompilerPass,
SpecializationAwareCompilerPass {
    private final AbstractCompiler compiler;
    private SpecializeModule.SpecializationState specializationState;

    DevirtualizePrototypeMethods(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void enableSpecialization(SpecializeModule.SpecializationState specializationState) {
        this.specializationState = specializationState;
    }

    @Override
    public void process(Node node, Node node2) {
        SimpleDefinitionFinder simpleDefinitionFinder = new SimpleDefinitionFinder(this.compiler);
        simpleDefinitionFinder.process(node, node2);
        this.process(node, node2, simpleDefinitionFinder);
    }

    @Override
    public void process(Node node, Node node2, SimpleDefinitionFinder simpleDefinitionFinder) {
        for (DefinitionSite definitionSite : simpleDefinitionFinder.getDefinitionSites()) {
            this.rewriteDefinitionIfEligible(definitionSite, simpleDefinitionFinder);
        }
    }

    private static boolean isCall(UseSite useSite) {
        Node node = useSite.node;
        Node node2 = node.getParent();
        return node2.getFirstChild() == node && NodeUtil.isCall(node2);
    }

    private static boolean isPrototypeMethodDefinition(Node node) {
        Node node2 = node.getParent();
        if (node2 == null) {
            return false;
        }
        Node node3 = node2.getParent();
        if (node3 == null || node2.getFirstChild() != node || !NodeUtil.isExprAssign(node3)) {
            return false;
        }
        Node node4 = node2.getLastChild();
        if (node4 == null || !NodeUtil.isFunction(node4)) {
            return false;
        }
        if (!NodeUtil.isGetProp(node)) {
            return false;
        }
        Node node5 = node.getFirstChild();
        return NodeUtil.isGetProp(node5) && node5.getLastChild().getString().equals("prototype");
    }

    private String getRewrittenMethodName(String string) {
        return "JSCompiler_StaticMethods_" + string;
    }

    private void rewriteDefinitionIfEligible(DefinitionSite definitionSite, SimpleDefinitionFinder simpleDefinitionFinder) {
        Object object;
        if (definitionSite.inExterns || !definitionSite.inGlobalScope || !this.isEligibleDefinition(simpleDefinitionFinder, definitionSite)) {
            return;
        }
        Node node = definitionSite.node;
        if (!DevirtualizePrototypeMethods.isPrototypeMethodDefinition(node)) {
            return;
        }
        for (object = node.getParent(); object != null; object = ((Node)object).getParent()) {
            if (!NodeUtil.isControlStructure((Node)object)) continue;
            return;
        }
        object = this.getRewrittenMethodName(node.getLastChild().getString());
        this.rewriteDefinition(node, (String)object);
        this.rewriteCallSites(simpleDefinitionFinder, definitionSite.definition, (String)object);
    }

    private boolean isEligibleDefinition(SimpleDefinitionFinder simpleDefinitionFinder, DefinitionSite definitionSite) {
        DefinitionsRemover.Definition definition = definitionSite.definition;
        JSModule jSModule = definitionSite.module;
        Node node = definition.getRValue();
        if (node == null || !NodeUtil.isFunction(node) || NodeUtil.isVarArgsFunction(node)) {
            return false;
        }
        Node node2 = definition.getLValue();
        if (node2 == null || !NodeUtil.isGetProp(node2)) {
            return false;
        }
        CodingConvention codingConvention = this.compiler.getCodingConvention();
        if (codingConvention.isExported(node2.getLastChild().getString())) {
            return false;
        }
        Collection<UseSite> collection = simpleDefinitionFinder.getUseSites(definition);
        if (collection.isEmpty()) {
            return false;
        }
        JSModuleGraph jSModuleGraph = this.compiler.getModuleGraph();
        for (UseSite useSite : collection) {
            if (!DevirtualizePrototypeMethods.isCall(useSite)) {
                return false;
            }
            Node node3 = useSite.node;
            if (this.specializationState != null && !this.specializationState.canFixupSpecializedFunctionContainingNode(node3)) {
                return false;
            }
            Collection<DefinitionsRemover.Definition> collection2 = simpleDefinitionFinder.getDefinitionsReferencedAt(node3);
            if (collection2.size() > 1) {
                return false;
            }
            Preconditions.checkState((!collection2.isEmpty() ? 1 : 0) != 0);
            Preconditions.checkState((boolean)collection2.contains(definition));
            JSModule jSModule2 = useSite.module;
            if (jSModule == jSModule2 || jSModule2 != null && jSModuleGraph.dependsOn(jSModule2, jSModule)) continue;
            return false;
        }
        return true;
    }

    private void rewriteCallSites(SimpleDefinitionFinder simpleDefinitionFinder, DefinitionsRemover.Definition definition, String string) {
        Collection<UseSite> collection = simpleDefinitionFinder.getUseSites(definition);
        for (UseSite useSite : collection) {
            Node node = useSite.node;
            Node node2 = node.getParent();
            Node node3 = node.getFirstChild();
            node.removeChild(node3);
            node2.replaceChild(node, node3);
            node2.addChildToFront(Node.newString(38, string).copyInformationFrom(node));
            this.compiler.reportCodeChange();
            if (this.specializationState == null) continue;
            this.specializationState.reportSpecializedFunctionContainingNode(node2);
        }
    }

    private void rewriteDefinition(Node node, String string) {
        Node node2 = node.getParent();
        Node node3 = node2.getLastChild();
        Node node4 = node2.getParent();
        Node node5 = node4.getParent();
        Node node6 = Node.newString(38, string).copyInformationFrom(node2.getFirstChild());
        if (this.specializationState != null) {
            this.specializationState.reportRemovedFunction(node3, node5);
        }
        node2.removeChild(node3);
        node6.addChildToFront(node3);
        node5.replaceChild(node4, new Node(118, node6));
        String string2 = string + "$self";
        Node node7 = node3.getFirstChild().getNext();
        node7.addChildToFront(Node.newString(38, string2).copyInformationFrom(node3));
        Node node8 = node3.getLastChild();
        this.replaceReferencesToThis(node8, string2);
        this.fixFunctionType(node3);
        this.compiler.reportCodeChange();
    }

    private void fixFunctionType(Node node) {
        FunctionType functionType = (FunctionType)node.getJSType();
        if (functionType != null) {
            Serializable serializable2;
            JSTypeRegistry jSTypeRegistry = this.compiler.getTypeRegistry();
            ArrayList arrayList = Lists.newArrayList();
            arrayList.add(functionType.getTypeOfThis());
            for (Serializable serializable2 : functionType.getParameters()) {
                arrayList.add(serializable2.getJSType());
            }
            ObjectType objectType = jSTypeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
            serializable2 = functionType.getReturnType();
            JSType jSType = jSTypeRegistry.createFunctionType(objectType, (JSType)serializable2, arrayList);
            node.setJSType(jSType);
        }
    }

    private void replaceReferencesToThis(Node node, String string) {
        if (NodeUtil.isFunction(node)) {
            return;
        }
        for (Node node2 : node.children()) {
            if (NodeUtil.isThis(node2)) {
                Node node3 = Node.newString(38, string);
                node3.setJSType(node2.getJSType());
                node.replaceChild(node2, node3);
                continue;
            }
            this.replaceReferencesToThis(node2, string);
        }
    }
}

