/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CheckAccessControls;
import com.google.javascript.jscomp.CheckGlobalNames;
import com.google.javascript.jscomp.CheckGlobalThis;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CheckRegExp;
import com.google.javascript.jscomp.CheckSideEffects;
import com.google.javascript.jscomp.CheckUnreachableCode;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.DisambiguateProperties;
import com.google.javascript.jscomp.ProcessDefines;
import com.google.javascript.jscomp.ProcessTweaks;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.jscomp.TypeCheck;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.jscomp.VariableReferenceCheck;
import java.util.List;
import java.util.Map;

public class DiagnosticGroups {
    private static final Map<String, DiagnosticGroup> groupsByName = Maps.newHashMap();
    static final String DIAGNOSTIC_GROUP_NAMES = "accessControls, ambiguousFunctionDecl, checkRegExp,checkTypes, checkVars, constantProperty, deprecated, externsValidation, fileoverviewTags, globalThis, internetExplorerChecks, nvalidCasts, missingProperties, nonStandardJsDocs, strictModuleDepCheck, typeInvalidation, undefinedVars, unknownDefines, uselessCode, visibility";
    public static DiagnosticGroup GLOBAL_THIS = DiagnosticGroups.registerGroup("globalThis", new DiagnosticGroup(new DiagnosticType[]{CheckGlobalThis.GLOBAL_THIS}));
    public static DiagnosticGroup DEPRECATED = DiagnosticGroups.registerGroup("deprecated", new DiagnosticGroup(CheckAccessControls.DEPRECATED_NAME, CheckAccessControls.DEPRECATED_NAME_REASON, CheckAccessControls.DEPRECATED_PROP, CheckAccessControls.DEPRECATED_PROP_REASON, CheckAccessControls.DEPRECATED_CLASS, CheckAccessControls.DEPRECATED_CLASS_REASON));
    public static DiagnosticGroup VISIBILITY = DiagnosticGroups.registerGroup("visibility", new DiagnosticGroup(CheckAccessControls.BAD_PRIVATE_GLOBAL_ACCESS, CheckAccessControls.BAD_PRIVATE_PROPERTY_ACCESS, CheckAccessControls.BAD_PROTECTED_PROPERTY_ACCESS, CheckAccessControls.PRIVATE_OVERRIDE, CheckAccessControls.VISIBILITY_MISMATCH));
    public static DiagnosticGroup CONSTANT_PROPERTY = DiagnosticGroups.registerGroup("constantProperty", new DiagnosticGroup(new DiagnosticType[]{CheckAccessControls.CONST_PROPERTY_REASSIGNED_VALUE}));
    public static DiagnosticGroup NON_STANDARD_JSDOC = DiagnosticGroups.registerGroup("nonStandardJsDocs", new DiagnosticGroup(new DiagnosticType[]{RhinoErrorReporter.BAD_JSDOC_ANNOTATION}));
    public static DiagnosticGroup ACCESS_CONTROLS = DiagnosticGroups.registerGroup("accessControls", new DiagnosticGroup(DEPRECATED, VISIBILITY));
    public static DiagnosticGroup INVALID_CASTS = DiagnosticGroups.registerGroup("invalidCasts", new DiagnosticGroup(new DiagnosticType[]{TypeValidator.INVALID_CAST}));
    public static DiagnosticGroup FILEOVERVIEW_JSDOC = DiagnosticGroups.registerGroup("fileoverviewTags", new DiagnosticGroup(new DiagnosticType[]{RhinoErrorReporter.EXTRA_FILEOVERVIEW}));
    public static DiagnosticGroup STRICT_MODULE_DEP_CHECK = DiagnosticGroups.registerGroup("strictModuleDepCheck", new DiagnosticGroup(VarCheck.STRICT_MODULE_DEP_ERROR, CheckGlobalNames.STRICT_MODULE_DEP_QNAME));
    public static DiagnosticGroup EXTERNS_VALIDATION = DiagnosticGroups.registerGroup("externsValidation", new DiagnosticGroup(VarCheck.NAME_REFERENCE_IN_EXTERNS_ERROR, VarCheck.UNDEFINED_EXTERN_VAR_ERROR));
    public static DiagnosticGroup AMBIGUOUS_FUNCTION_DECL = DiagnosticGroups.registerGroup("ambiguousFunctionDecl", new DiagnosticGroup(new DiagnosticType[]{VariableReferenceCheck.AMBIGUOUS_FUNCTION_DECL}));
    public static DiagnosticGroup UNKNOWN_DEFINES = DiagnosticGroups.registerGroup("unknownDefines", new DiagnosticGroup(new DiagnosticType[]{ProcessDefines.UNKNOWN_DEFINE_WARNING}));
    public static DiagnosticGroup TWEAKS = DiagnosticGroups.registerGroup("tweakValidation", new DiagnosticGroup(ProcessTweaks.INVALID_TWEAK_DEFAULT_VALUE_WARNING, ProcessTweaks.TWEAK_WRONG_GETTER_TYPE_WARNING, ProcessTweaks.UNKNOWN_TWEAK_WARNING));
    public static DiagnosticGroup MISSING_PROPERTIES = DiagnosticGroups.registerGroup("missingProperties", new DiagnosticGroup(new DiagnosticType[]{TypeCheck.INEXISTENT_PROPERTY}));
    public static DiagnosticGroup INTERNET_EXPLORER_CHECKS = DiagnosticGroups.registerGroup("internetExplorerChecks", new DiagnosticGroup(new DiagnosticType[]{RhinoErrorReporter.TRAILING_COMMA}));
    public static DiagnosticGroup UNDEFINED_VARIABLES = DiagnosticGroups.registerGroup("undefinedVars", new DiagnosticGroup(new DiagnosticType[]{VarCheck.UNDEFINED_VAR_ERROR}));
    public static DiagnosticGroup CHECK_REGEXP = DiagnosticGroups.registerGroup("checkRegExp", new DiagnosticGroup(new DiagnosticType[]{CheckRegExp.REGEXP_REFERENCE}));
    public static DiagnosticGroup CHECK_TYPES = DiagnosticGroups.registerGroup("checkTypes", new DiagnosticGroup(TypeValidator.ALL_DIAGNOSTICS, TypeCheck.ALL_DIAGNOSTICS));
    public static DiagnosticGroup CHECK_VARIABLES = DiagnosticGroups.registerGroup("checkVars", new DiagnosticGroup(VarCheck.UNDEFINED_VAR_ERROR, SyntacticScopeCreator.VAR_MULTIPLY_DECLARED_ERROR));
    public static DiagnosticGroup CHECK_USELESS_CODE = DiagnosticGroups.registerGroup("uselessCode", new DiagnosticGroup(CheckSideEffects.USELESS_CODE_ERROR, CheckUnreachableCode.UNREACHABLE_CODE));
    public static DiagnosticGroup TYPE_INVALIDATION = DiagnosticGroups.registerGroup("typeInvalidation", new DiagnosticGroup(new DiagnosticType[]{DisambiguateProperties.Warnings.INVALIDATION}));

    static DiagnosticGroup registerGroup(String string, DiagnosticGroup diagnosticGroup) {
        groupsByName.put(string, diagnosticGroup);
        return diagnosticGroup;
    }

    protected Map<String, DiagnosticGroup> getRegisteredGroups() {
        return ImmutableMap.copyOf(groupsByName);
    }

    protected DiagnosticGroup forName(String string) {
        return groupsByName.get(string);
    }

    void setWarningLevels(CompilerOptions compilerOptions, List<String> list, CheckLevel checkLevel) {
        for (String string : list) {
            DiagnosticGroup diagnosticGroup = this.forName(string);
            Preconditions.checkNotNull((Object)diagnosticGroup, (Object)("No warning class for name: " + string));
            compilerOptions.setWarningLevel(diagnosticGroup, checkLevel);
        }
    }
}

