/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class DotFormatter {
    private static final String INDENT = "  ";
    private static final String ARROW = " -> ";
    private static final String LINE = " -- ";
    private HashMap<Node, Integer> assignments = new HashMap();
    private int keyCount = 0;
    private Appendable builder;
    private final ControlFlowGraph<Node> cfg;
    private final boolean printAnnotations;

    private DotFormatter() {
        this.builder = new StringBuilder();
        this.cfg = null;
        this.printAnnotations = false;
    }

    private DotFormatter(Node node, ControlFlowGraph<Node> controlFlowGraph, Appendable appendable, boolean bl) throws IOException {
        this.cfg = controlFlowGraph;
        this.builder = appendable;
        this.printAnnotations = bl;
        this.formatPreamble();
        this.traverseNodes(node);
        this.formatConclusion();
    }

    public static String toDot(Node node) throws IOException {
        return DotFormatter.toDot(node, null);
    }

    static String toDot(Node node, ControlFlowGraph<Node> controlFlowGraph, boolean bl) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        new DotFormatter(node, controlFlowGraph, stringBuilder, bl);
        return stringBuilder.toString();
    }

    static String toDot(Node node, ControlFlowGraph<Node> controlFlowGraph) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        new DotFormatter(node, controlFlowGraph, stringBuilder, false);
        return stringBuilder.toString();
    }

    static void appendDot(Node node, ControlFlowGraph<Node> controlFlowGraph, Appendable appendable) throws IOException {
        new DotFormatter(node, controlFlowGraph, appendable, false);
    }

    static DotFormatter newInstanceForTesting() {
        return new DotFormatter();
    }

    private void traverseNodes(Node node) throws IOException {
        Object object;
        int n = this.key(node);
        for (object = node.getFirstChild(); object != null; object = ((Node)object).getNext()) {
            int n2 = this.key((Node)object);
            this.builder.append(INDENT);
            this.builder.append(this.formatNodeName(n));
            this.builder.append(ARROW);
            this.builder.append(this.formatNodeName(n2));
            this.builder.append(" [weight=1];\n");
            this.traverseNodes((Node)object);
        }
        if (this.cfg != null && this.cfg.hasNode(node)) {
            int n3;
            object = this.cfg.getOutEdges(node);
            Object[] objectArray = new String[object.size()];
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                DiGraph.DiGraphEdge diGraphEdge = (DiGraph.DiGraphEdge)object.get(n3);
                DiGraph.DiGraphNode diGraphNode = diGraphEdge.getDestination();
                String string = null;
                if (diGraphNode == this.cfg.getImplicitReturn()) {
                    string = "RETURN";
                } else {
                    int n4 = this.key((Node)diGraphNode.getValue());
                    string = this.formatNodeName(n4);
                }
                objectArray[n3] = this.formatNodeName(n) + ARROW + string + " [label=\"" + ((ControlFlowGraph.Branch)((Object)diGraphEdge.getValue())).toString() + "\", " + "fontcolor=\"red\", " + "weight=0.01, color=\"red\"];\n";
            }
            Arrays.sort(objectArray);
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                this.builder.append(INDENT);
                this.builder.append((CharSequence)objectArray[n3]);
            }
        }
    }

    int key(Node node) throws IOException {
        Integer n = this.assignments.get(node);
        if (n == null) {
            Object a;
            n = this.keyCount++;
            this.assignments.put(node, n);
            this.builder.append(INDENT);
            this.builder.append(this.formatNodeName(n));
            this.builder.append(" [label=\"");
            this.builder.append(this.name(node));
            JSType jSType = node.getJSType();
            if (jSType != null) {
                this.builder.append(" : ");
                this.builder.append(jSType.toString());
            }
            if (this.printAnnotations && this.cfg != null && this.cfg.hasNode(node) && (a = this.cfg.getNode(node).getAnnotation()) != null) {
                this.builder.append("\\n");
                this.builder.append(a.toString());
            }
            this.builder.append("\"");
            if (node.getJSDocInfo() != null) {
                this.builder.append(" color=\"green\"");
            }
            this.builder.append("];\n");
        }
        return n;
    }

    private String name(Node node) {
        int n = node.getType();
        switch (n) {
            case 122: {
                return "VOID";
            }
        }
        return Token.name(n);
    }

    private String formatNodeName(Integer n) {
        return "node" + n;
    }

    private void formatPreamble() throws IOException {
        this.builder.append("digraph AST {\n");
        this.builder.append(INDENT);
        this.builder.append("node [color=lightblue2, style=filled];\n");
    }

    private void formatConclusion() throws IOException {
        this.builder.append("}\n");
    }

    public static String toDot(GraphvizGraph graphvizGraph) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(graphvizGraph.isDirected() ? "digraph" : "graph");
        stringBuilder.append(INDENT);
        stringBuilder.append(graphvizGraph.getName());
        stringBuilder.append(" {\n");
        stringBuilder.append(INDENT);
        stringBuilder.append("node [color=lightblue2, style=filled];\n");
        String string = graphvizGraph.isDirected() ? ARROW : LINE;
        List<GraphvizGraph.GraphvizNode> list = graphvizGraph.getGraphvizNodes();
        Object[] objectArray = new String[list.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            GraphvizGraph.GraphvizNode graphvizNode = list.get(i);
            objectArray[i] = graphvizNode.getId() + " [label=\"" + graphvizNode.getLabel() + "\" color=\"" + graphvizNode.getColor() + "\"]";
        }
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            stringBuilder.append(INDENT);
            stringBuilder.append((String)object);
            stringBuilder.append(";\n");
        }
        List<GraphvizGraph.GraphvizEdge> list2 = graphvizGraph.getGraphvizEdges();
        Object[] objectArray2 = new String[list2.size()];
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object;
            object = (GraphvizGraph.GraphvizEdge)list2.get(i);
            objectArray2[i] = object.getNode1Id() + string + object.getNode2Id();
        }
        Arrays.sort(objectArray2);
        for (Object object : objectArray2) {
            stringBuilder.append(INDENT);
            stringBuilder.append((String)object);
            stringBuilder.append(";\n");
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }
}

