/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AnonymousFunctionNamingCallback;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeNameExtractor;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import java.io.Serializable;
import java.util.Map;

class FunctionNames
implements CompilerPass,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient AbstractCompiler compiler;
    private final Map<Node, FunctionRecord> functionMap = Maps.newLinkedHashMap();
    private final transient FunctionListExtractor functionListExtractor;

    FunctionNames(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.functionListExtractor = new FunctionListExtractor(this.functionMap);
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this.functionListExtractor);
        FunctionExpressionNamer functionExpressionNamer = new FunctionExpressionNamer(this.functionMap);
        AnonymousFunctionNamingCallback anonymousFunctionNamingCallback = new AnonymousFunctionNamingCallback(functionExpressionNamer);
        NodeTraversal.traverse(this.compiler, node2, anonymousFunctionNamingCallback);
    }

    public Iterable<Node> getFunctionNodeList() {
        return this.functionMap.keySet();
    }

    public int getFunctionId(Node node) {
        FunctionRecord functionRecord = this.functionMap.get(node);
        if (functionRecord != null) {
            return functionRecord.id;
        }
        return -1;
    }

    public String getFunctionName(Node node) {
        Node node2;
        FunctionRecord functionRecord = this.functionMap.get(node);
        if (functionRecord == null) {
            return null;
        }
        String string = functionRecord.name;
        if (string.isEmpty()) {
            string = "<anonymous>";
        }
        if ((node2 = functionRecord.parent) != null) {
            string = this.getFunctionName(node2) + "::" + string;
        }
        string = string.replaceAll("::this\\.", ".");
        string = string.replaceAll("\\.\\.", ".");
        string = string.replaceFirst("^(<anonymous>::)*", "");
        return string;
    }

    private static class FunctionExpressionNamer
    implements AnonymousFunctionNamingCallback.FunctionNamer {
        private static final char DELIMITER = '.';
        private static final NodeNameExtractor extractor = new NodeNameExtractor('.');
        private final Map<Node, FunctionRecord> functionMap;

        FunctionExpressionNamer(Map<Node, FunctionRecord> map) {
            this.functionMap = map;
        }

        @Override
        public final String getName(Node node) {
            return extractor.getName(node);
        }

        @Override
        public final void setFunctionName(String string, Node node) {
            FunctionRecord functionRecord = this.functionMap.get(node);
            assert (functionRecord != null);
            assert (functionRecord.name.isEmpty());
            functionRecord.name = string;
        }

        @Override
        public final String getCombinedName(String string, String string2) {
            return string + '.' + string2;
        }
    }

    private static class FunctionListExtractor
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Map<Node, FunctionRecord> functionMap;
        private int nextId = 0;

        FunctionListExtractor(Map<Node, FunctionRecord> map) {
            this.functionMap = map;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 105) {
                Node node3 = node.getFirstChild();
                String string = node3.getString();
                Node node4 = nodeTraversal.getEnclosingFunction();
                this.functionMap.put(node, new FunctionRecord(this.nextId, node4, string));
                ++this.nextId;
            }
        }
    }

    private static class FunctionRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int id;
        public final Node parent;
        public String name;

        FunctionRecord(int n, Node node, String string) {
            this.id = n;
            this.parent = node;
            this.name = string;
        }
    }
}

