/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.FindExportableNodes;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PrepareAst;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;

class GenerateExports
implements CompilerPass {
    private static final String PROTOTYPE_PROPERTY = "prototype";
    private final AbstractCompiler compiler;
    private final String exportSymbolFunction;
    private final String exportPropertyFunction;

    GenerateExports(AbstractCompiler abstractCompiler, String string, String string2) {
        Preconditions.checkNotNull((Object)abstractCompiler);
        Preconditions.checkNotNull((Object)string);
        Preconditions.checkNotNull((Object)string2);
        this.compiler = abstractCompiler;
        this.exportSymbolFunction = string;
        this.exportPropertyFunction = string2;
    }

    @Override
    public void process(Node node, Node node2) {
        FindExportableNodes findExportableNodes = new FindExportableNodes(this.compiler);
        NodeTraversal.traverse(this.compiler, node2, findExportableNodes);
        LinkedHashMap<String, FindExportableNodes.GenerateNodeContext> linkedHashMap = findExportableNodes.getExports();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            Node node3;
            Object object;
            Node node4;
            String string = (String)entry.getKey();
            FindExportableNodes.GenerateNodeContext generateNodeContext = (FindExportableNodes.GenerateNodeContext)entry.getValue();
            String string2 = null;
            String string3 = null;
            Node node5 = generateNodeContext.getNode().getFirstChild();
            if (node5.getType() == 33) {
                string2 = node5.getFirstChild().getQualifiedName();
                if (node5.getFirstChild().getType() == 33 && this.getPropertyName(node5.getFirstChild()).equals(PROTOTYPE_PROPERTY)) {
                    string3 = node5.getFirstChild().getFirstChild().getQualifiedName();
                }
            }
            boolean bl = true;
            if (string3 != null && linkedHashMap.containsKey(string3)) {
                bl = false;
            } else if (string2 != null && linkedHashMap.containsKey(string2)) {
                bl = false;
            }
            if (bl) {
                node4 = new Node(37, NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.exportSymbolFunction, generateNodeContext.getNode(), string));
                node4.addChildToBack(Node.newString(string));
                node4.addChildToBack(NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), string, generateNodeContext.getNode(), string));
            } else {
                object = this.getPropertyName(node5);
                node4 = new Node(37, new Node[]{NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), this.exportPropertyFunction, generateNodeContext.getNode(), this.exportPropertyFunction), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), string2, generateNodeContext.getNode(), this.exportPropertyFunction), Node.newString((String)object), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), string, generateNodeContext.getNode(), this.exportPropertyFunction)});
            }
            object = new Node(130, node4);
            this.annotate((Node)object);
            CodingConvention codingConvention = this.compiler.getCodingConvention();
            for (node3 = generateNodeContext.getContextNode().getNext(); node3 != null && NodeUtil.isExprCall(node3) && codingConvention.getClassesDefinedByCall(node3.getFirstChild()) != null; node3 = node3.getNext()) {
            }
            if (node3 == null) {
                generateNodeContext.getScriptNode().addChildToBack((Node)object);
            } else {
                generateNodeContext.getScriptNode().addChildBefore((Node)object, node3);
            }
            this.compiler.reportCodeChange();
        }
    }

    private void annotate(Node node) {
        NodeTraversal.traverse(this.compiler, node, new PrepareAst.PrepareAnnotations(this.compiler));
    }

    private String getPropertyName(Node node) {
        Preconditions.checkArgument((node.getType() == 33 ? 1 : 0) != 0);
        return node.getLastChild().getString();
    }
}

