/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.LinkedHashSet;

class GroupVariableDeclarations
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;

    GroupVariableDeclarations(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        Object object;
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        Iterator<Scope.Var> iterator = nodeTraversal.getScope().getVars();
        while (iterator.hasNext()) {
            object = iterator.next().getParentNode();
            if (((Node)object).getType() != 118) continue;
            linkedHashSet.add(object);
        }
        if (linkedHashSet.size() <= 1) {
            return;
        }
        object = linkedHashSet.iterator();
        Node node = (Node)object.next();
        while (object.hasNext()) {
            Node node2 = (Node)object.next();
            this.applyGroupingToVar(node, node2);
        }
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
    }

    private void applyGroupingToVar(Node node, Node node2) {
        Node node3;
        Node node4 = null;
        for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNext()) {
            if (!node5.hasChildren()) continue;
            if (node4 != null) {
                return;
            }
            node4 = node5;
        }
        Node node6 = node2.getParent();
        if (node4 != null) {
            node3 = node4.cloneNode();
            node2.replaceChild(node4, node3);
            Node node7 = node4.getFirstChild();
            node4.removeChild(node7);
            Node node8 = new Node(86, node4);
            node8.addChildAfter(node7, node4);
            if (node6.getType() == 115) {
                node6.replaceChild(node2, node8);
            } else {
                Node node9 = NodeUtil.newExpr(node8);
                node6.replaceChild(node2, node9);
            }
        } else if (node6.getType() == 115) {
            if (NodeUtil.isForIn(node6)) {
                node3 = node2.getFirstChild().cloneNode();
                node6.replaceChild(node2, node3);
            } else {
                node3 = new Node(124);
                node6.replaceChild(node2, node3);
            }
        } else {
            node6.removeChild(node2);
        }
        node3 = node2.removeChildren();
        node.addChildrenToBack(node3);
        this.compiler.reportCodeChange();
    }
}

