/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.deps.SortedDependencies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class JSModuleGraph {
    private Set<JSModule> modules;
    private List<List<JSModule>> modulesByDepth;
    private Map<JSModule, Set<JSModule>> dependencyMap = Maps.newHashMap();

    public JSModuleGraph(JSModule[] jSModuleArray) {
        this(Lists.newArrayList((Object[])jSModuleArray));
    }

    public JSModuleGraph(List<JSModule> list) {
        this.modules = Sets.newHashSetWithExpectedSize((int)list.size());
        this.modulesByDepth = Lists.newArrayList();
        for (JSModule jSModule : list) {
            int n = 0;
            for (JSModule jSModule2 : jSModule.getDependencies()) {
                int n2 = jSModule2.getDepth();
                if (n2 < 0) {
                    throw new ModuleDependenceException(String.format("Modules not in dependency order: %s preceded %s", jSModule.getName(), jSModule2.getName()), jSModule, jSModule2);
                }
                n = Math.max(n, n2 + 1);
            }
            jSModule.setDepth(n);
            this.modules.add(jSModule);
            if (n == this.modulesByDepth.size()) {
                this.modulesByDepth.add(new ArrayList());
            }
            this.modulesByDepth.get(n).add(jSModule);
        }
    }

    Iterable<JSModule> getAllModules() {
        return this.modules;
    }

    Iterable<JSModule> getAllModulesInDependencyOrder() {
        ArrayList arrayList = Lists.newArrayList(this.getAllModules());
        Collections.sort(arrayList, new DepthComparator());
        return arrayList;
    }

    int getModuleCount() {
        return this.modules.size();
    }

    JSModule getRootModule() {
        return (JSModule)Iterables.getOnlyElement((Iterable)this.modulesByDepth.get(0));
    }

    public boolean dependsOn(JSModule jSModule, JSModule jSModule2) {
        Set<JSModule> set = this.dependencyMap.get(jSModule);
        if (set == null) {
            set = this.getTransitiveDepsDeepestFirst(jSModule);
            this.dependencyMap.put(jSModule, set);
        }
        return set.contains(jSModule2);
    }

    JSModule getDeepestCommonDependency(JSModule jSModule, JSModule jSModule2) {
        int n = jSModule.getDepth();
        int n2 = jSModule2.getDepth();
        for (int i = Math.min(n, n2) - 1; i >= 0; --i) {
            List<JSModule> list = this.modulesByDepth.get(i);
            for (int j = list.size() - 1; j >= 0; --j) {
                JSModule jSModule3 = list.get(j);
                if (!this.dependsOn(jSModule, jSModule3) || !this.dependsOn(jSModule2, jSModule3)) continue;
                return jSModule3;
            }
        }
        return null;
    }

    public JSModule getDeepestCommonDependencyInclusive(JSModule jSModule, JSModule jSModule2) {
        if (jSModule2 == jSModule || this.dependsOn(jSModule2, jSModule)) {
            return jSModule;
        }
        if (this.dependsOn(jSModule, jSModule2)) {
            return jSModule2;
        }
        return this.getDeepestCommonDependency(jSModule, jSModule2);
    }

    public JSModule getDeepestCommonDependencyInclusive(Collection<JSModule> collection) {
        Iterator<JSModule> iterator = collection.iterator();
        JSModule jSModule = iterator.next();
        while (iterator.hasNext()) {
            jSModule = this.getDeepestCommonDependencyInclusive(jSModule, iterator.next());
        }
        return jSModule;
    }

    Set<JSModule> getTransitiveDepsDeepestFirst(JSModule jSModule) {
        Set<JSModule> set = this.dependencyMap.get(jSModule);
        if (set != null) {
            return set;
        }
        set = new TreeSet<JSModule>(new InverseDepthComparator());
        this.addDeps(set, jSModule);
        this.dependencyMap.put(jSModule, set);
        return set;
    }

    private void addDeps(Set<JSModule> set, JSModule jSModule) {
        for (JSModule jSModule2 : jSModule.getDependencies()) {
            set.add(jSModule2);
            this.addDeps(set, jSModule2);
        }
    }

    public void coalesceDuplicateFiles() {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        for (JSModule object : this.modules) {
            for (CompilerInput compilerInput : object.getInputs()) {
                linkedHashMultimap.put((Object)compilerInput.getName(), (Object)object);
            }
        }
        for (String string : linkedHashMultimap.keySet()) {
            Collection collection = linkedHashMultimap.get((Object)string);
            if (collection.size() <= 1) continue;
            JSModule jSModule = this.getDeepestCommonDependencyInclusive(collection);
            CompilerInput compilerInput = ((JSModule)collection.iterator().next()).getByName(string);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                JSModule jSModule2 = (JSModule)iterator.next();
                if (jSModule2 == jSModule) continue;
                jSModule2.removeByName(string);
            }
            if (collection.contains(jSModule)) continue;
            jSModule.add(compilerInput);
        }
    }

    List<CompilerInput> manageDependencies(List<String> list, List<CompilerInput> list2) throws SortedDependencies.CircularDependencyException, SortedDependencies.MissingProvideException {
        String string22;
        SortedDependencies<CompilerInput> sortedDependencies = new SortedDependencies<CompilerInput>(list2);
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet(sortedDependencies.getInputsWithoutProvides());
        for (String string22 : list) {
            linkedHashSet.add(sortedDependencies.getInputProviding(string22));
        }
        List<CompilerInput> list3 = sortedDependencies.getSortedDependenciesOf(list2);
        string22 = LinkedListMultimap.create();
        for (CompilerInput object2 : linkedHashSet) {
            JSModule jSModule = object2.getModule();
            Preconditions.checkNotNull((Object)jSModule);
            string22.put((Object)jSModule, (Object)object2);
        }
        for (JSModule jSModule : this.getAllModules()) {
            jSModule.removeAll();
        }
        for (JSModule jSModule : string22.keySet()) {
            List<CompilerInput> list4 = sortedDependencies.getSortedDependenciesOf(string22.get((Object)jSModule));
            for (CompilerInput compilerInput : list4) {
                JSModule jSModule2 = compilerInput.getModule();
                if (jSModule2 == null) {
                    compilerInput.setModule(jSModule);
                    continue;
                }
                compilerInput.setModule(null);
                compilerInput.setModule(this.getDeepestCommonDependencyInclusive(jSModule2, jSModule));
            }
        }
        Object object3 = list3.iterator();
        while (object3.hasNext()) {
            CompilerInput compilerInput = (CompilerInput)object3.next();
            JSModule jSModule = compilerInput.getModule();
            if (jSModule == null) continue;
            jSModule.add(compilerInput);
        }
        object3 = Lists.newArrayList();
        for (JSModule jSModule : this.getAllModulesInDependencyOrder()) {
            object3.addAll(jSModule.getInputs());
        }
        return object3;
    }

    private int depthCompare(JSModule jSModule, JSModule jSModule2) {
        int n;
        if (jSModule == jSModule2) {
            return 0;
        }
        int n2 = jSModule.getDepth();
        return n2 < (n = jSModule2.getDepth()) ? -1 : (n == n2 ? jSModule.getName().compareTo(jSModule2.getName()) : 1);
    }

    protected static class ModuleDependenceException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private final JSModule module;
        private final JSModule dependentModule;

        protected ModuleDependenceException(String string, JSModule jSModule, JSModule jSModule2) {
            super(string);
            this.module = jSModule;
            this.dependentModule = jSModule2;
        }

        public JSModule getModule() {
            return this.module;
        }

        public JSModule getDependentModule() {
            return this.dependentModule;
        }
    }

    private class InverseDepthComparator
    implements Comparator<JSModule> {
        private InverseDepthComparator() {
        }

        @Override
        public int compare(JSModule jSModule, JSModule jSModule2) {
            return JSModuleGraph.this.depthCompare(jSModule2, jSModule);
        }
    }

    private class DepthComparator
    implements Comparator<JSModule> {
        private DepthComparator() {
        }

        @Override
        public int compare(JSModule jSModule, JSModule jSModule2) {
            return JSModuleGraph.this.depthCompare(jSModule, jSModule2);
        }
    }
}

