/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.DataFlowAnalysis;
import com.google.javascript.jscomp.JoinOp;
import com.google.javascript.jscomp.LatticeElement;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.rhino.Node;
import java.util.BitSet;
import java.util.List;
import java.util.Set;

class LiveVariablesAnalysis
extends DataFlowAnalysis<Node, LiveVariableLattice> {
    public static final String ARGUMENT_ARRAY_ALIAS = "arguments";
    private final Scope jsScope;
    private final Set<Scope.Var> escaped;

    LiveVariablesAnalysis(ControlFlowGraph<Node> controlFlowGraph, Scope scope, AbstractCompiler abstractCompiler) {
        super(controlFlowGraph, new LiveVariableJoinOp());
        this.jsScope = scope;
        this.escaped = Sets.newHashSet();
        LiveVariablesAnalysis.computeEscaped(scope, this.escaped, abstractCompiler);
    }

    public Set<Scope.Var> getEscapedLocals() {
        return this.escaped;
    }

    public int getVarIndex(String string) {
        return this.jsScope.getVar((String)string).index;
    }

    @Override
    boolean isForward() {
        return false;
    }

    @Override
    LiveVariableLattice createEntryLattice() {
        return new LiveVariableLattice(this.jsScope.getVarCount());
    }

    @Override
    LiveVariableLattice createInitialEstimateLattice() {
        return new LiveVariableLattice(this.jsScope.getVarCount());
    }

    @Override
    LiveVariableLattice flowThrough(Node node, LiveVariableLattice liveVariableLattice) {
        BitSet bitSet = new BitSet(liveVariableLattice.liveSet.size());
        BitSet bitSet2 = new BitSet(liveVariableLattice.liveSet.size());
        boolean bl = false;
        List list = this.getCfg().getOutEdges(node);
        for (DiGraph.DiGraphEdge diGraphEdge : list) {
            if (!ControlFlowGraph.Branch.ON_EX.equals(diGraphEdge.getValue())) continue;
            bl = true;
        }
        this.computeGenKill(node, bitSet, bitSet2, bl);
        LiveVariableLattice liveVariableLattice2 = new LiveVariableLattice(liveVariableLattice);
        liveVariableLattice2.liveSet.andNot(bitSet2);
        liveVariableLattice2.liveSet.or(bitSet);
        return liveVariableLattice2;
    }

    private void computeGenKill(Node node, BitSet bitSet, BitSet bitSet2, boolean bl) {
        switch (node.getType()) {
            case 105: 
            case 125: 
            case 132: {
                return;
            }
            case 108: 
            case 113: 
            case 114: {
                this.computeGenKill(NodeUtil.getConditionExpression(node), bitSet, bitSet2, bl);
                return;
            }
            case 115: {
                if (!NodeUtil.isForIn(node)) {
                    this.computeGenKill(NodeUtil.getConditionExpression(node), bitSet, bitSet2, bl);
                } else {
                    Node node2 = node.getFirstChild();
                    Node node3 = node2.getNext();
                    if (NodeUtil.isVar(node2)) {
                        node2 = node2.getLastChild();
                    }
                    this.addToSetIfLocal(node2, bitSet2);
                    this.addToSetIfLocal(node2, bitSet);
                    this.computeGenKill(node3, bitSet, bitSet2, bl);
                }
                return;
            }
            case 118: {
                for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                    if (!node4.hasChildren()) continue;
                    this.computeGenKill(node4.getFirstChild(), bitSet, bitSet2, bl);
                    if (bl) continue;
                    this.addToSetIfLocal(node4, bitSet2);
                }
                return;
            }
            case 100: 
            case 101: {
                this.computeGenKill(node.getFirstChild(), bitSet, bitSet2, bl);
                this.computeGenKill(node.getLastChild(), bitSet, bitSet2, true);
                return;
            }
            case 98: {
                this.computeGenKill(node.getFirstChild(), bitSet, bitSet2, bl);
                this.computeGenKill(node.getFirstChild().getNext(), bitSet, bitSet2, true);
                this.computeGenKill(node.getLastChild(), bitSet, bitSet2, true);
                return;
            }
            case 38: {
                if (this.isArgumentsName(node)) {
                    this.markAllParametersEscaped();
                } else {
                    this.addToSetIfLocal(node, bitSet);
                }
                return;
            }
        }
        if (NodeUtil.isAssignmentOp(node) && NodeUtil.isName(node.getFirstChild())) {
            Node node5 = node.getFirstChild();
            if (!bl) {
                this.addToSetIfLocal(node5, bitSet2);
            }
            if (!NodeUtil.isAssign(node)) {
                this.addToSetIfLocal(node5, bitSet);
            }
            this.computeGenKill(node5.getNext(), bitSet, bitSet2, bl);
        } else {
            for (Node node6 = node.getFirstChild(); node6 != null; node6 = node6.getNext()) {
                this.computeGenKill(node6, bitSet, bitSet2, bl);
            }
        }
    }

    private void addToSetIfLocal(Node node, BitSet bitSet) {
        Preconditions.checkState((boolean)NodeUtil.isName(node));
        String string = node.getString();
        if (!this.jsScope.isDeclared(string, false)) {
            return;
        }
        Scope.Var var = this.jsScope.getVar(string);
        if (!this.escaped.contains(var)) {
            bitSet.set(var.index);
        }
    }

    void markAllParametersEscaped() {
        Node node = this.jsScope.getRootNode().getFirstChild().getNext();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            this.escaped.add(this.jsScope.getVar(node2.getString()));
        }
    }

    private boolean isArgumentsName(Node node) {
        return node.getType() == 38 && node.getString().equals(ARGUMENT_ARRAY_ALIAS) && !this.jsScope.isDeclared(ARGUMENT_ARRAY_ALIAS, false);
    }

    static class LiveVariableLattice
    implements LatticeElement {
        private final BitSet liveSet;

        private LiveVariableLattice(int n) {
            this.liveSet = new BitSet(n);
        }

        private LiveVariableLattice(LiveVariableLattice liveVariableLattice) {
            Preconditions.checkNotNull((Object)liveVariableLattice);
            this.liveSet = (BitSet)liveVariableLattice.liveSet.clone();
        }

        public boolean equals(Object object) {
            Preconditions.checkNotNull((Object)object);
            return object instanceof LiveVariableLattice && this.liveSet.equals(((LiveVariableLattice)object).liveSet);
        }

        public boolean isLive(Scope.Var var) {
            Preconditions.checkNotNull((Object)var);
            return this.liveSet.get(var.index);
        }

        public boolean isLive(int n) {
            return this.liveSet.get(n);
        }

        public String toString() {
            return this.liveSet.toString();
        }

        public int hashCode() {
            return this.liveSet.hashCode();
        }
    }

    private static class LiveVariableJoinOp
    implements JoinOp<LiveVariableLattice> {
        private LiveVariableJoinOp() {
        }

        public LiveVariableLattice apply(List<LiveVariableLattice> list) {
            LiveVariableLattice liveVariableLattice = new LiveVariableLattice(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                liveVariableLattice.liveSet.or(list.get(i).liveSet);
            }
            return liveVariableLattice;
        }
    }
}

