/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.TernaryValue;

class MinimizeExitPoints
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    AbstractCompiler compiler;

    MinimizeExitPoints(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        switch (node.getType()) {
            case 126: {
                this.tryMinimizeExits(node.getLastChild(), 116, node.getFirstChild().getString());
                break;
            }
            case 113: 
            case 115: {
                this.tryMinimizeExits(NodeUtil.getLoopCodeBlock(node), 117, null);
                break;
            }
            case 114: {
                this.tryMinimizeExits(NodeUtil.getLoopCodeBlock(node), 117, null);
                Node node3 = NodeUtil.getConditionExpression(node);
                if (NodeUtil.getImpureBooleanValue(node3) != TernaryValue.FALSE) break;
                this.tryMinimizeExits(node.getFirstChild(), 116, null);
                break;
            }
            case 105: {
                this.tryMinimizeExits(node.getLastChild(), 4, null);
            }
        }
    }

    void tryMinimizeExits(Node node, int n, String string) {
        Node node2;
        Node node3;
        Object object;
        if (MinimizeExitPoints.matchingExitNode(node, n, string)) {
            NodeUtil.removeChild(node.getParent(), node);
            this.compiler.reportCodeChange();
            return;
        }
        if (node.getType() == 108) {
            Node node4 = node.getFirstChild().getNext();
            this.tryMinimizeExits(node4, n, string);
            Node node5 = node4.getNext();
            if (node5 != null) {
                this.tryMinimizeExits(node5, n, string);
            }
            return;
        }
        if (node.getType() == 77) {
            object = node.getFirstChild();
            this.tryMinimizeExits((Node)object, n, string);
            Node node6 = NodeUtil.getCatchBlock(node);
            if (NodeUtil.hasCatchHandler(node6)) {
                Preconditions.checkState((boolean)node6.hasOneChild());
                node3 = node6.getFirstChild();
                node2 = node3.getLastChild();
                this.tryMinimizeExits(node2, n, string);
            }
            if (NodeUtil.hasFinally(node)) {
                node3 = node.getLastChild();
                this.tryMinimizeExits(node3, n, string);
            }
        }
        if (node.getType() == 126) {
            object = node.getLastChild();
            this.tryMinimizeExits((Node)object, n, string);
        }
        if (node.getType() != 125 || node.getLastChild() == null) {
            return;
        }
        for (Node node6 : node.children()) {
            if (node6.getType() == 108) {
                node3 = node6;
                node2 = node3.getFirstChild().getNext();
                Node node7 = node2.getNext();
                this.tryMinimizeIfBlockExits(node2, node7, node3, n, string);
                node2 = node3.getFirstChild().getNext();
                node7 = node2.getNext();
                if (node7 != null) {
                    this.tryMinimizeIfBlockExits(node7, node2, node3, n, string);
                }
            }
            if (node6 != node.getLastChild()) continue;
            break;
        }
        object = node.getLastChild();
        while (object != null) {
            this.tryMinimizeExits((Node)object, n, string);
            if (object == node.getLastChild()) break;
            object = node.getLastChild();
        }
    }

    private void tryMinimizeIfBlockExits(Node node, Node node2, Node node3, int n, String string) {
        Node node4 = null;
        Node node5 = null;
        if (node.getType() == 125) {
            if (!node.hasChildren()) {
                return;
            }
            node4 = node;
            node5 = node4.getLastChild();
        } else {
            node4 = node3;
            node5 = node;
        }
        if (!MinimizeExitPoints.matchingExitNode(node5, n, string)) {
            return;
        }
        if (node3.getNext() != null) {
            Node node6 = new Node(125).copyInformationFrom(node3);
            if (node2 == null) {
                node3.addChildToBack(node6);
            } else if (node2.getType() == 124) {
                node3.replaceChild(node2, node6);
            } else if (node2.getType() == 125) {
                node6 = node2;
            } else {
                node3.replaceChild(node2, node6);
                node6.addChildToBack(node2);
            }
            MinimizeExitPoints.moveAllFollowing(node3, node3.getParent(), node6);
        }
        NodeUtil.removeChild(node4, node5);
        this.compiler.reportCodeChange();
    }

    private static boolean matchingExitNode(Node node, int n, String string) {
        if (node.getType() == n) {
            if (n == 4) {
                return !node.hasChildren();
            }
            if (string == null) {
                return !node.hasChildren();
            }
            return node.hasChildren() && string.equals(node.getFirstChild().getString());
        }
        return false;
    }

    private static void moveAllFollowing(Node node, Node node2, Node node3) {
        Node node4 = node.getNext();
        while (node4 != null) {
            boolean bl = NodeUtil.isFunctionDeclaration(node4);
            node2.removeChild(node4);
            if (bl) {
                node3.addChildToFront(node4);
            } else {
                node3.addChildToBack(node4);
            }
            node4 = node.getNext();
        }
    }
}

