/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodeChangeHandler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.PerformanceTracker;
import com.google.javascript.jscomp.Tracer;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;

class PhaseOptimizer
implements CompilerPass {
    @VisibleForTesting
    static final List<String> OPTIMAL_ORDER = ImmutableList.of((Object)"removeUnreachableCode", (Object)"removeUnusedVars", (Object)"foldConstants", (Object)"deadAssignmentsElimination", (Object)"inlineVariables", (Object)"inlineFunctions", (Object)"removeUnusedPrototypeProperties", (Object)"minimizeExitPoints");
    static final int MAX_LOOPS = 100;
    static final String OPTIMIZE_LOOP_ERROR = "Fixed point loop exceeded the maximum number of iterations.";
    private static final Logger logger = Logger.getLogger(PhaseOptimizer.class.getName());
    private List<CompilerPass> passes = Lists.newArrayList();
    private final AbstractCompiler compiler;
    private final PerformanceTracker tracker;
    private final CodeChangeHandler.RecentChange recentChange = new CodeChangeHandler.RecentChange();
    private boolean loopMutex = false;
    private Tracer currentTracer = null;
    private String currentPassName = null;
    private PassFactory sanityCheck = null;
    private static boolean randomizeLoops = false;
    private static List<List<String>> loopsRun = Lists.newArrayList();

    PhaseOptimizer(AbstractCompiler abstractCompiler, PerformanceTracker performanceTracker) {
        this.compiler = abstractCompiler;
        this.tracker = performanceTracker;
        abstractCompiler.addChangeHandler(this.recentChange);
    }

    static void randomizeLoops() {
        randomizeLoops = true;
    }

    static List<List<String>> getLoopsRun() {
        return loopsRun;
    }

    static void clearLoopsRun() {
        loopsRun.clear();
    }

    void consume(List<PassFactory> list) {
        LoopInternal loopInternal = new LoopInternal();
        boolean bl = false;
        for (PassFactory passFactory : list) {
            if (passFactory.isOneTimePass()) {
                if (bl) {
                    this.passes.add(loopInternal);
                    loopInternal = new LoopInternal();
                    bl = false;
                }
                this.addOneTimePass(passFactory);
                continue;
            }
            ((Loop)loopInternal).addLoopedPass(passFactory);
            bl = true;
        }
        if (bl) {
            this.passes.add(loopInternal);
        }
    }

    void addOneTimePass(PassFactory passFactory) {
        this.passes.add(new PassFactoryDelegate(this.compiler, passFactory));
    }

    Loop addFixedPointLoop() {
        LoopInternal loopInternal = new LoopInternal();
        this.passes.add(loopInternal);
        return loopInternal;
    }

    void setSanityCheck(PassFactory passFactory) {
        this.sanityCheck = passFactory;
    }

    @Override
    public void process(Node node, Node node2) {
        for (CompilerPass compilerPass : this.passes) {
            compilerPass.process(node, node2);
            if (!this.hasHaltingErrors()) continue;
            return;
        }
    }

    private void startPass(String string) {
        Preconditions.checkState((this.currentTracer == null && this.currentPassName == null ? 1 : 0) != 0);
        this.currentPassName = string;
        this.currentTracer = this.newTracer(string);
    }

    private void endPass(Node node, Node node2) {
        Preconditions.checkState((this.currentTracer != null && this.currentPassName != null ? 1 : 0) != 0);
        String string = this.currentPassName;
        try {
            this.stopTracer(this.currentTracer, this.currentPassName);
            this.currentPassName = null;
            this.currentTracer = null;
            this.maybeSanityCheck(node, node2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Sanity check failed for " + string, exception);
        }
    }

    void maybeSanityCheck(Node node, Node node2) {
        if (this.sanityCheck != null) {
            this.sanityCheck.create(this.compiler).process(node, node2);
        }
    }

    private boolean hasHaltingErrors() {
        return this.compiler.hasHaltingErrors();
    }

    private Tracer newTracer(String string) {
        String string2 = string + (this.recentChange.hasCodeChanged() ? " on recently changed AST" : "");
        if (this.tracker != null) {
            this.tracker.recordPassStart(string);
        }
        return new Tracer("JSCompiler", string2);
    }

    private void stopTracer(Tracer tracer, String string) {
        long l = tracer.stop();
        if (this.tracker != null) {
            this.tracker.recordPassStop(string, l);
        }
    }

    private class LoopInternal
    extends Loop {
        private final List<NamedPass> myPasses = Lists.newArrayList();
        private final Set<String> myNames = Sets.newHashSet();

        private LoopInternal() {
        }

        @Override
        void addLoopedPass(PassFactory passFactory) {
            String string = passFactory.getName();
            Preconditions.checkArgument((!this.myNames.contains(string) ? 1 : 0) != 0, (Object)("Already a pass with name '" + string + "' in this loop"));
            this.myNames.add(passFactory.getName());
            this.myPasses.add(new PassFactoryDelegate(PhaseOptimizer.this.compiler, passFactory));
        }

        private List<String> getPassOrder() {
            ArrayList arrayList = Lists.newArrayList();
            for (NamedPass namedPass : this.myPasses) {
                arrayList.add(namedPass.name);
            }
            return arrayList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(Node node, Node node2) {
            Preconditions.checkState((!PhaseOptimizer.this.loopMutex ? 1 : 0) != 0, (Object)"Nested loops are forbidden");
            PhaseOptimizer.this.loopMutex = true;
            if (randomizeLoops) {
                this.randomizePasses();
            } else {
                this.optimizePasses();
            }
            try {
                int n = 0;
                block3: do {
                    if (n++ > 100) {
                        PhaseOptimizer.this.compiler.throwInternalError(PhaseOptimizer.OPTIMIZE_LOOP_ERROR, null);
                    }
                    PhaseOptimizer.this.recentChange.reset();
                    for (NamedPass namedPass : this.myPasses) {
                        namedPass.process(node, node2);
                        if (!PhaseOptimizer.this.hasHaltingErrors()) continue;
                        break block3;
                    }
                } while (PhaseOptimizer.this.recentChange.hasCodeChanged() && !PhaseOptimizer.this.hasHaltingErrors());
                if (randomizeLoops) {
                    loopsRun.add(this.getPassOrder());
                }
            }
            finally {
                PhaseOptimizer.this.loopMutex = false;
            }
        }

        private void randomizePasses() {
            ArrayList arrayList = Lists.newArrayList();
            Random random = new Random();
            while (this.myPasses.size() > 0) {
                arrayList.add(this.myPasses.remove(random.nextInt(this.myPasses.size())));
            }
            this.myPasses.addAll(arrayList);
        }

        private void optimizePasses() {
            ArrayList arrayList = Lists.newArrayList();
            block0: for (String string : OPTIMAL_ORDER) {
                for (NamedPass namedPass : this.myPasses) {
                    if (!namedPass.name.equals(string)) continue;
                    arrayList.add(namedPass);
                    continue block0;
                }
            }
            this.myPasses.removeAll(arrayList);
            this.myPasses.addAll(arrayList);
        }
    }

    static abstract class Loop
    implements CompilerPass {
        Loop() {
        }

        abstract void addLoopedPass(PassFactory var1);
    }

    private class PassFactoryDelegate
    extends NamedPass {
        private final AbstractCompiler myCompiler;
        private final PassFactory factory;

        private PassFactoryDelegate(AbstractCompiler abstractCompiler, PassFactory passFactory) {
            super(passFactory.getName());
            this.myCompiler = abstractCompiler;
            this.factory = passFactory;
        }

        @Override
        void processInternal(Node node, Node node2) {
            this.factory.create(this.myCompiler).process(node, node2);
        }
    }

    private abstract class NamedPass
    implements CompilerPass {
        private final String name;

        NamedPass(String string) {
            this.name = string;
        }

        @Override
        public void process(Node node, Node node2) {
            logger.info(this.name);
            PhaseOptimizer.this.startPass(this.name);
            this.processInternal(node, node2);
            PhaseOptimizer.this.endPass(node, node2);
        }

        abstract void processInternal(Node var1, Node var2);
    }
}

