/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ErrorFormat;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import java.io.PrintStream;

public class PrintStreamErrorManager
extends BasicErrorManager {
    private final MessageFormatter formatter;
    private final PrintStream stream;
    private int summaryDetailLevel = 1;

    public PrintStreamErrorManager(MessageFormatter messageFormatter, PrintStream printStream) {
        this.formatter = messageFormatter;
        this.stream = printStream;
    }

    public PrintStreamErrorManager(PrintStream printStream) {
        this(ErrorFormat.SOURCELESS.toFormatter(null, false), printStream);
    }

    @Override
    public void println(CheckLevel checkLevel, JSError jSError) {
        this.stream.println(jSError.format(checkLevel, this.formatter));
    }

    public void setSummaryDetailLevel(int n) {
        this.summaryDetailLevel = n;
    }

    @Override
    public void printSummary() {
        if (this.summaryDetailLevel >= 3 || this.summaryDetailLevel >= 1 && this.getErrorCount() + this.getWarningCount() > 0 || this.summaryDetailLevel >= 2 && this.getTypedPercent() > 0.0) {
            if (this.getTypedPercent() > 0.0) {
                this.stream.format("%d error(s), %d warning(s), %.1f%% typed%n", this.getErrorCount(), this.getWarningCount(), this.getTypedPercent());
            } else {
                this.stream.format("%d error(s), %d warning(s)%n", this.getErrorCount(), this.getWarningCount());
            }
        }
    }
}

