/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionNames;
import com.google.javascript.jscomp.NameReferenceGraphConstruction;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SimpleDefinitionFinder;
import com.google.javascript.jscomp.graph.FixedPointGraphTraversal;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PureFunctionIdentifier
implements CompilerPass {
    static final DiagnosticType INVALID_NO_SIDE_EFFECT_ANNOTATION = DiagnosticType.error("JSC_INVALID_NO_SIDE_EFFECT_ANNOTATION", "@nosideeffects may only appear in externs files.");
    static final DiagnosticType INVALID_MODIFIES_ANNOTATION = DiagnosticType.error("JSC_INVALID_MODIFIES_ANNOTATION", "@modifies may only appear in externs files.");
    private final AbstractCompiler compiler;
    private final DefinitionProvider definitionProvider;
    private final Map<Node, FunctionInformation> functionSideEffectMap;
    private final List<Node> allFunctionCalls;
    private Node externs;
    private Node root;

    public PureFunctionIdentifier(AbstractCompiler abstractCompiler, DefinitionProvider definitionProvider) {
        this.compiler = abstractCompiler;
        this.definitionProvider = definitionProvider;
        this.functionSideEffectMap = Maps.newHashMap();
        this.allFunctionCalls = Lists.newArrayList();
        this.externs = null;
        this.root = null;
    }

    @Override
    public void process(Node node, Node node2) {
        if (this.externs != null || this.root != null) {
            throw new IllegalStateException("It is illegal to call PureFunctionIdentifier.process twice the same instance.  Please use a new PureFunctionIdentifier instance each time.");
        }
        this.externs = node;
        this.root = node2;
        NodeTraversal.traverse(this.compiler, this.externs, new FunctionAnalyzer(true));
        NodeTraversal.traverse(this.compiler, this.root, new FunctionAnalyzer(false));
        this.propagateSideEffects();
        this.markPureFunctionCalls();
    }

    String getDebugReport() {
        FunctionInformation functionInformation;
        Node node;
        Preconditions.checkNotNull((Object)this.externs);
        Preconditions.checkNotNull((Object)this.root);
        StringBuilder stringBuilder = new StringBuilder();
        FunctionNames functionNames = new FunctionNames(this.compiler);
        functionNames.process(null, this.externs);
        functionNames.process(null, this.root);
        stringBuilder.append("Pure functions:\n");
        for (Map.Entry<Node, FunctionInformation> entry : this.functionSideEffectMap.entrySet()) {
            node = entry.getKey();
            functionInformation = entry.getValue();
            boolean bl = functionInformation.mayBePure() && !functionInformation.mayHaveSideEffects();
            if (!bl) continue;
            stringBuilder.append("  " + functionNames.getFunctionName(node) + "\n");
        }
        stringBuilder.append("\n");
        for (Map.Entry<Node, FunctionInformation> entry : this.functionSideEffectMap.entrySet()) {
            node = entry.getKey();
            functionInformation = entry.getValue();
            HashSet hashSet = Sets.newHashSet();
            for (Node node2 : functionInformation.getCallsInFunctionBody()) {
                Collection<DefinitionsRemover.Definition> collection = PureFunctionIdentifier.getCallableDefinitions(this.definitionProvider, node2.getFirstChild());
                if (collection == null) {
                    hashSet.add("<null def list>");
                    continue;
                }
                for (DefinitionsRemover.Definition definition : collection) {
                    hashSet.add(functionNames.getFunctionName(definition.getRValue()));
                }
            }
            stringBuilder.append(functionNames.getFunctionName(node) + " " + functionInformation.toString() + " Calls: " + hashSet + "\n");
        }
        return stringBuilder.toString();
    }

    private static Collection<DefinitionsRemover.Definition> getCallableDefinitions(DefinitionProvider definitionProvider, Node node) {
        if (NodeUtil.isGetProp(node) || NodeUtil.isName(node)) {
            ArrayList arrayList = Lists.newArrayList();
            Collection<DefinitionsRemover.Definition> collection = definitionProvider.getDefinitionsReferencedAt(node);
            if (collection == null) {
                return null;
            }
            for (DefinitionsRemover.Definition definition : collection) {
                Node node2 = definition.getRValue();
                if (node2 != null && NodeUtil.isFunction(node2)) {
                    arrayList.add(definition);
                    continue;
                }
                return null;
            }
            return arrayList;
        }
        if (node.getType() == 100 || node.getType() == 98) {
            Node node3 = node.getType() == 98 ? node.getFirstChild().getNext() : node.getFirstChild();
            Collection<DefinitionsRemover.Definition> collection = PureFunctionIdentifier.getCallableDefinitions(definitionProvider, node3);
            Collection<DefinitionsRemover.Definition> collection2 = PureFunctionIdentifier.getCallableDefinitions(definitionProvider, node3.getNext());
            if (collection != null && collection2 != null) {
                collection.addAll(collection2);
                return collection;
            }
            return null;
        }
        if (NodeUtil.isFunctionExpression(node)) {
            return Lists.newArrayList((Object[])new DefinitionsRemover.Definition[]{new DefinitionsRemover.FunctionExpressionDefinition(node, false)});
        }
        return null;
    }

    private void propagateSideEffects() {
        LinkedDirectedGraph<FunctionInformation, Node> linkedDirectedGraph = LinkedDirectedGraph.createWithoutAnnotations();
        for (FunctionInformation functionInformation : this.functionSideEffectMap.values()) {
            ((Graph)linkedDirectedGraph).createNode(functionInformation);
        }
        block1: for (FunctionInformation functionInformation : this.functionSideEffectMap.values()) {
            if (!functionInformation.mayHaveSideEffects()) continue;
            for (Node node : functionInformation.getCallsInFunctionBody()) {
                Node node2 = node.getFirstChild();
                Collection<DefinitionsRemover.Definition> collection = PureFunctionIdentifier.getCallableDefinitions(this.definitionProvider, node2);
                if (collection == null) {
                    functionInformation.setTaintsUnknown();
                    continue block1;
                }
                for (DefinitionsRemover.Definition definition : collection) {
                    Node node3 = definition.getRValue();
                    FunctionInformation functionInformation2 = this.functionSideEffectMap.get(node3);
                    Preconditions.checkNotNull((Object)functionInformation2);
                    ((Graph)linkedDirectedGraph).connect(functionInformation2, node, functionInformation);
                }
            }
        }
        FixedPointGraphTraversal.newTraversal(new SideEffectPropagationCallback()).computeFixedPoint(linkedDirectedGraph);
        for (FunctionInformation functionInformation : this.functionSideEffectMap.values()) {
            if (!functionInformation.mayBePure()) continue;
            functionInformation.setIsPure();
        }
    }

    private void markPureFunctionCalls() {
        for (Node node : this.allFunctionCalls) {
            Node node2 = node.getFirstChild();
            Collection<DefinitionsRemover.Definition> collection = PureFunctionIdentifier.getCallableDefinitions(this.definitionProvider, node2);
            Node.SideEffectFlags sideEffectFlags = new Node.SideEffectFlags();
            if (collection == null) {
                sideEffectFlags.setMutatesGlobalState();
                sideEffectFlags.setThrows();
                sideEffectFlags.setReturnsTainted();
            } else {
                sideEffectFlags.clearAllFlags();
                for (DefinitionsRemover.Definition definition : collection) {
                    FunctionInformation functionInformation = this.functionSideEffectMap.get(definition.getRValue());
                    Preconditions.checkNotNull((Object)functionInformation);
                    if (functionInformation.mutatesGlobalState()) {
                        sideEffectFlags.setMutatesGlobalState();
                    }
                    if (functionInformation.functionThrows) {
                        sideEffectFlags.setThrows();
                    }
                    if (!NodeUtil.isNew(node) && functionInformation.taintsThis) {
                        sideEffectFlags.setMutatesThis();
                    }
                    if (functionInformation.taintsReturn) {
                        sideEffectFlags.setReturnsTainted();
                    }
                    if (!sideEffectFlags.areAllFlagsSet()) continue;
                    break;
                }
            }
            if (NodeUtil.isCall(node)) {
                Preconditions.checkState((this.compiler != null ? 1 : 0) != 0);
                if (!NodeUtil.functionCallHasSideEffects(node, this.compiler)) {
                    sideEffectFlags.clearSideEffectFlags();
                }
            } else if (NodeUtil.isNew(node) && !NodeUtil.constructorCallHasSideEffects(node)) {
                sideEffectFlags.clearSideEffectFlags();
            }
            node.setSideEffectFlags(sideEffectFlags.valueOf());
        }
    }

    private static boolean isIncDec(Node node) {
        int n = node.getType();
        return n == 102 || n == 103;
    }

    private static boolean isKnownLocalValue(Node node) {
        Predicate<Node> predicate = new Predicate<Node>(){

            public boolean apply(Node node) {
                switch (node.getType()) {
                    case 86: {
                        return false;
                    }
                    case 42: {
                        return false;
                    }
                    case 38: {
                        return false;
                    }
                    case 33: 
                    case 35: {
                        return false;
                    }
                    case 37: {
                        return false;
                    }
                }
                return false;
            }
        };
        return NodeUtil.evaluatesToLocalValue(node, predicate);
    }

    private static Node getCallThisObject(Node node) {
        Node node2 = node.getFirstChild();
        if (!NodeUtil.isGet(node2)) {
            return null;
        }
        String string = node2.getLastChild().getString();
        if (string.equals("call") || string.equals("apply")) {
            return node2.getNext();
        }
        return node2.getFirstChild();
    }

    private static boolean isCallOrApply(Node node) {
        String string;
        Node node2 = node.getFirstChild();
        return NodeUtil.isGet(node2) && ((string = node2.getLastChild().getString()).equals("call") || string.equals("apply"));
    }

    static class Driver
    implements CompilerPass {
        private final AbstractCompiler compiler;
        private final String reportPath;
        private final boolean useNameReferenceGraph;

        Driver(AbstractCompiler abstractCompiler, String string, boolean bl) {
            this.compiler = abstractCompiler;
            this.reportPath = string;
            this.useNameReferenceGraph = bl;
        }

        @Override
        public void process(Node node, Node node2) {
            CompilerPass compilerPass;
            Object object = null;
            if (this.useNameReferenceGraph) {
                compilerPass = new NameReferenceGraphConstruction(this.compiler);
                ((NameReferenceGraphConstruction)compilerPass).process(node, node2);
                object = ((NameReferenceGraphConstruction)compilerPass).getNameReferenceGraph();
            } else {
                compilerPass = new SimpleDefinitionFinder(this.compiler);
                ((SimpleDefinitionFinder)compilerPass).process(node, node2);
                object = compilerPass;
            }
            compilerPass = new PureFunctionIdentifier(this.compiler, (DefinitionProvider)object);
            ((PureFunctionIdentifier)compilerPass).process(node, node2);
            if (this.reportPath != null) {
                try {
                    Files.write((CharSequence)((PureFunctionIdentifier)compilerPass).getDebugReport(), (File)new File(this.reportPath), (Charset)Charsets.UTF_8);
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        }
    }

    private static class FunctionInformation {
        private final boolean extern;
        private final List<Node> callsInFunctionBody = Lists.newArrayList();
        private Set<Scope.Var> blacklisted = Sets.newHashSet();
        private Set<Scope.Var> taintedLocals = Sets.newHashSet();
        private Set<String> knownLocals = Sets.newHashSet();
        private boolean pureFunction = false;
        private boolean functionThrows = false;
        private boolean taintsGlobalState = false;
        private boolean taintsThis = false;
        private boolean taintsArguments = false;
        private boolean taintsUnknown = false;
        private boolean taintsReturn = false;

        FunctionInformation(boolean bl) {
            this.extern = bl;
            this.checkInvariant();
        }

        void addTaintedLocalObject(Scope.Var var) {
            this.taintedLocals.add(var);
        }

        void resetLocalVars() {
            this.blacklisted = null;
            this.taintedLocals = null;
            this.knownLocals = Collections.emptySet();
        }

        public void blacklistLocal(Scope.Var var) {
            this.blacklisted.add(var);
        }

        boolean mayBePure() {
            return !this.functionThrows && !this.taintsGlobalState && !this.taintsThis && !this.taintsArguments && !this.taintsUnknown;
        }

        boolean mayHaveSideEffects() {
            return !this.pureFunction;
        }

        void setIsPure() {
            this.pureFunction = true;
            this.checkInvariant();
        }

        void setTaintsGlobalState() {
            this.taintsGlobalState = true;
            this.checkInvariant();
        }

        void setTaintsThis() {
            this.taintsThis = true;
            this.checkInvariant();
        }

        void setTaintsArguments() {
            this.taintsArguments = true;
            this.checkInvariant();
        }

        void setFunctionThrows() {
            this.functionThrows = true;
            this.checkInvariant();
        }

        void setTaintsUnknown() {
            this.taintsUnknown = true;
            this.checkInvariant();
        }

        void setTaintsReturn() {
            this.taintsReturn = true;
            this.checkInvariant();
        }

        boolean mutatesGlobalState() {
            return this.taintsGlobalState || this.taintsArguments || this.taintsUnknown;
        }

        boolean mutatesThis() {
            return this.taintsThis;
        }

        boolean functionThrows() {
            return this.functionThrows;
        }

        private void checkInvariant() {
            boolean bl;
            boolean bl2 = bl = this.mayBePure() || this.mayHaveSideEffects();
            if (!bl) {
                throw new IllegalStateException("Invariant failed.  " + this.toString());
            }
        }

        void appendCall(Node node) {
            this.callsInFunctionBody.add(node);
        }

        List<Node> getCallsInFunctionBody() {
            return this.callsInFunctionBody;
        }

        public String toString() {
            ArrayList arrayList = Lists.newArrayList();
            if (this.extern) {
                arrayList.add("extern");
            }
            if (this.pureFunction) {
                arrayList.add("pure");
            }
            if (this.taintsThis) {
                arrayList.add("this");
            }
            if (this.taintsGlobalState) {
                arrayList.add("global");
            }
            if (this.functionThrows) {
                arrayList.add("throw");
            }
            if (this.taintsUnknown) {
                arrayList.add("complex");
            }
            return "Side effects: " + ((Object)arrayList).toString();
        }
    }

    private static class SideEffectPropagationCallback
    implements FixedPointGraphTraversal.EdgeCallback<FunctionInformation, Node> {
        private SideEffectPropagationCallback() {
        }

        @Override
        public boolean traverseEdge(FunctionInformation functionInformation, Node node, FunctionInformation functionInformation2) {
            Preconditions.checkArgument((node.getType() == 37 || node.getType() == 30 ? 1 : 0) != 0);
            boolean bl = false;
            if (!functionInformation2.mutatesGlobalState() && functionInformation.mutatesGlobalState()) {
                functionInformation2.setTaintsGlobalState();
                bl = true;
            }
            if (!functionInformation2.functionThrows() && functionInformation.functionThrows()) {
                functionInformation2.setFunctionThrows();
                bl = true;
            }
            if (functionInformation.mutatesThis() && node.getType() != 30) {
                Node node2 = PureFunctionIdentifier.getCallThisObject(node);
                if (node2 != null && NodeUtil.isName(node2) && !PureFunctionIdentifier.isCallOrApply(node)) {
                    String string = node2.getString();
                    if (!functionInformation2.mutatesGlobalState()) {
                        functionInformation2.setTaintsGlobalState();
                        bl = true;
                    }
                } else if (node2 != null && NodeUtil.isThis(node2)) {
                    if (!functionInformation2.mutatesThis()) {
                        functionInformation2.setTaintsThis();
                        bl = true;
                    }
                } else if (!(node2 != null && NodeUtil.evaluatesToLocalValue(node2) && !PureFunctionIdentifier.isCallOrApply(node) || functionInformation2.mutatesGlobalState())) {
                    functionInformation2.setTaintsGlobalState();
                    bl = true;
                }
            }
            return bl;
        }
    }

    private class FunctionAnalyzer
    implements NodeTraversal.ScopedCallback {
        private final boolean inExterns;

        FunctionAnalyzer(boolean bl) {
            this.inExterns = bl;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (NodeUtil.isFunction(node)) {
                Node node3 = node2.getParent();
                this.visitFunction(nodeTraversal, node, node2, node3);
            }
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Node node3;
            if (this.inExterns) {
                return;
            }
            if (!NodeUtil.nodeTypeMayHaveSideEffects(node) && node.getType() != 4) {
                return;
            }
            if (NodeUtil.isCall(node) || NodeUtil.isNew(node)) {
                PureFunctionIdentifier.this.allFunctionCalls.add(node);
            }
            if ((node3 = nodeTraversal.getEnclosingFunction()) != null) {
                FunctionInformation functionInformation = (FunctionInformation)PureFunctionIdentifier.this.functionSideEffectMap.get(node3);
                Preconditions.checkNotNull((Object)functionInformation);
                if (NodeUtil.isAssignmentOp(node)) {
                    this.visitAssignmentOrUnaryOperator(functionInformation, nodeTraversal.getScope(), node, node.getFirstChild(), node.getLastChild());
                } else {
                    switch (node.getType()) {
                        case 30: 
                        case 37: {
                            this.visitCall(functionInformation, node);
                            break;
                        }
                        case 31: 
                        case 102: 
                        case 103: {
                            this.visitAssignmentOrUnaryOperator(functionInformation, nodeTraversal.getScope(), node, node.getFirstChild(), null);
                            break;
                        }
                        case 38: {
                            Preconditions.checkArgument((boolean)NodeUtil.isVarDeclaration(node));
                            Node node4 = node.getFirstChild();
                            if (node4 == null || NodeUtil.evaluatesToLocalValue(node4)) break;
                            Scope scope = nodeTraversal.getScope();
                            Scope.Var var = scope.getVar(node.getString());
                            functionInformation.blacklistLocal(var);
                            break;
                        }
                        case 49: {
                            this.visitThrow(functionInformation);
                            break;
                        }
                        case 4: {
                            if (!node.hasChildren() || NodeUtil.evaluatesToLocalValue(node.getFirstChild())) break;
                            functionInformation.setTaintsReturn();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unhandled side effect node type " + Token.name(node.getType()));
                        }
                    }
                }
            }
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            if (nodeTraversal.inGlobalScope()) {
                return;
            }
            FunctionInformation functionInformation = (FunctionInformation)PureFunctionIdentifier.this.functionSideEffectMap.get(nodeTraversal.getScopeRoot());
            if (functionInformation.mutatesGlobalState()) {
                functionInformation.resetLocalVars();
                return;
            }
            Iterator<Scope.Var> iterator = nodeTraversal.getScope().getVars();
            while (iterator.hasNext()) {
                Scope.Var var = iterator.next();
                boolean bl = false;
                if (var.getParentNode().getType() == 118) {
                    functionInformation.knownLocals.add(var.getName());
                    bl = true;
                }
                if (bl && !functionInformation.blacklisted.contains(var) || !functionInformation.taintedLocals.contains(var)) continue;
                functionInformation.setTaintsUnknown();
                functionInformation.resetLocalVars();
                break;
            }
            functionInformation.taintedLocals = null;
            functionInformation.blacklisted = null;
        }

        private void visitAssignmentOrUnaryOperator(FunctionInformation functionInformation, Scope scope, Node node, Node node2, Node node3) {
            if (NodeUtil.isName(node2)) {
                Scope.Var var = scope.getVar(node2.getString());
                if (var == null || var.scope != scope) {
                    functionInformation.setTaintsGlobalState();
                } else {
                    Preconditions.checkState((NodeUtil.isAssignmentOp(node) || PureFunctionIdentifier.isIncDec(node) || node.getType() == 31 ? 1 : 0) != 0);
                    if (node3 != null && NodeUtil.isAssign(node) && !NodeUtil.evaluatesToLocalValue(node3)) {
                        functionInformation.blacklistLocal(var);
                    }
                }
            } else if (NodeUtil.isGet(node2)) {
                if (NodeUtil.isThis(node2.getFirstChild())) {
                    functionInformation.setTaintsThis();
                } else {
                    Scope.Var var = null;
                    Node node4 = node2.getFirstChild();
                    if (NodeUtil.isName(node4)) {
                        var = scope.getVar(node4.getString());
                    }
                    if (var == null || var.scope != scope) {
                        functionInformation.setTaintsUnknown();
                    } else {
                        functionInformation.addTaintedLocalObject(var);
                    }
                }
            } else {
                functionInformation.setTaintsUnknown();
            }
        }

        private void visitCall(FunctionInformation functionInformation, Node node) {
            if (NodeUtil.isCall(node) && !NodeUtil.functionCallHasSideEffects(node, PureFunctionIdentifier.this.compiler)) {
                return;
            }
            if (NodeUtil.isNew(node) && !NodeUtil.constructorCallHasSideEffects(node)) {
                return;
            }
            functionInformation.appendCall(node);
        }

        private void visitFunction(NodeTraversal nodeTraversal, Node node, Node node2, Node node3) {
            boolean bl;
            Serializable serializable;
            Preconditions.checkArgument((!PureFunctionIdentifier.this.functionSideEffectMap.containsKey(node) ? 1 : 0) != 0);
            FunctionInformation functionInformation = new FunctionInformation(this.inExterns);
            PureFunctionIdentifier.this.functionSideEffectMap.put(node, functionInformation);
            if (this.inExterns) {
                FunctionType functionType;
                JSType jSType;
                serializable = node.getJSType();
                bl = false;
                if (serializable != null && ((JSType)serializable).isFunctionType() && this.isLocalValueType(jSType = (functionType = (FunctionType)serializable).getReturnType(), true)) {
                    bl = true;
                }
                if (!bl) {
                    functionInformation.setTaintsReturn();
                }
            }
            if ((serializable = this.getJSDocInfoForFunction(node, node2, node3)) != null) {
                bl = false;
                if (this.hasSideEffectsThisAnnotation((JSDocInfo)serializable)) {
                    if (this.inExterns) {
                        bl = true;
                        functionInformation.setTaintsThis();
                    } else {
                        nodeTraversal.report(node, INVALID_MODIFIES_ANNOTATION, new String[0]);
                    }
                }
                if (this.hasSideEffectsArgumentsAnnotation((JSDocInfo)serializable)) {
                    if (this.inExterns) {
                        bl = true;
                        functionInformation.setTaintsArguments();
                    } else {
                        nodeTraversal.report(node, INVALID_MODIFIES_ANNOTATION, new String[0]);
                    }
                }
                if (!bl) {
                    if (this.hasNoSideEffectsAnnotation((JSDocInfo)serializable)) {
                        if (this.inExterns) {
                            functionInformation.setIsPure();
                        } else {
                            nodeTraversal.report(node, INVALID_NO_SIDE_EFFECT_ANNOTATION, new String[0]);
                        }
                    } else if (this.inExterns) {
                        functionInformation.setTaintsGlobalState();
                    }
                }
            } else if (this.inExterns) {
                functionInformation.setTaintsGlobalState();
            }
        }

        private boolean isLocalValueType(JSType jSType, boolean bl) {
            Preconditions.checkNotNull((Object)jSType);
            JSType jSType2 = jSType.getGreatestSubtype(PureFunctionIdentifier.this.compiler.getTypeRegistry().getNativeType(JSTypeNative.OBJECT_TYPE));
            return jSType2.isNoType();
        }

        private void visitThrow(FunctionInformation functionInformation) {
            functionInformation.setFunctionThrows();
        }

        private JSDocInfo getJSDocInfoForFunction(Node node, Node node2, Node node3) {
            JSDocInfo jSDocInfo = node.getJSDocInfo();
            if (jSDocInfo != null) {
                return jSDocInfo;
            }
            if (NodeUtil.isName(node2)) {
                return node3.hasOneChild() ? node3.getJSDocInfo() : null;
            }
            if (NodeUtil.isAssign(node2)) {
                return node2.getJSDocInfo();
            }
            return null;
        }

        private boolean hasNoSideEffectsAnnotation(JSDocInfo jSDocInfo) {
            Preconditions.checkNotNull((Object)jSDocInfo);
            return jSDocInfo.isNoSideEffects();
        }

        private boolean hasSideEffectsThisAnnotation(JSDocInfo jSDocInfo) {
            Preconditions.checkNotNull((Object)jSDocInfo);
            return jSDocInfo.getModifies().contains("this");
        }

        private boolean hasSideEffectsArgumentsAnnotation(JSDocInfo jSDocInfo) {
            Preconditions.checkNotNull((Object)jSDocInfo);
            Set<String> set = jSDocInfo.getModifies();
            return set.size() > 1 || set.size() == 1 && !set.contains("this");
        }
    }
}

