/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.LinkedUndirectedGraph;
import com.google.javascript.jscomp.graph.UndiGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;

class RenameProperties
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final boolean generatePseudoNames;
    private final VariableMap prevUsedPropertyMap;
    private final List<Node> stringNodesToRename = new ArrayList<Node>();
    private final Map<Node, Node> callNodeToParentMap = new HashMap<Node, Node>();
    private final char[] reservedCharacters;
    private final Map<String, Property> propertyMap = new HashMap<String, Property>();
    private final UndiGraph<Property, PropertyAffinity> affinityGraph = LinkedUndirectedGraph.createWithoutAnnotations();
    private final Set<String> externedNames = new HashSet<String>(Arrays.asList("prototype"));
    private final Set<String> quotedNames = new HashSet<String>();
    private static final Comparator<Property> FREQUENCY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property property, Property property2) {
            if (property.numOccurrences != property2.numOccurrences) {
                return property2.numOccurrences - property.numOccurrences;
            }
            if (property.affinityScore != property2.affinityScore) {
                return property2.affinityScore - property.affinityScore;
            }
            return property.oldName.compareTo(property2.oldName);
        }
    };
    static final String RENAME_PROPERTY_FUNCTION_NAME = "JSCompiler_renameProperty";
    static final DiagnosticType BAD_CALL = DiagnosticType.error("JSC_BAD_RENAME_PROPERTY_FUNCTION_NAME_CALL", "Bad JSCompiler_renameProperty call - argument must be a string literal");
    static final DiagnosticType BAD_ARG = DiagnosticType.error("JSC_BAD_RENAME_PROPERTY_FUNCTION_NAME_ARG", "Bad JSCompiler_renameProperty argument - '{0}' is not a valid JavaScript identifier");

    RenameProperties(AbstractCompiler abstractCompiler, boolean bl) {
        this(abstractCompiler, bl, null, null);
    }

    RenameProperties(AbstractCompiler abstractCompiler, boolean bl, VariableMap variableMap) {
        this(abstractCompiler, bl, variableMap, null);
    }

    RenameProperties(AbstractCompiler abstractCompiler, boolean bl, VariableMap variableMap, @Nullable char[] cArray) {
        this.compiler = abstractCompiler;
        this.generatePseudoNames = bl;
        this.prevUsedPropertyMap = variableMap;
        this.reservedCharacters = cArray;
    }

    @Override
    public void process(Node node, Node node2) {
        Object object;
        Object object2;
        Preconditions.checkState((boolean)this.compiler.getLifeCycleStage().isNormalized());
        NodeTraversal.traverse(this.compiler, node, new ProcessExterns());
        NodeTraversal.traverse(this.compiler, node2, new ProcessProperties());
        HashSet<String> hashSet = new HashSet<String>(this.externedNames.size() + this.quotedNames.size());
        hashSet.addAll(this.externedNames);
        hashSet.addAll(this.quotedNames);
        if (this.prevUsedPropertyMap != null) {
            this.reusePropertyNames(hashSet, this.propertyMap.values());
        }
        this.compiler.addToDebugLog("JS property assignments:");
        this.computeAffinityScores();
        TreeSet<Property> treeSet = new TreeSet<Property>(FREQUENCY_COMPARATOR);
        treeSet.addAll(this.propertyMap.values());
        this.generateNames(treeSet, hashSet);
        boolean bl = false;
        for (Node node3 : this.stringNodesToRename) {
            object2 = node3.getString();
            object = this.propertyMap.get(object2);
            if (object == null || ((Property)object).newName == null) continue;
            Preconditions.checkState((boolean)((String)object2).equals(((Property)object).oldName));
            node3.setString(((Property)object).newName);
            bl = bl || !((Property)object).newName.equals(object2);
        }
        for (Node node3 : this.callNodeToParentMap.keySet()) {
            object2 = this.callNodeToParentMap.get(node3);
            object = node3.getFirstChild().getNext();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : ((Node)object).getString().split("[.]")) {
                String string2;
                Property property = this.propertyMap.get(string);
                if (property != null && property.newName != null) {
                    Preconditions.checkState((boolean)string.equals(property.oldName));
                    string2 = property.newName;
                } else {
                    string2 = string;
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('.');
                }
                stringBuilder.append(string2);
            }
            ((Node)object2).replaceChild(node3, Node.newString(stringBuilder.toString()));
            bl = true;
        }
        if (bl) {
            this.compiler.reportCodeChange();
        }
        this.compiler.setLifeCycleStage(AbstractCompiler.LifeCycleStage.NORMALIZED_OBFUSCATED);
    }

    private void reusePropertyNames(Set<String> set, Collection<Property> collection) {
        for (Property property : collection) {
            String string = this.prevUsedPropertyMap.lookupNewName(property.oldName);
            if (this.generatePseudoNames || string == null || set.contains(string)) continue;
            property.newName = string;
            set.add(string);
        }
    }

    private void computeAffinityScores() {
        for (Property property : this.propertyMap.values()) {
            UndiGraph.UndiGraphNode<Property, PropertyAffinity> undiGraphNode = this.affinityGraph.getUndirectedGraphNode(property);
            int n = 0;
            Iterator<UndiGraph.UndiGraphEdge<Property, PropertyAffinity>> iterator = undiGraphNode.getNeighborEdgesIterator();
            while (iterator.hasNext()) {
                UndiGraph.UndiGraphEdge<Property, PropertyAffinity> undiGraphEdge = iterator.next();
                n += ((PropertyAffinity)undiGraphEdge.getValue()).affinity + (undiGraphNode == undiGraphEdge.getNodeA() ? ((Property)undiGraphEdge.getNodeB().getValue()).numOccurrences : ((Property)undiGraphEdge.getNodeA().getValue()).numOccurrences);
            }
            ((Property)undiGraphNode.getValue()).affinityScore = n;
        }
    }

    private void generateNames(Set<Property> set, Set<String> set2) {
        NameGenerator nameGenerator = new NameGenerator(set2, "", this.reservedCharacters);
        for (Property property : set) {
            if (this.generatePseudoNames) {
                property.newName = "$" + property.oldName + "$";
            } else if (property.newName == null) {
                property.newName = nameGenerator.generateNextName();
            }
            set2.add(property.newName);
            this.compiler.addToDebugLog(property.oldName + " => " + property.newName);
        }
    }

    VariableMap getPropertyMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Property property : this.propertyMap.values()) {
            if (property.newName == null) continue;
            hashMap.put(property.oldName, property.newName);
        }
        return new VariableMap(hashMap);
    }

    private class PropertyAffinity {
        private int affinity = 0;

        private PropertyAffinity(int n) {
            this.affinity = n;
        }

        private void increase() {
            ++this.affinity;
        }
    }

    private class Property {
        final String oldName;
        String newName;
        int numOccurrences;
        int affinityScore = 0;

        Property(String string) {
            this.oldName = string;
        }
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private Set<Property> currentHighAffinityProperties = null;

        private ProcessProperties() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: {
                    Node node3 = node.getFirstChild().getNext();
                    if (node3.getType() != 40) break;
                    this.maybeMarkCandidate(node3);
                    break;
                }
                case 64: {
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        if (node4.getType() == 39) continue;
                        if (!node4.isQuotedString()) {
                            this.maybeMarkCandidate(node4);
                            continue;
                        }
                        RenameProperties.this.quotedNames.add(node4.getString());
                    }
                    break;
                }
                case 35: {
                    Node node5 = node.getLastChild();
                    if (node5 == null || node5.getType() != 40) break;
                    RenameProperties.this.quotedNames.add(node5.getString());
                    break;
                }
                case 37: {
                    Node node6 = node.getFirstChild();
                    if (node6.getType() != 38 || !RenameProperties.RENAME_PROPERTY_FUNCTION_NAME.equals(node6.getString())) break;
                    RenameProperties.this.callNodeToParentMap.put(node, node2);
                    this.countCallCandidates(nodeTraversal, node);
                    break;
                }
                case 105: {
                    Node node7;
                    if (NodeUtil.isFunctionDeclaration(node)) {
                        String string = node.getFirstChild().getString();
                        if (!RenameProperties.RENAME_PROPERTY_FUNCTION_NAME.equals(string)) break;
                        if (NodeUtil.isExpressionNode(node2)) {
                            node2.detachFromParent();
                        } else {
                            node2.removeChild(node);
                        }
                        RenameProperties.this.compiler.reportCodeChange();
                        break;
                    }
                    if (node2.getType() != 38 || !RenameProperties.RENAME_PROPERTY_FUNCTION_NAME.equals(node2.getString()) || (node7 = node2.getParent()).getType() != 118) break;
                    node7.removeChild(node2);
                    if (!node7.hasChildren()) {
                        node7.detachFromParent();
                    }
                    RenameProperties.this.compiler.reportCodeChange();
                }
            }
        }

        private void maybeMarkCandidate(Node node) {
            String string = node.getString();
            if (!RenameProperties.this.externedNames.contains(string)) {
                RenameProperties.this.stringNodesToRename.add(node);
                this.countPropertyOccurrence(string);
            }
        }

        private void countCallCandidates(NodeTraversal nodeTraversal, Node node) {
            Node node2 = node.getFirstChild().getNext();
            if (node2.getType() != 40) {
                nodeTraversal.report(node, BAD_CALL, new String[0]);
                return;
            }
            for (String string : node2.getString().split("[.]")) {
                if (!TokenStream.isJSIdentifier(string)) {
                    nodeTraversal.report(node, BAD_ARG, string);
                    continue;
                }
                if (RenameProperties.this.externedNames.contains(string)) continue;
                this.countPropertyOccurrence(string);
            }
        }

        private void countPropertyOccurrence(String string) {
            Property property = (Property)RenameProperties.this.propertyMap.get(string);
            if (property == null) {
                property = new Property(string);
                RenameProperties.this.propertyMap.put(string, property);
                RenameProperties.this.affinityGraph.createNode(property);
            }
            ++property.numOccurrences;
            if (this.currentHighAffinityProperties != null) {
                this.currentHighAffinityProperties.add(property);
            }
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            if (!nodeTraversal.inGlobalScope() && nodeTraversal.getScope().getParent().isGlobal()) {
                this.currentHighAffinityProperties = Sets.newHashSet();
            }
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            if (!nodeTraversal.inGlobalScope() && nodeTraversal.getScope().getParent().isGlobal()) {
                for (Property property : this.currentHighAffinityProperties) {
                    for (Property property2 : this.currentHighAffinityProperties) {
                        if (property.oldName.compareTo(property2.oldName) >= 0) continue;
                        Graph.GraphEdge graphEdge = RenameProperties.this.affinityGraph.getFirstEdge(property, property2);
                        if (graphEdge == null) {
                            RenameProperties.this.affinityGraph.connect(property, new PropertyAffinity(1), property2);
                            continue;
                        }
                        ((PropertyAffinity)graphEdge.getValue()).increase();
                    }
                }
                this.currentHighAffinityProperties = null;
            }
        }
    }

    private class ProcessExterns
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessExterns() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            switch (node.getType()) {
                case 33: {
                    Node node3 = node.getFirstChild().getNext();
                    if (node3.getType() != 40) break;
                    RenameProperties.this.externedNames.add(node3.getString());
                    break;
                }
                case 64: {
                    for (Node node4 = node.getFirstChild(); node4 != null; node4 = node4.getNext()) {
                        if (node4.getType() == 39) continue;
                        RenameProperties.this.externedNames.add(node4.getString());
                    }
                    break;
                }
            }
        }
    }
}

