/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.MakeDeclaredNamesUnique;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ShadowVariables;
import com.google.javascript.jscomp.VariableMap;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;

final class RenameVars
implements CompilerPass {
    private final AbstractCompiler compiler;
    private final ArrayList<Node> globalNameNodes = new ArrayList();
    private final ArrayList<Node> localNameNodes = new ArrayList();
    private final Map<Node, String> pseudoNameMap;
    private final Set<String> externNames = new HashSet<String>();
    private final Set<String> reservedNames;
    private final Map<String, String> renameMap = new HashMap<String, String>();
    private final VariableMap prevUsedRenameMap;
    private final String prefix;
    private int assignmentCount = 0;
    private StringBuilder assignmentLog;
    private Set<Scope.Var> localBleedingFunctions = Sets.newHashSet();
    private ArrayListMultimap<Scope, Scope.Var> localBleedingFunctionsPerScope = ArrayListMultimap.create();
    private final SortedMap<String, Assignment> assignments = new TreeMap<String, Assignment>();
    private final boolean localRenamingOnly;
    private boolean preserveFunctionExpressionNames;
    private final boolean shouldShadow;
    private final char[] reservedCharacters;
    public static final String LOCAL_VAR_PREFIX = "L ";
    private static final Comparator<Assignment> FREQUENCY_COMPARATOR = new Comparator<Assignment>(){

        @Override
        public int compare(Assignment assignment, Assignment assignment2) {
            if (assignment.count != assignment2.count) {
                return assignment2.count - assignment.count;
            }
            return ORDER_OF_OCCURRENCE_COMPARATOR.compare(assignment, assignment2);
        }
    };
    private static final Comparator<Assignment> ORDER_OF_OCCURRENCE_COMPARATOR = new Comparator<Assignment>(){

        @Override
        public int compare(Assignment assignment, Assignment assignment2) {
            return assignment.orderOfOccurrence - assignment2.orderOfOccurrence;
        }
    };

    RenameVars(AbstractCompiler abstractCompiler, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, VariableMap variableMap, @Nullable char[] cArray, @Nullable Set<String> set) {
        this.compiler = abstractCompiler;
        this.prefix = string == null ? "" : string;
        this.localRenamingOnly = bl;
        this.preserveFunctionExpressionNames = bl2;
        this.pseudoNameMap = bl3 ? Maps.newHashMap() : null;
        this.prevUsedRenameMap = variableMap;
        this.reservedCharacters = cArray;
        this.shouldShadow = bl4;
        this.reservedNames = set == null ? Sets.newHashSet() : Sets.newHashSet(set);
    }

    @Override
    public void process(Node node, Node node2) {
        this.assignmentLog = new StringBuilder();
        NodeTraversal.traverse(this.compiler, node, new ProcessVars(true));
        NodeTraversal.traverse(this.compiler, node2, new ProcessVars(false));
        this.reservedNames.addAll(this.externNames);
        TreeSet<Assignment> treeSet = new TreeSet<Assignment>(FREQUENCY_COMPARATOR);
        treeSet.addAll(this.assignments.values());
        if (this.shouldShadow) {
            new ShadowVariables(this.compiler, this.assignments, treeSet, this.pseudoNameMap).process(node, node2);
        }
        if (this.prevUsedRenameMap != null) {
            this.reusePreviouslyUsedVariableMap();
        }
        this.assignNames(treeSet);
        boolean bl = false;
        for (Node object : this.globalNameNodes) {
            String string = this.getNewGlobalName(object);
            if (string == null) continue;
            object.setString(string);
            bl = true;
        }
        int n = 0;
        for (Node node3 : this.localNameNodes) {
            String string = this.getNewLocalName(node3);
            if (string != null) {
                node3.setString(string);
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.compiler.reportCodeChange();
        }
        this.compiler.addToDebugLog("JS var assignments:\n" + this.assignmentLog);
        this.assignmentLog = null;
    }

    private String getNewGlobalName(Node node) {
        String string = node.getString();
        Assignment assignment = (Assignment)this.assignments.get(string);
        if (assignment.newName != null && !assignment.newName.equals(string)) {
            if (this.pseudoNameMap != null) {
                return this.pseudoNameMap.get(node);
            }
            return assignment.newName;
        }
        return null;
    }

    private String getNewLocalName(Node node) {
        String string = node.getString();
        Assignment assignment = (Assignment)this.assignments.get(string);
        if (!assignment.newName.equals(string)) {
            if (this.pseudoNameMap != null) {
                return this.pseudoNameMap.get(node);
            }
            return assignment.newName;
        }
        return null;
    }

    private void recordPseudoName(Node node) {
        this.pseudoNameMap.put(node, '$' + node.getString() + "$$");
    }

    private void reusePreviouslyUsedVariableMap() {
        for (Assignment assignment : this.assignments.values()) {
            String string = this.prevUsedRenameMap.lookupNewName(assignment.oldName);
            if (string == null || this.reservedNames.contains(string) || !assignment.oldName.startsWith(LOCAL_VAR_PREFIX) && (this.externNames.contains(assignment.oldName) || !string.startsWith(this.prefix))) continue;
            this.reservedNames.add(string);
            this.finalizeNameAssignment(assignment, string);
        }
    }

    private void assignNames(Set<Assignment> set) {
        Object object;
        NameGenerator nameGenerator = new NameGenerator(this.reservedNames, this.prefix, this.reservedCharacters);
        NameGenerator nameGenerator2 = this.prefix.isEmpty() ? nameGenerator : new NameGenerator(this.reservedNames, "", this.reservedCharacters);
        ArrayList<Assignment> arrayList = new ArrayList<Assignment>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (Assignment assignment : set) {
            if (assignment.newName != null || this.externNames.contains(assignment.oldName)) continue;
            if (assignment.oldName.startsWith(LOCAL_VAR_PREFIX)) {
                object = nameGenerator2.generateNextName();
                this.finalizeNameAssignment(assignment, (String)object);
            } else {
                object = nameGenerator.generateNextName();
                arrayList.add(assignment);
                arrayList2.add(object);
            }
            this.reservedNames.add((String)object);
        }
        int n = arrayList2.size();
        int n2 = 0;
        while (n2 < n) {
            object = new TreeSet<Assignment>(ORDER_OF_OCCURRENCE_COMPARATOR);
            int n3 = ((String)arrayList2.get(n2)).length();
            for (int i = n2; i < n && ((String)arrayList2.get(i)).length() == n3; ++i) {
                object.add(arrayList.get(i));
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Assignment assignment = (Assignment)iterator.next();
                this.finalizeNameAssignment(assignment, (String)arrayList2.get(n2));
                ++n2;
            }
        }
    }

    private void finalizeNameAssignment(Assignment assignment, String string) {
        assignment.setNewName(string);
        this.renameMap.put(assignment.oldName, string);
        this.assignmentLog.append(assignment.oldName).append(" => ").append(string).append('\n');
    }

    VariableMap getVariableMap() {
        return new VariableMap(this.renameMap);
    }

    private boolean okToRenameVar(String string, boolean bl) {
        return !this.compiler.getCodingConvention().isExported(string, bl);
    }

    private int getLocalVarIndex(Scope.Var var) {
        boolean bl;
        int n = var.index;
        Scope scope = var.scope.getParent();
        if (scope == null) {
            throw new IllegalArgumentException("Var is not local");
        }
        boolean bl2 = bl = scope.getParent() != null && this.localBleedingFunctions.contains(var);
        while (scope.getParent() != null) {
            if (bl) {
                n += this.localBleedingFunctionsPerScope.get((Object)scope).indexOf(var) + 1;
                bl = false;
            } else {
                n += this.localBleedingFunctionsPerScope.get((Object)scope).size();
            }
            n += scope.getVarCount();
            scope = scope.getParent();
        }
        return n;
    }

    class ProcessVars
    extends NodeTraversal.AbstractPostOrderCallback
    implements NodeTraversal.ScopedCallback {
        private final boolean isExternsPass_;

        ProcessVars(boolean bl) {
            this.isExternsPass_ = bl;
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            if (nodeTraversal.inGlobalScope()) {
                return;
            }
            Iterator<Scope.Var> iterator = nodeTraversal.getScope().getVars();
            while (iterator.hasNext()) {
                Scope.Var var = iterator.next();
                if (!var.isBleedingFunction()) continue;
                RenameVars.this.localBleedingFunctions.add(var);
                RenameVars.this.localBleedingFunctionsPerScope.put((Object)nodeTraversal.getScope().getParent(), (Object)var);
            }
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            boolean bl;
            if (node.getType() != 38) {
                return;
            }
            String string = node.getString();
            if (string.length() == 0) {
                return;
            }
            Scope.Var var = nodeTraversal.getScope().getVar(string);
            boolean bl2 = bl = var != null && var.isLocal() && (!var.scope.getParent().isGlobal() || !var.isBleedingFunction());
            if (!bl && RenameVars.this.localRenamingOnly) {
                RenameVars.this.reservedNames.add(string);
                return;
            }
            if (RenameVars.this.preserveFunctionExpressionNames && var != null && NodeUtil.isFunctionExpression(var.getParentNode())) {
                RenameVars.this.reservedNames.add(string);
                return;
            }
            if (!RenameVars.this.okToRenameVar(string, bl)) {
                String string2;
                if (bl && !(string2 = MakeDeclaredNamesUnique.ContextualRenameInverter.getOrginalName(string)).equals(string)) {
                    node.setString(string2);
                }
                return;
            }
            if (this.isExternsPass_) {
                if (!bl) {
                    RenameVars.this.externNames.add(string);
                }
                return;
            }
            if (RenameVars.this.pseudoNameMap != null) {
                RenameVars.this.recordPseudoName(node);
            }
            if (bl) {
                String string3 = RenameVars.LOCAL_VAR_PREFIX + RenameVars.this.getLocalVarIndex(var);
                this.incCount(string3);
                RenameVars.this.localNameNodes.add(node);
                node.setString(string3);
            } else if (var != null) {
                this.incCount(string);
                RenameVars.this.globalNameNodes.add(node);
            }
        }

        void incCount(String string) {
            Assignment assignment = (Assignment)RenameVars.this.assignments.get(string);
            if (assignment == null) {
                assignment = new Assignment(string);
                RenameVars.this.assignments.put(string, assignment);
            }
            ++assignment.count;
        }
    }

    class Assignment {
        final String oldName;
        final int orderOfOccurrence;
        String newName;
        int count;

        Assignment(String string) {
            this.oldName = string;
            this.newName = null;
            this.count = 0;
            this.orderOfOccurrence = RenameVars.this.assignmentCount++;
        }

        void setNewName(String string) {
            Preconditions.checkState((this.newName == null ? 1 : 0) != 0);
            this.newName = string;
        }
    }
}

