/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NameGenerator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ReplaceIdGenerators
implements CompilerPass {
    static final DiagnosticType NON_GLOBAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_NON_GLOBAL_ID_GENERATOR_CALL", "Id generator call must be in the global scope");
    static final DiagnosticType CONDITIONAL_ID_GENERATOR_CALL = DiagnosticType.error("JSC_CONDITIONAL_ID_GENERATOR_CALL", "Id generator call must be unconditional");
    private final AbstractCompiler compiler;
    private final Map<String, NameGenerator> nameGenerators;
    private final Map<String, List<Replacement>> idGeneratorMaps;

    public ReplaceIdGenerators(AbstractCompiler abstractCompiler, Set<String> set) {
        this.compiler = abstractCompiler;
        this.nameGenerators = Maps.newHashMap();
        this.idGeneratorMaps = Maps.newLinkedHashMap();
        for (String string : set) {
            this.nameGenerators.put(string, new NameGenerator(Collections.<String>emptySet(), "", null));
            this.idGeneratorMaps.put(string, Lists.newArrayList());
        }
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new Callback());
    }

    public String getIdGeneratorMap() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, List<Replacement>> entry : this.idGeneratorMaps.entrySet()) {
            stringBuilder.append("[");
            stringBuilder.append(entry.getKey());
            stringBuilder.append("]\n\n");
            for (Replacement replacement : entry.getValue()) {
                stringBuilder.append(replacement.toString());
                stringBuilder.append("\n");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private static class Replacement {
        private final String name;
        private final String sourceName;
        private final int lineNumber;

        private Replacement(String string, String string2, int n) {
            this.name = string;
            this.sourceName = string2;
            this.lineNumber = n;
        }

        public String toString() {
            return this.name + ":" + this.sourceName + ":" + this.lineNumber;
        }
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() != 37) {
                return;
            }
            String string = node.getFirstChild().getQualifiedName();
            NameGenerator nameGenerator = (NameGenerator)ReplaceIdGenerators.this.nameGenerators.get(string);
            if (nameGenerator == null) {
                return;
            }
            List list = (List)ReplaceIdGenerators.this.idGeneratorMaps.get(string);
            if (!nodeTraversal.inGlobalScope()) {
                ReplaceIdGenerators.this.compiler.report(nodeTraversal.makeError(node, NON_GLOBAL_ID_GENERATOR_CALL, new String[0]));
                return;
            }
            for (Node node3 : node.getAncestors()) {
                if (!NodeUtil.isControlStructure(node3)) continue;
                ReplaceIdGenerators.this.compiler.report(nodeTraversal.makeError(node, CONDITIONAL_ID_GENERATOR_CALL, new String[0]));
                return;
            }
            String string2 = nameGenerator.generateNextName();
            node2.replaceChild(node, Node.newString(string2));
            list.add(new Replacement(string2, nodeTraversal.getSourceName(), nodeTraversal.getLineNumber()));
            ReplaceIdGenerators.this.compiler.reportCodeChange();
        }
    }
}

