/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Normalize;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.UnionType;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import javax.annotation.Nullable;

class RuntimeTypeCheck
implements CompilerPass {
    private static final Comparator<JSType> ALPHA = new Comparator<JSType>(){

        @Override
        public int compare(JSType jSType, JSType jSType2) {
            return this.getName(jSType).compareTo(this.getName(jSType2));
        }

        private String getName(JSType jSType) {
            if (jSType.isInstanceType()) {
                return ((ObjectType)jSType).getReferenceName();
            }
            if (jSType.isNullType() || jSType.isBooleanValueType() || jSType.isNumberValueType() || jSType.isStringValueType() || jSType.isVoidType()) {
                return jSType.toString();
            }
            return "";
        }
    };
    private final AbstractCompiler compiler;
    private final String logFunction;

    RuntimeTypeCheck(AbstractCompiler abstractCompiler, @Nullable String string) {
        this.compiler = abstractCompiler;
        this.logFunction = string;
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, new AddMarkers(this.compiler));
        NodeTraversal.traverse(this.compiler, node2, new AddChecks());
        this.addBoilerplateCode();
    }

    private void addBoilerplateCode() {
        Node node = RuntimeTypeCheck.getBoilerplateCode(this.compiler, this.logFunction);
        this.compiler.getNodeForCodeInsertion(null).addChildrenToFront(node.removeChildren());
        this.compiler.reportCodeChange();
    }

    private Node jsCode(String string) {
        return NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), "jscomp.typecheck." + string, -1, -1);
    }

    @VisibleForTesting
    static Node getBoilerplateCode(AbstractCompiler abstractCompiler, @Nullable String string) {
        String string2;
        try {
            string2 = CharStreams.toString((Readable)new InputStreamReader(RuntimeTypeCheck.class.getResourceAsStream("js/runtime_type_check.js"), Charsets.UTF_8));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        string2 = string2.replace("%%LOG%%", string == null ? "function(warning, expr) {}" : string);
        return Normalize.parseAndNormalizeSyntheticCode(abstractCompiler, string2, "jscomp_runtimeTypeCheck_");
    }

    private class AddChecks
    extends NodeTraversal.AbstractPostOrderCallback {
        private AddChecks() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (NodeUtil.isFunction(node)) {
                this.visitFunction(nodeTraversal, node);
            } else if (node.getType() == 4) {
                this.visitReturn(nodeTraversal, node);
            }
        }

        private void visitFunction(NodeTraversal nodeTraversal, Node node) {
            FunctionType functionType = (FunctionType)node.getJSType();
            Node node2 = node.getLastChild();
            Node node3 = NodeUtil.getFnParameters(node).getFirstChild();
            Node node4 = null;
            for (Object object = node2.getFirstChild(); object != null && NodeUtil.isFunctionDeclaration((Node)object); object = ((Node)object).getNext()) {
                node4 = object;
            }
            for (Node node5 : functionType.getParameters()) {
                if (node3 == null) {
                    return;
                }
                Node node6 = this.createCheckTypeCallNode(node5.getJSType(), node3.cloneTree());
                if (node6 == null) {
                    node3 = node3.getNext();
                    continue;
                }
                node6 = new Node(130, node6);
                if (node4 == null) {
                    node2.addChildToFront(node6);
                } else {
                    node2.addChildAfter(node6, node4);
                }
                RuntimeTypeCheck.this.compiler.reportCodeChange();
                node3 = node3.getNext();
                node4 = node6;
            }
        }

        private void visitReturn(NodeTraversal nodeTraversal, Node node) {
            Node node2 = nodeTraversal.getEnclosingFunction();
            FunctionType functionType = (FunctionType)node2.getJSType();
            Node node3 = node.getFirstChild();
            if (node3 == null) {
                return;
            }
            Node node4 = this.createCheckTypeCallNode(functionType.getReturnType(), node3.cloneTree());
            if (node4 == null) {
                return;
            }
            node.replaceChild(node3, node4);
            RuntimeTypeCheck.this.compiler.reportCodeChange();
        }

        private Node createCheckTypeCallNode(JSType jSType, Node node) {
            TreeSet treeSet;
            Node node2 = new Node(63);
            if (jSType.isUnionType()) {
                treeSet = Sets.newTreeSet((Comparator)ALPHA);
                Iterables.addAll((Collection)treeSet, ((UnionType)jSType).getAlternates());
            } else {
                treeSet = ImmutableList.of((Object)jSType);
            }
            for (JSType jSType2 : treeSet) {
                Node node3 = this.createCheckerNode(jSType2);
                if (node3 == null) {
                    return null;
                }
                node2.addChildToBack(node3);
            }
            return new Node(37, RuntimeTypeCheck.this.jsCode("checkType"), node, node2);
        }

        private Node createCheckerNode(JSType jSType) {
            if (jSType.isNullType()) {
                return RuntimeTypeCheck.this.jsCode("nullChecker");
            }
            if (jSType.isBooleanValueType() || jSType.isNumberValueType() || jSType.isStringValueType() || jSType.isVoidType()) {
                return new Node(37, RuntimeTypeCheck.this.jsCode("valueChecker"), Node.newString(jSType.toString()));
            }
            if (jSType.isInstanceType()) {
                ObjectType objectType = (ObjectType)jSType;
                String string = objectType.getReferenceName();
                String string2 = NodeUtil.getSourceName(objectType.getConstructor().getSource());
                CompilerInput compilerInput = RuntimeTypeCheck.this.compiler.getInput(string2);
                if (compilerInput == null || compilerInput.isExtern()) {
                    return new Node(37, RuntimeTypeCheck.this.jsCode("externClassChecker"), Node.newString(string));
                }
                return new Node(37, RuntimeTypeCheck.this.jsCode(objectType.getConstructor().isInterface() ? "interfaceChecker" : "classChecker"), Node.newString(string));
            }
            return null;
        }
    }

    private static class AddMarkers
    extends NodeTraversal.AbstractPostOrderCallback {
        private final AbstractCompiler compiler;

        private AddMarkers(AbstractCompiler abstractCompiler) {
            this.compiler = abstractCompiler;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (NodeUtil.isFunction(node)) {
                this.visitFunction(nodeTraversal, node);
            }
        }

        private void visitFunction(NodeTraversal nodeTraversal, Node node) {
            FunctionType functionType = (FunctionType)node.getJSType();
            if (!functionType.isConstructor()) {
                return;
            }
            Node node2 = this.findNodeToInsertAfter(node);
            node2 = this.addMarker(functionType, node2, null);
            TreeSet treeSet = Sets.newTreeSet((Comparator)ALPHA);
            Iterables.addAll((Collection)treeSet, functionType.getAllImplementedInterfaces());
            for (ObjectType objectType : treeSet) {
                node2 = this.addMarker(functionType, node2, objectType);
            }
        }

        private Node addMarker(FunctionType functionType, Node node, @Nullable ObjectType objectType) {
            if (functionType.getSource() == null) {
                return node;
            }
            String string = NodeUtil.getFunctionName(functionType.getSource());
            if (string == null) {
                return node;
            }
            Node node2 = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), string, -1, -1);
            Node node3 = Node.newString(objectType == null ? "instance_of__" + string : "implements__" + objectType.getReferenceName());
            Node node4 = new Node(130, new Node(86, new Node(35, new Node(33, node2, Node.newString("prototype")), node3), new Node(44)));
            node.getParent().addChildAfter(node4, node);
            this.compiler.reportCodeChange();
            node = node4;
            return node;
        }

        private Node findNodeToInsertAfter(Node node) {
            Node node2 = this.findEnclosingConstructorDeclaration(node);
            Node node3 = node2.getNext();
            while (node3 != null && this.isClassDefiningCall(node3)) {
                node2 = node3;
                node3 = node2.getNext();
            }
            return node2;
        }

        private Node findEnclosingConstructorDeclaration(Node node) {
            while (node.getParent().getType() != 132 && node.getParent().getType() != 125) {
                node = node.getParent();
            }
            return node;
        }

        private boolean isClassDefiningCall(Node node) {
            return NodeUtil.isExprCall(node) && this.compiler.getCodingConvention().getClassesDefinedByCall(node.getFirstChild()) != null;
        }
    }
}

