/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.Map;

class ScopedAliases
implements CompilerPass {
    static final String SCOPING_METHOD_NAME = "goog.scope";
    private final AbstractCompiler compiler;
    static final DiagnosticType GOOG_SCOPE_USED_IMPROPERLY = DiagnosticType.error("JSC_GOOG_SCOPE_USED_IMPROPERLY", "The call to goog.scope must be alone in a single statement.");
    static final DiagnosticType GOOG_SCOPE_HAS_BAD_PARAMETERS = DiagnosticType.error("JSC_GOOG_SCOPE_HAS_BAD_PARAMETERS", "The call to goog.scope must take only a single parameter.  It must be an anonymous function that itself takes no parameters.");
    static final DiagnosticType GOOG_SCOPE_REFERENCES_THIS = DiagnosticType.error("JSC_GOOG_SCOPE_REFERENCES_THIS", "The body of a goog.scope function cannot reference 'this'.");
    static final DiagnosticType GOOG_SCOPE_USES_RETURN = DiagnosticType.error("JSC_GOOG_SCOPE_USES_RETURN", "The body of a goog.scope function cannot use 'return'.");
    static final DiagnosticType GOOG_SCOPE_USES_THROW = DiagnosticType.error("JSC_GOOG_SCOPE_USES_THROW", "The body of a goog.scope function cannot use 'throw'.");
    static final DiagnosticType GOOG_SCOPE_ALIAS_REDEFINED = DiagnosticType.error("JSC_GOOG_SCOPE_ALIAS_REDEFINED", "The alias {0} is assigned a value more than once.");
    static final DiagnosticType GOOG_SCOPE_NON_ALIAS_LOCAL = DiagnosticType.error("JSC_GOOG_SCOPE_NON_ALIAS_LOCAL", "The local variable {0} is in a goog.scope and is not an alias.");

    ScopedAliases(AbstractCompiler abstractCompiler, CompilerOptions.AliasTransformationHandler aliasTransformationHandler) {
        this.compiler = abstractCompiler;
    }

    @Override
    public void process(Node node, Node node2) {
        Traversal traversal = new Traversal();
        NodeTraversal.traverse(this.compiler, node2, traversal);
        if (!traversal.hasErrors()) {
            for (AliasUsage object : traversal.getAliasUsages()) {
                object.applyAlias();
            }
            for (Node node3 : traversal.getAliasDefinitions()) {
                if (node3.getParent().getType() == 118 && node3.getParent().hasOneChild()) {
                    node3.getParent().detachFromParent();
                    continue;
                }
                node3.detachFromParent();
            }
            for (Node node4 : traversal.getScopeCalls()) {
                Node node5 = node4.getParent();
                Node node6 = node4.getLastChild().getLastChild();
                node6.detachFromParent();
                node5.getParent().replaceChild(node5, node6);
                NodeUtil.tryMergeBlock(node6);
            }
            if (traversal.getAliasUsages().size() > 0 || traversal.getAliasDefinitions().size() > 0 || traversal.getScopeCalls().size() > 0) {
                this.compiler.reportCodeChange();
            }
        }
    }

    private class Traversal
    implements NodeTraversal.ScopedCallback {
        private List<Node> aliasDefinitions = Lists.newArrayList();
        private List<Node> scopeCalls = Lists.newArrayList();
        private List<AliasUsage> aliasUsages = Lists.newArrayList();
        private Map<String, Scope.Var> aliases = Maps.newHashMap();
        private boolean hasErrors = false;

        private Traversal() {
        }

        List<Node> getAliasDefinitions() {
            return this.aliasDefinitions;
        }

        private List<AliasUsage> getAliasUsages() {
            return this.aliasUsages;
        }

        List<Node> getScopeCalls() {
            return this.scopeCalls;
        }

        boolean hasErrors() {
            return this.hasErrors;
        }

        private boolean isCallToScopeMethod(Node node) {
            return node.getType() == 37 && ScopedAliases.SCOPING_METHOD_NAME.equals(node.getFirstChild().getQualifiedName());
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
            if (nodeTraversal.getScopeDepth() == 2) {
                this.aliases.clear();
            }
        }

        @Override
        public final boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return node.getType() != 105 || !nodeTraversal.inGlobalScope() || node2 != null && this.isCallToScopeMethod(node2);
        }

        private void report(NodeTraversal nodeTraversal, Node node, DiagnosticType diagnosticType, String ... stringArray) {
            ScopedAliases.this.compiler.report(nodeTraversal.makeError(node, diagnosticType, stringArray));
            this.hasErrors = true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            Object object;
            if (this.isCallToScopeMethod(node)) {
                if (!NodeUtil.isExpressionNode(node2)) {
                    this.report(nodeTraversal, node, GOOG_SCOPE_USED_IMPROPERLY, new String[0]);
                }
                if (node.getChildCount() != 2) {
                    this.report(nodeTraversal, node, GOOG_SCOPE_HAS_BAD_PARAMETERS, new String[0]);
                } else {
                    object = node.getChildAtIndex(1);
                    if (!NodeUtil.isFunction((Node)object) || NodeUtil.getFunctionName((Node)object) != null || NodeUtil.getFnParameters((Node)object).hasChildren()) {
                        this.report(nodeTraversal, (Node)object, GOOG_SCOPE_HAS_BAD_PARAMETERS, new String[0]);
                    } else {
                        this.scopeCalls.add(node);
                    }
                }
            }
            if (nodeTraversal.getScopeDepth() == 2) {
                int n = node.getType();
                if (n == 38 && node2.getType() == 118) {
                    if (node.hasChildren() && node.getFirstChild().isQualifiedName()) {
                        this.aliases.put(node.getString(), nodeTraversal.getScope().getVar(node.getString()));
                        this.aliasDefinitions.add(node);
                        return;
                    }
                    this.report(nodeTraversal, node, GOOG_SCOPE_NON_ALIAS_LOCAL, node.getString());
                }
                if (n == 38 && NodeUtil.isAssignmentOp(node2) && node == node2.getFirstChild()) {
                    this.report(nodeTraversal, node, GOOG_SCOPE_ALIAS_REDEFINED, node.getString());
                }
                if (n == 4) {
                    this.report(nodeTraversal, node, GOOG_SCOPE_USES_RETURN, new String[0]);
                } else if (n == 42) {
                    this.report(nodeTraversal, node, GOOG_SCOPE_REFERENCES_THIS, new String[0]);
                } else if (n == 49) {
                    this.report(nodeTraversal, node, GOOG_SCOPE_USES_THROW, new String[0]);
                }
            }
            if (nodeTraversal.getScopeDepth() >= 2) {
                Object object2;
                if (node.getType() == 38 && (object2 = this.aliases.get(object = node.getString())) != null && nodeTraversal.getScope().getVar((String)object) == object2) {
                    Node node3 = ((Scope.Var)object2).getInitialValue();
                    this.aliasUsages.add(new AliasedNode(node, node3));
                }
                if ((object = node.getJSDocInfo()) != null) {
                    for (Node node3 : ((JSDocInfo)object).getTypeNodes()) {
                        this.fixTypeNode(node3);
                    }
                }
            }
        }

        private void fixTypeNode(Node node) {
            Object object;
            if (node.getType() == 40) {
                String string;
                Scope.Var var;
                object = node.getString();
                int n = ((String)object).indexOf(46);
                if (n == -1) {
                    n = ((String)object).length();
                }
                if ((var = this.aliases.get(string = ((String)object).substring(0, n))) != null) {
                    Node node2 = var.getInitialValue();
                    this.aliasUsages.add(new AliasedTypeNode(node, node2.getQualifiedName() + ((String)object).substring(n)));
                }
            }
            for (object = node.getFirstChild(); object != null; object = ((Node)object).getNext()) {
                this.fixTypeNode((Node)object);
            }
        }
    }

    private class AliasedTypeNode
    implements AliasUsage {
        private final Node aliasReference;
        private final String correctedType;

        AliasedTypeNode(Node node, String string) {
            this.aliasReference = node;
            this.correctedType = string;
        }

        @Override
        public void applyAlias() {
            this.aliasReference.setString(this.correctedType);
        }
    }

    private class AliasedNode
    implements AliasUsage {
        private final Node aliasReference;
        private final Node aliasDefinition;

        AliasedNode(Node node, Node node2) {
            this.aliasReference = node;
            this.aliasDefinition = node2;
        }

        @Override
        public void applyAlias() {
            this.aliasReference.getParent().replaceChild(this.aliasReference, this.aliasDefinition.cloneTree());
        }
    }

    private static interface AliasUsage {
        public void applyAlias();
    }
}

