/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Predicate;
import com.google.debugging.sourcemap.FilePosition;
import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGenerator;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import java.io.IOException;

public class SourceMap {
    final SourceMapGenerator generator;

    private SourceMap(SourceMapGenerator sourceMapGenerator) {
        this.generator = sourceMapGenerator;
    }

    public void addMapping(Node node, FilePosition filePosition, FilePosition filePosition2) {
        String string = (String)node.getProp(16);
        if (string == null || node.getLineno() < 0) {
            return;
        }
        String string2 = (String)node.getProp(39);
        this.generator.addMapping(string, string2, new FilePosition(node.getLineno(), node.getCharno()), filePosition, filePosition2);
    }

    public void appendTo(Appendable appendable, String string) throws IOException {
        this.generator.appendTo(appendable, string);
    }

    public void reset() {
        this.generator.reset();
    }

    public void setStartingPosition(int n, int n2) {
        this.generator.setStartingPosition(n, n2);
    }

    public void setWrapperPrefix(String string) {
        this.generator.setWrapperPrefix(string);
    }

    public void validate(boolean bl) {
        this.generator.validate(bl);
    }

    public static enum DetailLevel implements Predicate<Node>
    {
        ALL{

            public boolean apply(Node node) {
                return true;
            }
        }
        ,
        SYMBOLS{

            public boolean apply(Node node) {
                return NodeUtil.isCall(node) || NodeUtil.isNew(node) || NodeUtil.isFunction(node) || NodeUtil.isName(node) || NodeUtil.isGet(node) || NodeUtil.isObjectLitKey(node, node.getParent()) || NodeUtil.isString(node) && NodeUtil.isGet(node.getParent());
            }
        };

    }

    public static enum Format {
        LEGACY{

            @Override
            SourceMap getInstance() {
                return new SourceMap(SourceMapGeneratorFactory.getInstance(SourceMapFormat.V1));
            }
        }
        ,
        DEFAULT{

            @Override
            SourceMap getInstance() {
                return new SourceMap(SourceMapGeneratorFactory.getInstance(SourceMapFormat.DEFAULT));
            }
        }
        ,
        EXPERIMENTIAL{

            @Override
            SourceMap getInstance() {
                return new SourceMap(SourceMapGeneratorFactory.getInstance(SourceMapFormat.V2));
            }
        };


        abstract SourceMap getInstance();
    }
}

