/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Maps;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.Map;

class SuppressDocWarningsGuard
extends WarningsGuard {
    private final Map<String, DiagnosticGroupWarningsGuard> suppressors = Maps.newHashMap();

    SuppressDocWarningsGuard(Map<String, DiagnosticGroup> map) {
        for (Map.Entry<String, DiagnosticGroup> entry : map.entrySet()) {
            this.suppressors.put(entry.getKey(), new DiagnosticGroupWarningsGuard(entry.getValue(), CheckLevel.OFF));
        }
    }

    @Override
    public CheckLevel level(JSError jSError) {
        Node node = jSError.node;
        if (node != null) {
            for (Node node2 = node; node2 != null; node2 = node2.getParent()) {
                int n = node2.getType();
                JSDocInfo jSDocInfo = null;
                if (n == 105) {
                    jSDocInfo = NodeUtil.getFunctionInfo(node2);
                } else if (n == 132) {
                    jSDocInfo = node2.getJSDocInfo();
                }
                if (jSDocInfo == null) continue;
                for (String string : jSDocInfo.getSuppressions()) {
                    CheckLevel checkLevel;
                    WarningsGuard warningsGuard = this.suppressors.get(string);
                    if (warningsGuard == null || (checkLevel = warningsGuard.level(jSError)) == null) continue;
                    return checkLevel;
                }
            }
        }
        return null;
    }

    @Override
    public int getPriority() {
        return WarningsGuard.Priority.SUPPRESS_DOC.value;
    }
}

