/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.FunctionTypeBuilder;
import com.google.javascript.jscomp.InferJSDocInfo;
import com.google.javascript.jscomp.MemoizedScopeCreator;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReverseAbstractInterpreter;
import com.google.javascript.jscomp.RhinoErrorReporter;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypeInferencePass;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.TernaryValue;
import java.io.Serializable;
import java.util.Iterator;

public class TypeCheck
implements NodeTraversal.Callback,
CompilerPass {
    static final DiagnosticType UNEXPECTED_TOKEN = DiagnosticType.error("JSC_INTERNAL_ERROR_UNEXPECTED_TOKEN", "Internal Error: Don't know how to handle {0}");
    static final DiagnosticType BAD_DELETE = DiagnosticType.warning("JSC_BAD_DELETE_OPERAND", "delete operator needs a reference operand");
    protected static final String OVERRIDING_PROTOTYPE_WITH_NON_OBJECT = "overriding prototype with non-object";
    static final DiagnosticType DETERMINISTIC_TEST = DiagnosticType.warning("JSC_DETERMINISTIC_TEST", "condition always evaluates to {2}\nleft : {0}\nright: {1}");
    static final DiagnosticType DETERMINISTIC_TEST_NO_RESULT = DiagnosticType.warning("JSC_DETERMINISTIC_TEST_NO_RESULT", "condition always evaluates to the same value\nleft : {0}\nright: {1}");
    static final DiagnosticType INEXISTENT_ENUM_ELEMENT = DiagnosticType.warning("JSC_INEXISTENT_ENUM_ELEMENT", "element {0} does not exist on this enum");
    static final DiagnosticType INEXISTENT_PROPERTY = DiagnosticType.disabled("JSC_INEXISTENT_PROPERTY", "Property {0} never defined on {1}");
    protected static final DiagnosticType NOT_A_CONSTRUCTOR = DiagnosticType.warning("JSC_NOT_A_CONSTRUCTOR", "cannot instantiate non-constructor");
    static final DiagnosticType BIT_OPERATION = DiagnosticType.warning("JSC_BAD_TYPE_FOR_BIT_OPERATION", "operator {0} cannot be applied to {1}");
    static final DiagnosticType NOT_CALLABLE = DiagnosticType.warning("JSC_NOT_FUNCTION_TYPE", "{0} expressions are not callable");
    static final DiagnosticType CONSTRUCTOR_NOT_CALLABLE = DiagnosticType.warning("JSC_CONSTRUCTOR_NOT_CALLABLE", "Constructor {0} should be called with the \"new\" keyword");
    static final DiagnosticType FUNCTION_MASKS_VARIABLE = DiagnosticType.warning("JSC_FUNCTION_MASKS_VARIABLE", "function {0} masks variable (IE bug)");
    static final DiagnosticType MULTIPLE_VAR_DEF = DiagnosticType.warning("JSC_MULTIPLE_VAR_DEF", "declaration of multiple variables with shared type information");
    static final DiagnosticType ENUM_DUP = DiagnosticType.error("JSC_ENUM_DUP", "enum element {0} already defined");
    static final DiagnosticType ENUM_NOT_CONSTANT = DiagnosticType.warning("JSC_ENUM_NOT_CONSTANT", "enum key {0} must be a syntactic constant");
    static final DiagnosticType INVALID_INTERFACE_MEMBER_DECLARATION = DiagnosticType.warning("JSC_INVALID_INTERFACE_MEMBER_DECLARATION", "interface members can only be empty property declarations, empty functions{0}");
    static final DiagnosticType INTERFACE_FUNCTION_NOT_EMPTY = DiagnosticType.warning("JSC_INTERFACE_FUNCTION_NOT_EMPTY", "interface member functions must have an empty body");
    static final DiagnosticType CONFLICTING_EXTENDED_TYPE = DiagnosticType.warning("JSC_CONFLICTING_EXTENDED_TYPE", "{0} cannot extend this type; a constructor can only extend objects and an interface can only extend interfaces");
    static final DiagnosticType BAD_IMPLEMENTED_TYPE = DiagnosticType.warning("JSC_IMPLEMENTS_NON_INTERFACE", "can only implement interfaces");
    static final DiagnosticType HIDDEN_SUPERCLASS_PROPERTY = DiagnosticType.warning("JSC_HIDDEN_SUPERCLASS_PROPERTY", "property {0} already defined on superclass {1}; use @override to override it");
    static final DiagnosticType HIDDEN_INTERFACE_PROPERTY = DiagnosticType.warning("JSC_HIDDEN_INTERFACE_PROPERTY", "property {0} already defined on interface {1}; use @override to override it");
    static final DiagnosticType HIDDEN_SUPERCLASS_PROPERTY_MISMATCH = DiagnosticType.warning("JSC_HIDDEN_SUPERCLASS_PROPERTY_MISMATCH", "mismatch of the {0} property type and the type of the property it overrides from superclass {1}\noriginal: {2}\noverride: {3}");
    static final DiagnosticType UNKNOWN_OVERRIDE = DiagnosticType.warning("JSC_UNKNOWN_OVERRIDE", "property {0} not defined on any superclass of {1}");
    static final DiagnosticType INTERFACE_METHOD_OVERRIDE = DiagnosticType.warning("JSC_INTERFACE_METHOD_OVERRIDE", "property {0} is already defined by the {1} extended interface");
    static final DiagnosticType UNKNOWN_EXPR_TYPE = DiagnosticType.warning("JSC_UNKNOWN_EXPR_TYPE", "could not determine the type of this expression");
    static final DiagnosticType UNRESOLVED_TYPE = DiagnosticType.warning("JSC_UNRESOLVED_TYPE", "could not resolve the name {0} to a type");
    static final DiagnosticType WRONG_ARGUMENT_COUNT = DiagnosticType.warning("JSC_WRONG_ARGUMENT_COUNT", "Function {0}: called with {1} argument(s). Function requires at least {2} argument(s){3}.");
    static final DiagnosticType ILLEGAL_IMPLICIT_CAST = DiagnosticType.warning("JSC_ILLEGAL_IMPLICIT_CAST", "Illegal annotation on {0}. @implicitCast may only be used in externs.");
    static final DiagnosticGroup ALL_DIAGNOSTICS = new DiagnosticGroup(DETERMINISTIC_TEST, DETERMINISTIC_TEST_NO_RESULT, INEXISTENT_ENUM_ELEMENT, INEXISTENT_PROPERTY, NOT_A_CONSTRUCTOR, BIT_OPERATION, NOT_CALLABLE, CONSTRUCTOR_NOT_CALLABLE, FUNCTION_MASKS_VARIABLE, MULTIPLE_VAR_DEF, ENUM_DUP, ENUM_NOT_CONSTANT, INVALID_INTERFACE_MEMBER_DECLARATION, INTERFACE_FUNCTION_NOT_EMPTY, CONFLICTING_EXTENDED_TYPE, BAD_IMPLEMENTED_TYPE, HIDDEN_SUPERCLASS_PROPERTY, HIDDEN_INTERFACE_PROPERTY, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, UNKNOWN_OVERRIDE, INTERFACE_METHOD_OVERRIDE, UNKNOWN_EXPR_TYPE, UNRESOLVED_TYPE, WRONG_ARGUMENT_COUNT, ILLEGAL_IMPLICIT_CAST, RhinoErrorReporter.TYPE_PARSE_ERROR, TypedScopeCreator.UNKNOWN_LENDS, TypedScopeCreator.LENDS_ON_NON_OBJECT, TypedScopeCreator.CTOR_INITIALIZER, TypedScopeCreator.IFACE_INITIALIZER, FunctionTypeBuilder.THIS_TYPE_NON_OBJECT);
    private final AbstractCompiler compiler;
    private final TypeValidator validator;
    private final ReverseAbstractInterpreter reverseInterpreter;
    private final JSTypeRegistry typeRegistry;
    private Scope topScope;
    private ScopeCreator scopeCreator;
    private final CheckLevel reportMissingOverride;
    private final CheckLevel reportUnknownTypes;
    private boolean reportMissingProperties = true;
    private InferJSDocInfo inferJSDocInfo = null;
    private int typedCount = 0;
    private int nullCount = 0;
    private int unknownCount = 0;
    private boolean inExterns;
    private int noTypeCheckSection = 0;

    public TypeCheck(AbstractCompiler abstractCompiler, ReverseAbstractInterpreter reverseAbstractInterpreter, JSTypeRegistry jSTypeRegistry, Scope scope, ScopeCreator scopeCreator, CheckLevel checkLevel, CheckLevel checkLevel2) {
        this.compiler = abstractCompiler;
        this.validator = abstractCompiler.getTypeValidator();
        this.reverseInterpreter = reverseAbstractInterpreter;
        this.typeRegistry = jSTypeRegistry;
        this.topScope = scope;
        this.scopeCreator = scopeCreator;
        this.reportMissingOverride = checkLevel;
        this.reportUnknownTypes = checkLevel2;
        this.inferJSDocInfo = new InferJSDocInfo(abstractCompiler);
    }

    public TypeCheck(AbstractCompiler abstractCompiler, ReverseAbstractInterpreter reverseAbstractInterpreter, JSTypeRegistry jSTypeRegistry, CheckLevel checkLevel, CheckLevel checkLevel2) {
        this(abstractCompiler, reverseAbstractInterpreter, jSTypeRegistry, null, null, checkLevel, checkLevel2);
    }

    TypeCheck(AbstractCompiler abstractCompiler, ReverseAbstractInterpreter reverseAbstractInterpreter, JSTypeRegistry jSTypeRegistry) {
        this(abstractCompiler, reverseAbstractInterpreter, jSTypeRegistry, null, null, CheckLevel.WARNING, CheckLevel.OFF);
    }

    TypeCheck reportMissingProperties(boolean bl) {
        this.reportMissingProperties = bl;
        return this;
    }

    @Override
    public void process(Node node, Node node2) {
        Preconditions.checkNotNull((Object)this.scopeCreator);
        Preconditions.checkNotNull((Object)this.topScope);
        Node node3 = node2.getParent();
        Preconditions.checkState((node3 != null ? 1 : 0) != 0);
        Preconditions.checkState((node == null || node3.hasChild(node) ? 1 : 0) != 0);
        if (node != null) {
            this.check(node, true);
        }
        this.check(node2, false);
    }

    public Scope processForTesting(Node node, Node node2) {
        Preconditions.checkState((this.scopeCreator == null ? 1 : 0) != 0);
        Preconditions.checkState((this.topScope == null ? 1 : 0) != 0);
        Preconditions.checkState((node2.getParent() != null ? 1 : 0) != 0);
        Node node3 = node2.getParent();
        this.scopeCreator = new MemoizedScopeCreator(new TypedScopeCreator(this.compiler));
        this.topScope = this.scopeCreator.createScope(node3, null);
        TypeInferencePass typeInferencePass = new TypeInferencePass(this.compiler, this.reverseInterpreter, this.topScope, this.scopeCreator);
        typeInferencePass.process(node, node2);
        this.process(node, node2);
        return this.topScope;
    }

    public void check(Node node, boolean bl) {
        Preconditions.checkNotNull((Object)node);
        NodeTraversal nodeTraversal = new NodeTraversal(this.compiler, this, this.scopeCreator);
        this.inExterns = bl;
        nodeTraversal.traverseWithScope(node, this.topScope);
        if (bl) {
            this.inferJSDocInfo.process(node, null);
        } else {
            this.inferJSDocInfo.process(null, node);
        }
    }

    private void checkNoTypeCheckSection(Node node, boolean bl) {
        switch (node.getType()) {
            case 86: 
            case 105: 
            case 118: 
            case 125: 
            case 132: {
                JSDocInfo jSDocInfo = node.getJSDocInfo();
                if (jSDocInfo != null && jSDocInfo.isNoTypeCheck()) {
                    this.noTypeCheckSection = bl ? ++this.noTypeCheckSection : --this.noTypeCheckSection;
                }
                this.validator.setShouldReport(this.noTypeCheckSection == 0);
            }
        }
    }

    private void report(NodeTraversal nodeTraversal, Node node, DiagnosticType diagnosticType, String ... stringArray) {
        if (this.noTypeCheckSection == 0) {
            nodeTraversal.report(node, diagnosticType, stringArray);
        }
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
        this.checkNoTypeCheckSection(node, true);
        switch (node.getType()) {
            case 105: {
                TypeCheck typeCheck = this;
                Scope scope = nodeTraversal.getScope();
                FunctionType functionType = (FunctionType)node.getJSType();
                String string = node.getFirstChild().getString();
                if (string == null || string.length() <= 0 || !scope.isDeclared(string, false) || scope.getVar(string).getType() instanceof FunctionType) break;
                this.report(nodeTraversal, node, FUNCTION_MASKS_VARIABLE, string);
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        boolean bl = true;
        switch (node.getType()) {
            case 38: {
                bl = this.visitName(nodeTraversal, node, node2);
                break;
            }
            case 83: {
                if (node2.getType() != 105) {
                    this.ensureTyped(nodeTraversal, node, this.getJSType(node.getFirstChild()));
                    break;
                }
                bl = false;
                break;
            }
            case 85: {
                this.ensureTyped(nodeTraversal, node, this.getJSType(node.getLastChild()));
                break;
            }
            case 43: 
            case 44: {
                this.ensureTyped(nodeTraversal, node, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 42: {
                this.ensureTyped(nodeTraversal, node, nodeTraversal.getScope().getTypeOfThis());
                break;
            }
            case 69: {
                this.ensureTyped(nodeTraversal, node);
                break;
            }
            case 65: {
                this.ensureTyped(nodeTraversal, node, this.getJSType(node.getFirstChild()));
                break;
            }
            case 41: {
                this.ensureTyped(nodeTraversal, node, JSTypeNative.NULL_TYPE);
                break;
            }
            case 39: {
                if (NodeUtil.isObjectLitKey(node, node.getParent())) break;
                this.ensureTyped(nodeTraversal, node, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case 40: {
                if (NodeUtil.isObjectLitKey(node, node.getParent())) break;
                this.ensureTyped(nodeTraversal, node, JSTypeNative.STRING_TYPE);
                break;
            }
            case 147: 
            case 148: {
                break;
            }
            case 63: {
                this.ensureTyped(nodeTraversal, node, JSTypeNative.ARRAY_TYPE);
                break;
            }
            case 47: {
                this.ensureTyped(nodeTraversal, node, JSTypeNative.REGEXP_TYPE);
                break;
            }
            case 33: {
                this.visitGetProp(nodeTraversal, node, node2);
                bl = node2.getType() != 86 || node2.getFirstChild() != node;
                break;
            }
            case 35: {
                this.visitGetElem(nodeTraversal, node);
                bl = false;
                break;
            }
            case 118: {
                this.visitVar(nodeTraversal, node);
                bl = false;
                break;
            }
            case 30: {
                this.visitNew(nodeTraversal, node);
                bl = true;
                break;
            }
            case 37: {
                this.visitCall(nodeTraversal, node);
                bl = !NodeUtil.isExpressionNode(node2);
                break;
            }
            case 4: {
                this.visitReturn(nodeTraversal, node);
                bl = false;
                break;
            }
            case 102: 
            case 103: {
                Node node3 = node.getFirstChild();
                this.validator.expectNumber(nodeTraversal, node3, this.getJSType(node3), "increment/decrement");
                this.ensureTyped(nodeTraversal, node, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case 26: {
                this.ensureTyped(nodeTraversal, node, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 122: {
                this.ensureTyped(nodeTraversal, node, JSTypeNative.VOID_TYPE);
                break;
            }
            case 32: {
                this.ensureTyped(nodeTraversal, node, JSTypeNative.STRING_TYPE);
                break;
            }
            case 27: {
                JSType jSType = this.getJSType(node.getFirstChild());
                if (!jSType.matchesInt32Context()) {
                    this.report(nodeTraversal, node, BIT_OPERATION, NodeUtil.opToStr(node.getType()), jSType.toString());
                }
                this.ensureTyped(nodeTraversal, node, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case 28: 
            case 29: {
                Node node4 = node.getFirstChild();
                this.validator.expectNumber(nodeTraversal, node4, this.getJSType(node4), "sign operator");
                this.ensureTyped(nodeTraversal, node, JSTypeNative.NUMBER_TYPE);
                break;
            }
            case 12: 
            case 13: {
                JSType jSType = this.getJSType(node.getFirstChild());
                JSType jSType2 = this.getJSType(node.getLastChild());
                JSType jSType3 = jSType.restrictByNotNullOrUndefined();
                JSType jSType4 = jSType2.restrictByNotNullOrUndefined();
                TernaryValue ternaryValue = jSType3.testForEquality(jSType4);
                if (ternaryValue != TernaryValue.UNKNOWN) {
                    if (node.getType() == 13) {
                        ternaryValue = ternaryValue.not();
                    }
                    this.report(nodeTraversal, node, DETERMINISTIC_TEST, jSType.toString(), jSType2.toString(), ternaryValue.toString());
                }
                this.ensureTyped(nodeTraversal, node, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 45: 
            case 46: {
                JSType jSType = this.getJSType(node.getFirstChild());
                JSType jSType5 = this.getJSType(node.getLastChild());
                JSType jSType6 = jSType.restrictByNotNullOrUndefined();
                JSType jSType7 = jSType5.restrictByNotNullOrUndefined();
                if (!jSType6.canTestForShallowEqualityWith(jSType7)) {
                    this.report(nodeTraversal, node, DETERMINISTIC_TEST_NO_RESULT, jSType.toString(), jSType5.toString());
                }
                this.ensureTyped(nodeTraversal, node, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                JSType jSType = this.getJSType(node.getFirstChild());
                JSType jSType8 = this.getJSType(node.getLastChild());
                if (jSType8.isNumber()) {
                    this.validator.expectNumber(nodeTraversal, node, jSType, "left side of numeric comparison");
                } else if (jSType.isNumber()) {
                    this.validator.expectNumber(nodeTraversal, node, jSType8, "right side of numeric comparison");
                } else if (!jSType.matchesNumberContext() || !jSType8.matchesNumberContext()) {
                    String string = "left side of comparison";
                    this.validator.expectString(nodeTraversal, node, jSType, string);
                    this.validator.expectNotNullOrUndefined(nodeTraversal, node, jSType, string, this.getNativeType(JSTypeNative.STRING_TYPE));
                    string = "right side of comparison";
                    this.validator.expectString(nodeTraversal, node, jSType8, string);
                    this.validator.expectNotNullOrUndefined(nodeTraversal, node, jSType8, string, this.getNativeType(JSTypeNative.STRING_TYPE));
                }
                this.ensureTyped(nodeTraversal, node, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 51: {
                Node node5 = node.getFirstChild();
                Node node6 = node.getLastChild();
                JSType jSType = this.getJSType(node5);
                JSType jSType9 = this.getJSType(node6);
                this.validator.expectObject(nodeTraversal, node, jSType9, "'in' requires an object");
                this.validator.expectString(nodeTraversal, node5, jSType, "left side of 'in'");
                this.ensureTyped(nodeTraversal, node, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 52: {
                Node node7 = node.getFirstChild();
                Node node8 = node.getLastChild();
                JSType jSType = this.getJSType(node7);
                JSType jSType10 = this.getJSType(node8).restrictByNotNullOrUndefined();
                this.validator.expectAnyObject(nodeTraversal, node7, jSType, "deterministic instanceof yields false");
                this.validator.expectActualObject(nodeTraversal, node8, jSType10, "instanceof requires an object");
                this.ensureTyped(nodeTraversal, node, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 86: {
                this.visitAssign(nodeTraversal, node);
                bl = false;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.visitBinaryOperator(node.getType(), nodeTraversal, node);
                break;
            }
            case 31: {
                if (!TypeCheck.isReference(node.getFirstChild())) {
                    this.report(nodeTraversal, node, BAD_DELETE, new String[0]);
                }
                this.ensureTyped(nodeTraversal, node, JSTypeNative.BOOLEAN_TYPE);
                break;
            }
            case 111: {
                JSType jSType = this.getJSType(node2.getFirstChild());
                JSType jSType11 = this.getJSType(node.getFirstChild());
                this.validator.expectSwitchMatchesCase(nodeTraversal, node, jSType, jSType11);
                bl = false;
                break;
            }
            case 119: {
                Node node9 = node.getFirstChild();
                JSType jSType = this.getJSType(node9);
                this.validator.expectObject(nodeTraversal, node9, jSType, "with requires an object");
                bl = false;
                break;
            }
            case 105: {
                this.visitFunction(nodeTraversal, node);
                break;
            }
            case 49: 
            case 77: 
            case 110: 
            case 112: 
            case 116: 
            case 117: 
            case 120: 
            case 124: 
            case 125: 
            case 126: 
            case 130: 
            case 132: 
            case 152: 
            case 153: {
                bl = false;
                break;
            }
            case 108: 
            case 113: 
            case 114: 
            case 115: {
                bl = false;
                break;
            }
            case 64: 
            case 98: 
            case 100: 
            case 101: {
                if (node.getJSType() != null) {
                    this.ensureTyped(nodeTraversal, node);
                } else if (node.getType() == 64 && node2.getJSType() instanceof EnumType) {
                    this.ensureTyped(nodeTraversal, node, node2.getJSType());
                } else {
                    this.ensureTyped(nodeTraversal, node);
                }
                if (node.getType() != 64) break;
                for (Node node10 : node.children()) {
                    this.visitObjLitKey(nodeTraversal, node10, node);
                }
                break;
            }
            default: {
                this.report(nodeTraversal, node, UNEXPECTED_TOKEN, Token.name(node.getType()));
                this.ensureTyped(nodeTraversal, node);
            }
        }
        boolean bl2 = bl = bl && !this.inExterns;
        if (bl) {
            this.doPercentTypedAccounting(nodeTraversal, node);
        }
        this.checkNoTypeCheckSection(node, false);
    }

    private void doPercentTypedAccounting(NodeTraversal nodeTraversal, Node node) {
        JSType jSType = node.getJSType();
        if (jSType == null) {
            ++this.nullCount;
        } else if (jSType.isUnknownType()) {
            if (this.reportUnknownTypes.isOn()) {
                this.compiler.report(nodeTraversal.makeError(node, this.reportUnknownTypes, UNKNOWN_EXPR_TYPE, new String[0]));
            }
            ++this.unknownCount;
        } else {
            ++this.typedCount;
        }
    }

    private void visitAssign(NodeTraversal nodeTraversal, Node node) {
        Object object;
        Object object2;
        Serializable serializable;
        JSDocInfo jSDocInfo = node.getJSDocInfo();
        Node node2 = node.getFirstChild();
        Node node3 = node.getLastChild();
        if (node2.getType() == 33) {
            Serializable serializable2;
            serializable = node2.getFirstChild();
            object2 = this.getJSType((Node)serializable);
            object = node2.getLastChild().getString();
            if (((Node)serializable).getType() == 33 && ((JSType)(serializable2 = this.getJSType(((Node)serializable).getFirstChild()))).isInterface() && ((Node)serializable).getLastChild().getString().equals("prototype")) {
                this.visitInterfaceGetprop(nodeTraversal, node, (Node)serializable, (String)object, node2, node3);
            }
            if (jSDocInfo != null && jSDocInfo.hasType()) {
                this.visitAnnotatedAssignGetprop(nodeTraversal, node, jSDocInfo.getType().evaluate(nodeTraversal.getScope(), this.typeRegistry), (Node)serializable, (String)object, node3);
                return;
            }
            if (jSDocInfo != null && jSDocInfo.hasEnumParameterType()) {
                this.checkEnumInitializer(nodeTraversal, node3, jSDocInfo.getEnumParameterType().evaluate(nodeTraversal.getScope(), this.typeRegistry));
                return;
            }
            if (((String)object).equals("prototype")) {
                if (object2 instanceof FunctionType && ((FunctionType)(serializable2 = (FunctionType)object2)).isConstructor()) {
                    JSType jSType = node3.getJSType();
                    this.validator.expectObject(nodeTraversal, node3, jSType, OVERRIDING_PROTOTYPE_WITH_NON_OBJECT);
                }
                return;
            }
            if (((Node)serializable).getType() == 33) {
                serializable2 = ((Node)serializable).getFirstChild();
                String string = NodeUtil.getStringValue(((Node)serializable).getLastChild());
                if ("prototype".equals(string)) {
                    FunctionType functionType;
                    JSType jSType = ((Node)serializable2).getJSType();
                    if (jSType instanceof FunctionType && ((functionType = (FunctionType)jSType).isConstructor() || functionType.isInterface())) {
                        this.checkDeclaredPropertyInheritance(nodeTraversal, node, functionType, (String)object, jSDocInfo, this.getJSType(node3));
                    }
                    return;
                }
            }
            if ((serializable2 = ObjectType.cast(((JSType)object2).restrictByNotNullOrUndefined())) != null) {
                if (((ObjectType)serializable2).hasProperty((String)object) && !((ObjectType)serializable2).isPropertyTypeInferred((String)object) && !this.propertyIsImplicitCast((ObjectType)serializable2, (String)object)) {
                    this.validator.expectCanAssignToPropertyOf(nodeTraversal, node, this.getJSType(node3), ((ObjectType)serializable2).getPropertyType((String)object), (Node)serializable, (String)object);
                }
                return;
            }
        } else if (node2.getType() == 38) {
            serializable = this.getJSType(node.getLastChild());
            object2 = nodeTraversal.getScope().getVar(node2.getString());
            if (object2 != null && ((Scope.Var)object2).isTypeInferred()) {
                return;
            }
        }
        serializable = this.getJSType(node2);
        object2 = node.getLastChild();
        object = this.getJSType((Node)object2);
        if (this.validator.expectCanAssignTo(nodeTraversal, node, (JSType)object, (JSType)serializable, "assignment")) {
            this.ensureTyped(nodeTraversal, node, (JSType)object);
        } else {
            this.ensureTyped(nodeTraversal, node);
        }
    }

    private void visitObjLitKey(NodeTraversal nodeTraversal, Node node, Node node2) {
        Node node3 = node.getFirstChild();
        JSType jSType = NodeUtil.getObjectLitKeyTypeFromValueType(node, this.getJSType(node3));
        if (jSType == null) {
            jSType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        Node node4 = node2;
        JSType jSType2 = this.getJSType(node);
        boolean bl = this.validator.expectCanAssignToPropertyOf(nodeTraversal, node, jSType, jSType2, node4, NodeUtil.getObjectLitKeyName(node));
        if (bl) {
            this.ensureTyped(nodeTraversal, node, jSType);
        } else {
            this.ensureTyped(nodeTraversal, node);
        }
        JSType jSType3 = this.getJSType(node2);
        ObjectType objectType = ObjectType.cast(jSType3.restrictByNotNullOrUndefined());
        if (objectType != null) {
            String string = NodeUtil.getObjectLitKeyName(node);
            if (objectType.hasProperty(string) && !objectType.isPropertyTypeInferred(string) && !this.propertyIsImplicitCast(objectType, string)) {
                this.validator.expectCanAssignToPropertyOf(nodeTraversal, node, jSType2, objectType.getPropertyType(string), node4, string);
            }
            return;
        }
    }

    private boolean propertyIsImplicitCast(ObjectType objectType, String string) {
        while (objectType != null) {
            JSDocInfo jSDocInfo = objectType.getOwnPropertyJSDocInfo(string);
            if (jSDocInfo != null && jSDocInfo.isImplicitCast()) {
                return true;
            }
            objectType = objectType.getImplicitPrototype();
        }
        return false;
    }

    private void checkDeclaredPropertyInheritance(NodeTraversal nodeTraversal, Node node, FunctionType functionType, String string, JSDocInfo jSDocInfo, JSType jSType) {
        JSType jSType2;
        Iterator<ObjectType> iterator;
        if (TypeCheck.hasUnknownOrEmptySupertype(functionType)) {
            return;
        }
        FunctionType functionType2 = functionType.getSuperClassConstructor();
        boolean bl = functionType2 != null && functionType2.getPrototype().hasProperty(string);
        boolean bl2 = jSDocInfo != null && jSDocInfo.isOverride();
        boolean bl3 = false;
        if (functionType.isConstructor()) {
            iterator = functionType.getImplementedInterfaces().iterator();
            while (iterator.hasNext()) {
                jSType2 = iterator.next();
                if (jSType2.isUnknownType() || jSType2.isEmptyType()) continue;
                FunctionType functionType3 = jSType2.toObjectType().getConstructor();
                Preconditions.checkNotNull((Object)functionType3);
                boolean bl4 = functionType3.getPrototype().hasProperty(string);
                boolean bl5 = bl3 = bl3 || bl4;
                if (!this.reportMissingOverride.isOn() || bl2 || !bl4) continue;
                this.compiler.report(nodeTraversal.makeError(node, this.reportMissingOverride, HIDDEN_INTERFACE_PROPERTY, string, functionType3.getTopMostDefiningType(string).toString()));
            }
        }
        if (!bl2 && !bl) {
            return;
        }
        Iterator<ObjectType> iterator2 = iterator = bl ? functionType2.getTopMostDefiningType(string) : null;
        if (this.reportMissingOverride.isOn() && functionType.isConstructor() && !bl2 && bl) {
            this.compiler.report(nodeTraversal.makeError(node, this.reportMissingOverride, HIDDEN_SUPERCLASS_PROPERTY, string, iterator.toString()));
        }
        if (!bl2) {
            return;
        }
        if (bl) {
            jSType2 = functionType2.getPrototype().getPropertyType(string);
            if (!jSType.canAssignTo(jSType2)) {
                this.compiler.report(nodeTraversal.makeError(node, HIDDEN_SUPERCLASS_PROPERTY_MISMATCH, string, iterator.toString(), jSType2.toString(), jSType.toString()));
            }
        } else if (!bl3) {
            this.compiler.report(nodeTraversal.makeError(node, UNKNOWN_OVERRIDE, string, functionType.getInstanceType().toString()));
        }
    }

    private static boolean hasUnknownOrEmptySupertype(FunctionType functionType) {
        Preconditions.checkArgument((functionType.isConstructor() || functionType.isInterface() ? 1 : 0) != 0);
        Preconditions.checkArgument((!functionType.isUnknownType() ? 1 : 0) != 0);
        ObjectType objectType;
        while ((objectType = functionType.getPrototype().getImplicitPrototype()) != null) {
            if (objectType.isUnknownType() || objectType.isEmptyType()) {
                return true;
            }
            functionType = objectType.getConstructor();
            if (functionType == null) {
                return false;
            }
            Preconditions.checkState((functionType.isConstructor() || functionType.isInterface() ? 1 : 0) != 0);
        }
        return false;
    }

    private void visitInterfaceGetprop(NodeTraversal nodeTraversal, Node node, Node node2, String string, Node node3, Node node4) {
        JSType jSType = this.getJSType(node4);
        String string2 = this.compiler.getCodingConvention().getAbstractMethodName();
        if (!(jSType.isOrdinaryFunction() || node4.isQualifiedName() && node4.getQualifiedName().equals(string2))) {
            String string3 = string2 != null ? ", or " + string2 : "";
            this.compiler.report(nodeTraversal.makeError(node2, INVALID_INTERFACE_MEMBER_DECLARATION, string3));
        }
        if (node.getLastChild().getType() == 105 && !NodeUtil.isEmptyBlock(node.getLastChild().getLastChild())) {
            this.compiler.report(nodeTraversal.makeError(node2, INTERFACE_FUNCTION_NOT_EMPTY, string2));
        }
    }

    private void visitAnnotatedAssignGetprop(NodeTraversal nodeTraversal, Node node, JSType jSType, Node node2, String string, Node node3) {
        this.validator.expectCanAssignToPropertyOf(nodeTraversal, node, this.getJSType(node3), jSType, node2, string);
    }

    boolean visitName(NodeTraversal nodeTraversal, Node node, Node node2) {
        int n = node2.getType();
        if (n == 105 || n == 120 || n == 83 || n == 118) {
            return false;
        }
        JSType jSType = node.getJSType();
        if (jSType == null) {
            JSType jSType2;
            jSType = this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
            Scope.Var var = nodeTraversal.getScope().getVar(node.getString());
            if (var != null && (jSType2 = var.getType()) != null) {
                jSType = jSType2;
            }
        }
        this.ensureTyped(nodeTraversal, node, jSType);
        return true;
    }

    private void visitGetProp(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.getJSType() != null && node2.getType() == 86) {
            return;
        }
        Node node3 = node.getLastChild();
        Node node4 = node.getFirstChild();
        JSType jSType = this.getJSType(node4);
        if (!this.validator.expectNotNullOrUndefined(nodeTraversal, node, jSType, jSType + " has no properties", this.getNativeType(JSTypeNative.OBJECT_TYPE))) {
            this.ensureTyped(nodeTraversal, node);
            return;
        }
        this.checkPropertyAccess(jSType, node3.getString(), nodeTraversal, node);
        this.ensureTyped(nodeTraversal, node);
    }

    private void checkPropertyAccess(JSType jSType, String string, NodeTraversal nodeTraversal, Node node) {
        ObjectType objectType = jSType.dereference();
        if (objectType != null) {
            JSType jSType2 = this.getJSType(node);
            if ((!objectType.hasProperty(string) || objectType.equals(this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE))) && jSType2.equals(this.typeRegistry.getNativeType(JSTypeNative.UNKNOWN_TYPE))) {
                if (objectType instanceof EnumType) {
                    this.report(nodeTraversal, node, INEXISTENT_ENUM_ELEMENT, string);
                } else if (!objectType.isEmptyType() && this.reportMissingProperties && !this.isPropertyTest(node) && !this.typeRegistry.canPropertyBeDefined(objectType, string)) {
                    this.report(nodeTraversal, node, INEXISTENT_PROPERTY, string, this.validator.getReadableJSTypeName(node.getFirstChild(), true));
                }
            }
        }
    }

    private boolean isPropertyTest(Node node) {
        Node node2 = node.getParent();
        switch (node2.getType()) {
            case 37: {
                return node2.getFirstChild() != node && this.compiler.getCodingConvention().isPropertyTestFunction(node2);
            }
            case 108: 
            case 113: 
            case 114: 
            case 115: {
                return NodeUtil.getConditionExpression(node2) == node;
            }
            case 32: 
            case 52: {
                return true;
            }
            case 98: 
            case 101: {
                return node2.getFirstChild() == node;
            }
            case 26: {
                return node2.getParent().getType() == 100 && node2.getParent().getFirstChild() == node2;
            }
        }
        return false;
    }

    private void visitGetElem(NodeTraversal nodeTraversal, Node node) {
        Node node2 = node.getFirstChild();
        Node node3 = node.getLastChild();
        this.validator.expectIndexMatch(nodeTraversal, node, this.getJSType(node2), this.getJSType(node3));
        this.ensureTyped(nodeTraversal, node);
    }

    private void visitVar(NodeTraversal nodeTraversal, Node node) {
        JSDocInfo jSDocInfo = node.hasOneChild() ? node.getJSDocInfo() : null;
        for (Node node2 : node.children()) {
            Node node3 = node2.getFirstChild();
            Scope.Var var = nodeTraversal.getScope().getVar(node2.getString());
            if (node3 == null) continue;
            JSType jSType = this.getJSType(node3);
            JSType jSType2 = var.getType();
            jSType2 = jSType2 == null ? this.getNativeType(JSTypeNative.UNKNOWN_TYPE) : jSType2;
            JSDocInfo jSDocInfo2 = node2.getJSDocInfo();
            if (jSDocInfo2 == null) {
                jSDocInfo2 = jSDocInfo;
            }
            if (jSDocInfo2 != null && jSDocInfo2.hasEnumParameterType()) {
                this.checkEnumInitializer(nodeTraversal, node3, jSDocInfo2.getEnumParameterType().evaluate(nodeTraversal.getScope(), this.typeRegistry));
                continue;
            }
            if (var.isTypeInferred()) {
                this.ensureTyped(nodeTraversal, node2, jSType);
                continue;
            }
            this.validator.expectCanAssignTo(nodeTraversal, node3, jSType, jSType2, "initializing variable");
        }
    }

    private void visitNew(NodeTraversal nodeTraversal, Node node) {
        Node node2 = node.getFirstChild();
        FunctionType functionType = this.getFunctionType(node2);
        if (functionType != null && functionType.isConstructor()) {
            this.visitParameterList(nodeTraversal, node, functionType);
            this.ensureTyped(nodeTraversal, node, functionType.getInstanceType());
        } else {
            if (node2.getType() != 33) {
                Node node3 = node2.getLineno() < 0 || node2.getCharno() < 0 ? node : node2;
                this.report(nodeTraversal, node3, NOT_A_CONSTRUCTOR, new String[0]);
            }
            this.ensureTyped(nodeTraversal, node);
        }
    }

    private void visitFunction(NodeTraversal nodeTraversal, Node node) {
        JSDocInfo jSDocInfo = node.getJSDocInfo();
        FunctionType functionType = (FunctionType)node.getJSType();
        String string = node.getFirstChild().getString();
        if (functionType.isInterface() || functionType.isConstructor()) {
            FunctionType functionType2 = functionType.getPrototype().getImplicitPrototype().getConstructor();
            if (functionType2 != null && functionType2 != this.getNativeType(JSTypeNative.OBJECT_FUNCTION_TYPE) && (functionType2.isConstructor() && functionType.isInterface() || functionType2.isInterface() && functionType.isConstructor())) {
                this.compiler.report(nodeTraversal.makeError(node, CONFLICTING_EXTENDED_TYPE, string));
            }
            for (ObjectType objectType : functionType.getImplementedInterfaces()) {
                boolean bl = false;
                ObjectType objectType2 = ObjectType.cast(objectType);
                if (objectType2 != null) {
                    FunctionType functionType3 = objectType2.getConstructor();
                    if (functionType3 != null && !functionType3.isInterface()) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (!bl) continue;
                this.report(nodeTraversal, node, BAD_IMPLEMENTED_TYPE, string);
            }
            if (functionType.isConstructor()) {
                this.validator.expectAllInterfaceProperties(nodeTraversal, node, functionType);
            }
        }
    }

    private void visitCall(NodeTraversal nodeTraversal, Node node) {
        Node node2 = node.getFirstChild();
        JSType jSType = this.getJSType(node2).restrictByNotNullOrUndefined();
        if (!jSType.canBeCalled()) {
            this.report(nodeTraversal, node, NOT_CALLABLE, jSType.toString());
            this.ensureTyped(nodeTraversal, node);
            return;
        }
        if (jSType instanceof FunctionType) {
            FunctionType functionType = (FunctionType)jSType;
            boolean bl = false;
            JSDocInfo jSDocInfo = functionType.getJSDocInfo();
            if (jSDocInfo != null) {
                String string = jSDocInfo.getSourceName();
                CompilerInput compilerInput = this.compiler.getInput(string);
                bl = compilerInput.isExtern();
            }
            if (functionType.isConstructor() && !functionType.isNativeObjectType() && (functionType.getReturnType().isUnknownType() || functionType.getReturnType().isVoidType() || !bl)) {
                this.report(nodeTraversal, node, CONSTRUCTOR_NOT_CALLABLE, jSType.toString());
            }
            this.visitParameterList(nodeTraversal, node, functionType);
            this.ensureTyped(nodeTraversal, node, functionType.getReturnType());
        } else {
            this.ensureTyped(nodeTraversal, node);
        }
    }

    private void visitParameterList(NodeTraversal nodeTraversal, Node node, FunctionType functionType) {
        Iterator<Node> iterator = node.children().iterator();
        iterator.next();
        Iterator<Node> iterator2 = functionType.getParameters().iterator();
        int n = 0;
        Node node2 = null;
        Node node3 = null;
        while (iterator.hasNext() && (iterator2.hasNext() || node2 != null && node2.isVarArgs())) {
            if (iterator2.hasNext()) {
                node2 = iterator2.next();
            }
            node3 = iterator.next();
            this.validator.expectArgumentMatchesParameter(nodeTraversal, node3, this.getJSType(node3), this.getJSType(node2), node, ++n);
        }
        int n2 = node.getChildCount() - 1;
        int n3 = functionType.getMinArguments();
        int n4 = functionType.getMaxArguments();
        if (n3 > n2 || n4 < n2) {
            this.report(nodeTraversal, node, WRONG_ARGUMENT_COUNT, this.validator.getReadableJSTypeName(node.getFirstChild(), false), String.valueOf(n2), String.valueOf(n3), n4 != Integer.MAX_VALUE ? " and no more than " + n4 + " argument(s)" : "");
        }
    }

    private void visitReturn(NodeTraversal nodeTraversal, Node node) {
        Node node2 = nodeTraversal.getEnclosingFunction();
        if (node2 == null) {
            return;
        }
        JSType jSType = this.getJSType(node2);
        if (jSType instanceof FunctionType) {
            JSType jSType2;
            Node node3;
            FunctionType functionType = (FunctionType)jSType;
            JSType jSType3 = functionType.getReturnType();
            if (jSType3 == null) {
                jSType3 = this.getNativeType(JSTypeNative.VOID_TYPE);
            }
            if ((node3 = node.getFirstChild()) == null) {
                jSType2 = this.getNativeType(JSTypeNative.VOID_TYPE);
                node3 = node;
            } else {
                jSType2 = this.getJSType(node3);
            }
            this.validator.expectCanAssignTo(nodeTraversal, node3, jSType2, jSType3, "inconsistent return type");
        }
    }

    private void visitBinaryOperator(int n, NodeTraversal nodeTraversal, Node node) {
        Node node2 = node.getFirstChild();
        JSType jSType = this.getJSType(node2);
        Node node3 = node.getLastChild();
        JSType jSType2 = this.getJSType(node3);
        switch (n) {
            case 18: 
            case 19: 
            case 20: 
            case 90: 
            case 91: 
            case 92: {
                if (!jSType.matchesInt32Context()) {
                    this.report(nodeTraversal, node2, BIT_OPERATION, NodeUtil.opToStr(node.getType()), jSType.toString());
                }
                if (jSType2.matchesUint32Context()) break;
                this.report(nodeTraversal, node3, BIT_OPERATION, NodeUtil.opToStr(node.getType()), jSType2.toString());
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                this.validator.expectNumber(nodeTraversal, node2, jSType, "left operand");
                this.validator.expectNumber(nodeTraversal, node3, jSType2, "right operand");
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 87: 
            case 88: 
            case 89: {
                this.validator.expectBitwiseable(nodeTraversal, node2, jSType, "bad left operand to bitwise operator");
                this.validator.expectBitwiseable(nodeTraversal, node3, jSType2, "bad right operand to bitwise operator");
                break;
            }
            case 21: 
            case 93: {
                break;
            }
            default: {
                this.report(nodeTraversal, node, UNEXPECTED_TOKEN, Node.tokenToName(n));
            }
        }
        this.ensureTyped(nodeTraversal, node);
    }

    private void checkEnumInitializer(NodeTraversal nodeTraversal, Node node, JSType jSType) {
        if (node.getType() == 64) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                Node node3 = node2.getFirstChild();
                this.validator.expectCanAssignTo(nodeTraversal, node3, this.getJSType(node3), jSType, "element type must match enum's type");
            }
        } else if (node.getJSType() instanceof EnumType) {
            EnumType enumType = (EnumType)node.getJSType();
            JSType jSType2 = enumType.getElementsType().getPrimitiveType();
            this.validator.expectCanAssignTo(nodeTraversal, node, jSType2, jSType, "incompatible enum element types");
        }
    }

    private static boolean isReference(Node node) {
        switch (node.getType()) {
            case 33: 
            case 35: 
            case 38: {
                return true;
            }
        }
        return false;
    }

    private JSType getJSType(Node node) {
        JSType jSType = node.getJSType();
        if (jSType == null) {
            return this.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return jSType;
    }

    private FunctionType getFunctionType(Node node) {
        JSType jSType = this.getJSType(node).restrictByNotNullOrUndefined();
        if (jSType.isUnknownType()) {
            return this.typeRegistry.getNativeFunctionType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
        }
        if (jSType instanceof FunctionType) {
            return (FunctionType)jSType;
        }
        return null;
    }

    private void ensureTyped(NodeTraversal nodeTraversal, Node node) {
        this.ensureTyped(nodeTraversal, node, this.getNativeType(JSTypeNative.UNKNOWN_TYPE));
    }

    private void ensureTyped(NodeTraversal nodeTraversal, Node node, JSTypeNative jSTypeNative) {
        this.ensureTyped(nodeTraversal, node, this.getNativeType(jSTypeNative));
    }

    private void ensureTyped(NodeTraversal nodeTraversal, Node node, JSType object) {
        Preconditions.checkState((node.getType() != 105 || object instanceof FunctionType || ((JSType)object).isUnknownType() ? 1 : 0) != 0);
        JSDocInfo jSDocInfo = node.getJSDocInfo();
        if (jSDocInfo != null) {
            Object object2;
            if (jSDocInfo.hasType()) {
                object2 = jSDocInfo.getType().evaluate(nodeTraversal.getScope(), this.typeRegistry);
                this.validator.expectCanCast(nodeTraversal, node, (JSType)object2, (JSType)object);
                object = object2;
            }
            if (jSDocInfo.isImplicitCast() && !this.inExterns) {
                object2 = node.getType() == 33 ? node.getLastChild().getString() : "(missing)";
                this.compiler.report(nodeTraversal.makeError(node, ILLEGAL_IMPLICIT_CAST, new String[]{object2}));
            }
        }
        if (node.getJSType() == null) {
            node.setJSType((JSType)object);
        }
    }

    double getTypedPercent() {
        int n = this.nullCount + this.unknownCount + this.typedCount;
        if (n == 0) {
            return 0.0;
        }
        return 100.0 * (double)this.typedCount / (double)n;
    }

    private JSType getNativeType(JSTypeNative jSTypeNative) {
        return this.typeRegistry.getNativeType(jSTypeNative);
    }
}

