/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ControlFlowAnalysis;
import com.google.javascript.jscomp.ControlFlowGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.GraphReachability;
import com.google.javascript.rhino.Node;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class UnreachableCodeElimination
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass,
NodeTraversal.ScopedCallback {
    private static final Logger logger = Logger.getLogger(UnreachableCodeElimination.class.getName());
    private final AbstractCompiler compiler;
    private final boolean removeNoOpStatements;
    Deque<ControlFlowGraph<Node>> cfgStack = new LinkedList<ControlFlowGraph<Node>>();
    ControlFlowGraph<Node> curCfg = null;

    UnreachableCodeElimination(AbstractCompiler abstractCompiler, boolean bl) {
        this.compiler = abstractCompiler;
        this.removeNoOpStatements = bl;
    }

    @Override
    public void enterScope(NodeTraversal nodeTraversal) {
        Scope scope = nodeTraversal.getScope();
        ControlFlowAnalysis controlFlowAnalysis = new ControlFlowAnalysis(this.compiler, false, false);
        controlFlowAnalysis.process(null, scope.getRootNode());
        this.cfgStack.push(this.curCfg);
        this.curCfg = controlFlowAnalysis.getCfg();
        new GraphReachability(this.curCfg).compute(this.curCfg.getEntry().getValue());
    }

    @Override
    public void exitScope(NodeTraversal nodeTraversal) {
        this.curCfg = this.cfgStack.pop();
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node2 == null) {
            return;
        }
        if (node.getType() == 105 || node.getType() == 132) {
            return;
        }
        DiGraph.DiGraphNode diGraphNode = this.curCfg.getDirectedGraphNode(node);
        if (diGraphNode == null) {
            return;
        }
        if (diGraphNode.getAnnotation() != GraphReachability.REACHABLE || this.removeNoOpStatements && !NodeUtil.mayHaveSideEffects(node)) {
            this.removeDeadExprStatementSafely(node);
            return;
        }
        this.tryRemoveUnconditionalBranching(node);
    }

    private Node tryRemoveUnconditionalBranching(Node node) {
        if (node == null) {
            return node;
        }
        DiGraph.DiGraphNode diGraphNode = this.curCfg.getDirectedGraphNode(node);
        if (diGraphNode == null) {
            return node;
        }
        switch (node.getType()) {
            case 4: {
                if (node.hasChildren()) break;
            }
            case 116: 
            case 117: {
                List list = diGraphNode.getOutEdges();
                if (list.size() != 1 || node.getNext() != null && node.getNext().getType() != 105) break;
                Preconditions.checkState((list.get(0).getValue() == ControlFlowGraph.Branch.UNCOND ? 1 : 0) != 0);
                Node node2 = this.computeFollowing(node);
                Node node3 = (Node)list.get(0).getDestination().getValue();
                if (node3 != node2) break;
                this.removeDeadExprStatementSafely(node);
                return node2;
            }
        }
        return node;
    }

    private Node computeFollowing(Node node) {
        Node node2 = ControlFlowAnalysis.computeFollowNode(node);
        while (node2 != null && node2.getType() == 125) {
            if (node2.hasChildren()) {
                node2 = node2.getFirstChild();
                continue;
            }
            node2 = this.computeFollowing(node2);
        }
        return node2;
    }

    private void removeDeadExprStatementSafely(Node node) {
        Node node2 = node.getParent();
        if (node.getType() == 124 || node.getType() == 125 && !node.hasChildren()) {
            return;
        }
        switch (node.getType()) {
            case 114: {
                return;
            }
            case 125: {
                if (node2.getType() != 77 || !NodeUtil.isTryCatchNodeContainer(node)) break;
                return;
            }
            case 120: {
                Node node3 = node2.getParent();
                NodeUtil.maybeAddFinally(node3);
            }
        }
        NodeUtil.redeclareVarsInsideBranch(node);
        this.compiler.reportCodeChange();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Removing " + node.toString());
        }
        NodeUtil.removeChild(node.getParent(), node);
    }
}

