/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.JSModuleGraph;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Set;

class VarCheck
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    static final DiagnosticType UNDEFINED_VAR_ERROR = DiagnosticType.error("JSC_UNDEFINED_VARIABLE", "variable {0} is undefined");
    static final DiagnosticType VIOLATED_MODULE_DEP_ERROR = DiagnosticType.error("JSC_VIOLATED_MODULE_DEPENDENCY", "module {0} cannot reference {2}, defined in module {1}, since {1} loads after {0}");
    static final DiagnosticType MISSING_MODULE_DEP_ERROR = DiagnosticType.warning("JSC_MISSING_MODULE_DEPENDENCY", "missing module dependency; module {0} should depend on module {1} because it references {2}");
    static final DiagnosticType STRICT_MODULE_DEP_ERROR = DiagnosticType.disabled("JSC_STRICT_MODULE_DEPENDENCY", "module {0} cannot reference {2}, defined in module {1}");
    static final DiagnosticType NAME_REFERENCE_IN_EXTERNS_ERROR = DiagnosticType.warning("JSC_NAME_REFERENCE_IN_EXTERNS", "accessing name {0} in externs has no effect");
    static final DiagnosticType UNDEFINED_EXTERN_VAR_ERROR = DiagnosticType.warning("JSC_UNDEFINED_EXTERN_VAR_ERROR", "name {0} is not undefined in the externs.");
    static final DiagnosticType INVALID_FUNCTION_DECL = DiagnosticType.error("JSC_INVALID_FUNCTION_DECL", "Syntax error: function declaration must have a name");
    private CompilerInput synthesizedExternsInput = null;
    private Node synthesizedExternsRoot = null;
    private Set<String> varsToDeclareInExterns = Sets.newHashSet();
    private final AbstractCompiler compiler;
    private final boolean sanityCheck;
    private boolean strictExternCheck;

    VarCheck(AbstractCompiler abstractCompiler) {
        this(abstractCompiler, false);
    }

    VarCheck(AbstractCompiler abstractCompiler, boolean bl) {
        this.compiler = abstractCompiler;
        this.strictExternCheck = abstractCompiler.getErrorLevel(JSError.make("", 0, 0, UNDEFINED_EXTERN_VAR_ERROR, new String[0])) == CheckLevel.ERROR;
        this.sanityCheck = bl;
    }

    @Override
    public void process(Node node, Node node2) {
        if (!this.sanityCheck) {
            NodeTraversal.traverse(this.compiler, node, new NameRefInExternsCheck());
        }
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{node, node2}), this);
        for (String string : this.varsToDeclareInExterns) {
            this.createSynthesizedExternVar(string);
        }
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        CompilerInput compilerInput;
        Scope scope;
        Scope.Var var;
        if (node.getType() != 38) {
            return;
        }
        String string = node.getString();
        if (string.isEmpty()) {
            Preconditions.checkState((boolean)NodeUtil.isFunction(node2));
            if (!NodeUtil.isFunctionExpression(node2)) {
                nodeTraversal.report(node, INVALID_FUNCTION_DECL, new String[0]);
            }
            return;
        }
        if ((node2.getType() == 118 || NodeUtil.isFunctionDeclaration(node2)) && this.varsToDeclareInExterns.contains(string)) {
            this.createSynthesizedExternVar(string);
            node.addSuppression("duplicate");
        }
        if ((var = (scope = nodeTraversal.getScope()).getVar(string)) == null) {
            if (!NodeUtil.isFunctionExpression(node2)) {
                if (!this.strictExternCheck || !nodeTraversal.getInput().isExtern()) {
                    nodeTraversal.report(node, UNDEFINED_VAR_ERROR, string);
                }
                if (this.sanityCheck) {
                    throw new IllegalStateException("Unexpected variable " + string);
                }
                this.createSynthesizedExternVar(string);
                scope.getGlobalScope().declare(string, node, null, this.getSynthesizedExternsInput());
            }
            return;
        }
        CompilerInput compilerInput2 = nodeTraversal.getInput();
        if (compilerInput2 == (compilerInput = var.input) || compilerInput2 == null || compilerInput == null) {
            return;
        }
        JSModule jSModule = compilerInput2.getModule();
        JSModule jSModule2 = compilerInput.getModule();
        JSModuleGraph jSModuleGraph = this.compiler.getModuleGraph();
        if (jSModule2 != jSModule && jSModule2 != null && jSModule != null && !jSModuleGraph.dependsOn(jSModule, jSModule2)) {
            if (!this.sanityCheck && scope.isGlobal()) {
                if (jSModuleGraph.dependsOn(jSModule2, jSModule)) {
                    nodeTraversal.report(node, VIOLATED_MODULE_DEP_ERROR, jSModule.getName(), jSModule2.getName(), string);
                } else {
                    nodeTraversal.report(node, MISSING_MODULE_DEP_ERROR, jSModule.getName(), jSModule2.getName(), string);
                }
            } else {
                nodeTraversal.report(node, STRICT_MODULE_DEP_ERROR, jSModule.getName(), jSModule2.getName(), string);
            }
        }
    }

    private void createSynthesizedExternVar(String string) {
        Node node = Node.newString(38, string);
        if (this.compiler.getCodingConvention().isConstant(string)) {
            node.putBooleanProp(42, true);
        }
        this.getSynthesizedExternsRoot().addChildToBack(new Node(118, node));
        this.varsToDeclareInExterns.remove(string);
        this.compiler.reportCodeChange();
    }

    private CompilerInput getSynthesizedExternsInput() {
        if (this.synthesizedExternsInput == null) {
            this.synthesizedExternsInput = this.compiler.newExternInput("{SyntheticVarsDeclar}");
        }
        return this.synthesizedExternsInput;
    }

    private Node getSynthesizedExternsRoot() {
        if (this.synthesizedExternsRoot == null) {
            CompilerInput compilerInput = this.getSynthesizedExternsInput();
            this.synthesizedExternsRoot = compilerInput.getAstRoot(this.compiler);
        }
        return this.synthesizedExternsRoot;
    }

    private class NameRefInExternsCheck
    extends NodeTraversal.AbstractPostOrderCallback {
        private NameRefInExternsCheck() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.getType() == 38) {
                switch (node2.getType()) {
                    case 83: 
                    case 105: 
                    case 118: {
                        break;
                    }
                    case 33: {
                        Scope scope;
                        Scope.Var var;
                        if (node != node2.getFirstChild() || (var = (scope = nodeTraversal.getScope()).getVar(node.getString())) != null) break;
                        nodeTraversal.report(node, UNDEFINED_EXTERN_VAR_ERROR, node.getString());
                        VarCheck.this.varsToDeclareInExterns.add(node.getString());
                        break;
                    }
                    default: {
                        nodeTraversal.report(node, NAME_REFERENCE_IN_EXTERNS_ERROR, node.getString());
                        Scope scope = nodeTraversal.getScope();
                        Scope.Var var = scope.getVar(node.getString());
                        if (var != null) break;
                        VarCheck.this.varsToDeclareInExterns.add(node.getString());
                    }
                }
            }
        }
    }
}

