/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.Set;

class VariableShadowDeclarationCheck
implements CompilerPass {
    static final DiagnosticType SHADOW_VAR_ERROR = DiagnosticType.error("JSC_REDECL_NOSHADOW_VARIABLE", "Highly error prone shadowing of variable name {0}.Consider using a different local variable name.");
    private final AbstractCompiler compiler;
    private final CheckLevel checkLevel;
    private final Set<String> externalNoShadowVariableNames;

    VariableShadowDeclarationCheck(AbstractCompiler abstractCompiler, CheckLevel checkLevel) {
        this.compiler = abstractCompiler;
        this.checkLevel = checkLevel;
        this.externalNoShadowVariableNames = Sets.newHashSet();
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node, new NoShadowAnnotationGatheringCallback());
        NodeTraversal.traverse(this.compiler, node2, new ShadowDeclarationCheckingCallback());
    }

    private class ShadowDeclarationCheckingCallback
    implements NodeTraversal.ScopedCallback {
        private ShadowDeclarationCheckingCallback() {
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            if (nodeTraversal.inGlobalScope()) {
                return;
            }
            Scope scope = nodeTraversal.getScope();
            Scope scope2 = scope.getParent();
            Iterator<Scope.Var> iterator = scope.getVars();
            while (iterator.hasNext()) {
                Scope.Var var = iterator.next();
                if (VariableShadowDeclarationCheck.this.externalNoShadowVariableNames.contains(var.getName())) {
                    VariableShadowDeclarationCheck.this.compiler.report(nodeTraversal.makeError(var.nameNode, VariableShadowDeclarationCheck.this.checkLevel, SHADOW_VAR_ERROR, var.getName()));
                    continue;
                }
                Scope.Var var2 = scope2.getVar(var.getName());
                if (var2 == null || !var2.isNoShadow() && !var2.isLocal()) continue;
                VariableShadowDeclarationCheck.this.compiler.report(nodeTraversal.makeError(var.nameNode, VariableShadowDeclarationCheck.this.checkLevel, SHADOW_VAR_ERROR, var.getName()));
            }
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        }
    }

    private class NoShadowAnnotationGatheringCallback
    implements NodeTraversal.ScopedCallback {
        private NoShadowAnnotationGatheringCallback() {
        }

        @Override
        public void enterScope(NodeTraversal nodeTraversal) {
            Scope scope = nodeTraversal.getScope();
            Iterator<Scope.Var> iterator = scope.getVars();
            while (iterator.hasNext()) {
                Scope.Var var = iterator.next();
                if (!var.isNoShadow()) continue;
                VariableShadowDeclarationCheck.this.externalNoShadowVariableNames.add(var.getName());
            }
        }

        @Override
        public void exitScope(NodeTraversal nodeTraversal) {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node node, Node node2) {
            return true;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        }
    }
}

