/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.ant;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.MessageFormatter;
import org.apache.tools.ant.Task;

public final class AntErrorManager
extends BasicErrorManager {
    private final MessageFormatter formatter;
    private final Task task;

    public AntErrorManager(MessageFormatter messageFormatter, Task task) {
        this.formatter = messageFormatter;
        this.task = task;
    }

    @Override
    public void println(CheckLevel checkLevel, JSError jSError) {
        switch (checkLevel) {
            case ERROR: {
                this.task.log(jSError.format(checkLevel, this.formatter), 0);
                break;
            }
            case WARNING: {
                this.task.log(jSError.format(checkLevel, this.formatter), 1);
            }
        }
    }

    @Override
    protected void printSummary() {
        String string = this.getErrorCount() + " error(s), " + this.getWarningCount() + " warning(s)";
        if (this.getTypedPercent() > 0.0) {
            string = string + ", " + this.getTypedPercent() + " typed";
        }
        int n = this.getErrorCount() + this.getWarningCount() == 0 ? 2 : 1;
        this.task.log(string, n);
    }
}

