/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.graph;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.DiGraph;
import com.google.javascript.jscomp.graph.Graph;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.GraphvizGraph;
import com.google.javascript.jscomp.graph.SubGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LinkedDirectedGraph<N, E>
extends DiGraph<N, E>
implements GraphvizGraph {
    protected final Map<N, LinkedDirectedGraphNode<N, E>> nodes = Maps.newHashMap();
    private final boolean useNodeAnnotations;
    private final boolean useEdgeAnnotations;

    @Override
    public SubGraph<N, E> newSubGraph() {
        return new Graph.SimpleSubGraph(this);
    }

    public static <N, E> LinkedDirectedGraph<N, E> createWithoutAnnotations() {
        return new LinkedDirectedGraph<N, E>(false, false);
    }

    public static <N, E> LinkedDirectedGraph<N, E> createWithNodeAnnotations() {
        return new LinkedDirectedGraph<N, E>(true, false);
    }

    public static <N, E> LinkedDirectedGraph<N, E> createWithEdgeAnnotations() {
        return new LinkedDirectedGraph<N, E>(false, true);
    }

    public static <N, E> LinkedDirectedGraph<N, E> create() {
        return new LinkedDirectedGraph<N, E>(true, true);
    }

    protected LinkedDirectedGraph(boolean bl, boolean bl2) {
        this.useNodeAnnotations = bl;
        this.useEdgeAnnotations = bl2;
    }

    @Override
    public void connect(N n, E e, N n2) {
        LinkedDirectedGraphNode linkedDirectedGraphNode = (LinkedDirectedGraphNode)this.getNodeOrFail(n);
        LinkedDirectedGraphNode linkedDirectedGraphNode2 = (LinkedDirectedGraphNode)this.getNodeOrFail(n2);
        LinkedDirectedGraphEdge linkedDirectedGraphEdge = this.useEdgeAnnotations ? new AnnotatedLinkedDirectedGraphEdge(linkedDirectedGraphNode, e, linkedDirectedGraphNode2) : new LinkedDirectedGraphEdge(linkedDirectedGraphNode, e, linkedDirectedGraphNode2);
        linkedDirectedGraphNode.getOutEdges().add(linkedDirectedGraphEdge);
        linkedDirectedGraphNode2.getInEdges().add(linkedDirectedGraphEdge);
    }

    @Override
    public void disconnect(N n, N n2) {
        this.disconnectInDirection(n, n2);
        this.disconnectInDirection(n2, n);
    }

    @Override
    public void disconnectInDirection(N n, N n2) {
        LinkedDirectedGraphNode linkedDirectedGraphNode = (LinkedDirectedGraphNode)this.getNodeOrFail(n);
        LinkedDirectedGraphNode linkedDirectedGraphNode2 = (LinkedDirectedGraphNode)this.getNodeOrFail(n2);
        for (DiGraph.DiGraphEdge<N, E> diGraphEdge : this.getDirectedGraphEdges(n, n2)) {
            linkedDirectedGraphNode.getOutEdges().remove(diGraphEdge);
            linkedDirectedGraphNode2.getInEdges().remove(diGraphEdge);
        }
    }

    @Override
    public Iterable<DiGraph.DiGraphNode<N, E>> getDirectedGraphNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public DiGraph.DiGraphNode<N, E> getDirectedGraphNode(N n) {
        return this.nodes.get(n);
    }

    @Override
    public GraphNode<N, E> getNode(N n) {
        return this.getDirectedGraphNode(n);
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getInEdges(N n) {
        LinkedDirectedGraphNode linkedDirectedGraphNode = (LinkedDirectedGraphNode)this.getNodeOrFail(n);
        return Collections.unmodifiableList(linkedDirectedGraphNode.getInEdges());
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getOutEdges(N n) {
        LinkedDirectedGraphNode linkedDirectedGraphNode = (LinkedDirectedGraphNode)this.getNodeOrFail(n);
        return Collections.unmodifiableList(linkedDirectedGraphNode.getOutEdges());
    }

    @Override
    public DiGraph.DiGraphNode<N, E> createDirectedGraphNode(N n) {
        LinkedDirectedGraphNode<N, E> linkedDirectedGraphNode = this.nodes.get(n);
        if (linkedDirectedGraphNode == null) {
            linkedDirectedGraphNode = this.useNodeAnnotations ? new AnnotatedLinkedDirectedGraphNode(n) : new LinkedDirectedGraphNode(n);
            this.nodes.put(n, linkedDirectedGraphNode);
        }
        return linkedDirectedGraphNode;
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges(N n, N n2) {
        List<DiGraph.DiGraphEdge<N, E>> list = this.getDirectedGraphEdges(n, n2);
        List<DiGraph.DiGraphEdge<N, E>> list2 = this.getDirectedGraphEdges(n2, n);
        int n3 = list.size() + list2.size();
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)n3);
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return arrayList;
    }

    @Override
    public Graph.GraphEdge<N, E> getFirstEdge(N n, N n2) {
        DiGraph.DiGraphNode diGraphNode = (DiGraph.DiGraphNode)this.getNodeOrFail(n);
        DiGraph.DiGraphNode diGraphNode2 = (DiGraph.DiGraphNode)this.getNodeOrFail(n2);
        for (DiGraph.DiGraphEdge diGraphEdge : diGraphNode.getOutEdges()) {
            if (diGraphEdge.getDestination() != diGraphNode2) continue;
            return diGraphEdge;
        }
        for (DiGraph.DiGraphEdge diGraphEdge : diGraphNode2.getOutEdges()) {
            if (diGraphEdge.getDestination() != diGraphNode) continue;
            return diGraphEdge;
        }
        return null;
    }

    @Override
    public GraphNode<N, E> createNode(N n) {
        return this.createDirectedGraphNode(n);
    }

    @Override
    public List<DiGraph.DiGraphEdge<N, E>> getDirectedGraphEdges(N n, N n2) {
        DiGraph.DiGraphNode diGraphNode = (DiGraph.DiGraphNode)this.getNodeOrFail(n);
        DiGraph.DiGraphNode diGraphNode2 = (DiGraph.DiGraphNode)this.getNodeOrFail(n2);
        ArrayList arrayList = Lists.newArrayList();
        for (DiGraph.DiGraphEdge diGraphEdge : diGraphNode.getOutEdges()) {
            if (diGraphEdge.getDestination() != diGraphNode2) continue;
            arrayList.add(diGraphEdge);
        }
        return arrayList;
    }

    @Override
    public boolean isConnectedInDirection(N n, N n2) {
        return this.isConnectedInDirection(n, Predicates.alwaysTrue(), n2);
    }

    @Override
    public boolean isConnectedInDirection(N n, E e, N n2) {
        return this.isConnectedInDirection(n, Predicates.equalTo(e), n2);
    }

    @Override
    private boolean isConnectedInDirection(N n, Predicate<E> predicate, N n2) {
        DiGraph.DiGraphNode diGraphNode = (DiGraph.DiGraphNode)this.getNodeOrFail(n);
        DiGraph.DiGraphNode diGraphNode2 = (DiGraph.DiGraphNode)this.getNodeOrFail(n2);
        for (DiGraph.DiGraphEdge diGraphEdge : diGraphNode.getOutEdges()) {
            if (diGraphEdge.getDestination() != diGraphNode2 || !predicate.apply(diGraphEdge.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedPredNodes(N n) {
        return this.getDirectedPredNodes(this.nodes.get(n));
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedSuccNodes(N n) {
        return this.getDirectedSuccNodes(this.nodes.get(n));
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedPredNodes(DiGraph.DiGraphNode<N, E> diGraphNode) {
        if (diGraphNode == null) {
            throw new IllegalArgumentException(diGraphNode + " is null");
        }
        ArrayList arrayList = Lists.newArrayList();
        for (DiGraph.DiGraphEdge<N, E> diGraphEdge : diGraphNode.getInEdges()) {
            arrayList.add(diGraphEdge.getSource());
        }
        return arrayList;
    }

    @Override
    public List<DiGraph.DiGraphNode<N, E>> getDirectedSuccNodes(DiGraph.DiGraphNode<N, E> diGraphNode) {
        if (diGraphNode == null) {
            throw new IllegalArgumentException(diGraphNode + " is null");
        }
        ArrayList arrayList = Lists.newArrayList();
        for (DiGraph.DiGraphEdge<N, E> diGraphEdge : diGraphNode.getOutEdges()) {
            arrayList.add(diGraphEdge.getDestination());
        }
        return arrayList;
    }

    @Override
    public List<GraphvizGraph.GraphvizEdge> getGraphvizEdges() {
        ArrayList arrayList = Lists.newArrayList();
        for (LinkedDirectedGraphNode<N, E> linkedDirectedGraphNode : this.nodes.values()) {
            for (DiGraph.DiGraphEdge<N, E> diGraphEdge : linkedDirectedGraphNode.getOutEdges()) {
                arrayList.add((LinkedDirectedGraphEdge)diGraphEdge);
            }
        }
        return arrayList;
    }

    @Override
    public List<GraphvizGraph.GraphvizNode> getGraphvizNodes() {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)this.nodes.size());
        for (LinkedDirectedGraphNode<N, E> linkedDirectedGraphNode : this.nodes.values()) {
            arrayList.add(linkedDirectedGraphNode);
        }
        return arrayList;
    }

    @Override
    public String getName() {
        return "LinkedGraph";
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public Collection<GraphNode<N, E>> getNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    @Override
    public List<GraphNode<N, E>> getNeighborNodes(N n) {
        DiGraph.DiGraphNode<N, E> diGraphNode = this.getDirectedGraphNode(n);
        return this.getNeighborNodes(diGraphNode);
    }

    @Override
    public List<GraphNode<N, E>> getNeighborNodes(DiGraph.DiGraphNode<N, E> diGraphNode) {
        ArrayList arrayList = Lists.newArrayList();
        Iterator iterator = ((LinkedDirectedGraphNode)diGraphNode).neighborIterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public Iterator<GraphNode<N, E>> getNeighborNodesIterator(N n) {
        LinkedDirectedGraphNode<N, E> linkedDirectedGraphNode = this.nodes.get(n);
        Preconditions.checkNotNull(linkedDirectedGraphNode);
        return ((LinkedDirectedGraphNode)linkedDirectedGraphNode).neighborIterator();
    }

    @Override
    public List<Graph.GraphEdge<N, E>> getEdges() {
        ArrayList arrayList = Lists.newArrayList();
        for (LinkedDirectedGraphNode<N, E> linkedDirectedGraphNode : this.nodes.values()) {
            for (DiGraph.DiGraphEdge diGraphEdge : linkedDirectedGraphNode.getOutEdges()) {
                arrayList.add(diGraphEdge);
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public int getNodeDegree(N n) {
        DiGraph.DiGraphNode diGraphNode = (DiGraph.DiGraphNode)this.getNodeOrFail(n);
        return diGraphNode.getInEdges().size() + diGraphNode.getOutEdges().size();
    }

    static class AnnotatedLinkedDirectedGraphEdge<N, E>
    extends LinkedDirectedGraphEdge<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedDirectedGraphEdge(DiGraph.DiGraphNode<N, E> diGraphNode, E e, DiGraph.DiGraphNode<N, E> diGraphNode2) {
            super(diGraphNode, e, diGraphNode2);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation annotation) {
            this.annotation = annotation;
        }
    }

    static class LinkedDirectedGraphEdge<N, E>
    implements DiGraph.DiGraphEdge<N, E>,
    GraphvizGraph.GraphvizEdge {
        private DiGraph.DiGraphNode<N, E> sourceNode;
        private DiGraph.DiGraphNode<N, E> destNode;
        protected final E value;

        LinkedDirectedGraphEdge(DiGraph.DiGraphNode<N, E> diGraphNode, E e, DiGraph.DiGraphNode<N, E> diGraphNode2) {
            this.value = e;
            this.sourceNode = diGraphNode;
            this.destNode = diGraphNode2;
        }

        @Override
        public DiGraph.DiGraphNode<N, E> getSource() {
            return this.sourceNode;
        }

        @Override
        public DiGraph.DiGraphNode<N, E> getDestination() {
            return this.destNode;
        }

        @Override
        public void setDestination(DiGraph.DiGraphNode<N, E> diGraphNode) {
            this.destNode = diGraphNode;
        }

        @Override
        public void setSource(DiGraph.DiGraphNode<N, E> diGraphNode) {
            this.sourceNode = diGraphNode;
        }

        @Override
        public E getValue() {
            return this.value;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation annotation) {
            throw new UnsupportedOperationException("Graph initialized with edge annotations turned off");
        }

        @Override
        public String getColor() {
            return "black";
        }

        @Override
        public String getLabel() {
            return this.value != null ? this.value.toString() : "null";
        }

        @Override
        public String getNode1Id() {
            return ((LinkedDirectedGraphNode)this.sourceNode).getId();
        }

        @Override
        public String getNode2Id() {
            return ((LinkedDirectedGraphNode)this.destNode).getId();
        }

        public String toString() {
            return this.sourceNode.toString() + " -> " + this.destNode.toString();
        }

        @Override
        public GraphNode<N, E> getNodeA() {
            return this.sourceNode;
        }

        @Override
        public GraphNode<N, E> getNodeB() {
            return this.destNode;
        }
    }

    static class AnnotatedLinkedDirectedGraphNode<N, E>
    extends LinkedDirectedGraphNode<N, E> {
        protected Annotation annotation;

        AnnotatedLinkedDirectedGraphNode(N n) {
            super(n);
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation annotation) {
            this.annotation = annotation;
        }
    }

    static class LinkedDirectedGraphNode<N, E>
    implements DiGraph.DiGraphNode<N, E>,
    GraphvizGraph.GraphvizNode {
        List<DiGraph.DiGraphEdge<N, E>> inEdgeList = Lists.newArrayList();
        List<DiGraph.DiGraphEdge<N, E>> outEdgeList = Lists.newArrayList();
        protected final N value;

        LinkedDirectedGraphNode(N n) {
            this.value = n;
        }

        @Override
        public N getValue() {
            return this.value;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public void setAnnotation(Annotation annotation) {
            throw new UnsupportedOperationException("Graph initialized with node annotations turned off");
        }

        @Override
        public String getColor() {
            return "white";
        }

        @Override
        public String getId() {
            return "LDN" + this.hashCode();
        }

        @Override
        public String getLabel() {
            return this.value != null ? this.value.toString() : "null";
        }

        public String toString() {
            return this.getLabel();
        }

        @Override
        public List<DiGraph.DiGraphEdge<N, E>> getInEdges() {
            return this.inEdgeList;
        }

        @Override
        public List<DiGraph.DiGraphEdge<N, E>> getOutEdges() {
            return this.outEdgeList;
        }

        private Iterator<GraphNode<N, E>> neighborIterator() {
            return new NeighborIterator();
        }

        private class NeighborIterator
        implements Iterator<GraphNode<N, E>> {
            private final Iterator<DiGraph.DiGraphEdge<N, E>> in;
            private final Iterator<DiGraph.DiGraphEdge<N, E>> out;

            private NeighborIterator() {
                this.in = LinkedDirectedGraphNode.this.inEdgeList.iterator();
                this.out = LinkedDirectedGraphNode.this.outEdgeList.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.in.hasNext() || this.out.hasNext();
            }

            @Override
            public GraphNode<N, E> next() {
                boolean bl = !this.in.hasNext();
                Iterator iterator = bl ? this.out : this.in;
                DiGraph.DiGraphEdge diGraphEdge = iterator.next();
                return bl ? diGraphEdge.getDestination() : diGraphEdge.getSource();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported.");
            }
        }
    }
}

