/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSDocInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private LazilyInitializedInfo info = null;
    private LazilyInitializedDocumentation documentation = null;
    private String sourceName = null;
    private Visibility visibility = null;
    private int bitset = 0;
    private JSTypeExpression type = null;
    private JSTypeExpression thisType = null;
    private boolean includeDocumentation = false;
    private static final int MASK_FLAGS = 0x3FFFFFFF;
    private static final int MASK_CONSTANT = 1;
    private static final int MASK_CONSTRUCTOR = 2;
    private static final int MASK_DEFINE = 4;
    private static final int MASK_HIDDEN = 8;
    private static final int MASK_PRESERVETRY = 16;
    private static final int MASK_NOCHECK = 32;
    private static final int MASK_OVERRIDE = 64;
    private static final int MASK_NOALIAS = 128;
    private static final int MASK_DEPRECATED = 256;
    private static final int MASK_INTERFACE = 512;
    private static final int MASK_EXPORT = 1024;
    private static final int MASK_NOSHADOW = 2048;
    private static final int MASK_FILEOVERVIEW = 4096;
    private static final int MASK_IMPLICITCAST = 8192;
    private static final int MASK_NOSIDEEFFECTS = 16384;
    private static final int MASK_EXTERNS = 32768;
    private static final int MASK_JAVADISPATCH = 65536;
    private static final int MASK_NOCOMPILE = 131072;
    private static final int MASK_TYPEFIELD = -536870912;
    private static final int TYPEFIELD_TYPE = 0x20000000;
    private static final int TYPEFIELD_RETURN = 0x40000000;
    private static final int TYPEFIELD_ENUM = 0x60000000;
    private static final int TYPEFIELD_TYPEDEF = Integer.MIN_VALUE;

    JSDocInfo(boolean bl) {
        this.includeDocumentation = bl;
    }

    public JSDocInfo() {
    }

    void setConstant(boolean bl) {
        this.setFlag(bl, 1);
    }

    void setConstructor(boolean bl) {
        this.setFlag(bl, 2);
    }

    void setDefine(boolean bl) {
        this.setFlag(bl, 4);
    }

    void setHidden(boolean bl) {
        this.setFlag(bl, 8);
    }

    void setNoCheck(boolean bl) {
        this.setFlag(bl, 32);
    }

    void setShouldPreserveTry(boolean bl) {
        this.setFlag(bl, 16);
    }

    void setOverride(boolean bl) {
        this.setFlag(bl, 64);
    }

    void setNoAlias(boolean bl) {
        this.setFlag(bl, 128);
    }

    public void setDeprecated(boolean bl) {
        this.setFlag(bl, 256);
    }

    void setInterface(boolean bl) {
        this.setFlag(bl, 512);
    }

    void setExport(boolean bl) {
        this.setFlag(bl, 1024);
    }

    void setNoShadow(boolean bl) {
        this.setFlag(bl, 2048);
    }

    void setImplicitCast(boolean bl) {
        this.setFlag(bl, 8192);
    }

    void setNoSideEffects(boolean bl) {
        this.setFlag(bl, 16384);
    }

    void setExterns(boolean bl) {
        this.setFlag(bl, 32768);
    }

    void setJavaDispatch(boolean bl) {
        this.setFlag(bl, 65536);
    }

    void setNoCompile(boolean bl) {
        this.setFlag(bl, 131072);
    }

    private void setFlag(boolean bl, int n) {
        this.bitset = bl ? (this.bitset |= n) : (this.bitset &= ~n);
    }

    public boolean isConstant() {
        return this.getFlag(1) || this.isDefine();
    }

    public boolean isConstructor() {
        return this.getFlag(2);
    }

    public boolean isDefine() {
        return this.getFlag(4);
    }

    public boolean isHidden() {
        return this.getFlag(8);
    }

    public boolean isNoTypeCheck() {
        return this.getFlag(32);
    }

    public boolean shouldPreserveTry() {
        return this.getFlag(16);
    }

    public boolean isOverride() {
        return this.getFlag(64);
    }

    public boolean isNoAlias() {
        return this.getFlag(128);
    }

    public boolean isDeprecated() {
        return this.getFlag(256);
    }

    public boolean isInterface() {
        return this.getFlag(512);
    }

    public boolean isExport() {
        return this.getFlag(1024);
    }

    public boolean isNoShadow() {
        return this.getFlag(2048);
    }

    public boolean isImplicitCast() {
        return this.getFlag(8192);
    }

    public boolean isNoSideEffects() {
        return this.getFlag(16384);
    }

    public boolean isExterns() {
        return this.getFlag(32768);
    }

    public boolean isJavaDispatch() {
        return this.getFlag(65536);
    }

    public boolean isNoCompile() {
        return this.getFlag(131072);
    }

    public boolean containsDeclaration() {
        return this.hasType() || this.hasReturnType() || this.hasEnumParameterType() || this.hasTypedefType() || this.hasThisType() || this.getParameterCount() > 0 || this.getFlag(27591);
    }

    private boolean getFlag(int n) {
        return (this.bitset & n) != 0;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    private void lazyInitInfo() {
        if (this.info == null) {
            this.info = new LazilyInitializedInfo();
        }
    }

    private boolean lazyInitDocumentation() {
        if (!this.includeDocumentation) {
            return false;
        }
        if (this.documentation == null) {
            this.documentation = new LazilyInitializedDocumentation();
        }
        return true;
    }

    Marker addMarker() {
        if (!this.lazyInitDocumentation()) {
            return null;
        }
        if (this.documentation.markers == null) {
            this.documentation.markers = Lists.newArrayList();
        }
        Marker marker = new Marker();
        this.documentation.markers.add(marker);
        return marker;
    }

    boolean setDeprecationReason(String string) {
        this.lazyInitInfo();
        if (this.info.deprecated != null) {
            return false;
        }
        this.info.deprecated = string;
        return true;
    }

    public void addSuppression(String string) {
        this.lazyInitInfo();
        if (this.info.suppressions == null) {
            this.info.suppressions = Sets.newHashSet();
        }
        this.info.suppressions.add(string);
    }

    boolean setSuppressions(Set<String> set) {
        this.lazyInitInfo();
        if (this.info.suppressions != null) {
            return false;
        }
        this.info.suppressions = set;
        return true;
    }

    void addModifies(String string) {
        this.lazyInitInfo();
        if (this.info.modifies == null) {
            this.info.modifies = Sets.newHashSet();
        }
        this.info.modifies.add(string);
    }

    boolean setModifies(Set<String> set) {
        this.lazyInitInfo();
        if (this.info.modifies != null) {
            return false;
        }
        this.info.modifies = set;
        return true;
    }

    boolean documentVersion(String string) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.version != null) {
            return false;
        }
        this.documentation.version = string;
        return true;
    }

    boolean documentReference(String string) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.sees == null) {
            this.documentation.sees = Lists.newArrayList();
        }
        this.documentation.sees.add(string);
        return true;
    }

    boolean documentAuthor(String string) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.authors == null) {
            this.documentation.authors = Lists.newArrayList();
        }
        this.documentation.authors.add(string);
        return true;
    }

    boolean documentThrows(JSTypeExpression jSTypeExpression, String string) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.throwsDescriptions == null) {
            this.documentation.throwsDescriptions = new LinkedHashMap<JSTypeExpression, String>();
        }
        if (!this.documentation.throwsDescriptions.containsKey(jSTypeExpression)) {
            this.documentation.throwsDescriptions.put(jSTypeExpression, string);
            return true;
        }
        return false;
    }

    boolean documentParam(String string, String string2) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.parameters == null) {
            this.documentation.parameters = new LinkedHashMap<String, String>();
        }
        if (!this.documentation.parameters.containsKey(string)) {
            this.documentation.parameters.put(string, string2);
            return true;
        }
        return false;
    }

    boolean documentBlock(String string) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.blockDescription != null) {
            return false;
        }
        this.documentation.blockDescription = string;
        return true;
    }

    boolean documentFileOverview(String string) {
        this.setFlag(true, 4096);
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.fileOverview != null) {
            return false;
        }
        this.documentation.fileOverview = string;
        return true;
    }

    boolean documentReturn(String string) {
        if (!this.lazyInitDocumentation()) {
            return true;
        }
        if (this.documentation.returnDescription != null) {
            return false;
        }
        this.documentation.returnDescription = string;
        return true;
    }

    boolean declareParam(JSTypeExpression jSTypeExpression, String string) {
        this.lazyInitInfo();
        if (this.info.parameters == null) {
            this.info.parameters = new LinkedHashMap<String, JSTypeExpression>();
        }
        if (!this.info.parameters.containsKey(string)) {
            this.info.parameters.put(string, jSTypeExpression);
            return true;
        }
        return false;
    }

    boolean declareTemplateTypeName(String string) {
        this.lazyInitInfo();
        if (this.info.templateTypeName != null) {
            return false;
        }
        this.info.templateTypeName = string;
        return true;
    }

    boolean declareThrows(JSTypeExpression jSTypeExpression) {
        this.lazyInitInfo();
        if (this.info.thrownTypes == null) {
            this.info.thrownTypes = Lists.newArrayList();
        }
        this.info.thrownTypes.add(jSTypeExpression);
        return true;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public JSTypeExpression getParameterType(String string) {
        if (this.info == null || this.info.parameters == null) {
            return null;
        }
        return this.info.parameters.get(string);
    }

    public boolean hasParameter(String string) {
        if (this.info == null || this.info.parameters == null) {
            return false;
        }
        return this.info.parameters.containsKey(string);
    }

    public boolean hasParameterType(String string) {
        return this.getParameterType(string) != null;
    }

    public Set<String> getParameterNames() {
        if (this.info == null || this.info.parameters == null) {
            return ImmutableSet.of();
        }
        return ImmutableSet.copyOf(this.info.parameters.keySet());
    }

    public int getParameterCount() {
        if (this.info == null || this.info.parameters == null) {
            return 0;
        }
        return this.info.parameters.size();
    }

    void setType(JSTypeExpression jSTypeExpression) {
        this.setType(jSTypeExpression, 0x20000000);
    }

    void setReturnType(JSTypeExpression jSTypeExpression) {
        this.setType(jSTypeExpression, 0x40000000);
    }

    void setEnumParameterType(JSTypeExpression jSTypeExpression) {
        this.setType(jSTypeExpression, 0x60000000);
    }

    void setTypedefType(JSTypeExpression jSTypeExpression) {
        this.setType(jSTypeExpression, Integer.MIN_VALUE);
    }

    private void setType(JSTypeExpression jSTypeExpression, int n) {
        if ((this.bitset & 0xE0000000) != 0) {
            throw new IllegalStateException("API tried to add two incompatible type tags. This should have been blocked and emitted a warning.");
        }
        this.bitset = this.bitset & 0x3FFFFFFF | n;
        this.type = jSTypeExpression;
    }

    public List<JSTypeExpression> getThrownTypes() {
        if (this.info == null || this.info.thrownTypes == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.info.thrownTypes);
    }

    public boolean hasType() {
        return this.hasType(0x20000000);
    }

    public boolean hasEnumParameterType() {
        return this.hasType(0x60000000);
    }

    public boolean hasTypedefType() {
        return this.hasType(Integer.MIN_VALUE);
    }

    public boolean hasReturnType() {
        return this.hasType(0x40000000);
    }

    private boolean hasType(int n) {
        return (this.bitset & 0xE0000000) == n;
    }

    public JSTypeExpression getType() {
        return this.getType(0x20000000);
    }

    public JSTypeExpression getReturnType() {
        return this.getType(0x40000000);
    }

    public JSTypeExpression getEnumParameterType() {
        return this.getType(0x60000000);
    }

    public JSTypeExpression getTypedefType() {
        return this.getType(Integer.MIN_VALUE);
    }

    private JSTypeExpression getType(int n) {
        if ((0xE0000000 & this.bitset) == n) {
            return this.type;
        }
        return null;
    }

    public JSTypeExpression getThisType() {
        return this.thisType;
    }

    void setThisType(JSTypeExpression jSTypeExpression) {
        this.thisType = jSTypeExpression;
    }

    public boolean hasThisType() {
        return this.thisType != null;
    }

    void setBaseType(JSTypeExpression jSTypeExpression) {
        this.lazyInitInfo();
        this.info.baseType = jSTypeExpression;
    }

    public JSTypeExpression getBaseType() {
        return this.info == null ? null : this.info.baseType;
    }

    public String getDescription() {
        return this.info == null ? null : this.info.description;
    }

    void setDescription(String string) {
        this.lazyInitInfo();
        this.info.description = string;
    }

    public String getMeaning() {
        return this.info == null ? null : this.info.meaning;
    }

    void setMeaning(String string) {
        this.lazyInitInfo();
        this.info.meaning = string;
    }

    public String getLendsName() {
        return this.info == null ? null : this.info.lendsName;
    }

    void setLendsName(String string) {
        this.lazyInitInfo();
        this.info.lendsName = string;
    }

    public String getLicense() {
        return this.info == null ? null : this.info.license;
    }

    public void setLicense(String string) {
        this.lazyInitInfo();
        this.info.license = string;
    }

    public String toString() {
        return "JSDocInfo";
    }

    public boolean hasBaseType() {
        return this.getBaseType() != null;
    }

    boolean addImplementedInterface(JSTypeExpression jSTypeExpression) {
        this.lazyInitInfo();
        if (this.info.implementedInterfaces == null) {
            this.info.implementedInterfaces = Lists.newArrayListWithCapacity((int)2);
        }
        if (this.info.implementedInterfaces.contains(jSTypeExpression)) {
            return false;
        }
        this.info.implementedInterfaces.add(jSTypeExpression);
        return true;
    }

    public List<JSTypeExpression> getImplementedInterfaces() {
        if (this.info == null || this.info.implementedInterfaces == null) {
            return ImmutableList.of();
        }
        return Collections.unmodifiableList(this.info.implementedInterfaces);
    }

    public int getImplementedInterfaceCount() {
        if (this.info == null || this.info.implementedInterfaces == null) {
            return 0;
        }
        return this.info.implementedInterfaces.size();
    }

    public String getDeprecationReason() {
        return this.info == null ? null : this.info.deprecated;
    }

    public Set<String> getSuppressions() {
        Set<String> set = this.info == null ? null : this.info.suppressions;
        return set == null ? Collections.emptySet() : set;
    }

    public Set<String> getModifies() {
        Set<String> set = this.info == null ? null : this.info.modifies;
        return set == null ? Collections.emptySet() : set;
    }

    public boolean hasDescriptionForParameter(String string) {
        if (this.documentation == null || this.documentation.parameters == null) {
            return false;
        }
        return this.documentation.parameters.containsKey(string);
    }

    public String getDescriptionForParameter(String string) {
        if (this.documentation == null || this.documentation.parameters == null) {
            return null;
        }
        return this.documentation.parameters.get(string);
    }

    public Collection<String> getAuthors() {
        return this.documentation == null ? null : this.documentation.authors;
    }

    public Collection<String> getReferences() {
        return this.documentation == null ? null : this.documentation.sees;
    }

    public String getVersion() {
        return this.documentation == null ? null : this.documentation.version;
    }

    public String getReturnDescription() {
        return this.documentation == null ? null : this.documentation.returnDescription;
    }

    public String getBlockDescription() {
        return this.documentation == null ? null : this.documentation.blockDescription;
    }

    public boolean hasFileOverview() {
        return this.getFlag(4096);
    }

    public String getFileOverview() {
        return this.documentation == null ? null : this.documentation.fileOverview;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public Collection<Marker> getMarkers() {
        return this.documentation == null ? null : this.documentation.markers;
    }

    void setSourceName(String string) {
        this.sourceName = string;
    }

    public String getTemplateTypeName() {
        if (this.info == null) {
            return null;
        }
        return this.info.templateTypeName;
    }

    public Collection<Node> getTypeNodes() {
        ArrayList arrayList = Lists.newArrayList();
        if (this.type != null) {
            arrayList.add(this.type.getRoot());
        }
        if (this.thisType != null) {
            arrayList.add(this.thisType.getRoot());
        }
        if (this.info != null) {
            if (this.info.baseType != null) {
                arrayList.add(this.info.baseType.getRoot());
            }
            if (this.info.implementedInterfaces != null) {
                for (JSTypeExpression jSTypeExpression : this.info.implementedInterfaces) {
                    arrayList.add(jSTypeExpression.getRoot());
                }
            }
            if (this.info.parameters != null) {
                for (JSTypeExpression jSTypeExpression : this.info.parameters.values()) {
                    if (jSTypeExpression == null) continue;
                    arrayList.add(jSTypeExpression.getRoot());
                }
            }
            if (this.info.thrownTypes != null) {
                for (JSTypeExpression jSTypeExpression : this.info.thrownTypes) {
                    if (jSTypeExpression == null) continue;
                    arrayList.add(jSTypeExpression.getRoot());
                }
            }
        }
        return arrayList;
    }

    public boolean hasModifies() {
        return this.info != null && this.info.modifies != null;
    }

    public String getOriginalCommentString() {
        return this.documentation == null ? null : this.documentation.sourceComment;
    }

    void setOriginalCommentString(String string) {
        if (!this.lazyInitDocumentation()) {
            return;
        }
        this.documentation.sourceComment = string;
    }

    public static final class Marker {
        public StringPosition annotation = null;
        public StringPosition name = null;
        public StringPosition description = null;
        public TypePosition type = null;
    }

    public static class TypePosition
    extends SourcePosition<Node> {
        public boolean hasBrackets = false;
    }

    public static class StringPosition
    extends SourcePosition<String> {
    }

    private static final class LazilyInitializedDocumentation {
        String sourceComment = null;
        List<Marker> markers = null;
        Map<String, String> parameters = null;
        Map<JSTypeExpression, String> throwsDescriptions = null;
        String blockDescription = null;
        String fileOverview = null;
        String returnDescription = null;
        String version = null;
        List<String> authors = null;
        List<String> sees = null;

        private LazilyInitializedDocumentation() {
        }
    }

    private static final class LazilyInitializedInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        JSTypeExpression baseType = null;
        List<JSTypeExpression> implementedInterfaces = null;
        Map<String, JSTypeExpression> parameters = null;
        List<JSTypeExpression> thrownTypes = null;
        String templateTypeName = null;
        String description = null;
        String meaning = null;
        String deprecated = null;
        String license = null;
        Set<String> suppressions = null;
        Set<String> modifies = null;
        String lendsName = null;

        private LazilyInitializedInfo() {
        }
    }

    public static enum Visibility {
        PRIVATE,
        PROTECTED,
        PUBLIC,
        INHERITED;

    }
}

