/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.javascript.rhino.FunctionNode;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.ScriptOrFnNode;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class Node
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int LOCAL_BLOCK_PROP = -3;
    public static final int OBJECT_IDS_PROP = -2;
    public static final int CATCH_SCOPE_PROP = -1;
    public static final int LABEL_ID_PROP = 0;
    public static final int TARGET_PROP = 1;
    public static final int BREAK_PROP = 2;
    public static final int CONTINUE_PROP = 3;
    public static final int ENUM_PROP = 4;
    public static final int FUNCTION_PROP = 5;
    public static final int TEMP_PROP = 6;
    public static final int LOCAL_PROP = 7;
    public static final int CODEOFFSET_PROP = 8;
    public static final int FIXUPS_PROP = 9;
    public static final int VARS_PROP = 10;
    public static final int USES_PROP = 11;
    public static final int REGEXP_PROP = 12;
    public static final int CASES_PROP = 13;
    public static final int DEFAULT_PROP = 14;
    public static final int CASEARRAY_PROP = 15;
    public static final int SOURCENAME_PROP = 16;
    public static final int TYPE_PROP = 17;
    public static final int SPECIAL_PROP_PROP = 18;
    public static final int LABEL_PROP = 19;
    public static final int FINALLY_PROP = 20;
    public static final int LOCALCOUNT_PROP = 21;
    public static final int TARGETBLOCK_PROP = 22;
    public static final int VARIABLE_PROP = 23;
    public static final int LASTUSE_PROP = 24;
    public static final int ISNUMBER_PROP = 25;
    public static final int DIRECTCALL_PROP = 26;
    public static final int SPECIALCALL_PROP = 27;
    public static final int DEBUGSOURCE_PROP = 28;
    public static final int JSDOC_INFO_PROP = 29;
    public static final int VAR_ARGS_NAME = 29;
    public static final int SKIP_INDEXES_PROP = 30;
    public static final int INCRDECR_PROP = 31;
    public static final int MEMBER_TYPE_PROP = 32;
    public static final int NAME_PROP = 33;
    public static final int PARENTHESIZED_PROP = 34;
    public static final int QUOTED_PROP = 35;
    public static final int OPT_ARG_NAME = 36;
    public static final int SYNTHETIC_BLOCK_PROP = 37;
    public static final int EMPTY_BLOCK = 38;
    public static final int ORIGINALNAME_PROP = 39;
    public static final int BRACELESS_TYPE = 40;
    public static final int SIDE_EFFECT_FLAGS = 41;
    public static final int IS_CONSTANT_NAME = 42;
    public static final int IS_OPTIONAL_PARAM = 43;
    public static final int IS_VAR_ARGS_PARAM = 44;
    public static final int IS_NAMESPACE = 45;
    public static final int IS_DISPATCHER = 46;
    public static final int DIRECTIVES = 47;
    public static final int DIRECT_EVAL = 48;
    public static final int FREE_CALL = 49;
    public static final int LAST_PROP = 49;
    public static final int BOTH = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int NON_SPECIALCALL = 0;
    public static final int SPECIALCALL_EVAL = 1;
    public static final int SPECIALCALL_WITH = 2;
    public static final int DECR_FLAG = 1;
    public static final int POST_FLAG = 2;
    public static final int PROPERTY_FLAG = 1;
    public static final int ATTRIBUTE_FLAG = 2;
    public static final int DESCENDANTS_FLAG = 4;
    int type;
    Node next;
    private Node first;
    private Node last;
    private PropListItem propListHead;
    public static final int COLUMN_BITS = 12;
    public static final int MAX_COLUMN_NUMBER = 4095;
    public static final int COLUMN_MASK = 4095;
    private int sourcePosition;
    private JSType jsType;
    private Node parent;
    public static final int FLAG_GLOBAL_STATE_UNMODIFIED = 1;
    public static final int FLAG_THIS_UNMODIFIED = 2;
    public static final int FLAG_ARGUMENTS_UNMODIFIED = 4;
    public static final int FLAG_NO_THROWS = 8;
    public static final int FLAG_LOCAL_RESULTS = 16;
    public static final int SIDE_EFFECTS_FLAGS_MASK = 31;
    public static final int SIDE_EFFECTS_ALL = 0;
    public static final int NO_SIDE_EFFECTS = 15;

    private static final String propToString(int n) {
        switch (n) {
            case -3: {
                return "local_block";
            }
            case -2: {
                return "object_ids_prop";
            }
            case -1: {
                return "catch_scope_prop";
            }
            case 0: {
                return "label_id_prop";
            }
            case 1: {
                return "target";
            }
            case 2: {
                return "break";
            }
            case 3: {
                return "continue";
            }
            case 4: {
                return "enum";
            }
            case 5: {
                return "function";
            }
            case 6: {
                return "temp";
            }
            case 7: {
                return "local";
            }
            case 8: {
                return "codeoffset";
            }
            case 9: {
                return "fixups";
            }
            case 10: {
                return "vars";
            }
            case 11: {
                return "uses";
            }
            case 12: {
                return "regexp";
            }
            case 13: {
                return "cases";
            }
            case 14: {
                return "default";
            }
            case 15: {
                return "casearray";
            }
            case 16: {
                return "sourcename";
            }
            case 17: {
                return "type";
            }
            case 18: {
                return "special_prop";
            }
            case 19: {
                return "label";
            }
            case 20: {
                return "finally";
            }
            case 21: {
                return "localcount";
            }
            case 22: {
                return "targetblock";
            }
            case 23: {
                return "variable";
            }
            case 24: {
                return "lastuse";
            }
            case 25: {
                return "isnumber";
            }
            case 26: {
                return "directcall";
            }
            case 27: {
                return "specialcall";
            }
            case 28: {
                return "debugsource";
            }
            case 29: {
                return "jsdoc_info";
            }
            case 30: {
                return "skip_indexes";
            }
            case 31: {
                return "incrdecr";
            }
            case 32: {
                return "member_type";
            }
            case 33: {
                return "name";
            }
            case 34: {
                return "parenthesized";
            }
            case 35: {
                return "quoted";
            }
            case 37: {
                return "synthetic";
            }
            case 38: {
                return "empty_block";
            }
            case 39: {
                return "originalname";
            }
            case 41: {
                return "side_effect_flags";
            }
            case 42: {
                return "is_constant_name";
            }
            case 43: {
                return "is_optional_param";
            }
            case 44: {
                return "is_var_args_param";
            }
            case 45: {
                return "is_namespace";
            }
            case 46: {
                return "is_dispatcher";
            }
            case 47: {
                return "directives";
            }
            case 48: {
                return "direct_eval";
            }
            case 49: {
                return "free_call";
            }
        }
        Kit.codeBug();
        return null;
    }

    public Node(int n) {
        this.type = n;
        this.parent = null;
        this.sourcePosition = -1;
    }

    public Node(int n, Node node) {
        Preconditions.checkArgument((node.parent == null ? 1 : 0) != 0, (Object)"new child has existing parent");
        Preconditions.checkArgument((node.next == null ? 1 : 0) != 0, (Object)"new child has existing sibling");
        this.type = n;
        this.parent = null;
        this.first = this.last = node;
        node.next = null;
        node.parent = this;
        this.sourcePosition = -1;
    }

    public Node(int n, Node node, Node node2) {
        Preconditions.checkArgument((node.parent == null ? 1 : 0) != 0, (Object)"first new child has existing parent");
        Preconditions.checkArgument((node.next == null ? 1 : 0) != 0, (Object)"first new child has existing sibling");
        Preconditions.checkArgument((node2.parent == null ? 1 : 0) != 0, (Object)"second new child has existing parent");
        Preconditions.checkArgument((node2.next == null ? 1 : 0) != 0, (Object)"second new child has existing sibling");
        this.type = n;
        this.parent = null;
        this.first = node;
        this.last = node2;
        node.next = node2;
        node.parent = this;
        node2.next = null;
        node2.parent = this;
        this.sourcePosition = -1;
    }

    public Node(int n, Node node, Node node2, Node node3) {
        Preconditions.checkArgument((node.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node3.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node3.next == null ? 1 : 0) != 0);
        this.type = n;
        this.parent = null;
        this.first = node;
        this.last = node3;
        node.next = node2;
        node.parent = this;
        node2.next = node3;
        node2.parent = this;
        node3.next = null;
        node3.parent = this;
        this.sourcePosition = -1;
    }

    public Node(int n, Node node, Node node2, Node node3, Node node4) {
        Preconditions.checkArgument((node.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node2.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node3.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node3.next == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node4.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node4.next == null ? 1 : 0) != 0);
        this.type = n;
        this.parent = null;
        this.first = node;
        this.last = node4;
        node.next = node2;
        node.parent = this;
        node2.next = node3;
        node2.parent = this;
        node3.next = node4;
        node3.parent = this;
        node4.next = null;
        node4.parent = this;
        this.sourcePosition = -1;
    }

    public Node(int n, int n2, int n3) {
        this.type = n;
        this.parent = null;
        this.sourcePosition = Node.mergeLineCharNo(n2, n3);
    }

    public Node(int n, Node node, int n2, int n3) {
        this(n, node);
        this.sourcePosition = Node.mergeLineCharNo(n2, n3);
    }

    public Node(int n, Node node, Node node2, int n2, int n3) {
        this(n, node, node2);
        this.sourcePosition = Node.mergeLineCharNo(n2, n3);
    }

    public Node(int n, Node node, Node node2, Node node3, int n2, int n3) {
        this(n, node, node2, node3);
        this.sourcePosition = Node.mergeLineCharNo(n2, n3);
    }

    public Node(int n, Node node, Node node2, Node node3, Node node4, int n2, int n3) {
        this(n, node, node2, node3, node4);
        this.sourcePosition = Node.mergeLineCharNo(n2, n3);
    }

    public Node(int n, Node[] nodeArray, int n2, int n3) {
        this(n, nodeArray);
        this.sourcePosition = Node.mergeLineCharNo(n2, n3);
    }

    public Node(int n, Node[] nodeArray) {
        this.type = n;
        this.parent = null;
        if (nodeArray.length != 0) {
            this.first = nodeArray[0];
            this.last = nodeArray[nodeArray.length - 1];
            for (int i = 1; i < nodeArray.length; ++i) {
                if (null != nodeArray[i - 1].next) {
                    throw new IllegalArgumentException("duplicate child");
                }
                nodeArray[i - 1].next = nodeArray[i];
                Preconditions.checkArgument((nodeArray[i - 1].parent == null ? 1 : 0) != 0);
                nodeArray[i - 1].parent = this;
            }
            Preconditions.checkArgument((nodeArray[nodeArray.length - 1].parent == null ? 1 : 0) != 0);
            nodeArray[nodeArray.length - 1].parent = this;
            if (null != this.last.next) {
                throw new IllegalArgumentException("duplicate child");
            }
        }
    }

    public static Node newNumber(double d) {
        return new NumberNode(d);
    }

    public static Node newNumber(double d, int n, int n2) {
        return new NumberNode(d, n, n2);
    }

    public static Node newString(String string) {
        return new StringNode(40, string);
    }

    public static Node newString(int n, String string) {
        return new StringNode(n, string);
    }

    public static Node newString(String string, int n, int n2) {
        return new StringNode(40, string, n, n2);
    }

    public static Node newString(int n, String string, int n2, int n3) {
        return new StringNode(n, string, n2, n3);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public boolean hasChildren() {
        return this.first != null;
    }

    public Node getFirstChild() {
        return this.first;
    }

    public Node getLastChild() {
        return this.last;
    }

    public Node getNext() {
        return this.next;
    }

    public Node getChildBefore(Node node) {
        if (node == this.first) {
            return null;
        }
        Node node2 = this.first;
        while (node2.next != node) {
            node2 = node2.next;
            if (node2 != null) continue;
            throw new RuntimeException("node is not a child");
        }
        return node2;
    }

    public Node getChildAtIndex(int n) {
        Node node = this.first;
        while (n > 0) {
            node = node.next;
            --n;
        }
        return node;
    }

    public Node getLastSibling() {
        Node node = this;
        while (node.next != null) {
            node = node.next;
        }
        return node;
    }

    public void addChildToFront(Node node) {
        Preconditions.checkArgument((node.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node.next == null ? 1 : 0) != 0);
        node.parent = this;
        node.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node;
        }
    }

    public void addChildToBack(Node node) {
        Preconditions.checkArgument((node.parent == null ? 1 : 0) != 0);
        Preconditions.checkArgument((node.next == null ? 1 : 0) != 0);
        node.parent = this;
        node.next = null;
        if (this.last == null) {
            this.first = this.last = node;
            return;
        }
        this.last.next = node;
        this.last = node;
    }

    public void addChildrenToFront(Node node) {
        Node node2 = node;
        while (node2 != null) {
            Preconditions.checkArgument((node2.parent == null ? 1 : 0) != 0);
            node2.parent = this;
            node2 = node2.next;
        }
        node2 = node.getLastSibling();
        node2.next = this.first;
        this.first = node;
        if (this.last == null) {
            this.last = node2;
        }
    }

    public void addChildrenToBack(Node node) {
        Node node2 = node;
        while (node2 != null) {
            Preconditions.checkArgument((node2.parent == null ? 1 : 0) != 0);
            node2.parent = this;
            node2 = node2.next;
        }
        if (this.last != null) {
            this.last.next = node;
        }
        this.last = node.getLastSibling();
        if (this.first == null) {
            this.first = node;
        }
    }

    public void addChildBefore(Node node, Node node2) {
        Preconditions.checkArgument((node2 != null ? 1 : 0) != 0, (Object)"The existing child node of the parent should not be null.");
        Preconditions.checkArgument((node.next == null ? 1 : 0) != 0, (Object)"The new child node has siblings.");
        Preconditions.checkArgument((node.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        if (this.first == node2) {
            node.parent = this;
            node.next = this.first;
            this.first = node;
            return;
        }
        Node node3 = this.getChildBefore(node2);
        this.addChildAfter(node, node3);
    }

    public void addChildAfter(Node node, Node node2) {
        Preconditions.checkArgument((node.next == null ? 1 : 0) != 0, (Object)"The new child node has siblings.");
        Preconditions.checkArgument((node.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        node.parent = this;
        node.next = node2.next;
        node2.next = node;
        if (this.last == node2) {
            this.last = node;
        }
    }

    public void removeChild(Node node) {
        Node node2 = this.getChildBefore(node);
        if (node2 == null) {
            this.first = this.first.next;
        } else {
            node2.next = node.next;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
        node.parent = null;
    }

    public void replaceChild(Node node, Node node2) {
        Preconditions.checkArgument((node2.next == null ? 1 : 0) != 0, (Object)"The new child node has siblings.");
        Preconditions.checkArgument((node2.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        node2.copyInformationFrom(node);
        node2.next = node.next;
        node2.parent = this;
        if (node == this.first) {
            this.first = node2;
        } else {
            Node node3 = this.getChildBefore(node);
            node3.next = node2;
        }
        if (node == this.last) {
            this.last = node2;
        }
        node.next = null;
        node.parent = null;
    }

    public void replaceChildAfter(Node node, Node node2) {
        Preconditions.checkArgument((node.parent == this ? 1 : 0) != 0, (Object)"prev is not a child of this node.");
        Preconditions.checkArgument((node2.next == null ? 1 : 0) != 0, (Object)"The new child node has siblings.");
        Preconditions.checkArgument((node2.parent == null ? 1 : 0) != 0, (Object)"The new child node already has a parent.");
        node2.copyInformationFrom(node);
        Node node3 = node.next;
        node2.next = node3.next;
        node2.parent = this;
        node.next = node2;
        if (node3 == this.last) {
            this.last = node2;
        }
        node3.next = null;
        node3.parent = null;
    }

    @VisibleForTesting
    PropListItem lookupProperty(int n) {
        PropListItem propListItem = this.propListHead;
        while (propListItem != null && n != propListItem.type) {
            propListItem = propListItem.next;
        }
        return propListItem;
    }

    public Node clonePropsFrom(Node node) {
        Preconditions.checkState((this.propListHead == null ? 1 : 0) != 0, (Object)"Node has existing properties.");
        this.propListHead = node.propListHead;
        return this;
    }

    public void removeProp(int n) {
        PropListItem propListItem = this.removeProp(this.propListHead, n);
        if (propListItem != this.propListHead) {
            this.propListHead = propListItem;
        }
    }

    private PropListItem removeProp(PropListItem propListItem, int n) {
        if (propListItem == null) {
            return null;
        }
        if (propListItem.type == n) {
            return propListItem.next;
        }
        PropListItem propListItem2 = this.removeProp(propListItem.next, n);
        if (propListItem2 != propListItem.next) {
            return new PropListItem(propListItem.type, propListItem.intValue, propListItem.objectValue, propListItem2);
        }
        return propListItem;
    }

    public Object getProp(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            return null;
        }
        return propListItem.objectValue;
    }

    public boolean getBooleanProp(int n) {
        return this.getIntProp(n) != 0;
    }

    public int getIntProp(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            return 0;
        }
        return propListItem.intValue;
    }

    public int getExistingIntProp(int n) {
        PropListItem propListItem = this.lookupProperty(n);
        if (propListItem == null) {
            Kit.codeBug();
        }
        return propListItem.intValue;
    }

    public void putProp(int n, Object object) {
        this.removeProp(n);
        if (object != null) {
            this.propListHead = new PropListItem(n, object, this.propListHead);
        }
    }

    public void putBooleanProp(int n, boolean bl) {
        this.putIntProp(n, bl ? 1 : 0);
    }

    public void putIntProp(int n, int n2) {
        this.removeProp(n);
        if (n2 != 0) {
            this.propListHead = new PropListItem(n, n2, this.propListHead);
        }
    }

    private int[] getSortedPropTypes() {
        int n = 0;
        Object object = this.propListHead;
        while (object != null) {
            ++n;
            object = ((PropListItem)object).next;
        }
        object = new int[n];
        PropListItem propListItem = this.propListHead;
        while (propListItem != null) {
            object[--n] = propListItem.type;
            propListItem = propListItem.next;
        }
        Arrays.sort((int[])object);
        return object;
    }

    public int getLineno() {
        return Node.extractLineno(this.sourcePosition);
    }

    public int getCharno() {
        return Node.extractCharno(this.sourcePosition);
    }

    public double getDouble() throws UnsupportedOperationException {
        if (this.getType() == 39) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a number node");
    }

    public void setDouble(double d) throws UnsupportedOperationException {
        if (this.getType() == 39) {
            throw new IllegalStateException("Number node not created with Node.newNumber");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String getString() throws UnsupportedOperationException {
        if (this.getType() == 40) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public void setString(String string) throws UnsupportedOperationException {
        if (this.getType() == 40) {
            throw new IllegalStateException("String node not created with Node.newString");
        }
        throw new UnsupportedOperationException(this + " is not a string node");
    }

    public String toString() {
        return this.toString(true, true, true);
    }

    public String toString(boolean bl, boolean bl2, boolean bl3) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, bl, bl2, bl3);
        return stringBuilder.toString();
    }

    private void toString(StringBuilder stringBuilder, boolean bl, boolean bl2, boolean bl3) {
        int n;
        Object object;
        stringBuilder.append(Token.name(this.type));
        if (this instanceof StringNode) {
            stringBuilder.append(' ');
            stringBuilder.append(this.getString());
        } else if (this.type == 105) {
            stringBuilder.append(' ');
            if (this.first == null || this.first.getType() != 38) {
                stringBuilder.append("<invalid>");
            } else {
                stringBuilder.append(this.first.getString());
            }
        } else if (this instanceof ScriptOrFnNode) {
            object = (ScriptOrFnNode)this;
            if (this instanceof FunctionNode) {
                FunctionNode functionNode = (FunctionNode)this;
                stringBuilder.append(' ');
                stringBuilder.append(functionNode.getFunctionName());
            }
            if (bl) {
                stringBuilder.append(" [source name: ");
                stringBuilder.append(((ScriptOrFnNode)object).getSourceName());
                stringBuilder.append("] [encoded source length: ");
                stringBuilder.append(((ScriptOrFnNode)object).getEncodedSourceEnd() - ((ScriptOrFnNode)object).getEncodedSourceStart());
                stringBuilder.append("] [base line: ");
                stringBuilder.append(((ScriptOrFnNode)object).getBaseLineno());
                stringBuilder.append("] [end line: ");
                stringBuilder.append(((ScriptOrFnNode)object).getEndLineno());
                stringBuilder.append(']');
            }
        } else if (this.type == 39) {
            stringBuilder.append(' ');
            stringBuilder.append(this.getDouble());
        }
        if (bl && (n = this.getLineno()) != -1) {
            stringBuilder.append(' ');
            stringBuilder.append(n);
        }
        if (bl2) {
            object = this.getSortedPropTypes();
            for (int i = 0; i < ((Object)object).length; ++i) {
                String string;
                Object object2 = object[i];
                PropListItem propListItem = this.lookupProperty((int)object2);
                stringBuilder.append(" [");
                stringBuilder.append(Node.propToString((int)object2));
                stringBuilder.append(": ");
                block0 : switch (object2) {
                    case 22: {
                        string = "target block property";
                        break;
                    }
                    case -3: {
                        string = "last local block";
                        break;
                    }
                    case 25: {
                        switch (propListItem.intValue) {
                            case 0: {
                                string = "both";
                                break block0;
                            }
                            case 2: {
                                string = "right";
                                break block0;
                            }
                            case 1: {
                                string = "left";
                                break block0;
                            }
                        }
                        throw Kit.codeBug();
                    }
                    case 27: {
                        switch (propListItem.intValue) {
                            case 1: {
                                string = "eval";
                                break block0;
                            }
                            case 2: {
                                string = "with";
                                break block0;
                            }
                        }
                        throw Kit.codeBug();
                    }
                    default: {
                        Object object3 = propListItem.objectValue;
                        string = object3 != null ? object3.toString() : String.valueOf(propListItem.intValue);
                    }
                }
                stringBuilder.append(string);
                stringBuilder.append(']');
            }
        }
        if (bl3 && this.jsType != null && (object = this.jsType.toString()) != null) {
            stringBuilder.append(" : ");
            stringBuilder.append((String)object);
        }
    }

    public String toStringTree() {
        return this.toStringTreeImpl();
    }

    private String toStringTreeImpl() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendStringTree(stringBuilder);
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Should not happen\n" + iOException);
        }
    }

    public void appendStringTree(Appendable appendable) throws IOException {
        Node.toStringTreeHelper(this, 0, appendable);
    }

    private static void toStringTreeHelper(Node node, int n, Appendable appendable) throws IOException {
        for (int i = 0; i != n; ++i) {
            appendable.append("    ");
        }
        appendable.append(node.toString());
        appendable.append('\n');
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            Node.toStringTreeHelper(node2, n + 1, appendable);
        }
    }

    public void setLineno(int n) {
        int n2 = this.getCharno();
        if (n2 == -1) {
            n2 = 0;
        }
        this.sourcePosition = Node.mergeLineCharNo(n, n2);
    }

    public void setCharno(int n) {
        this.sourcePosition = Node.mergeLineCharNo(this.getLineno(), n);
    }

    protected static int mergeLineCharNo(int n, int n2) {
        if (n < 0 || n2 < 0) {
            return -1;
        }
        if ((n2 & 0xFFFFF000) != 0) {
            return n << 12 | 0xFFF;
        }
        return n << 12 | n2 & 0xFFF;
    }

    protected static int extractLineno(int n) {
        if (n == -1) {
            return -1;
        }
        return n >>> 12;
    }

    protected static int extractCharno(int n) {
        if (n == -1) {
            return -1;
        }
        return n & 0xFFF;
    }

    public Iterable<Node> children() {
        if (this.first == null) {
            return Collections.emptySet();
        }
        return new SiblingNodeIterable(this.first);
    }

    public Iterable<Node> siblings() {
        return new SiblingNodeIterable(this);
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getAncestor(int n) {
        Node node;
        Preconditions.checkArgument((n >= 0 ? 1 : 0) != 0);
        for (node = this; node != null && n-- > 0; node = node.getParent()) {
        }
        return node;
    }

    public AncestorIterable getAncestors() {
        return new AncestorIterable(this.getParent());
    }

    public boolean hasOneChild() {
        return this.first != null && this.first == this.last;
    }

    public boolean hasMoreThanOneChild() {
        return this.first != null && this.first != this.last;
    }

    public int getChildCount() {
        int n = 0;
        Node node = this.first;
        while (node != null) {
            ++n;
            node = node.next;
        }
        return n;
    }

    public boolean hasChild(Node node) {
        for (Node node2 = this.first; node2 != null; node2 = node2.getNext()) {
            if (node != node2) continue;
            return true;
        }
        return false;
    }

    public String checkTreeEquals(Node node) {
        NodeMismatch nodeMismatch = this.checkTreeEqualsImpl(node);
        if (nodeMismatch != null) {
            return "Node tree inequality:\nTree1:\n" + this.toStringTree() + "\n\nTree2:\n" + node.toStringTree() + "\n\nSubtree1: " + nodeMismatch.nodeA.toStringTree() + "\n\nSubtree2: " + nodeMismatch.nodeB.toStringTree();
        }
        return null;
    }

    private static Class getNodeClass(Node node) {
        Class<?> clazz = node.getClass();
        if (clazz == FunctionNode.class || clazz == ScriptOrFnNode.class) {
            return Node.class;
        }
        return clazz;
    }

    NodeMismatch checkTreeEqualsImpl(Node node) {
        if (!this.isEquivalentTo(node, false, false)) {
            return new NodeMismatch(this, node);
        }
        NodeMismatch nodeMismatch = null;
        Node node2 = this.first;
        Node node3 = node.first;
        while (nodeMismatch == null && node2 != null) {
            if (node == null) {
                throw new IllegalStateException();
            }
            nodeMismatch = node2.checkTreeEqualsImpl(node3);
            if (nodeMismatch != null) {
                return nodeMismatch;
            }
            node2 = node2.next;
            node3 = node3.next;
        }
        return nodeMismatch;
    }

    NodeMismatch checkTreeTypeAwareEqualsImpl(Node node) {
        if (!this.isEquivalentTo(node, true, false)) {
            return new NodeMismatch(this, node);
        }
        NodeMismatch nodeMismatch = null;
        Node node2 = this.first;
        Node node3 = node.first;
        while (nodeMismatch == null && node2 != null) {
            nodeMismatch = node2.checkTreeTypeAwareEqualsImpl(node3);
            if (nodeMismatch != null) {
                return nodeMismatch;
            }
            node2 = node2.next;
            node3 = node3.next;
        }
        return nodeMismatch;
    }

    public static String tokenToName(int n) {
        switch (n) {
            case -1: {
                return "error";
            }
            case 0: {
                return "eof";
            }
            case 1: {
                return "eol";
            }
            case 2: {
                return "enterwith";
            }
            case 3: {
                return "leavewith";
            }
            case 4: {
                return "return";
            }
            case 5: {
                return "goto";
            }
            case 6: {
                return "ifeq";
            }
            case 7: {
                return "ifne";
            }
            case 8: {
                return "setname";
            }
            case 9: {
                return "bitor";
            }
            case 10: {
                return "bitxor";
            }
            case 11: {
                return "bitand";
            }
            case 12: {
                return "eq";
            }
            case 13: {
                return "ne";
            }
            case 14: {
                return "lt";
            }
            case 15: {
                return "le";
            }
            case 16: {
                return "gt";
            }
            case 17: {
                return "ge";
            }
            case 18: {
                return "lsh";
            }
            case 19: {
                return "rsh";
            }
            case 20: {
                return "ursh";
            }
            case 21: {
                return "add";
            }
            case 22: {
                return "sub";
            }
            case 23: {
                return "mul";
            }
            case 24: {
                return "div";
            }
            case 25: {
                return "mod";
            }
            case 27: {
                return "bitnot";
            }
            case 29: {
                return "neg";
            }
            case 30: {
                return "new";
            }
            case 31: {
                return "delprop";
            }
            case 32: {
                return "typeof";
            }
            case 33: {
                return "getprop";
            }
            case 34: {
                return "setprop";
            }
            case 35: {
                return "getelem";
            }
            case 36: {
                return "setelem";
            }
            case 37: {
                return "call";
            }
            case 38: {
                return "name";
            }
            case 39: {
                return "number";
            }
            case 40: {
                return "string";
            }
            case 41: {
                return "null";
            }
            case 42: {
                return "this";
            }
            case 43: {
                return "false";
            }
            case 44: {
                return "true";
            }
            case 45: {
                return "sheq";
            }
            case 46: {
                return "shne";
            }
            case 47: {
                return "regexp";
            }
            case 28: {
                return "pos";
            }
            case 48: {
                return "bindname";
            }
            case 49: {
                return "throw";
            }
            case 51: {
                return "in";
            }
            case 52: {
                return "instanceof";
            }
            case 54: {
                return "getvar";
            }
            case 55: {
                return "setvar";
            }
            case 77: {
                return "try";
            }
            case 133: {
                return "typeofname";
            }
            case 61: {
                return "thisfn";
            }
            case 78: {
                return "semi";
            }
            case 79: {
                return "lb";
            }
            case 80: {
                return "rb";
            }
            case 81: {
                return "lc";
            }
            case 82: {
                return "rc";
            }
            case 83: {
                return "lp";
            }
            case 84: {
                return "rp";
            }
            case 85: {
                return "comma";
            }
            case 86: {
                return "assign";
            }
            case 87: {
                return "assign_bitor";
            }
            case 88: {
                return "assign_bitxor";
            }
            case 89: {
                return "assign_bitand";
            }
            case 90: {
                return "assign_lsh";
            }
            case 91: {
                return "assign_rsh";
            }
            case 92: {
                return "assign_ursh";
            }
            case 93: {
                return "assign_add";
            }
            case 94: {
                return "assign_sub";
            }
            case 95: {
                return "assign_mul";
            }
            case 96: {
                return "assign_div";
            }
            case 97: {
                return "assign_mod";
            }
            case 98: {
                return "hook";
            }
            case 99: {
                return "colon";
            }
            case 100: {
                return "or";
            }
            case 101: {
                return "and";
            }
            case 102: {
                return "inc";
            }
            case 103: {
                return "dec";
            }
            case 104: {
                return "dot";
            }
            case 105: {
                return "function";
            }
            case 106: {
                return "export";
            }
            case 107: {
                return "import";
            }
            case 108: {
                return "if";
            }
            case 109: {
                return "else";
            }
            case 110: {
                return "switch";
            }
            case 111: {
                return "case";
            }
            case 112: {
                return "default";
            }
            case 113: {
                return "while";
            }
            case 114: {
                return "do";
            }
            case 115: {
                return "for";
            }
            case 116: {
                return "break";
            }
            case 117: {
                return "continue";
            }
            case 118: {
                return "var";
            }
            case 119: {
                return "with";
            }
            case 120: {
                return "catch";
            }
            case 121: {
                return "finally";
            }
            case 123: {
                return "reserved";
            }
            case 26: {
                return "not";
            }
            case 122: {
                return "void";
            }
            case 125: {
                return "block";
            }
            case 63: {
                return "arraylit";
            }
            case 64: {
                return "objectlit";
            }
            case 126: {
                return "label";
            }
            case 127: {
                return "target";
            }
            case 128: {
                return "loop";
            }
            case 129: {
                return "expr_void";
            }
            case 130: {
                return "expr_result";
            }
            case 131: {
                return "jsr";
            }
            case 132: {
                return "script";
            }
            case 124: {
                return "empty";
            }
            case 65: {
                return "get_ref";
            }
            case 69: {
                return "ref_special";
            }
        }
        return "<unknown=" + n + ">";
    }

    public boolean isEquivalentTo(Node node) {
        return this.isEquivalentTo(node, false, true);
    }

    public boolean isEquivalentToTyped(Node node) {
        return this.isEquivalentTo(node, true, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    boolean isEquivalentTo(Node var1_1, boolean var2_2, boolean var3_3) {
        if (this.type != var1_1.getType() || this.getChildCount() != var1_1.getChildCount() || Node.getNodeClass(this) != Node.getNodeClass(var1_1)) {
            return false;
        }
        if (var2_2 && !JSType.isEquivalent(this.jsType, var1_1.getJSType())) {
            return false;
        }
        if (this.type == 63) {
            try {
                var4_4 = (int[])this.getProp(30);
                var5_8 /* !! */  = (int[])var1_1.getProp(30);
                if (var4_4 == null) {
                    if (var5_8 /* !! */  == null) ** GOTO lbl24
                    return false;
                }
                if (var5_8 /* !! */  == null) {
                    return false;
                }
                if (((int[])var4_4).length != var5_8 /* !! */ .length) {
                    return false;
                }
                for (var6_11 = 0; var6_11 < ((int[])var4_4).length; ++var6_11) {
                    if (var4_4[var6_11] == var5_8 /* !! */ [var6_11]) continue;
                    return false;
                }
            }
            catch (Exception var4_5) {
                return false;
            }
        } else if (this.type == 102 || this.type == 103 ? (var4_6 = this.getIntProp(31)) != (var5_9 = var1_1.getIntProp(31)) : this.type == 40 && (var4_7 = this.getIntProp(35)) != (var5_10 = var1_1.getIntProp(35))) {
            return false;
        }
lbl24:
        // 4 sources

        if (var3_3) {
            var4_4 = this.first;
            var5_8 /* !! */  = (int[])var1_1.first;
            while (var4_4 != null) {
                if (!var4_4.isEquivalentTo((Node)var5_8 /* !! */ , var2_2, true)) {
                    return false;
                }
                var4_4 = var4_4.next;
                var5_8 /* !! */  = (int[])var5_8 /* !! */ .next;
            }
        }
        return true;
    }

    public boolean hasSideEffects() {
        switch (this.type) {
            case 85: 
            case 129: {
                if (this.last != null) {
                    return this.last.hasSideEffects();
                }
                return true;
            }
            case 98: {
                if (this.first == null || this.first.next == null || this.first.next.next == null) {
                    Kit.codeBug();
                }
                return this.first.next.hasSideEffects() && this.first.next.next.hasSideEffects();
            }
            case -1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 30: 
            case 31: 
            case 34: 
            case 36: 
            case 37: 
            case 49: 
            case 50: 
            case 55: 
            case 56: 
            case 62: 
            case 66: 
            case 67: 
            case 68: 
            case 77: 
            case 78: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 102: 
            case 103: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 130: 
            case 131: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 149: {
                return true;
            }
        }
        return false;
    }

    public String getQualifiedName() {
        if (this.type == 38) {
            return this.getString();
        }
        if (this.type == 33) {
            String string = this.getFirstChild().getQualifiedName();
            if (string == null) {
                return null;
            }
            return string + "." + this.getLastChild().getString();
        }
        if (this.type == 42) {
            return "this";
        }
        return null;
    }

    public boolean isQualifiedName() {
        switch (this.getType()) {
            case 38: 
            case 42: {
                return true;
            }
            case 33: {
                return this.getFirstChild().isQualifiedName();
            }
        }
        return false;
    }

    public boolean isUnscopedQualifiedName() {
        switch (this.getType()) {
            case 38: {
                return true;
            }
            case 33: {
                return this.getFirstChild().isUnscopedQualifiedName();
            }
        }
        return false;
    }

    public Node detachFromParent() {
        Preconditions.checkState((this.parent != null ? 1 : 0) != 0);
        this.parent.removeChild(this);
        return this;
    }

    public Node removeFirstChild() {
        Node node = this.first;
        if (node != null) {
            this.removeChild(node);
        }
        return node;
    }

    public Node removeChildren() {
        Node node = this.first;
        for (Node node2 = this.first; node2 != null; node2 = node2.getNext()) {
            node2.parent = null;
        }
        this.first = null;
        this.last = null;
        return node;
    }

    public void detachChildren() {
        Node node = this.first;
        while (node != null) {
            Node node2 = node.getNext();
            node.parent = null;
            node.next = null;
            node = node2;
        }
        this.first = null;
        this.last = null;
    }

    public Node removeChildAfter(Node node) {
        Preconditions.checkArgument((node.parent == this ? 1 : 0) != 0, (Object)"prev is not a child of this node.");
        Preconditions.checkArgument((node.next != null ? 1 : 0) != 0, (Object)"no next sibling.");
        Node node2 = node.next;
        node.next = node2.next;
        if (node2 == this.last) {
            this.last = node;
        }
        node2.next = null;
        node2.parent = null;
        return node2;
    }

    public Node cloneNode() {
        Node node;
        try {
            node = (Node)super.clone();
            node.next = null;
            node.first = null;
            node.last = null;
            node.parent = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.getMessage());
        }
        return node;
    }

    public Node cloneTree() {
        Node node = this.cloneNode();
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            Node node3 = node2.cloneTree();
            node3.parent = node;
            if (node.last != null) {
                node.last.next = node3;
            }
            if (node.first == null) {
                node.first = node3;
            }
            node.last = node3;
        }
        return node;
    }

    public Node copyInformationFrom(Node node) {
        if (this.getProp(39) == null) {
            this.putProp(39, node.getProp(39));
        }
        if (this.getProp(16) == null) {
            this.putProp(16, node.getProp(16));
            this.sourcePosition = node.sourcePosition;
        }
        return this;
    }

    public Node copyInformationFromForTree(Node node) {
        this.copyInformationFrom(node);
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            node2.copyInformationFromForTree(node);
        }
        return this;
    }

    public JSType getJSType() {
        return this.jsType;
    }

    public void setJSType(JSType jSType) {
        this.jsType = jSType;
    }

    public FileLevelJsDocBuilder getJsDocBuilderForNode() {
        return new FileLevelJsDocBuilder();
    }

    public JSDocInfo getJSDocInfo() {
        return (JSDocInfo)this.getProp(29);
    }

    public void setJSDocInfo(JSDocInfo jSDocInfo) {
        this.putProp(29, jSDocInfo);
    }

    public void setVarArgs(boolean bl) {
        this.putBooleanProp(29, bl);
    }

    public boolean isVarArgs() {
        return this.getBooleanProp(29);
    }

    public void setOptionalArg(boolean bl) {
        this.putBooleanProp(36, bl);
    }

    public boolean isOptionalArg() {
        return this.getBooleanProp(36);
    }

    public void setIsSyntheticBlock(boolean bl) {
        this.putBooleanProp(37, bl);
    }

    public boolean isSyntheticBlock() {
        return this.getBooleanProp(37);
    }

    public void setDirectives(Set<String> set) {
        this.putProp(47, set);
    }

    public Set<String> getDirectives() {
        return (Set)this.getProp(47);
    }

    public void addSuppression(String string) {
        if (this.getJSDocInfo() == null) {
            this.setJSDocInfo(new JSDocInfo(false));
        }
        this.getJSDocInfo().addSuppression(string);
    }

    public void setWasEmptyNode(boolean bl) {
        this.putBooleanProp(38, bl);
    }

    public boolean wasEmptyNode() {
        return this.getBooleanProp(38);
    }

    public void setSideEffectFlags(int n) {
        Preconditions.checkArgument((this.getType() == 37 || this.getType() == 30 ? 1 : 0) != 0, (Object)("setIsNoSideEffectsCall only supports CALL and NEW nodes, got " + Token.name(this.getType())));
        this.putIntProp(41, n);
    }

    public void setSideEffectFlags(SideEffectFlags sideEffectFlags) {
        this.setSideEffectFlags(sideEffectFlags.valueOf());
    }

    public int getSideEffectFlags() {
        return this.getIntProp(41);
    }

    public boolean isOnlyModifiesThisCall() {
        return this.areBitFlagsSet(this.getSideEffectFlags() & 0xF, 13);
    }

    public boolean isNoSideEffectsCall() {
        return this.areBitFlagsSet(this.getSideEffectFlags(), 15);
    }

    public boolean isLocalResultCall() {
        return this.areBitFlagsSet(this.getSideEffectFlags(), 16);
    }

    private boolean areBitFlagsSet(int n, int n2) {
        return (n & n2) == n2;
    }

    public boolean isQuotedString() {
        return false;
    }

    public void setQuotedString() {
        Kit.codeBug();
    }

    static class NodeMismatch {
        final Node nodeA;
        final Node nodeB;

        NodeMismatch(Node node, Node node2) {
            this.nodeA = node;
            this.nodeB = node2;
        }

        public boolean equals(Object object) {
            if (object instanceof NodeMismatch) {
                NodeMismatch nodeMismatch = (NodeMismatch)object;
                return nodeMismatch.nodeA.equals(this.nodeA) && nodeMismatch.nodeB.equals(this.nodeB);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.nodeA, this.nodeB});
        }
    }

    public static class SideEffectFlags {
        private int value = 0;

        public SideEffectFlags() {
        }

        public SideEffectFlags(int n) {
            this.value = n;
        }

        public int valueOf() {
            return this.value;
        }

        public void setAllFlags() {
            this.value = 0;
        }

        public void clearAllFlags() {
            this.value = 31;
        }

        public boolean areAllFlagsSet() {
            return this.value == 0;
        }

        public void clearSideEffectFlags() {
            this.value |= 0xF;
        }

        public void setMutatesGlobalState() {
            this.removeFlag(1);
            this.removeFlag(4);
            this.removeFlag(2);
        }

        public void setThrows() {
            this.removeFlag(8);
        }

        public void setMutatesThis() {
            this.removeFlag(2);
        }

        public void setMutatesArguments() {
            this.removeFlag(4);
        }

        public void setReturnsTainted() {
            this.removeFlag(16);
        }

        private void removeFlag(int n) {
            this.value &= ~n;
        }
    }

    public class FileLevelJsDocBuilder {
        public void append(String string) {
            String string2;
            JSDocInfo jSDocInfo = Node.this.getJSDocInfo();
            if (jSDocInfo == null) {
                jSDocInfo = new JSDocInfo(false);
            }
            if ((string2 = jSDocInfo.getLicense()) == null) {
                string2 = "";
            }
            jSDocInfo.setLicense(string2 + string);
            Node.this.setJSDocInfo(jSDocInfo);
        }
    }

    public static class AncestorIterable
    implements Iterable<Node> {
        private Node cur;

        AncestorIterable(Node node) {
            this.cur = node;
        }

        @Override
        public Iterator<Node> iterator() {
            return new Iterator<Node>(){

                @Override
                public boolean hasNext() {
                    return AncestorIterable.this.cur != null;
                }

                @Override
                public Node next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Node node = AncestorIterable.this.cur;
                    AncestorIterable.this.cur = AncestorIterable.this.cur.getParent();
                    return node;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static final class SiblingNodeIterable
    implements Iterable<Node>,
    Iterator<Node> {
        private final Node start;
        private Node current;
        private boolean used;

        SiblingNodeIterable(Node node) {
            this.start = node;
            this.current = node;
            this.used = false;
        }

        @Override
        public Iterator<Node> iterator() {
            if (!this.used) {
                this.used = true;
                return this;
            }
            return new SiblingNodeIterable(this.start).iterator();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            try {
                Node node = this.current;
                return node;
            }
            finally {
                this.current = this.current.getNext();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PropListItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final PropListItem next;
        final int type;
        final int intValue;
        final Object objectValue;

        PropListItem(int n, int n2, PropListItem propListItem) {
            this(n, n2, null, propListItem);
        }

        PropListItem(int n, Object object, PropListItem propListItem) {
            this(n, 0, object, propListItem);
        }

        PropListItem(int n, int n2, Object object, PropListItem propListItem) {
            this.type = n;
            this.intValue = n2;
            this.objectValue = object;
            this.next = propListItem;
        }
    }

    private static class StringNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private String str;

        StringNode(int n, String string) {
            super(n);
            if (null == string) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = string;
        }

        StringNode(int n, String string, int n2, int n3) {
            super(n, n2, n3);
            if (null == string) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = string;
        }

        @Override
        public String getString() {
            return this.str;
        }

        @Override
        public void setString(String string) {
            if (null == string) {
                throw new IllegalArgumentException("StringNode: str is null");
            }
            this.str = string;
        }

        @Override
        boolean isEquivalentTo(Node node, boolean bl, boolean bl2) {
            return super.isEquivalentTo(node, bl, bl2) && this.str.equals(((StringNode)node).str);
        }

        @Override
        public boolean isQuotedString() {
            return this.getBooleanProp(35);
        }

        @Override
        public void setQuotedString() {
            this.putBooleanProp(35, true);
        }
    }

    private static class NumberNode
    extends Node {
        private static final long serialVersionUID = 1L;
        private double number;

        NumberNode(double d) {
            super(39);
            this.number = d;
        }

        public NumberNode(double d, int n, int n2) {
            super(39, n, n2);
            this.number = d;
        }

        @Override
        public double getDouble() {
            return this.number;
        }

        @Override
        public void setDouble(double d) {
            this.number = d;
        }

        @Override
        boolean isEquivalentTo(Node node, boolean bl, boolean bl2) {
            return super.isEquivalentTo(node, bl, bl2) && this.getDouble() == ((NumberNode)node).getDouble();
        }
    }
}

