/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino;

import com.google.javascript.rhino.CompilerEnvirons;
import com.google.javascript.rhino.Context;
import com.google.javascript.rhino.Decompiler;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.EvaluatorException;
import com.google.javascript.rhino.FunctionNode;
import com.google.javascript.rhino.IRFactory;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JavaScriptException;
import com.google.javascript.rhino.Kit;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.ObjArray;
import com.google.javascript.rhino.RhinoException;
import com.google.javascript.rhino.ScriptOrFnNode;
import com.google.javascript.rhino.ScriptRuntime;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.TokenStream;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.List;

public class Parser {
    static final int CLEAR_TI_MASK = 65535;
    static final int TI_AFTER_EOL = 65536;
    static final int TI_CHECK_LABEL = 131072;
    CompilerEnvirons compilerEnv;
    private ErrorReporter errorReporter;
    private String sourceURI;
    boolean calledByCompileFunction;
    private TokenStream ts;
    private int currentFlaggedToken;
    private int syntaxErrorCount;
    private IRFactory nf;
    private int nestingOfFunction;
    private Decompiler decompiler;
    ScriptOrFnNode currentScriptOrFn;
    private int nestingOfWith;
    private Hashtable<String, Node> labelSet;
    private ObjArray loopSet;
    private ObjArray loopAndSwitchSet;
    private boolean hasReturnValue;
    private int functionEndFlags;

    public static ScriptOrFnNode parse(String string, String string2) {
        return Parser.parse(string, string2, false);
    }

    public static ScriptOrFnNode parseWithJSDoc(String string, String string2) {
        return Parser.parse(string, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScriptOrFnNode parse(String string, String string2, boolean bl) {
        Context context = Context.enter();
        SimpleErrorReporter simpleErrorReporter = new SimpleErrorReporter();
        context.setErrorReporter(simpleErrorReporter);
        CompilerEnvirons compilerEnvirons = new CompilerEnvirons();
        compilerEnvirons.initFromContext(context);
        if (bl) {
            compilerEnvirons.setParseJSDoc(true);
        }
        Parser parser = new Parser(compilerEnvirons, simpleErrorReporter);
        ScriptOrFnNode scriptOrFnNode = null;
        try {
            scriptOrFnNode = parser.parse(string, string2, 1);
        }
        catch (EvaluatorException evaluatorException) {
            simpleErrorReporter.error(evaluatorException.details(), evaluatorException.sourceName(), evaluatorException.lineNumber(), evaluatorException.lineSource(), evaluatorException.lineNumber());
        }
        finally {
            Context.exit();
        }
        List<String> list = simpleErrorReporter.errors();
        if (list != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string3 : list) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string3);
            }
            throw new RhinoException(stringBuilder.toString());
        }
        return scriptOrFnNode;
    }

    public Parser(CompilerEnvirons compilerEnvirons, ErrorReporter errorReporter) {
        this.compilerEnv = compilerEnvirons;
        this.errorReporter = errorReporter;
    }

    Decompiler createDecompiler(CompilerEnvirons compilerEnvirons) {
        return new Decompiler();
    }

    void addStrictWarning(String string, String string2) {
        if (this.compilerEnv.isStrictMode()) {
            this.addWarning(string, string2);
        }
    }

    void addWarning(String string) {
        this.reportWarning(ScriptRuntime.getMessage0(string), this.ts.getLineno(), this.ts.getOffset(), this.ts.getLine());
    }

    void addWarning(String string, String string2) {
        this.reportWarning(ScriptRuntime.getMessage1(string, string2), this.ts.getLineno(), this.ts.getOffset(), this.ts.getLine());
    }

    void addWarning(String string, int n, int n2) {
        this.reportWarning(ScriptRuntime.getMessage0(string), n, n2, null);
    }

    void addWarning(String string, String string2, int n, int n2) {
        this.reportWarning(ScriptRuntime.getMessage1(string, string2), n, n2, null);
    }

    private void reportWarning(String string, int n, int n2, String string2) {
        if (this.compilerEnv.reportWarningAsError()) {
            ++this.syntaxErrorCount;
            this.errorReporter.error(string, this.sourceURI, n, string2, n2);
        } else {
            this.errorReporter.warning(string, this.sourceURI, n, string2, n2);
        }
    }

    void addError(String string) {
        ++this.syntaxErrorCount;
        String string2 = ScriptRuntime.getMessage0(string);
        this.errorReporter.error(string2, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    void addError(String string, String string2) {
        ++this.syntaxErrorCount;
        String string3 = ScriptRuntime.getMessage1(string, string2);
        this.errorReporter.error(string3, this.sourceURI, this.ts.getLineno(), this.ts.getLine(), this.ts.getOffset());
    }

    RuntimeException reportError(String string) {
        this.addError(string);
        throw new ParserException();
    }

    private int peekToken() throws IOException {
        int n = this.currentFlaggedToken;
        if (n == 0) {
            n = this.ts.getToken();
            if (n == 1) {
                while ((n = this.ts.getToken()) == 1) {
                }
                n |= 0x10000;
            }
            this.currentFlaggedToken = n;
        }
        return n & 0xFFFF;
    }

    private int peekFlaggedToken() throws IOException {
        this.peekToken();
        return this.currentFlaggedToken;
    }

    private void consumeToken() {
        this.currentFlaggedToken = 0;
    }

    private int nextToken() throws IOException {
        int n = this.peekToken();
        this.consumeToken();
        return n;
    }

    private int nextFlaggedToken() throws IOException {
        this.peekToken();
        int n = this.currentFlaggedToken;
        this.consumeToken();
        return n;
    }

    private boolean matchToken(int n) throws IOException {
        int n2 = this.peekToken();
        if (n2 != n) {
            return false;
        }
        this.consumeToken();
        return true;
    }

    private int peekTokenOrEOL() throws IOException {
        int n = this.peekToken();
        if ((this.currentFlaggedToken & 0x10000) != 0) {
            n = 1;
        }
        return n;
    }

    private void setCheckForLabel() {
        if ((this.currentFlaggedToken & 0xFFFF) != 38) {
            throw Kit.codeBug();
        }
        this.currentFlaggedToken |= 0x20000;
    }

    private void mustMatchToken(int n, String string) throws IOException, ParserException {
        if (!this.matchToken(n)) {
            this.reportError(string);
        }
    }

    private void mustHaveXML() {
        if (!this.compilerEnv.isXmlAvailable()) {
            this.reportError("msg.XML.not.available");
        }
    }

    boolean insideFunction() {
        return this.nestingOfFunction != 0;
    }

    private Node enterSwitch(Node node, int n, int n2) {
        Node node2 = this.nf.createSwitch(n, n2);
        node2.addChildToBack(node);
        if (this.loopAndSwitchSet == null) {
            this.loopAndSwitchSet = new ObjArray();
        }
        this.loopAndSwitchSet.push(node2);
        return node2;
    }

    private void exitSwitch() {
        this.loopAndSwitchSet.pop();
    }

    public TokenStream initForUnitTest(Reader reader, String string, int n, boolean bl) {
        this.sourceURI = string;
        this.ts = new TokenStream(this, reader, null, n);
        return this.ts;
    }

    public ScriptOrFnNode parse(String string, String string2, int n) {
        this.sourceURI = string2;
        this.ts = new TokenStream(this, null, string, n);
        try {
            return this.parse();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public ScriptOrFnNode parse(Reader reader, String string, int n) throws IOException {
        this.sourceURI = string;
        this.ts = new TokenStream(this, reader, null, n);
        return this.parse();
    }

    private ScriptOrFnNode parse() throws IOException {
        int n;
        this.decompiler = this.createDecompiler(this.compilerEnv);
        this.nf = new IRFactory(this);
        this.currentScriptOrFn = this.nf.createScript();
        int n2 = this.decompiler.getCurrentOffset();
        this.decompiler.addToken(132);
        this.currentFlaggedToken = 0;
        this.syntaxErrorCount = 0;
        this.ts.setFileLevelJsDocBuilder(this.currentScriptOrFn.getJsDocBuilderForNode());
        int n3 = this.ts.getLineno();
        int n4 = this.ts.getCharno();
        Node node = this.nf.createLeaf(125, n3, n4);
        try {
            while ((n = this.peekToken()) > 0) {
                Node node2;
                block8: {
                    if (n == 105) {
                        this.consumeToken();
                        try {
                            node2 = this.function(this.calledByCompileFunction ? 2 : 1);
                            break block8;
                        }
                        catch (ParserException parserException) {
                            break;
                        }
                    }
                    node2 = this.statement();
                }
                this.nf.addChildToBack(node, node2);
            }
        }
        catch (StackOverflowError stackOverflowError) {
            String string = ScriptRuntime.getMessage0("msg.too.deep.parser.recursion");
            throw Context.reportRuntimeError(string, this.sourceURI, this.ts.getLineno(), null, 0);
        }
        if (this.syntaxErrorCount != 0) {
            String string = String.valueOf(this.syntaxErrorCount);
            string = ScriptRuntime.getMessage1("msg.got.syntax.errors", string);
            throw this.errorReporter.runtimeError(string, this.sourceURI, n3, null, 0);
        }
        this.currentScriptOrFn.setSourceName(this.sourceURI);
        this.currentScriptOrFn.setBaseLineno(n3);
        this.currentScriptOrFn.setEndLineno(this.ts.getLineno());
        if (this.currentScriptOrFn.getJSDocInfo() == null) {
            this.currentScriptOrFn.setJSDocInfo(this.ts.getFileOverviewJSDocInfo());
        }
        n = this.decompiler.getCurrentOffset();
        this.currentScriptOrFn.setEncodedSourceBounds(n2, n);
        this.nf.initScript(this.currentScriptOrFn, node);
        this.currentScriptOrFn.setIsSyntheticBlock(true);
        this.decompiler = null;
        return this.currentScriptOrFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node parseFunctionBody() throws IOException {
        Node node;
        block10: {
            ++this.nestingOfFunction;
            node = this.nf.createBlock(this.ts.getLineno(), this.ts.getCharno());
            try {
                while (true) {
                    Node node2;
                    int n = this.peekToken();
                    switch (n) {
                        case -1: 
                        case 0: 
                        case 82: {
                            break block10;
                        }
                        case 105: {
                            this.consumeToken();
                            node2 = this.function(1);
                            break;
                        }
                        default: {
                            node2 = this.statement();
                        }
                    }
                    this.nf.addChildToBack(node, node2);
                }
            }
            catch (ParserException parserException) {
            }
            finally {
                --this.nestingOfFunction;
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node function(int n) throws IOException, ParserException {
        int n2;
        Node node;
        Node node2;
        int n3;
        int n4;
        String string;
        int n5 = n;
        int n6 = this.ts.getLineno();
        int n7 = this.ts.getCharno();
        int n8 = this.decompiler.markFunctionStart(n);
        Node node3 = null;
        if (this.matchToken(38)) {
            string = this.ts.getString();
            n4 = this.ts.getLineno();
            n3 = this.ts.getCharno();
            this.decompiler.addName(string);
            if (!this.matchToken(83)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    Node node4 = this.nf.createName(string, n4, n3);
                    string = "";
                    node3 = this.memberExprTail(false, node4);
                }
                this.mustMatchToken(83, "msg.no.paren.parms");
            }
        } else {
            string = "";
            n4 = this.ts.getLineno();
            n3 = this.ts.getCharno();
            if (!this.matchToken(83)) {
                if (this.compilerEnv.isAllowMemberExprAsFunctionName()) {
                    node3 = this.memberExpr(false);
                }
                this.mustMatchToken(83, "msg.no.paren.parms");
            }
        }
        if (node3 != null) {
            n5 = 2;
        }
        boolean bl = this.insideFunction();
        FunctionNode functionNode = this.nf.createFunction(string, n4, n3);
        if (bl || this.nestingOfWith > 0) {
            functionNode.itsIgnoreDynamicScope = true;
        }
        int n9 = this.currentScriptOrFn.addFunction(functionNode);
        ScriptOrFnNode scriptOrFnNode = this.currentScriptOrFn;
        this.currentScriptOrFn = functionNode;
        int n10 = this.nestingOfWith;
        this.nestingOfWith = 0;
        Hashtable<String, Node> hashtable = this.labelSet;
        this.labelSet = null;
        ObjArray objArray = this.loopSet;
        this.loopSet = null;
        ObjArray objArray2 = this.loopAndSwitchSet;
        this.loopAndSwitchSet = null;
        boolean bl2 = this.hasReturnValue;
        int n11 = this.functionEndFlags;
        JSDocInfo jSDocInfo = this.ts.getAndResetJSDocInfo();
        try {
            int n12;
            this.decompiler.addToken(83);
            node2 = this.nf.createLeaf(83, this.ts.getLineno(), this.ts.getCharno());
            if (!this.matchToken(84)) {
                n12 = 1;
                do {
                    if (n12 == 0) {
                        this.decompiler.addToken(85);
                    }
                    n12 = 0;
                    this.mustMatchToken(38, "msg.no.parm");
                    String string2 = this.ts.getString();
                    this.nf.addChildToBack(node2, this.nf.createName(string2, this.ts.getLineno(), this.ts.getCharno()));
                    this.decompiler.addName(string2);
                } while (this.matchToken(85));
                this.mustMatchToken(84, "msg.no.paren.after.parms");
            }
            this.decompiler.addToken(84);
            this.mustMatchToken(81, "msg.no.brace.body");
            this.decompiler.addEOL(81);
            node = this.parseFunctionBody();
            this.mustMatchToken(82, "msg.no.brace.after.body");
            this.decompiler.addToken(82);
            n2 = this.decompiler.markFunctionEnd(n8);
            if (n != 2) {
                if (this.compilerEnv.getLanguageVersion() >= 120 && (n12 = this.peekTokenOrEOL()) == 105) {
                    this.reportError("msg.no.semi.stmt");
                }
                this.decompiler.addToken(1);
            }
        }
        finally {
            this.hasReturnValue = bl2;
            this.functionEndFlags = n11;
            this.loopAndSwitchSet = objArray2;
            this.loopSet = objArray;
            this.labelSet = hashtable;
            this.nestingOfWith = n10;
            this.currentScriptOrFn = scriptOrFnNode;
        }
        functionNode.setEncodedSourceBounds(n8, n2);
        functionNode.setSourceName(this.sourceURI);
        functionNode.setBaseLineno(n6);
        functionNode.setEndLineno(this.ts.getLineno());
        Node node5 = this.nf.initFunction(functionNode, n9, node2, jSDocInfo, node, n5);
        if (node3 != null) {
            node5 = this.nf.createAssignment(86, node3, node5, n6, n7);
            if (n != 2) {
                node5 = this.nf.createExprStatementNoReturn(node5, n6, n7);
            }
        }
        return node5;
    }

    private Node statements() throws IOException {
        int n;
        Node node = this.nf.createBlock(this.ts.getLineno(), this.ts.getCharno());
        while ((n = this.peekToken()) > 0 && n != 82) {
            this.nf.addChildToBack(node, this.statement());
        }
        return node;
    }

    private Node condition() throws IOException, ParserException {
        this.mustMatchToken(83, "msg.no.paren.cond");
        this.decompiler.addToken(83);
        Node node = this.expr(false);
        this.mustMatchToken(84, "msg.no.paren.after.cond");
        this.decompiler.addToken(84);
        if (node.getProp(34) == null && (node.getType() == 8 || node.getType() == 34 || node.getType() == 36)) {
            this.addStrictWarning("msg.equal.as.assign", "");
        }
        return node;
    }

    private String matchLabel() throws IOException, JavaScriptException {
        int n = this.ts.getLineno();
        String string = null;
        int n2 = this.peekTokenOrEOL();
        if (n2 == 38) {
            this.consumeToken();
            string = this.ts.getString();
            this.decompiler.addName(string);
            Node node = null;
            if (this.labelSet != null) {
                node = this.labelSet.get(string);
            }
            if (node == null) {
                this.reportError("msg.undef.label");
            }
        }
        return string;
    }

    private Node statement() throws IOException {
        try {
            Node node = this.statementHelper(null);
            if (node != null) {
                if (this.compilerEnv.isStrictMode() && !node.hasSideEffects()) {
                    this.addStrictWarning("msg.no.side.effects", "");
                }
                return node;
            }
        }
        catch (ParserException parserException) {
            // empty catch block
        }
        int n = this.ts.getLineno();
        int n2 = this.ts.getCharno();
        block5: while (true) {
            int n3 = this.peekTokenOrEOL();
            this.consumeToken();
            switch (n3) {
                case -1: 
                case 0: 
                case 1: 
                case 78: {
                    break block5;
                }
                default: {
                    continue block5;
                }
            }
            break;
        }
        return this.nf.createExprStatement(this.nf.createErrorName(), n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node statementHelper(Node node) throws IOException, ParserException {
        int n;
        Node node2 = null;
        int n2 = this.peekToken();
        switch (n2) {
            case 108: {
                this.consumeToken();
                this.decompiler.addToken(108);
                int n3 = this.ts.getLineno();
                int n4 = this.ts.getCharno();
                Node node3 = this.condition();
                this.decompiler.addEOL(81);
                Node node4 = this.statement();
                Node node5 = null;
                if (this.matchToken(109)) {
                    this.decompiler.addToken(82);
                    this.decompiler.addToken(109);
                    this.decompiler.addEOL(81);
                    node5 = this.statement();
                }
                this.decompiler.addEOL(82);
                node2 = this.nf.createIf(node3, node4, node5, n3, n4);
                return node2;
            }
            case 110: {
                this.consumeToken();
                this.decompiler.addToken(110);
                int n5 = this.ts.getLineno();
                int n6 = this.ts.getCharno();
                this.mustMatchToken(83, "msg.no.paren.switch");
                this.decompiler.addToken(83);
                node2 = this.enterSwitch(this.expr(false), n5, n6);
                try {
                    this.mustMatchToken(84, "msg.no.paren.after.switch");
                    this.decompiler.addToken(84);
                    this.mustMatchToken(81, "msg.no.brace.switch");
                    this.decompiler.addEOL(81);
                    boolean bl = false;
                    block41: while (true) {
                        Node node6;
                        n2 = this.nextToken();
                        n5 = this.ts.getLineno();
                        n6 = this.ts.getCharno();
                        switch (n2) {
                            case 82: {
                                break block41;
                            }
                            case 111: {
                                this.decompiler.addToken(111);
                                node6 = this.expr(false);
                                this.mustMatchToken(99, "msg.no.colon.case");
                                this.decompiler.addEOL(99);
                                break;
                            }
                            case 112: {
                                if (bl) {
                                    this.reportError("msg.double.switch.default");
                                }
                                this.decompiler.addToken(112);
                                bl = true;
                                node6 = null;
                                this.mustMatchToken(99, "msg.no.colon.case");
                                this.decompiler.addEOL(99);
                                break;
                            }
                            default: {
                                this.reportError("msg.bad.switch");
                                break block41;
                            }
                        }
                        Node node7 = this.nf.createLeaf(125, n5, n6);
                        node7.setIsSyntheticBlock(true);
                        while ((n2 = this.peekToken()) != 82 && n2 != 111 && n2 != 112 && n2 != 0) {
                            this.nf.addChildToBack(node7, this.statement());
                        }
                        this.nf.addSwitchCase(node2, node6, node7, n5, n6);
                    }
                    this.decompiler.addEOL(82);
                    this.nf.closeSwitch(node2);
                }
                finally {
                    this.exitSwitch();
                }
                return node2;
            }
            case 113: {
                this.consumeToken();
                this.decompiler.addToken(113);
                int n7 = this.ts.getLineno();
                int n8 = this.ts.getCharno();
                Node node8 = this.condition();
                this.decompiler.addEOL(81);
                Node node9 = this.statement();
                this.decompiler.addEOL(82);
                node2 = this.nf.createWhile(node8, node9, n7, n8);
                return node2;
            }
            case 114: {
                this.consumeToken();
                this.decompiler.addToken(114);
                this.decompiler.addEOL(81);
                int n9 = this.ts.getLineno();
                int n10 = this.ts.getCharno();
                Node node10 = this.statement();
                this.decompiler.addToken(82);
                this.mustMatchToken(113, "msg.no.while.do");
                this.decompiler.addToken(113);
                Node node11 = this.condition();
                node2 = this.nf.createDoWhile(node10, node11, n9, n10);
                this.matchToken(78);
                this.decompiler.addEOL(78);
                return node2;
            }
            case 115: {
                Node node12;
                Node node13;
                this.consumeToken();
                boolean bl = false;
                this.decompiler.addToken(115);
                int n11 = this.ts.getLineno();
                int n12 = this.ts.getCharno();
                Node node14 = null;
                if (this.matchToken(38)) {
                    this.decompiler.addName(this.ts.getString());
                    if (this.ts.getString().equals("each")) {
                        bl = true;
                    } else {
                        this.reportError("msg.no.paren.for");
                    }
                }
                this.mustMatchToken(83, "msg.no.paren.for");
                this.decompiler.addToken(83);
                n2 = this.peekToken();
                if (n2 == 78) {
                    node13 = this.nf.createLeaf(124, this.ts.getLineno(), this.ts.getCharno());
                } else if (n2 == 118) {
                    this.consumeToken();
                    node13 = this.variables(115);
                } else {
                    node13 = this.expr(true);
                }
                if (this.matchToken(51)) {
                    this.decompiler.addToken(51);
                    node12 = this.expr(false);
                } else {
                    this.mustMatchToken(78, "msg.no.semi.for");
                    this.decompiler.addToken(78);
                    node12 = this.peekToken() == 78 ? this.nf.createLeaf(124, this.ts.getLineno(), this.ts.getCharno()) : this.expr(false);
                    this.mustMatchToken(78, "msg.no.semi.for.cond");
                    this.decompiler.addToken(78);
                    node14 = this.peekToken() == 84 ? this.nf.createLeaf(124, this.ts.getLineno(), this.ts.getCharno()) : this.expr(false);
                }
                this.mustMatchToken(84, "msg.no.paren.for.ctrl");
                this.decompiler.addToken(84);
                this.decompiler.addEOL(81);
                Node node15 = this.statement();
                this.decompiler.addEOL(82);
                node2 = node14 == null ? this.nf.createForIn(node13, node12, node15, n11, n12) : this.nf.createFor(node13, node12, node14, node15, n11, n12);
                return node2;
            }
            case 77: {
                this.consumeToken();
                int n13 = this.ts.getLineno();
                int n14 = this.ts.getCharno();
                Node node16 = null;
                Node node17 = null;
                JSDocInfo jSDocInfo = this.ts.getAndResetJSDocInfo();
                this.decompiler.addToken(77);
                this.decompiler.addEOL(81);
                Node node18 = this.statement();
                this.decompiler.addEOL(82);
                node16 = this.nf.createLeaf(125, this.ts.getLineno(), this.ts.getCharno());
                boolean bl = false;
                int n15 = this.peekToken();
                if (n15 == 120) {
                    while (this.matchToken(120)) {
                        int n16 = this.ts.getLineno();
                        int n17 = this.ts.getCharno();
                        if (bl) {
                            this.reportError("msg.catch.unreachable");
                        }
                        this.decompiler.addToken(120);
                        this.mustMatchToken(83, "msg.no.paren.catch");
                        this.decompiler.addToken(83);
                        this.mustMatchToken(38, "msg.bad.catchcond");
                        String string = this.ts.getString();
                        int n18 = this.ts.getLineno();
                        int n19 = this.ts.getCharno();
                        this.decompiler.addName(string);
                        Node node19 = null;
                        if (this.matchToken(108)) {
                            this.decompiler.addToken(108);
                            node19 = this.expr(false);
                        } else {
                            bl = true;
                        }
                        this.mustMatchToken(84, "msg.bad.catchcond");
                        this.decompiler.addToken(84);
                        this.mustMatchToken(81, "msg.no.brace.catchblock");
                        this.decompiler.addEOL(81);
                        this.nf.addChildToBack(node16, this.nf.createCatch(string, n18, n19, node19, this.statements(), n16, n17));
                        this.mustMatchToken(82, "msg.no.brace.after.body");
                        this.decompiler.addEOL(82);
                    }
                } else if (n15 != 121) {
                    this.mustMatchToken(121, "msg.try.no.catchfinally");
                }
                if (this.matchToken(121)) {
                    this.decompiler.addToken(121);
                    this.decompiler.addEOL(81);
                    node17 = this.statement();
                    this.decompiler.addEOL(82);
                }
                node2 = this.nf.createTryCatchFinally(node18, node16, node17, n13, n14);
                if (jSDocInfo != null) {
                    node2.setJSDocInfo(jSDocInfo);
                }
                return node2;
            }
            case 49: {
                this.consumeToken();
                if (this.peekTokenOrEOL() == 1) {
                    this.reportError("msg.bad.throw.eol");
                }
                n = this.ts.getLineno();
                int n20 = this.ts.getCharno();
                this.decompiler.addToken(49);
                node2 = this.nf.createThrow(this.expr(false), n, n20);
                break;
            }
            case 116: {
                this.consumeToken();
                n = this.ts.getLineno();
                int n21 = this.ts.getCharno();
                this.decompiler.addToken(116);
                String string = this.matchLabel();
                if (string != null) {
                    this.decompiler.addToken(38);
                    this.decompiler.addName(string);
                }
                node2 = this.nf.createBreak(string, n, n21);
                break;
            }
            case 117: {
                this.consumeToken();
                n = this.ts.getLineno();
                int n22 = this.ts.getCharno();
                this.decompiler.addToken(117);
                String string = this.matchLabel();
                if (string != null) {
                    this.decompiler.addToken(38);
                    this.decompiler.addName(string);
                }
                node2 = this.nf.createContinue(string, n, n22);
                break;
            }
            case 152: {
                this.consumeToken();
                n = this.ts.getLineno();
                int n23 = this.ts.getCharno();
                this.decompiler.addToken(152);
                node2 = this.nf.createDebugger(n, n23);
                break;
            }
            case 119: {
                Node node20;
                this.consumeToken();
                this.decompiler.addToken(119);
                int n24 = this.ts.getLineno();
                int n25 = this.ts.getCharno();
                this.mustMatchToken(83, "msg.no.paren.with");
                this.decompiler.addToken(83);
                Node node21 = this.expr(false);
                this.mustMatchToken(84, "msg.no.paren.after.with");
                this.decompiler.addToken(84);
                this.decompiler.addEOL(81);
                ++this.nestingOfWith;
                try {
                    node20 = this.statement();
                }
                finally {
                    --this.nestingOfWith;
                }
                this.decompiler.addEOL(82);
                node2 = this.nf.createWith(node21, node20, n24, n25);
                return node2;
            }
            case 118: 
            case 149: {
                this.consumeToken();
                node2 = this.variables(n2);
                break;
            }
            case 4: {
                Node node22;
                if (!this.insideFunction()) {
                    this.reportError("msg.bad.return");
                }
                this.consumeToken();
                this.decompiler.addToken(4);
                n = this.ts.getLineno();
                int n26 = this.ts.getCharno();
                n2 = this.peekTokenOrEOL();
                switch (n2) {
                    case -1: 
                    case 0: 
                    case 1: 
                    case 78: 
                    case 82: {
                        node22 = null;
                        break;
                    }
                    default: {
                        node22 = this.expr(false);
                        this.hasReturnValue = true;
                    }
                }
                node2 = this.nf.createReturn(node22, n, n26);
                break;
            }
            case 81: {
                this.consumeToken();
                if (node != null) {
                    this.decompiler.addToken(81);
                }
                node2 = this.statements();
                this.mustMatchToken(82, "msg.no.brace.block");
                if (node != null) {
                    this.decompiler.addEOL(82);
                }
                return node2;
            }
            case -1: 
            case 78: {
                this.consumeToken();
                node2 = this.nf.createLeaf(124, this.ts.getLineno(), this.ts.getCharno());
                return node2;
            }
            case 105: {
                this.consumeToken();
                node2 = this.function(3);
                return node2;
            }
            case 112: {
                this.consumeToken();
                this.mustHaveXML();
                this.decompiler.addToken(112);
                n = this.ts.getLineno();
                int n27 = this.ts.getCharno();
                if (!this.matchToken(38) || !this.ts.getString().equals("xml")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" xml");
                if (!this.matchToken(38) || !this.ts.getString().equals("namespace")) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addName(" namespace");
                if (!this.matchToken(86)) {
                    this.reportError("msg.bad.namespace");
                }
                this.decompiler.addToken(86);
                Node node23 = this.expr(false);
                node2 = this.nf.createDefaultNamespace(node23, n, n27);
                break;
            }
            case 38: {
                n = this.ts.getLineno();
                int n28 = this.ts.getCharno();
                String string = this.ts.getString();
                this.setCheckForLabel();
                node2 = this.expr(false);
                if (node2.getType() != 126) {
                    node2 = this.nf.createExprStatement(node2, n, n28);
                    break;
                }
                if (this.peekToken() != 99) {
                    Kit.codeBug();
                }
                this.consumeToken();
                this.decompiler.addName(string);
                this.decompiler.addEOL(99);
                if (this.labelSet == null) {
                    this.labelSet = new Hashtable();
                } else if (this.labelSet.containsKey(string)) {
                    this.reportError("msg.dup.label");
                }
                this.labelSet.put(string, node2);
                node2 = this.nf.createLabel(string, n, n28);
                try {
                    this.nf.addChildToBack(node2, this.statementHelper(node2));
                }
                finally {
                    this.labelSet.remove(string);
                }
                return node2;
            }
            default: {
                n = this.ts.getLineno();
                int n29 = this.ts.getCharno();
                node2 = this.expr(false);
                node2 = this.nf.createExprStatement(node2, n, n29);
                break;
            }
        }
        n = this.peekFlaggedToken();
        switch (n & 0xFFFF) {
            case 78: {
                this.consumeToken();
                break;
            }
            case -1: 
            case 0: 
            case 82: {
                break;
            }
            default: {
                if ((n & 0x10000) != 0) break;
                this.reportError("msg.no.semi.stmt");
            }
        }
        this.decompiler.addEOL(78);
        return node2;
    }

    private Node variables(int n) throws IOException, ParserException {
        Node node;
        boolean bl = true;
        JSDocInfo jSDocInfo = null;
        if (n == 149) {
            node = this.nf.createVariables(149, this.ts.getLineno(), this.ts.getCharno());
            this.decompiler.addToken(149);
        } else {
            node = this.nf.createVariables(118, this.ts.getLineno(), this.ts.getCharno());
            jSDocInfo = this.ts.getAndResetJSDocInfo();
            if (jSDocInfo != null) {
                node.setJSDocInfo(jSDocInfo);
            }
            this.decompiler.addToken(118);
        }
        do {
            this.mustMatchToken(38, "msg.bad.var");
            String string = this.ts.getString();
            int n2 = this.ts.getLineno();
            int n3 = this.ts.getCharno();
            JSDocInfo jSDocInfo2 = this.ts.getAndResetJSDocInfo();
            if (!bl) {
                this.decompiler.addToken(85);
            }
            bl = false;
            this.decompiler.addName(string);
            if (n == 149) {
                if (!this.currentScriptOrFn.addConst(string)) {
                    if (this.currentScriptOrFn.addVar(string) != -2) {
                        this.addError("msg.var.redecl", string);
                    } else {
                        this.addError("msg.const.redecl", string);
                    }
                }
            } else {
                int n4 = this.currentScriptOrFn.addVar(string);
                if (n4 == -2) {
                    this.addError("msg.const.redecl", string);
                } else if (n4 == -1) {
                    this.addStrictWarning("msg.var.hides.arg", string);
                } else if (n4 == 0) {
                    this.addStrictWarning("msg.var.redecl", string);
                }
            }
            Node node2 = this.nf.createTaggedName(string, jSDocInfo2, n2, n3);
            if (this.matchToken(86)) {
                this.decompiler.addToken(86);
                Node node3 = this.assignExpr(n == 115);
                this.nf.addChildToBack(node2, node3);
            }
            this.nf.addChildToBack(node, node2);
        } while (this.matchToken(85));
        return node;
    }

    private Node expr(boolean bl) throws IOException, ParserException {
        Node node = this.assignExpr(bl);
        int n = this.ts.getLineno();
        int n2 = this.ts.getCharno();
        while (this.matchToken(85)) {
            this.decompiler.addToken(85);
            if (this.compilerEnv.isStrictMode() && !node.hasSideEffects()) {
                this.addStrictWarning("msg.no.side.effects", "");
            }
            node = this.nf.createBinary(85, node, this.assignExpr(bl), n, n2);
        }
        return node;
    }

    private Node assignExpr(boolean bl) throws IOException, ParserException {
        Node node = this.condExpr(bl);
        int n = this.peekToken();
        int n2 = this.ts.getLineno();
        int n3 = this.ts.getCharno();
        if (86 <= n && n <= 97) {
            this.consumeToken();
            JSDocInfo jSDocInfo = this.ts.getAndResetJSDocInfo();
            this.decompiler.addToken(n);
            Node node2 = this.assignExpr(bl);
            node = this.nf.createBinary(n, node, node2, n2, n3);
            if (jSDocInfo != null) {
                node.setJSDocInfo(jSDocInfo);
            }
        } else if (n == 78 && node.getType() == 33 && this.ts.isPopulated()) {
            node.setJSDocInfo(this.ts.getAndResetJSDocInfo());
        }
        return node;
    }

    private Node condExpr(boolean bl) throws IOException, ParserException {
        Node node = this.orExpr(bl);
        if (this.matchToken(98)) {
            int n = this.ts.getLineno();
            int n2 = this.ts.getCharno();
            this.decompiler.addToken(98);
            Node node2 = this.assignExpr(false);
            this.mustMatchToken(99, "msg.no.colon.cond");
            this.decompiler.addToken(99);
            Node node3 = this.assignExpr(bl);
            return this.nf.createCondExpr(node, node2, node3, n, n2);
        }
        return node;
    }

    private Node orExpr(boolean bl) throws IOException, ParserException {
        Node node = this.andExpr(bl);
        if (this.matchToken(100)) {
            int n = this.ts.getLineno();
            int n2 = this.ts.getCharno();
            this.decompiler.addToken(100);
            node = this.nf.createBinary(100, node, this.orExpr(bl), n, n2);
        }
        return node;
    }

    private Node andExpr(boolean bl) throws IOException, ParserException {
        Node node = this.bitOrExpr(bl);
        if (this.matchToken(101)) {
            int n = this.ts.getLineno();
            int n2 = this.ts.getCharno();
            this.decompiler.addToken(101);
            node = this.nf.createBinary(101, node, this.andExpr(bl), n, n2);
        }
        return node;
    }

    private Node bitOrExpr(boolean bl) throws IOException, ParserException {
        Node node = this.bitXorExpr(bl);
        while (this.matchToken(9)) {
            int n = this.ts.getLineno();
            int n2 = this.ts.getCharno();
            this.decompiler.addToken(9);
            node = this.nf.createBinary(9, node, this.bitXorExpr(bl), n, n2);
        }
        return node;
    }

    private Node bitXorExpr(boolean bl) throws IOException, ParserException {
        Node node = this.bitAndExpr(bl);
        while (this.matchToken(10)) {
            int n = this.ts.getLineno();
            int n2 = this.ts.getCharno();
            this.decompiler.addToken(10);
            node = this.nf.createBinary(10, node, this.bitAndExpr(bl), n, n2);
        }
        return node;
    }

    private Node bitAndExpr(boolean bl) throws IOException, JavaScriptException {
        Node node = this.eqExpr(bl);
        while (this.matchToken(11)) {
            int n = this.ts.getLineno();
            int n2 = this.ts.getCharno();
            this.decompiler.addToken(11);
            node = this.nf.createBinary(11, node, this.eqExpr(bl), n, n2);
        }
        return node;
    }

    private Node eqExpr(boolean bl) throws IOException, ParserException {
        Node node = this.relExpr(bl);
        block9: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.getLineno();
            int n3 = this.ts.getCharno();
            switch (n) {
                case 12: 
                case 13: 
                case 45: 
                case 46: {
                    this.consumeToken();
                    int n4 = n;
                    int n5 = n;
                    if (this.compilerEnv.getLanguageVersion() == 120) {
                        switch (n) {
                            case 12: {
                                n5 = 45;
                                break;
                            }
                            case 13: {
                                n5 = 46;
                                break;
                            }
                            case 45: {
                                n4 = 12;
                                break;
                            }
                            case 46: {
                                n4 = 13;
                            }
                        }
                    }
                    this.decompiler.addToken(n4);
                    node = this.nf.createBinary(n5, node, this.relExpr(bl), n2, n3);
                    continue block9;
                }
            }
            break;
        }
        return node;
    }

    private Node relExpr(boolean bl) throws IOException, ParserException {
        Node node = this.shiftExpr();
        block4: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.getLineno();
            int n3 = this.ts.getCharno();
            switch (n) {
                case 51: {
                    if (bl) break block4;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 52: {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    node = this.nf.createBinary(n, node, this.shiftExpr(), n2, n3);
                    continue block4;
                }
            }
            break;
        }
        return node;
    }

    private Node shiftExpr() throws IOException, ParserException {
        Node node = this.addExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.getLineno();
            int n3 = this.ts.getCharno();
            switch (n) {
                case 18: 
                case 19: 
                case 20: {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    node = this.nf.createBinary(n, node, this.addExpr(), n2, n3);
                    continue block3;
                }
            }
            break;
        }
        return node;
    }

    private Node addExpr() throws IOException, ParserException {
        Node node = this.mulExpr();
        while (true) {
            int n = this.peekToken();
            int n2 = this.ts.getLineno();
            int n3 = this.ts.getCharno();
            if (n != 21 && n != 22) break;
            this.consumeToken();
            this.decompiler.addToken(n);
            node = this.nf.createBinary(n, node, this.mulExpr(), n2, n3);
        }
        return node;
    }

    private Node mulExpr() throws IOException, ParserException {
        Node node = this.unaryExpr();
        block3: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.getLineno();
            int n3 = this.ts.getCharno();
            switch (n) {
                case 23: 
                case 24: 
                case 25: {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    node = this.nf.createBinary(n, node, this.unaryExpr(), n2, n3);
                    continue block3;
                }
            }
            break;
        }
        return node;
    }

    private Node unaryExpr() throws IOException, ParserException {
        int n = this.peekToken();
        int n2 = this.ts.getLineno();
        int n3 = this.ts.getCharno();
        switch (n) {
            case 26: 
            case 27: 
            case 32: 
            case 122: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.nf.createUnary(n, this.unaryExpr(), n2, n3);
            }
            case 21: {
                this.consumeToken();
                this.decompiler.addToken(28);
                return this.nf.createUnary(28, this.unaryExpr(), n2, n3);
            }
            case 22: {
                this.consumeToken();
                this.decompiler.addToken(29);
                return this.nf.createUnary(29, this.unaryExpr(), n2, n3);
            }
            case 102: 
            case 103: {
                this.consumeToken();
                this.decompiler.addToken(n);
                return this.nf.createIncDec(n, false, this.memberExpr(true), n2, n3);
            }
            case 31: {
                this.consumeToken();
                this.decompiler.addToken(31);
                return this.nf.createUnary(31, this.unaryExpr(), n2, n3);
            }
            case -1: {
                this.consumeToken();
                break;
            }
            case 14: {
                if (this.compilerEnv.isXmlAvailable()) {
                    this.consumeToken();
                    Node node = this.xmlInitializer();
                    return this.memberExprTail(true, node);
                }
            }
            default: {
                Node node = this.memberExpr(true);
                n = this.peekTokenOrEOL();
                if (n == 102 || n == 103) {
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    return this.nf.createIncDec(n, true, node, n2, n3);
                }
                return node;
            }
        }
        return this.nf.createErrorName();
    }

    private Node xmlInitializer() throws IOException {
        int n = this.ts.getFirstXMLToken();
        int n2 = this.ts.getLineno();
        int n3 = this.ts.getCharno();
        if (n != 141 && n != 144) {
            this.reportError("msg.syntax");
            return null;
        }
        Node node = this.nf.createLeaf(30, n2, n3);
        String string = this.ts.getString();
        n2 = this.ts.getLineno();
        n3 = this.ts.getCharno();
        boolean bl = string.trim().startsWith("<>");
        Node node2 = this.nf.createName(bl ? "XMLList" : "XML", n2, n3);
        this.nf.addChildToBack(node, node2);
        node2 = null;
        while (true) {
            switch (n) {
                case 141: {
                    string = this.ts.getString();
                    n2 = this.ts.getLineno();
                    n3 = this.ts.getCharno();
                    this.decompiler.addName(string);
                    this.mustMatchToken(81, "msg.syntax");
                    this.decompiler.addToken(81);
                    Node node3 = this.peekToken() == 82 ? this.nf.createString("", n2, n3) : this.expr(false);
                    this.mustMatchToken(82, "msg.syntax");
                    this.decompiler.addToken(82);
                    node2 = node2 == null ? this.nf.createString(string, n2, n3) : this.nf.createBinary(21, node2, this.nf.createString(string, n2, n3), n2, n3);
                    int n4 = this.ts.isXMLAttribute() ? 71 : 72;
                    node3 = this.nf.createUnary(n4, node3, n2, n3);
                    node2 = this.nf.createBinary(21, node2, node3, n2, n3);
                    break;
                }
                case 144: {
                    string = this.ts.getString();
                    n2 = this.ts.getLineno();
                    n3 = this.ts.getCharno();
                    this.decompiler.addName(string);
                    node2 = node2 == null ? this.nf.createString(string, n2, n3) : this.nf.createBinary(21, node2, this.nf.createString(string, n2, n3), n2, n3);
                    this.nf.addChildToBack(node, node2);
                    return node;
                }
                default: {
                    this.reportError("msg.syntax");
                    return null;
                }
            }
            n = this.ts.getNextXMLToken();
        }
    }

    private void argumentList(Node node) throws IOException, ParserException {
        boolean bl = this.matchToken(84);
        if (!bl) {
            boolean bl2 = true;
            do {
                if (!bl2) {
                    this.decompiler.addToken(85);
                }
                bl2 = false;
                this.nf.addChildToBack(node, this.assignExpr(false));
            } while (this.matchToken(85));
            this.mustMatchToken(84, "msg.no.paren.arg");
        }
        this.decompiler.addToken(84);
    }

    private Node memberExpr(boolean bl) throws IOException, ParserException {
        Node node;
        int n = this.peekToken();
        int n2 = this.ts.getLineno();
        int n3 = this.ts.getCharno();
        if (n == 30) {
            this.consumeToken();
            this.decompiler.addToken(30);
            node = this.nf.createLeaf(30, n2, n3);
            this.nf.addChildToBack(node, this.memberExpr(false));
            if (this.matchToken(83)) {
                this.decompiler.addToken(83);
                this.argumentList(node);
            }
            if ((n = this.peekToken()) == 81) {
                this.nf.addChildToBack(node, this.primaryExpr());
            }
        } else {
            node = this.primaryExpr();
        }
        return this.memberExprTail(bl, node);
    }

    private Node memberExprTail(boolean bl, Node node) throws IOException, ParserException {
        block11: while (true) {
            int n = this.peekToken();
            int n2 = this.ts.getLineno();
            int n3 = this.ts.getCharno();
            block0 : switch (n) {
                case 104: 
                case 139: {
                    String string;
                    this.consumeToken();
                    this.decompiler.addToken(n);
                    int n4 = 0;
                    if (n == 139) {
                        this.mustHaveXML();
                        n4 = 4;
                    }
                    if (!this.compilerEnv.isXmlAvailable()) {
                        this.mustMatchToken(38, "msg.no.name.after.dot");
                        string = this.ts.getString();
                        this.decompiler.addName(string);
                        node = this.nf.createPropertyGet(node, null, string, n4, n2, n3, this.ts.getLineno(), this.ts.getCharno());
                        break;
                    }
                    n = this.nextToken();
                    switch (n) {
                        case 38: {
                            string = this.ts.getString();
                            this.decompiler.addName(string);
                            node = this.propertyName(node, string, n4, n2, n3, this.ts.getLineno(), this.ts.getCharno());
                            break block0;
                        }
                        case 23: {
                            this.decompiler.addName("*");
                            node = this.propertyName(node, "*", n4, this.ts.getLineno(), this.ts.getCharno());
                            break block0;
                        }
                        case 143: {
                            this.decompiler.addToken(143);
                            node = this.attributeAccess(node, n4);
                            break block0;
                        }
                    }
                    this.reportError("msg.no.name.after.dot");
                    break;
                }
                case 142: {
                    this.consumeToken();
                    this.mustHaveXML();
                    this.decompiler.addToken(142);
                    node = this.nf.createDotQuery(node, this.expr(false), this.ts.getLineno(), this.ts.getCharno());
                    this.mustMatchToken(84, "msg.no.paren");
                    this.decompiler.addToken(84);
                    break;
                }
                case 79: {
                    this.consumeToken();
                    this.decompiler.addToken(79);
                    node = this.nf.createElementGet(node, null, this.expr(false), 0, n2, n3);
                    this.mustMatchToken(80, "msg.no.bracket.index");
                    this.decompiler.addToken(80);
                    break;
                }
                case 83: {
                    if (!bl) break block11;
                    this.consumeToken();
                    this.decompiler.addToken(83);
                    node = this.nf.createCallOrNew(37, node, this.ts.getLineno(), this.ts.getCharno());
                    this.argumentList(node);
                    break;
                }
                default: {
                    break block11;
                }
            }
        }
        return node;
    }

    private Node attributeAccess(Node node, int n) throws IOException {
        n |= 2;
        int n2 = this.nextToken();
        switch (n2) {
            case 38: {
                String string = this.ts.getString();
                int n3 = this.ts.getLineno();
                int n4 = this.ts.getCharno();
                this.decompiler.addName(string);
                node = this.propertyName(node, string, n, n3, n4);
                break;
            }
            case 23: {
                this.decompiler.addName("*");
                node = this.propertyName(node, "*", n, this.ts.getLineno(), this.ts.getCharno());
                break;
            }
            case 79: {
                this.decompiler.addToken(79);
                node = this.nf.createElementGet(node, null, this.expr(false), n, this.ts.getLineno(), this.ts.getCharno());
                this.mustMatchToken(80, "msg.no.bracket.index");
                this.decompiler.addToken(80);
                break;
            }
            default: {
                this.reportError("msg.no.name.after.xmlAttr");
                node = this.nf.createPropertyGet(node, null, "?", n, this.ts.getLineno(), this.ts.getCharno(), this.ts.getLineno(), this.ts.getCharno());
            }
        }
        return node;
    }

    private Node propertyName(Node node, String string, int n, int n2, int n3, int n4, int n5) throws IOException, ParserException {
        String string2 = null;
        if (this.matchToken(140)) {
            this.decompiler.addToken(140);
            string2 = string;
            int n6 = this.nextToken();
            switch (n6) {
                case 38: {
                    string = this.ts.getString();
                    this.decompiler.addName(string);
                    break;
                }
                case 23: {
                    this.decompiler.addName("*");
                    string = "*";
                    break;
                }
                case 79: {
                    this.decompiler.addToken(79);
                    node = this.nf.createElementGet(node, string2, this.expr(false), n, n4, n5);
                    this.mustMatchToken(80, "msg.no.bracket.index");
                    this.decompiler.addToken(80);
                    return node;
                }
                default: {
                    this.reportError("msg.no.name.after.coloncolon");
                    string = "?";
                }
            }
        }
        node = this.nf.createPropertyGet(node, string2, string, n, n2, n3, n4, n5);
        return node;
    }

    private Node propertyName(Node node, String string, int n, int n2, int n3) throws IOException, ParserException {
        return this.propertyName(node, string, n, n2, n3, n2, n3);
    }

    private Node primaryExpr() throws IOException, ParserException {
        int n = this.nextFlaggedToken();
        int n2 = n & 0xFFFF;
        switch (n2) {
            case 105: {
                return this.function(2);
            }
            case 79: {
                ObjArray objArray = new ObjArray();
                int n3 = 0;
                int n4 = this.ts.getLineno();
                int n5 = this.ts.getCharno();
                this.decompiler.addToken(79);
                boolean bl = true;
                while (true) {
                    if ((n2 = this.peekToken()) == 85) {
                        this.consumeToken();
                        this.decompiler.addToken(85);
                        if (!bl) {
                            bl = true;
                            continue;
                        }
                        objArray.add(null);
                        ++n3;
                        continue;
                    }
                    if (n2 == 80) {
                        if (bl && objArray.size() > 0) {
                            this.addWarning("msg.trailing.comma");
                        }
                        break;
                    }
                    if (!bl) {
                        this.reportError("msg.no.bracket.arg");
                    }
                    objArray.add(this.assignExpr(false));
                    bl = false;
                }
                this.consumeToken();
                this.decompiler.addToken(80);
                return this.nf.createArrayLiteral(objArray, n3, n4, n5);
            }
            case 81: {
                ObjArray objArray = new ObjArray();
                this.decompiler.addToken(81);
                int n6 = this.ts.getLineno();
                int n7 = this.ts.getCharno();
                if (!this.matchToken(82)) {
                    boolean bl = true;
                    block22: do {
                        if (!bl) {
                            this.decompiler.addToken(85);
                        } else {
                            bl = false;
                        }
                        n2 = this.peekToken();
                        switch (n2) {
                            case 38: 
                            case 40: {
                                Node node;
                                this.consumeToken();
                                String string = this.ts.getString();
                                int n8 = this.ts.getLineno();
                                int n9 = this.ts.getCharno();
                                if (n2 == 38) {
                                    if (string.equals("get") && this.peekToken() == 38) {
                                        this.decompiler.addToken(147);
                                        this.consumeToken();
                                        string = this.ts.getString();
                                        this.decompiler.addName(string);
                                        if (this.getterSetterProperty(objArray, string, true, n8, n9)) continue block22;
                                        break block22;
                                    }
                                    if (string.equals("set") && this.peekToken() == 38) {
                                        this.decompiler.addToken(148);
                                        this.consumeToken();
                                        string = this.ts.getString();
                                        this.decompiler.addName(string);
                                        if (this.getterSetterProperty(objArray, string, false, n8, n9)) continue block22;
                                        break block22;
                                    }
                                    this.decompiler.addName(string);
                                    node = this.nf.createString(string, n8, n9);
                                } else {
                                    this.decompiler.addString(string);
                                    node = this.nf.createString(string, n8, n9);
                                    node.setQuotedString();
                                }
                                this.plainProperty(objArray, node);
                                break;
                            }
                            case 39: {
                                this.consumeToken();
                                double d = this.ts.getNumber();
                                int n9 = this.ts.getLineno();
                                int n10 = this.ts.getCharno();
                                this.decompiler.addNumber(d);
                                Node node = this.nf.createNumber(d, n9, n10);
                                this.plainProperty(objArray, node);
                                break;
                            }
                            case 85: {
                                this.consumeToken();
                            }
                            case 82: {
                                this.addWarning("msg.trailing.comma");
                                break block22;
                            }
                            default: {
                                this.reportError("msg.bad.prop");
                                break block22;
                            }
                        }
                    } while (this.matchToken(85));
                    this.mustMatchToken(82, "msg.no.brace.prop");
                }
                this.decompiler.addToken(82);
                return this.nf.createObjectLiteral(objArray, n6, n7);
            }
            case 83: {
                JSDocInfo jSDocInfo = this.ts.getAndResetJSDocInfo();
                this.decompiler.addToken(83);
                Node node = this.expr(false);
                node.putProp(34, Boolean.TRUE);
                this.decompiler.addToken(84);
                if (jSDocInfo == null) {
                    jSDocInfo = this.ts.getAndResetJSDocInfo();
                }
                if (jSDocInfo != null && jSDocInfo.hasType()) {
                    node.setJSDocInfo(jSDocInfo);
                }
                this.mustMatchToken(84, "msg.no.paren");
                return node;
            }
            case 143: {
                this.mustHaveXML();
                this.decompiler.addToken(143);
                Node node = this.attributeAccess(null, 0);
                return node;
            }
            case 38: {
                String string = this.ts.getString();
                int n11 = this.ts.getLineno();
                int n12 = this.ts.getCharno();
                if ((n & 0x20000) != 0 && this.peekToken() == 99) {
                    return this.nf.createLabel(string, n11, n12);
                }
                this.decompiler.addName(string);
                Node node = this.compilerEnv.isXmlAvailable() ? this.propertyName(null, string, 0, n11, n12) : this.nf.createName(string, n11, n12);
                return node;
            }
            case 39: {
                double d = this.ts.getNumber();
                int n13 = this.ts.getLineno();
                int n14 = this.ts.getCharno();
                this.decompiler.addNumber(d);
                return this.nf.createNumber(d, n13, n14);
            }
            case 40: {
                String string = this.ts.getString();
                int n15 = this.ts.getLineno();
                int n16 = this.ts.getCharno();
                this.decompiler.addString(string);
                return this.nf.createString(string, n15, n16);
            }
            case 24: 
            case 96: {
                this.ts.readRegExp(n2);
                String string = this.ts.regExpFlags;
                this.ts.regExpFlags = null;
                String string2 = this.ts.getString();
                int n17 = this.ts.getLineno();
                int n18 = this.ts.getCharno();
                this.decompiler.addRegexp(string2, string);
                return this.nf.createRegExp(string2, string, n17, n18);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                int n19 = this.ts.getLineno();
                int n20 = this.ts.getCharno();
                this.decompiler.addToken(n2);
                return this.nf.createLeaf(n2, n19, n20);
            }
            case 123: {
                this.reportError("msg.reserved.id");
                break;
            }
            case -1: {
                break;
            }
            case 0: {
                this.reportError("msg.unexpected.eof");
                break;
            }
            default: {
                this.reportError("msg.syntax");
            }
        }
        return null;
    }

    String getSourceName() {
        return this.sourceURI;
    }

    private void plainProperty(ObjArray objArray, Object object) throws IOException {
        this.mustMatchToken(99, "msg.no.colon.prop");
        this.decompiler.addToken(64);
        objArray.add(object);
        objArray.add(this.assignExpr(false));
    }

    private boolean getterSetterProperty(ObjArray objArray, String string, boolean bl, int n, int n2) throws IOException {
        Node node = this.function(2);
        if (node.getType() != 105) {
            this.reportError("msg.bad.prop");
            return false;
        }
        int n3 = node.getExistingIntProp(5);
        FunctionNode functionNode = this.currentScriptOrFn.getFunctionNode(n3);
        if (functionNode.getFunctionName().length() != 0) {
            this.reportError("msg.bad.prop");
            return false;
        }
        objArray.add(this.nf.createName(string, n, n2));
        if (bl) {
            objArray.add(this.nf.createUnary(147, node, n, n2));
        } else {
            objArray.add(this.nf.createUnary(148, node, n, n2));
        }
        return true;
    }

    private static class ParserException
    extends RuntimeException {
        static final long serialVersionUID = 5882582646773765630L;

        private ParserException() {
        }
    }
}

