/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

public enum BooleanLiteralSet {
    EMPTY,
    TRUE,
    FALSE,
    BOTH;


    private BooleanLiteralSet fromOrdinal(int n) {
        switch (n) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return TRUE;
            }
            case 2: {
                return FALSE;
            }
            case 3: {
                return BOTH;
            }
        }
        throw new IllegalArgumentException("Ordinal: " + n);
    }

    public BooleanLiteralSet intersection(BooleanLiteralSet booleanLiteralSet) {
        return this.fromOrdinal(this.ordinal() & booleanLiteralSet.ordinal());
    }

    public BooleanLiteralSet union(BooleanLiteralSet booleanLiteralSet) {
        return this.fromOrdinal(this.ordinal() | booleanLiteralSet.ordinal());
    }

    public boolean contains(boolean bl) {
        switch (this.ordinal()) {
            case 0: {
                return false;
            }
            case 1: {
                return bl;
            }
            case 2: {
                return !bl;
            }
            case 3: {
                return true;
            }
        }
        throw new IndexOutOfBoundsException("Ordinal: " + this.ordinal());
    }

    public static BooleanLiteralSet get(boolean bl) {
        return bl ? TRUE : FALSE;
    }
}

