/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.ArrowType;
import com.google.javascript.rhino.jstype.FunctionBuilder;
import com.google.javascript.rhino.jstype.FunctionParamBuilder;
import com.google.javascript.rhino.jstype.FunctionPrototypeType;
import com.google.javascript.rhino.jstype.InstanceObjectType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.PrototypeObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.UnionType;
import com.google.javascript.rhino.jstype.Visitor;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class FunctionType
extends PrototypeObjectType {
    private static final long serialVersionUID = 1L;
    private ArrowType call;
    private FunctionPrototypeType prototype;
    private final Kind kind;
    private ObjectType typeOfThis;
    private Node source;
    private List<ObjectType> implementedInterfaces = ImmutableList.of();
    private List<FunctionType> subTypes;
    private String templateTypeName;

    FunctionType(JSTypeRegistry jSTypeRegistry, String string, Node node, ArrowType arrowType, ObjectType objectType, String string2, boolean bl, boolean bl2) {
        super(jSTypeRegistry, string, jSTypeRegistry.getNativeObjectType(JSTypeNative.FUNCTION_INSTANCE_TYPE), bl2);
        Preconditions.checkArgument((node == null || 105 == node.getType() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)arrowType);
        this.source = node;
        Kind kind = this.kind = bl ? Kind.CONSTRUCTOR : Kind.ORDINARY;
        this.typeOfThis = bl ? (objectType != null ? objectType : new InstanceObjectType(jSTypeRegistry, this, bl2)) : (objectType != null ? objectType : jSTypeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        this.call = arrowType;
        this.templateTypeName = string2;
    }

    private FunctionType(JSTypeRegistry jSTypeRegistry, String string, Node node) {
        super(jSTypeRegistry, string, jSTypeRegistry.getNativeObjectType(JSTypeNative.FUNCTION_INSTANCE_TYPE));
        Preconditions.checkArgument((node == null || 105 == node.getType() ? 1 : 0) != 0);
        Preconditions.checkArgument((string != null ? 1 : 0) != 0);
        this.source = node;
        this.call = new ArrowType(jSTypeRegistry, new Node(83), null);
        this.kind = Kind.INTERFACE;
        this.typeOfThis = new InstanceObjectType(jSTypeRegistry, this);
    }

    static FunctionType forInterface(JSTypeRegistry jSTypeRegistry, String string, Node node) {
        return new FunctionType(jSTypeRegistry, string, node);
    }

    @Override
    public boolean isInstanceType() {
        return this.isEquivalentTo(this.registry.getNativeType(JSTypeNative.U2U_CONSTRUCTOR_TYPE));
    }

    @Override
    public boolean isConstructor() {
        return this.kind == Kind.CONSTRUCTOR;
    }

    @Override
    public boolean isInterface() {
        return this.kind == Kind.INTERFACE;
    }

    @Override
    public boolean isOrdinaryFunction() {
        return this.kind == Kind.ORDINARY;
    }

    @Override
    public boolean isFunctionType() {
        return true;
    }

    @Override
    public boolean canBeCalled() {
        return true;
    }

    public Iterable<Node> getParameters() {
        Node node = this.getParametersNode();
        if (node != null) {
            return node.children();
        }
        return Collections.emptySet();
    }

    public Node getParametersNode() {
        return this.call.parameters;
    }

    public int getMinArguments() {
        int n = 0;
        int n2 = 0;
        for (Node node : this.getParameters()) {
            ++n;
            if (node.isOptionalArg() || node.isVarArgs()) continue;
            n2 = n;
        }
        return n2;
    }

    public int getMaxArguments() {
        Node node;
        Node node2 = this.getParametersNode();
        if (!(node2 == null || (node = node2.getLastChild()) != null && node.isVarArgs())) {
            return node2.getChildCount();
        }
        return Integer.MAX_VALUE;
    }

    public JSType getReturnType() {
        return this.call.returnType;
    }

    public boolean isReturnTypeInferred() {
        return this.call.returnTypeInferred;
    }

    ArrowType getInternalArrowType() {
        return this.call;
    }

    public FunctionPrototypeType getPrototype() {
        if (this.prototype == null) {
            this.setPrototype(new FunctionPrototypeType(this.registry, this, null));
        }
        return this.prototype;
    }

    public void setPrototypeBasedOn(ObjectType objectType) {
        if (this.prototype == null) {
            this.setPrototype(new FunctionPrototypeType(this.registry, this, objectType, this.isNativeObjectType()));
        } else {
            this.prototype.setImplicitPrototype(objectType);
        }
    }

    public boolean setPrototype(FunctionPrototypeType functionPrototypeType) {
        FunctionType functionType;
        if (functionPrototypeType == null) {
            return false;
        }
        if (this.isConstructor() && functionPrototypeType == this.getInstanceType()) {
            return false;
        }
        boolean bl = functionPrototypeType != null;
        this.prototype = functionPrototypeType;
        if ((this.isConstructor() || this.isInterface()) && (functionType = this.getSuperClassConstructor()) != null) {
            functionType.addSubType(this);
        }
        if (bl) {
            this.clearCachedValues();
        }
        return true;
    }

    public Iterable<ObjectType> getAllImplementedInterfaces() {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (ObjectType objectType : this.getImplementedInterfaces()) {
            this.addRelatedInterfaces(objectType, linkedHashSet);
        }
        return linkedHashSet;
    }

    private void addRelatedInterfaces(ObjectType objectType, Set<ObjectType> set) {
        FunctionType functionType = objectType.getConstructor();
        if (functionType != null) {
            if (!functionType.isInterface()) {
                return;
            }
            set.add(objectType);
            if (functionType.getSuperClassConstructor() != null) {
                this.addRelatedInterfaces(functionType.getSuperClassConstructor().getInstanceType(), set);
            }
        }
    }

    public Iterable<ObjectType> getImplementedInterfaces() {
        FunctionType functionType;
        FunctionType functionType2 = functionType = this.isConstructor() ? this.getSuperClassConstructor() : null;
        if (functionType == null) {
            return this.implementedInterfaces;
        }
        return Iterables.concat(this.implementedInterfaces, functionType.getImplementedInterfaces());
    }

    public void setImplementedInterfaces(List<ObjectType> list) {
        for (ObjectType objectType : list) {
            this.registry.registerTypeImplementingInterface(this, objectType);
        }
        this.implementedInterfaces = ImmutableList.copyOf(list);
    }

    @Override
    public boolean hasProperty(String string) {
        return super.hasProperty(string) || "prototype".equals(string);
    }

    @Override
    public boolean hasOwnProperty(String string) {
        return super.hasOwnProperty(string) || "prototype".equals(string);
    }

    @Override
    public JSType getPropertyType(String string) {
        if ("prototype".equals(string)) {
            return this.getPrototype();
        }
        if (!this.hasOwnProperty(string)) {
            if ("call".equals(string)) {
                Node node = this.getParametersNode();
                if (node == null) {
                    this.defineDeclaredProperty(string, new FunctionBuilder(this.registry).withReturnType(this.getReturnType()).build(), false, this.source);
                } else {
                    node = node.cloneTree();
                    Node node2 = Node.newString(38, "thisType");
                    node2.setJSType(this.registry.createOptionalNullableType(this.getTypeOfThis()));
                    node.addChildToFront(node2);
                    node2.setOptionalArg(true);
                    this.defineDeclaredProperty(string, new FunctionBuilder(this.registry).withParamsNode(node).withReturnType(this.getReturnType()).build(), false, this.source);
                }
            } else if ("apply".equals(string)) {
                FunctionParamBuilder functionParamBuilder = new FunctionParamBuilder(this.registry);
                functionParamBuilder.addOptionalParams(this.registry.createNullableType(this.getTypeOfThis()), this.registry.createNullableType(this.registry.getNativeType(JSTypeNative.OBJECT_TYPE)));
                this.defineDeclaredProperty(string, new FunctionBuilder(this.registry).withParams(functionParamBuilder).withReturnType(this.getReturnType()).build(), false, this.source);
            }
        }
        return super.getPropertyType(string);
    }

    @Override
    boolean defineProperty(String string, JSType jSType, boolean bl, boolean bl2, Node node) {
        if ("prototype".equals(string)) {
            ObjectType objectType = jSType.toObjectType();
            if (objectType != null) {
                if (objectType.isEquivalentTo(this.prototype)) {
                    return true;
                }
                return this.setPrototype(new FunctionPrototypeType(this.registry, this, objectType, this.isNativeObjectType()));
            }
            return false;
        }
        return super.defineProperty(string, jSType, bl, bl2, node);
    }

    @Override
    public boolean isPropertyTypeInferred(String string) {
        return "prototype".equals(string) || super.isPropertyTypeInferred(string);
    }

    @Override
    public JSType getLeastSupertype(JSType jSType) {
        return this.supAndInfHelper(jSType, true);
    }

    @Override
    public JSType getGreatestSubtype(JSType jSType) {
        return this.supAndInfHelper(jSType, false);
    }

    private JSType supAndInfHelper(JSType jSType, boolean bl) {
        if (this.isFunctionType() && jSType.isFunctionType()) {
            JSType jSType2;
            FunctionType functionType;
            if (this.isEquivalentTo(jSType)) {
                return this;
            }
            FunctionType functionType2 = null;
            if (jSType instanceof FunctionType) {
                functionType2 = (FunctionType)jSType;
            }
            if (functionType2 != null && this.isOrdinaryFunction() && jSType.isOrdinaryFunction() && !this.call.hasUnknownParamsOrReturn() && !functionType2.call.hasUnknownParamsOrReturn()) {
                boolean bl2 = this.isSubtype(jSType);
                boolean bl3 = jSType.isSubtype(this);
                if (bl2 && !bl3) {
                    return bl ? jSType : this;
                }
                if (bl3 && !bl2) {
                    return bl ? this : jSType;
                }
                functionType = this.tryMergeFunctionPiecewise(functionType2, bl);
                if (functionType != null) {
                    return functionType;
                }
            }
            if ((jSType2 = this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE)).isEquivalentTo(jSType)) {
                return bl ? jSType : this;
            }
            if (jSType2.isEquivalentTo(this)) {
                return bl ? this : jSType;
            }
            FunctionType functionType3 = this.registry.getNativeFunctionType(JSTypeNative.U2U_CONSTRUCTOR_TYPE);
            functionType = this.registry.getNativeFunctionType(JSTypeNative.LEAST_FUNCTION_TYPE);
            return bl ? functionType3 : functionType;
        }
        return bl ? super.getLeastSupertype(jSType) : super.getGreatestSubtype(jSType);
    }

    private FunctionType tryMergeFunctionPiecewise(FunctionType functionType, boolean bl) {
        Node node = null;
        if (!this.call.hasEqualParameters(functionType.call)) {
            return null;
        }
        node = this.call.parameters;
        JSType jSType = bl ? this.call.returnType.getLeastSupertype(functionType.call.returnType) : this.call.returnType.getGreatestSubtype(functionType.call.returnType);
        ObjectType objectType = null;
        if (FunctionType.isEquivalent(this.typeOfThis, functionType.typeOfThis)) {
            objectType = this.typeOfThis;
        } else {
            JSType jSType2;
            JSType jSType3 = jSType2 = bl ? this.typeOfThis.getLeastSupertype(functionType.typeOfThis) : this.typeOfThis.getGreatestSubtype(functionType.typeOfThis);
            objectType = jSType2 instanceof ObjectType ? (ObjectType)jSType2 : (bl ? this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE) : this.registry.getNativeObjectType(JSTypeNative.NO_OBJECT_TYPE));
        }
        boolean bl2 = this.call.returnTypeInferred || functionType.call.returnTypeInferred;
        return new FunctionType(this.registry, null, null, new ArrowType(this.registry, node, jSType, bl2), objectType, null, false, false);
    }

    public FunctionType getSuperClassConstructor() {
        Preconditions.checkArgument((this.isConstructor() || this.isInterface() ? 1 : 0) != 0);
        ObjectType objectType = this.getPrototype().getImplicitPrototype();
        if (objectType == null) {
            return null;
        }
        return objectType.getConstructor();
    }

    public JSType getTopMostDefiningType(String string) {
        ObjectType objectType;
        Preconditions.checkState((this.isConstructor() || this.isInterface() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.getPrototype().hasProperty(string));
        FunctionType functionType = this;
        do {
            objectType = functionType.getInstanceType();
        } while ((functionType = functionType.getSuperClassConstructor()) != null && functionType.getPrototype().hasProperty(string));
        return objectType;
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        if (!(jSType instanceof FunctionType)) {
            return false;
        }
        FunctionType functionType = (FunctionType)jSType;
        if (!functionType.isFunctionType()) {
            return false;
        }
        if (this.isConstructor()) {
            if (functionType.isConstructor()) {
                return this == functionType;
            }
            return false;
        }
        if (this.isInterface()) {
            if (functionType.isInterface()) {
                return this.getReferenceName().equals(functionType.getReferenceName());
            }
            return false;
        }
        if (functionType.isInterface()) {
            return false;
        }
        return this.typeOfThis.isEquivalentTo(functionType.typeOfThis) && this.call.isEquivalentTo(functionType.call);
    }

    @Override
    public int hashCode() {
        return this.isInterface() ? this.getReferenceName().hashCode() : this.call.hashCode();
    }

    public boolean hasEqualCallType(FunctionType functionType) {
        return this.call.isEquivalentTo(functionType.call);
    }

    @Override
    public String toString() {
        boolean bl;
        if (this == this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE)) {
            return "Function";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("function (");
        int n = this.call.parameters.getChildCount();
        boolean bl2 = bl = !this.typeOfThis.isUnknownType();
        if (bl) {
            if (this.isConstructor()) {
                stringBuilder.append("new:");
            } else {
                stringBuilder.append("this:");
            }
            stringBuilder.append(this.typeOfThis.toString());
        }
        if (n > 0) {
            Node node;
            if (bl) {
                stringBuilder.append(", ");
            }
            if ((node = this.call.parameters.getFirstChild()).isVarArgs()) {
                this.appendVarArgsString(stringBuilder, node.getJSType());
            } else {
                stringBuilder.append(node.getJSType().toString());
            }
            for (node = node.getNext(); node != null; node = node.getNext()) {
                stringBuilder.append(", ");
                if (node.isVarArgs()) {
                    this.appendVarArgsString(stringBuilder, node.getJSType());
                    continue;
                }
                stringBuilder.append(node.getJSType().toString());
            }
        }
        stringBuilder.append("): ");
        stringBuilder.append(this.call.returnType);
        return stringBuilder.toString();
    }

    private void appendVarArgsString(StringBuilder stringBuilder, JSType jSType) {
        if (jSType.isUnionType()) {
            jSType = ((UnionType)jSType).getRestrictedUnion(this.registry.getNativeType(JSTypeNative.VOID_TYPE));
        }
        stringBuilder.append("...[").append(jSType.toString()).append("]");
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        if (JSType.isSubtype(this, jSType)) {
            return true;
        }
        if (jSType.isFunctionType()) {
            if (((FunctionType)jSType).isInterface()) {
                return true;
            }
            if (this.isInterface()) {
                return false;
            }
            FunctionType functionType = (FunctionType)jSType;
            boolean bl = this.isConstructor() || functionType.isConstructor() || functionType.typeOfThis.getConstructor() != null && functionType.typeOfThis.getConstructor().isInterface() || functionType.typeOfThis.isSubtype(this.typeOfThis) || this.typeOfThis.isSubtype(functionType.typeOfThis);
            return bl && this.call.isSubtype(functionType.call);
        }
        return this.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE).isSubtype(jSType);
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseFunctionType(this);
    }

    public ObjectType getInstanceType() {
        Preconditions.checkState((boolean)this.hasInstanceType());
        return this.typeOfThis;
    }

    void setInstanceType(ObjectType objectType) {
        this.typeOfThis = objectType;
    }

    public boolean hasInstanceType() {
        return this.isConstructor() || this.isInterface();
    }

    public ObjectType getTypeOfThis() {
        return this.typeOfThis.isNoObjectType() ? this.registry.getNativeObjectType(JSTypeNative.OBJECT_TYPE) : this.typeOfThis;
    }

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node node) {
        this.source = node;
    }

    private void addSubType(FunctionType functionType) {
        if (this.subTypes == null) {
            this.subTypes = Lists.newArrayList();
        }
        this.subTypes.add(functionType);
    }

    @Override
    public void clearCachedValues() {
        super.clearCachedValues();
        if (this.subTypes != null) {
            for (FunctionType functionType : this.subTypes) {
                functionType.clearCachedValues();
            }
        }
        if (!this.isNativeObjectType()) {
            if (this.hasInstanceType()) {
                this.getInstanceType().clearCachedValues();
            }
            if (this.prototype != null) {
                this.prototype.clearCachedValues();
            }
        }
    }

    public List<FunctionType> getSubTypes() {
        return this.subTypes;
    }

    @Override
    public boolean hasCachedValues() {
        return this.prototype != null || super.hasCachedValues();
    }

    public String getTemplateTypeName() {
        return this.templateTypeName;
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        this.setResolvedTypeInternal(this);
        this.call = (ArrowType)FunctionType.safeResolve(this.call, errorReporter, staticScope);
        this.prototype = (FunctionPrototypeType)FunctionType.safeResolve(this.prototype, errorReporter, staticScope);
        JSType jSType = FunctionType.safeResolve(this.typeOfThis, errorReporter, staticScope);
        if (jSType != null) {
            jSType = jSType.restrictByNotNullOrUndefined();
        }
        if (jSType instanceof ObjectType) {
            this.typeOfThis = (ObjectType)jSType;
        }
        boolean bl = false;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ObjectType objectType : this.implementedInterfaces) {
            ObjectType objectType2 = (ObjectType)objectType.resolve(errorReporter, staticScope);
            builder.add((Object)objectType2);
            bl |= objectType2 != objectType;
        }
        if (bl) {
            this.implementedInterfaces = builder.build();
        }
        if (this.subTypes != null) {
            for (int i = 0; i < this.subTypes.size(); ++i) {
                this.subTypes.set(i, (FunctionType)this.subTypes.get(i).resolve(errorReporter, staticScope));
            }
        }
        return super.resolveInternal(errorReporter, staticScope);
    }

    @Override
    public String toDebugHashCodeString() {
        boolean bl;
        if (this == this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE)) {
            return super.toDebugHashCodeString();
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("function (");
        int n = this.call.parameters.getChildCount();
        boolean bl2 = bl = !this.typeOfThis.isUnknownType();
        if (bl) {
            stringBuilder.append("this:");
            stringBuilder.append(this.getDebugHashCodeStringOf(this.typeOfThis));
        }
        if (n > 0) {
            if (bl) {
                stringBuilder.append(", ");
            }
            Node node = this.call.parameters.getFirstChild();
            stringBuilder.append(this.getDebugHashCodeStringOf(node.getJSType()));
            for (node = node.getNext(); node != null; node = node.getNext()) {
                stringBuilder.append(", ");
                stringBuilder.append(this.getDebugHashCodeStringOf(node.getJSType()));
            }
        }
        stringBuilder.append(")");
        stringBuilder.append(": ");
        stringBuilder.append(this.getDebugHashCodeStringOf(this.call.returnType));
        return stringBuilder.toString();
    }

    private String getDebugHashCodeStringOf(JSType jSType) {
        if (jSType == this) {
            return "me";
        }
        return jSType.toDebugHashCodeString();
    }

    private static enum Kind {
        ORDINARY,
        CONSTRUCTOR,
        INTERFACE;

    }
}

