/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.EnumElementType;
import com.google.javascript.rhino.jstype.EnumType;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.ProxyObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import java.util.List;

class NamedType
extends ProxyObjectType {
    private static final long serialVersionUID = 1L;
    private final String reference;
    private final String sourceName;
    private final int lineno;
    private final int charno;
    private Predicate<JSType> validator;
    private List<PropertyContinuation> propertyContinuations = null;

    NamedType(JSTypeRegistry jSTypeRegistry, String string, String string2, int n, int n2) {
        super(jSTypeRegistry, jSTypeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        Preconditions.checkNotNull((Object)string);
        this.reference = string;
        this.sourceName = string2;
        this.lineno = n;
        this.charno = n2;
    }

    @Override
    boolean defineProperty(String string, JSType jSType, boolean bl, boolean bl2, Node node) {
        if (!this.isResolved()) {
            if (this.propertyContinuations == null) {
                this.propertyContinuations = Lists.newArrayList();
            }
            this.propertyContinuations.add(new PropertyContinuation(string, jSType, bl, bl2, node));
            return true;
        }
        return super.defineProperty(string, jSType, bl, bl2, node);
    }

    private void finishPropertyContinuations() {
        ObjectType objectType = this.getReferencedObjTypeInternal();
        if (objectType != null && !objectType.isUnknownType() && this.propertyContinuations != null) {
            for (PropertyContinuation propertyContinuation : this.propertyContinuations) {
                propertyContinuation.commit(this);
            }
        }
        this.propertyContinuations = null;
    }

    public JSType getReferencedType() {
        return this.getReferencedTypeInternal();
    }

    @Override
    public String getReferenceName() {
        return this.reference;
    }

    @Override
    public String toString() {
        return this.reference;
    }

    @Override
    public boolean hasReferenceName() {
        return true;
    }

    @Override
    boolean isNamedType() {
        return true;
    }

    @Override
    public boolean isNominalType() {
        return true;
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        if (this == jSType) {
            return true;
        }
        ObjectType objectType = ObjectType.cast(jSType);
        if (objectType != null) {
            return objectType.isNominalType() && this.reference.equals(objectType.getReferenceName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.reference.hashCode();
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        boolean bl = this.resolveViaRegistry(errorReporter, staticScope);
        if (this.detectImplicitPrototypeCycle()) {
            this.handleTypeCycle(errorReporter);
        }
        if (bl) {
            super.resolveInternal(errorReporter, staticScope);
            this.finishPropertyContinuations();
            return this.registry.isLastGeneration() ? this.getReferencedType() : this;
        }
        this.resolveViaProperties(errorReporter, staticScope);
        if (this.detectImplicitPrototypeCycle()) {
            this.handleTypeCycle(errorReporter);
        }
        super.resolveInternal(errorReporter, staticScope);
        if (this.isResolved()) {
            this.finishPropertyContinuations();
        }
        return this.registry.isLastGeneration() ? this.getReferencedType() : this;
    }

    private boolean resolveViaRegistry(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        JSType jSType = this.registry.getType(this.reference);
        if (jSType != null) {
            this.setReferencedAndResolvedType(jSType, errorReporter, staticScope);
            return true;
        }
        return false;
    }

    private void resolveViaProperties(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        JSType jSType = this.lookupViaProperties(errorReporter, staticScope);
        if (jSType instanceof FunctionType && (jSType.isConstructor() || jSType.isInterface())) {
            FunctionType functionType = (FunctionType)jSType;
            this.setReferencedAndResolvedType(functionType.getInstanceType(), errorReporter, staticScope);
        } else if (jSType instanceof EnumType) {
            this.setReferencedAndResolvedType(((EnumType)jSType).getElementsType(), errorReporter, staticScope);
        } else {
            this.handleUnresolvedType(errorReporter, jSType == null || jSType.isUnknownType());
        }
    }

    private JSType lookupViaProperties(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        String[] stringArray = this.reference.split("\\.", -1);
        if (stringArray[0].length() == 0) {
            return null;
        }
        StaticSlot<JSType> staticSlot = staticScope.getSlot(stringArray[0]);
        if (staticSlot == null) {
            return null;
        }
        JSType jSType = staticSlot.getType();
        if (jSType == null || jSType.isAllType() || jSType.isNoType()) {
            return null;
        }
        JSType jSType2 = this.getTypedefType(errorReporter, staticSlot, stringArray[0]);
        if (jSType2 == null) {
            return null;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            ObjectType objectType = ObjectType.cast(jSType2);
            if (objectType == null) {
                return null;
            }
            if (stringArray[i].length() == 0) {
                return null;
            }
            jSType2 = objectType.getPropertyType(stringArray[i]);
        }
        return jSType2;
    }

    private void setReferencedAndResolvedType(JSType jSType, ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        if (this.validator != null) {
            this.validator.apply((Object)jSType);
        }
        this.setReferencedType(jSType);
        this.checkEnumElementCycle(errorReporter);
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    private void handleTypeCycle(ErrorReporter errorReporter) {
        this.setReferencedType(this.registry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE));
        errorReporter.warning("Cycle detected in inheritance chain of type " + this.reference, this.sourceName, this.lineno, null, this.charno);
        this.setResolvedTypeInternal(this.getReferencedType());
    }

    private void checkEnumElementCycle(ErrorReporter errorReporter) {
        JSType jSType = this.getReferencedType();
        if (jSType instanceof EnumElementType && ((EnumElementType)jSType).getPrimitiveType() == this) {
            this.handleTypeCycle(errorReporter);
        }
    }

    private void handleUnresolvedType(ErrorReporter errorReporter, boolean bl) {
        if (this.registry.isLastGeneration()) {
            boolean bl2;
            boolean bl3 = bl2 = bl && this.registry.isForwardDeclaredType(this.reference);
            if (!bl2 && this.registry.isLastGeneration()) {
                errorReporter.warning("Bad type annotation. Unknown type " + this.reference, this.sourceName, this.lineno, null, this.charno);
            } else {
                this.setReferencedType(this.registry.getNativeObjectType(JSTypeNative.NO_RESOLVED_TYPE));
                if (this.registry.isLastGeneration() && this.validator != null) {
                    this.validator.apply((Object)this.getReferencedType());
                }
            }
            this.setResolvedTypeInternal(this.getReferencedType());
        } else {
            this.setResolvedTypeInternal(this);
        }
    }

    JSType getTypedefType(ErrorReporter errorReporter, StaticSlot<JSType> staticSlot, String string) {
        JSType jSType = staticSlot.getType();
        if (jSType != null) {
            return jSType;
        }
        this.handleUnresolvedType(errorReporter, true);
        return null;
    }

    @Override
    public boolean setValidator(Predicate<JSType> predicate) {
        if (this.isResolved()) {
            return super.setValidator(predicate);
        }
        this.validator = predicate;
        return true;
    }

    private static final class PropertyContinuation {
        private final String propertyName;
        private final JSType type;
        private final boolean inferred;
        private final boolean inExterns;
        private final Node propertyNode;

        private PropertyContinuation(String string, JSType jSType, boolean bl, boolean bl2, Node node) {
            this.propertyName = string;
            this.type = jSType;
            this.inferred = bl;
            this.inExterns = bl2;
            this.propertyNode = node;
        }

        void commit(ObjectType objectType) {
            objectType.defineProperty(this.propertyName, this.type, this.inferred, this.inExterns, this.propertyNode);
        }
    }
}

