/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.Visitor;

public class NoObjectType
extends FunctionType {
    private static final long serialVersionUID = 1L;

    NoObjectType(JSTypeRegistry jSTypeRegistry) {
        super(jSTypeRegistry, null, null, jSTypeRegistry.createArrowType(null, null), null, null, true, true);
        this.getInternalArrowType().returnType = this;
        this.setInstanceType(this);
    }

    @Override
    public boolean isSubtype(JSType jSType) {
        if (JSType.isSubtype(this, jSType)) {
            return true;
        }
        return jSType.isObject() && !jSType.isNoType() && !jSType.isNoResolvedType();
    }

    @Override
    public boolean isFunctionType() {
        return false;
    }

    @Override
    public boolean isNoObjectType() {
        return true;
    }

    @Override
    public ObjectType getImplicitPrototype() {
        return null;
    }

    @Override
    public String getReferenceName() {
        return null;
    }

    @Override
    public boolean matchesNumberContext() {
        return true;
    }

    @Override
    public boolean matchesObjectContext() {
        return true;
    }

    @Override
    public boolean matchesStringContext() {
        return true;
    }

    @Override
    public boolean isEquivalentTo(JSType jSType) {
        return this == jSType;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public int getPropertiesCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public JSType getPropertyType(String string) {
        return this.getNativeType(JSTypeNative.NO_TYPE);
    }

    @Override
    public boolean hasProperty(String string) {
        return true;
    }

    @Override
    boolean defineProperty(String string, JSType jSType, boolean bl, boolean bl2, Node node) {
        return true;
    }

    @Override
    public JSDocInfo getOwnPropertyJSDocInfo(String string) {
        return null;
    }

    @Override
    public void setPropertyJSDocInfo(String string, JSDocInfo jSDocInfo, boolean bl) {
    }

    @Override
    public boolean isPropertyTypeInferred(String string) {
        return false;
    }

    @Override
    public <T> T visit(Visitor<T> visitor) {
        return visitor.caseNoObjectType();
    }

    @Override
    public String toString() {
        return "NoObject";
    }

    @Override
    public FunctionType getConstructor() {
        return null;
    }

    @Override
    JSType resolveInternal(ErrorReporter errorReporter, StaticScope<JSType> staticScope) {
        return this;
    }
}

