/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CodingConventions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClosureCodingConvention
extends CodingConventions.Proxy {
    private static final long serialVersionUID = 1L;
    static final DiagnosticType OBJECTLIT_EXPECTED = DiagnosticType.warning("JSC_REFLECT_OBJECTLIT_EXPECTED", "Object literal expected as second argument");
    private final Set<String> indirectlyDeclaredProperties;
    private final Set<String> propertyTestFunctions = ImmutableSet.of((Object)"goog.isDef", (Object)"goog.isNull", (Object)"goog.isDefAndNotNull", (Object)"goog.isString", (Object)"goog.isNumber", (Object)"goog.isBoolean", (Object[])new String[]{"goog.isFunction", "goog.isArray", "goog.isObject"});

    public ClosureCodingConvention() {
        this(CodingConventions.getDefault());
    }

    public ClosureCodingConvention(CodingConvention wrapped) {
        super(wrapped);
        HashSet props = Sets.newHashSet((Object[])new String[]{"superClass_", "instance_", "getInstance"});
        props.addAll(wrapped.getIndirectlyDeclaredProperties());
        this.indirectlyDeclaredProperties = ImmutableSet.copyOf((Collection)props);
    }

    @Override
    public void applySubclassRelationship(FunctionType parentCtor, FunctionType childCtor, CodingConvention.SubclassType type) {
        super.applySubclassRelationship(parentCtor, childCtor, type);
        if (type == CodingConvention.SubclassType.INHERITS) {
            childCtor.defineDeclaredProperty("superClass_", parentCtor.getPrototype(), childCtor.getSource());
            childCtor.getPrototype().defineDeclaredProperty("constructor", childCtor.cloneWithoutArrowType(), childCtor.getSource());
        }
    }

    @Override
    public CodingConvention.SubclassRelationship getClassesDefinedByCall(Node callNode) {
        CodingConvention.SubclassRelationship relationship = super.getClassesDefinedByCall(callNode);
        if (relationship != null) {
            return relationship;
        }
        Node callName = callNode.getFirstChild();
        CodingConvention.SubclassType type = ClosureCodingConvention.typeofClassDefiningName(callName);
        if (type != null) {
            boolean isDeprecatedCall;
            Node subclass = null;
            Node superclass = callNode.getLastChild();
            boolean bl = isDeprecatedCall = callNode.getChildCount() == 2 && callName.isGetProp();
            if (isDeprecatedCall) {
                subclass = callName.getFirstChild();
            } else if (callNode.getChildCount() == 3) {
                subclass = callName.getNext();
            } else {
                return null;
            }
            if (type == CodingConvention.SubclassType.MIXIN) {
                if (!ClosureCodingConvention.endsWithPrototype(superclass)) {
                    return null;
                }
                if (!isDeprecatedCall) {
                    if (!ClosureCodingConvention.endsWithPrototype(subclass)) {
                        return null;
                    }
                    subclass = subclass.getFirstChild();
                }
                superclass = superclass.getFirstChild();
            }
            if (subclass != null && subclass.isUnscopedQualifiedName() && superclass.isUnscopedQualifiedName()) {
                return new CodingConvention.SubclassRelationship(type, subclass, superclass);
            }
        }
        return null;
    }

    private static CodingConvention.SubclassType typeofClassDefiningName(Node callName) {
        String name;
        int dollarIndex;
        String methodName = null;
        if (callName.isGetProp()) {
            methodName = callName.getLastChild().getString();
        } else if (callName.isName() && (dollarIndex = (name = callName.getString()).lastIndexOf(36)) != -1) {
            methodName = name.substring(dollarIndex + 1);
        }
        if (methodName != null) {
            if (methodName.equals("inherits")) {
                return CodingConvention.SubclassType.INHERITS;
            }
            if (methodName.equals("mixin")) {
                return CodingConvention.SubclassType.MIXIN;
            }
        }
        return null;
    }

    @Override
    public boolean isSuperClassReference(String propertyName) {
        return "superClass_".equals(propertyName) || super.isSuperClassReference(propertyName);
    }

    private static boolean endsWithPrototype(Node qualifiedName) {
        return qualifiedName.isGetProp() && qualifiedName.getLastChild().getString().equals("prototype");
    }

    @Override
    public boolean extractIsModuleFile(Node node, Node parent) {
        String namespace = ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.module");
        return namespace != null;
    }

    @Override
    public String extractClassNameIfProvide(Node node, Node parent) {
        String namespace = ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.provide");
        if (namespace == null) {
            namespace = ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.module");
        }
        return namespace;
    }

    @Override
    public String extractClassNameIfRequire(Node node, Node parent) {
        return ClosureCodingConvention.extractClassNameIfGoog(node, parent, "goog.require");
    }

    private static String extractClassNameIfGoog(Node node, Node parent, String functionName) {
        Node target;
        Node callee;
        String className = null;
        if (NodeUtil.isExprCall(parent) && (callee = node.getFirstChild()) != null && callee.isGetProp() && callee.matchesQualifiedName(functionName) && (target = callee.getNext()) != null && target.isString()) {
            className = target.getString();
        }
        return className;
    }

    @Override
    public String getExportPropertyFunction() {
        return "goog.exportProperty";
    }

    @Override
    public String getExportSymbolFunction() {
        return "goog.exportSymbol";
    }

    @Override
    public List<String> identifyTypeDeclarationCall(Node n) {
        Node typeDeclaration;
        Node typeArray;
        Node callName = n.getFirstChild();
        if (callName.matchesQualifiedName("goog.addDependency") && n.getChildCount() >= 3 && (typeArray = callName.getNext().getNext()).isArrayLit()) {
            ArrayList typeNames = Lists.newArrayList();
            for (Node name = typeArray.getFirstChild(); name != null; name = name.getNext()) {
                if (!name.isString()) continue;
                typeNames.add(name.getString());
            }
            return typeNames;
        }
        if (callName.matchesQualifiedName("goog.forwardDeclare") && n.getChildCount() == 2 && (typeDeclaration = n.getChildAtIndex(1)).isString()) {
            return Lists.newArrayList((Object[])new String[]{typeDeclaration.getString()});
        }
        return super.identifyTypeDeclarationCall(n);
    }

    @Override
    public String getAbstractMethodName() {
        return "goog.abstractMethod";
    }

    @Override
    public String getSingletonGetterClassName(Node callNode) {
        Node callArg = callNode.getFirstChild();
        if (!callArg.matchesQualifiedName("goog.addSingletonGetter") && !callArg.matchesQualifiedName("goog$addSingletonGetter") || callNode.getChildCount() != 2) {
            return super.getSingletonGetterClassName(callNode);
        }
        return callArg.getNext().getQualifiedName();
    }

    @Override
    public void applySingletonGetter(FunctionType functionType, FunctionType getterType, ObjectType objectType) {
        super.applySingletonGetter(functionType, getterType, objectType);
        functionType.defineDeclaredProperty("getInstance", getterType, functionType.getSource());
        functionType.defineDeclaredProperty("instance_", objectType, functionType.getSource());
    }

    @Override
    public String getGlobalObject() {
        return "goog.global";
    }

    @Override
    public boolean isPropertyTestFunction(Node call) {
        Preconditions.checkArgument((boolean)call.isCall());
        return this.propertyTestFunctions.contains(call.getFirstChild().getQualifiedName()) || super.isPropertyTestFunction(call);
    }

    @Override
    public CodingConvention.ObjectLiteralCast getObjectLiteralCast(Node callNode) {
        Preconditions.checkArgument((boolean)callNode.isCall());
        CodingConvention.ObjectLiteralCast proxyCast = super.getObjectLiteralCast(callNode);
        if (proxyCast != null) {
            return proxyCast;
        }
        Node callName = callNode.getFirstChild();
        if (!callName.matchesQualifiedName("goog.reflect.object") || callNode.getChildCount() != 3) {
            return null;
        }
        Node typeNode = callName.getNext();
        if (!typeNode.isQualifiedName()) {
            return null;
        }
        Node objectNode = typeNode.getNext();
        if (!objectNode.isObjectLit()) {
            return new CodingConvention.ObjectLiteralCast(null, null, OBJECTLIT_EXPECTED);
        }
        return new CodingConvention.ObjectLiteralCast(typeNode.getQualifiedName(), typeNode.getNext(), null);
    }

    @Override
    public boolean isPrivate(String name) {
        return false;
    }

    @Override
    public Collection<CodingConvention.AssertionFunctionSpec> getAssertionFunctions() {
        return ImmutableList.of((Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assert"), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertNumber", JSTypeNative.NUMBER_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertString", JSTypeNative.STRING_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertFunction", JSTypeNative.FUNCTION_INSTANCE_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertObject", JSTypeNative.OBJECT_TYPE), (Object)new CodingConvention.AssertionFunctionSpec("goog.asserts.assertArray", JSTypeNative.ARRAY_TYPE), (Object)new AssertFunctionByTypeName("goog.asserts.assertElement", "Element"), (Object)new AssertInstanceofSpec("goog.asserts.assertInstanceof"));
    }

    @Override
    public CodingConvention.Bind describeFunctionBind(Node n, boolean useTypeInfo) {
        CodingConvention.Bind result = super.describeFunctionBind(n, useTypeInfo);
        if (result != null) {
            return result;
        }
        if (!n.isCall()) {
            return null;
        }
        Node callTarget = n.getFirstChild();
        if (callTarget.isQualifiedName()) {
            if (callTarget.matchesQualifiedName("goog.bind") || callTarget.matchesQualifiedName("goog$bind")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = ClosureCodingConvention.safeNext(fn);
                Node parameters = ClosureCodingConvention.safeNext(thisValue);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
            if (callTarget.matchesQualifiedName("goog.partial") || callTarget.matchesQualifiedName("goog$partial")) {
                Node fn = callTarget.getNext();
                if (fn == null) {
                    return null;
                }
                Node thisValue = null;
                Node parameters = ClosureCodingConvention.safeNext(fn);
                return new CodingConvention.Bind(fn, thisValue, parameters);
            }
        }
        return null;
    }

    @Override
    public Collection<String> getIndirectlyDeclaredProperties() {
        return this.indirectlyDeclaredProperties;
    }

    private static Node safeNext(Node n) {
        if (n != null) {
            return n.getNext();
        }
        return null;
    }

    public static class AssertFunctionByTypeName
    extends CodingConvention.AssertionFunctionSpec {
        private final String typeName;

        public AssertFunctionByTypeName(String functionName, String typeName) {
            super(functionName);
            this.typeName = typeName;
        }

        @Override
        public JSType getAssertedType(Node call, JSTypeRegistry registry) {
            return registry.getType(this.typeName);
        }
    }

    public static class AssertInstanceofSpec
    extends CodingConvention.AssertionFunctionSpec {
        public AssertInstanceofSpec(String functionName) {
            super(functionName, JSTypeNative.OBJECT_TYPE);
        }

        @Override
        public JSType getAssertedType(Node call, JSTypeRegistry registry) {
            JSType ownerType;
            Node constructor;
            if (call.getChildCount() > 2 && (constructor = call.getFirstChild().getNext().getNext()) != null && (ownerType = constructor.getJSType()) != null && ownerType.isFunctionType() && ownerType.isConstructor()) {
                FunctionType functionType = (FunctionType)ownerType;
                return functionType.getInstanceType();
            }
            return registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
    }
}

