/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.CompilerOptions;

final class CompilerOptionsValidator {
    static void validate(CompilerOptions options) {
        if (options.checkMissingGetCssNameLevel.isOn() && (options.checkMissingGetCssNameBlacklist == null || options.checkMissingGetCssNameBlacklist.isEmpty())) {
            throw new InvalidOptionsException("Cannot check use of goog.getCssName because of empty blacklist.", new Object[0]);
        }
        if (!(options.getLanguageIn() == options.getLanguageOut() || options.getLanguageIn().isEs6OrHigher() && options.getLanguageOut() == CompilerOptions.LanguageMode.ECMASCRIPT3)) {
            throw new InvalidOptionsException("Can only convert code from ES6 to ES3. Cannot convert from %s to %s.", new Object[]{options.getLanguageIn(), options.getLanguageOut()});
        }
    }

    private CompilerOptionsValidator() {
    }

    public static class InvalidOptionsException
    extends RuntimeException {
        private InvalidOptionsException(String message, Object ... args) {
            super(String.format(message, args));
        }
    }
}

