/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Es6RewriteLetConst
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private int uId;
    private final Map<Node, Map<String, String>> renameMap = new LinkedHashMap<Node, Map<String, String>>();
    private final Set<Node> letConsts = new HashSet<Node>();

    public Es6RewriteLetConst(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    private String newUniqueName(String name) {
        return name + "$" + this.uId++;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (!n.isLet() && !n.isConst()) {
            return;
        }
        Scope scope = t.getScope();
        Node nameNode = n.getFirstChild();
        if (!(nameNode.hasChildren() || parent != null && NodeUtil.isEnhancedFor(parent))) {
            nameNode.addChildToFront(IR.name("undefined").useSourceInfoIfMissingFrom(nameNode));
        }
        String oldName = nameNode.getString();
        this.letConsts.add(n);
        Scope hoistScope = scope.getClosestHoistScope();
        boolean doRename = false;
        if (scope != hoistScope) {
            doRename = hoistScope.isDeclared(oldName, true);
            String newName = doRename ? this.newUniqueName(oldName) : oldName;
            Scope.Var oldVar = scope.getVar(oldName);
            scope.undeclare(oldVar);
            hoistScope.declare(newName, nameNode, null, oldVar.input);
            if (doRename) {
                nameNode.setString(newName);
                Node scopeRoot = scope.getRootNode();
                if (!this.renameMap.containsKey(scopeRoot)) {
                    this.renameMap.put(scopeRoot, new HashMap());
                }
                this.renameMap.get(scopeRoot).put(oldName, newName);
            }
        }
        if (doRename) {
            t.getCompiler().reportCodeChange();
        }
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{externs, root}), this);
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{externs, root}), new RenameReferences());
        LoopClosureTransformer transformer = new LoopClosureTransformer();
        NodeTraversal.traverseRoots(this.compiler, Lists.newArrayList((Object[])new Node[]{externs, root}), transformer);
        transformer.transformLoopClosure();
        if (!this.letConsts.isEmpty()) {
            for (Node n : this.letConsts) {
                n.setType(118);
            }
            this.compiler.reportCodeChange();
        }
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
        NodeTraversal.traverse(this.compiler, scriptRoot, new RenameReferences());
        LoopClosureTransformer transformer = new LoopClosureTransformer();
        NodeTraversal.traverse(this.compiler, scriptRoot, transformer);
        transformer.transformLoopClosure();
        if (!this.letConsts.isEmpty()) {
            for (Node n : this.letConsts) {
                n.setType(118);
            }
            this.compiler.reportCodeChange();
        }
    }

    private class LoopClosureTransformer
    extends NodeTraversal.AbstractPostOrderCallback {
        private static final String LOOP_OBJECT_NAME = "$jscomp$loop";
        private final Map<Node, LoopObject> loopObjectMap = new LinkedHashMap<Node, LoopObject>();
        private final Multimap<Node, LoopObject> functionLoopObjectsMap = LinkedHashMultimap.create();
        private final Multimap<Node, String> functionHandledMap = HashMultimap.create();
        private final Multimap<Scope.Var, Node> referenceMap = LinkedHashMultimap.create();

        private LoopClosureTransformer() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            String name = n.getString();
            Scope referencedIn = t.getScope();
            Scope.Var var = referencedIn.getVar(name);
            if (var == null) {
                return;
            }
            if (!var.isLet() && !var.isConst()) {
                return;
            }
            Scope declaredIn = var.getScope();
            Node loopNode = null;
            Scope s = declaredIn;
            while (true) {
                Node scopeRoot = s.getRootNode();
                if (NodeUtil.isLoopStructure(s.getRootNode())) {
                    loopNode = scopeRoot;
                    break;
                }
                if (scopeRoot.getParent() != null && NodeUtil.isLoopStructure(scopeRoot.getParent())) {
                    loopNode = scopeRoot.getParent();
                    break;
                }
                if (s.isFunctionBlockScope() || s.isGlobal()) {
                    return;
                }
                s = s.getParent();
            }
            this.referenceMap.put((Object)var, (Object)n);
            for (s = referencedIn; s != declaredIn; s = s.getParent()) {
                if (!s.isFunctionBlockScope()) continue;
                Node function = s.getRootNode().getParent();
                if (this.functionHandledMap.get((Object)function).contains(name)) {
                    return;
                }
                this.functionHandledMap.put((Object)function, (Object)name);
                if (!this.loopObjectMap.containsKey(loopNode)) {
                    this.loopObjectMap.put(loopNode, new LoopObject(Es6RewriteLetConst.this.newUniqueName(LOOP_OBJECT_NAME)));
                }
                LoopObject object = this.loopObjectMap.get(loopNode);
                object.vars.add(var);
                this.functionLoopObjectsMap.put((Object)function, (Object)object);
                return;
            }
        }

        private void transformLoopClosure() {
            if (this.loopObjectMap.isEmpty()) {
                return;
            }
            for (Node loopNode : this.loopObjectMap.keySet()) {
                LoopObject object = this.loopObjectMap.get(loopNode);
                Node objectLit = IR.objectlit(new Node[0]);
                Node objectLitNextIteration = IR.objectlit(new Node[0]);
                for (Scope.Var var : object.vars) {
                    objectLit.addChildToBack(IR.stringKey(var.name, IR.name("undefined")));
                    objectLitNextIteration.addChildToBack(IR.stringKey(var.name, IR.getprop(IR.name(object.name), IR.string(var.name))));
                }
                Node updateLoopObject = IR.assign(IR.name(object.name), objectLitNextIteration);
                loopNode.getParent().addChildBefore(IR.var(IR.name(object.name), objectLit).useSourceInfoIfMissingFromForTree(loopNode), loopNode);
                if (NodeUtil.isVanillaFor(loopNode)) {
                    Node increment;
                    Node initializer = loopNode.getFirstChild();
                    loopNode.replaceChild(initializer, IR.empty());
                    if (!initializer.isEmpty()) {
                        loopNode.getParent().addChildBefore(initializer, loopNode);
                    }
                    if ((increment = loopNode.getChildAtIndex(2)).isEmpty()) {
                        loopNode.replaceChild(increment, updateLoopObject.useSourceInfoIfMissingFromForTree(loopNode));
                    } else {
                        Node placeHolder = IR.empty();
                        loopNode.replaceChild(increment, placeHolder);
                        loopNode.replaceChild(placeHolder, IR.comma(updateLoopObject, increment).useSourceInfoIfMissingFromForTree(loopNode));
                    }
                } else if (loopNode.isDo()) {
                    loopNode.getFirstChild().addChildToBack(IR.exprResult(updateLoopObject).useSourceInfoIfMissingFromForTree(loopNode));
                } else {
                    loopNode.getLastChild().addChildToBack(IR.exprResult(updateLoopObject).useSourceInfoIfMissingFromForTree(loopNode));
                }
                for (Scope.Var var : object.vars) {
                    for (Node reference : this.referenceMap.get((Object)var)) {
                        if (NodeUtil.isEnhancedFor(loopNode) && loopNode.getFirstChild() == reference.getParent()) {
                            loopNode.getLastChild().addChildToFront(IR.exprResult(IR.assign(IR.getprop(IR.name(object.name), IR.string(var.name)), IR.name(var.name))).useSourceInfoIfMissingFromForTree(reference));
                            continue;
                        }
                        if (NodeUtil.isNameDeclaration(reference.getParent())) {
                            Node grandParent = reference.getParent().getParent();
                            Node declaration = reference.getParent();
                            if (declaration.getChildCount() > 1) {
                                for (int i = 1; i < declaration.getChildCount(); ++i) {
                                    Node name = declaration.getChildAtIndex(i);
                                    grandParent.addChildAfter(IR.nameDeclaration(name.detachFromParent(), declaration.getType()).useSourceInfoIfMissingFromForTree(declaration), declaration);
                                }
                            }
                            if (reference.hasChildren()) {
                                declaration = reference.getParent();
                                Node newReference = IR.name(var.name);
                                Node replacement = IR.exprResult(IR.assign(newReference, reference.removeFirstChild())).useSourceInfoIfMissingFromForTree(declaration);
                                grandParent.replaceChild(declaration, replacement);
                                reference = newReference;
                            } else {
                                grandParent.removeChild(declaration);
                            }
                        }
                        reference.getParent().replaceChild(reference, IR.getprop(IR.name(object.name), IR.string(var.name)).useSourceInfoIfMissingFromForTree(reference));
                    }
                }
            }
            for (Node function : this.functionLoopObjectsMap.keySet()) {
                Node returnNode = IR.returnNode();
                Collection objects = this.functionLoopObjectsMap.get((Object)function);
                Node[] objectNames = new Node[objects.size()];
                Node[] objectNamesForCall = new Node[objects.size()];
                int i = 0;
                for (LoopObject object : objects) {
                    objectNames[i] = IR.name(object.name);
                    objectNamesForCall[i] = IR.name(object.name);
                    ++i;
                }
                Node iife = IR.function(IR.name(""), IR.paramList(objectNames), IR.block(returnNode));
                Node call = IR.call(iife, objectNamesForCall);
                call.putBooleanProp(50, true);
                function.getParent().replaceChild(function, call.useSourceInfoIfMissingFromForTree(function));
                returnNode.addChildToFront(function);
            }
        }

        private class LoopObject {
            private final String name;
            private final Set<Scope.Var> vars = new LinkedHashSet<Scope.Var>();

            private LoopObject(String name) {
                this.name = name;
            }
        }
    }

    private class RenameReferences
    extends NodeTraversal.AbstractPostOrderCallback {
        private RenameReferences() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!NodeUtil.isReferenceName(n)) {
                return;
            }
            Scope referencedIn = t.getScope();
            String oldName = n.getString();
            boolean doRename = false;
            String newName = null;
            for (Scope current = referencedIn; current != null; current = current.getParent()) {
                Map renamesAtCurrentLevel = (Map)Es6RewriteLetConst.this.renameMap.get(current.getRootNode());
                if (current.isDeclared(oldName, false)) {
                    return;
                }
                if (renamesAtCurrentLevel == null || !renamesAtCurrentLevel.containsKey(oldName)) continue;
                doRename = true;
                newName = (String)renamesAtCurrentLevel.get(oldName);
                break;
            }
            if (doRename) {
                n.setString(newName);
                t.getCompiler().reportCodeChange();
            }
        }
    }
}

