/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;

public class Es6ToEs3ClassSideInheritance
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    final AbstractCompiler compiler;
    private final Multimap<Scope.Var, String> staticMembers = ArrayListMultimap.create();

    public Es6ToEs3ClassSideInheritance(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new FindStaticMembers());
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (!n.isCall()) {
            return;
        }
        if (n.getFirstChild().matchesQualifiedName("$jscomp$copy$properties")) {
            Node superClassName = n.getLastChild();
            Node subClassName = n.getChildBefore(superClassName);
            Scope.Var key = nodeTraversal.getScope().getVar(superClassName.getQualifiedName());
            if (this.staticMembers.containsKey((Object)key)) {
                for (String staticMember : this.staticMembers.get((Object)key)) {
                    Node sAssign = IR.exprResult(IR.assign(IR.getprop(subClassName.detachFromParent(), IR.string(staticMember)), IR.getprop(superClassName.detachFromParent(), IR.string(staticMember))));
                    sAssign.useSourceInfoIfMissingFromForTree(n);
                    parent.getParent().addChildAfter(sAssign, parent);
                    this.staticMembers.put((Object)nodeTraversal.getScope().getVar(subClassName.getQualifiedName()), (Object)staticMember);
                }
                parent.detachFromParent();
            }
        }
    }

    private class FindStaticMembers
    extends NodeTraversal.AbstractPostOrderCallback {
        private FindStaticMembers() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node n, Node parent) {
            JSDocInfo classInfo;
            if (!(n.isAssign() && n.hasChildren() && n.getFirstChild().isGetProp())) {
                return;
            }
            Node potentialClassName = n.getFirstChild().getFirstChild();
            Scope.Var potentialClassDecl = nodeTraversal.getScope().getVar(potentialClassName.getQualifiedName());
            if (potentialClassDecl != null && potentialClassDecl.getNode().getParent() != null && potentialClassDecl.getNode().getParent().getJSDocInfo() != null && (classInfo = potentialClassDecl.getNode().getParent().getJSDocInfo()).isConstructor() && n.getLastChild().isFunction()) {
                Es6ToEs3ClassSideInheritance.this.staticMembers.put((Object)potentialClassDecl, (Object)n.getFirstChild().getLastChild().getString());
            }
        }
    }
}

