/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6RewriteLetConst;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.List;

public class Es6ToEs3Converter
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    static final DiagnosticType CANNOT_CONVERT = DiagnosticType.error("JSC_CANNOT_CONVERT", "This code cannot be converted from ES6 to ES3. {0}");
    static final DiagnosticType CANNOT_CONVERT_YET = DiagnosticType.error("JSC_CANNOT_CONVERT_YET", "ES6-to-ES3 conversion of ''{0}'' is not yet implemented.");
    static final DiagnosticType DYNAMIC_EXTENDS_TYPE = DiagnosticType.error("JSC_DYNAMIC_EXTENDS_TYPE", "The class in an extends clause must be a qualified name.");
    static final DiagnosticType NO_SUPERTYPE = DiagnosticType.error("JSC_NO_SUPERTYPE", "The super keyword may only appear in classes with an extends clause.");
    static final DiagnosticType CLASS_REASSIGNMENT = DiagnosticType.error("CLASS_REASSIGNMENT", "Class names defined inside a function cannot be reassigned.");
    private static final String THIS_VAR = "$jscomp$this";
    private static final String FRESH_SPREAD_VAR = "$jscomp$spread$args";
    private int freshSpreadVarCounter = 0;
    private static final String FRESH_COMP_PROP_VAR = "$jscomp$compprop";
    private int freshPropVarCounter = 0;
    private static final String FRESH_CLASS_NAME_BASE = "$jscomp$unique$class$";
    public static final String COPY_PROP = "$jscomp$copy$properties";
    private static final String INHERITS = "$jscomp$inherits";

    public Es6ToEs3Converter(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
        new Es6RewriteLetConst(this.compiler).process(externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
        new Es6RewriteLetConst(this.compiler).hotSwapScript(scriptRoot, originalRoot);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 105: {
                if (!n.isArrowFunction()) break;
                this.visitArrowFunction(t, n);
                break;
            }
            case 42: {
                this.visitThis(n, parent);
                break;
            }
            case 158: {
                this.checkClassSuperReferences(n);
                break;
            }
            case 156: 
            case 157: 
            case 163: 
            case 175: {
                this.cannotConvertYet(n, Token.name(n.getType()));
                return false;
            }
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        block0 : switch (n.getType()) {
            case 64: {
                for (Node child : n.children()) {
                    if (!child.isComputedProp()) continue;
                    this.visitObjectWithComputedProperty(n, parent);
                    break block0;
                }
                break;
            }
            case 160: {
                if (!parent.isObjectLit()) break;
                this.visitMemberDefInObjectLit(n, parent);
                break;
            }
            case 161: {
                this.visitSuper(n);
                break;
            }
            case 154: {
                this.visitStringKey(n);
                break;
            }
            case 158: {
                this.visitClass(n, parent);
                break;
            }
            case 83: {
                this.visitParamList(n, parent);
                break;
            }
            case 30: 
            case 37: 
            case 63: {
                for (Node child : n.children()) {
                    if (!child.isSpread()) continue;
                    this.visitArrayLitOrCallWithSpread(n, parent);
                    break block0;
                }
                break;
            }
            case 177: {
                this.visitTemplateLiteral(t, n);
            }
        }
    }

    private void visitMemberDefInObjectLit(Node n, Node parent) {
        String name = n.getString();
        Node stringKey = IR.stringKey(name, n.getFirstChild().detachFromParent());
        parent.replaceChild(n, stringKey);
        this.compiler.reportCodeChange();
    }

    private void visitStringKey(Node n) {
        if (!n.hasChildren()) {
            Node name = IR.name(n.getString());
            name.copyInformationFrom(n);
            n.addChildToBack(name);
            this.compiler.reportCodeChange();
        }
    }

    private void visitThis(Node node, Node parent) {
        Node enclosingMemberDef = NodeUtil.getEnclosingClassMember(node);
        if (enclosingMemberDef == null) {
            return;
        }
        Node enclosingClass = NodeUtil.getEnclosingClass(node);
        if (enclosingMemberDef.isStaticMember()) {
            parent.replaceChild(node, IR.name(NodeUtil.getClassName(enclosingClass)).srcref(node));
        }
    }

    private void checkClassReassignment(Node clazz) {
        Node enclosingFunction = Es6ToEs3Converter.getEnclosingFunction(clazz);
        if (enclosingFunction == null) {
            return;
        }
        Node name = NodeUtil.getClassNameNode(clazz);
        CheckClassAssignments checkAssigns = new CheckClassAssignments(name);
        NodeTraversal.traverse(this.compiler, enclosingFunction, checkAssigns);
    }

    private void visitSuper(Node node) {
        Node methodName;
        Node enclosing = node.getParent();
        Node potentialCallee = node;
        if (!enclosing.isCall()) {
            enclosing = enclosing.getParent();
            potentialCallee = potentialCallee.getParent();
        }
        if (!enclosing.isCall() || enclosing.getFirstChild() != potentialCallee) {
            this.cannotConvertYet(node, "Only calls to super or to a method of super are supported.");
            return;
        }
        Node clazz = NodeUtil.getEnclosingClass(node);
        if (clazz == null) {
            this.compiler.report(JSError.make(node, NO_SUPERTYPE, new String[0]));
            return;
        }
        if (NodeUtil.getClassNameNode(clazz) == null) {
            return;
        }
        Node callName = enclosing.removeFirstChild();
        if (callName.isSuper()) {
            Node enclosingMember = NodeUtil.getEnclosingClassMember(enclosing);
            methodName = IR.string(enclosingMember.getString()).srcref(enclosing);
        } else {
            methodName = IR.string(callName.getLastChild().getString()).srcref(enclosing);
        }
        boolean inFunction = Es6ToEs3Converter.isInFunction(clazz);
        String uniqueClassString = inFunction ? NodeUtil.getClassName(clazz) : Es6ToEs3Converter.getUniqueClassName(NodeUtil.getClassName(clazz));
        Node uniqueClassName = IR.name(uniqueClassString);
        Node base = IR.getprop(uniqueClassName.srcref(enclosing), IR.string("base").srcref(enclosing)).srcref(enclosing);
        enclosing.addChildToFront(methodName);
        enclosing.addChildToFront(IR.thisNode().srcref(enclosing));
        enclosing.addChildToFront(base);
        enclosing.putBooleanProp(50, false);
        this.compiler.reportCodeChange();
    }

    private void visitParamList(Node paramList, Node function) {
        Node insertSpot = null;
        Node block = function.getLastChild();
        for (int i = 0; i < paramList.getChildCount(); ++i) {
            Node param = paramList.getChildAtIndex(i);
            if (param.hasChildren()) {
                param.setOptionalArg(true);
                Node defaultValue = param.removeFirstChild();
                Node name = IR.name(param.getString());
                Node undefined = IR.name("undefined");
                Node stm = IR.exprResult(IR.and(IR.sheq(name, undefined), IR.assign(name.cloneNode(), defaultValue)));
                block.addChildAfter(stm.useSourceInfoIfMissingFromForTree(param), insertSpot);
                insertSpot = stm;
                this.compiler.reportCodeChange();
                continue;
            }
            if (!param.isRest()) continue;
            param.setType(38);
            param.setVarArgs(true);
            Node newArr = IR.exprResult(IR.assign(IR.name(param.getString()), IR.call(IR.getprop(IR.getprop(IR.arraylit(new Node[0]), IR.string("slice")), IR.string("call")), IR.name("arguments"), IR.number(i))));
            block.addChildAfter(newArr.useSourceInfoIfMissingFromForTree(param), insertSpot);
            this.compiler.reportCodeChange();
        }
    }

    private void visitArrayLitOrCallWithSpread(Node node, Node parent) {
        Preconditions.checkArgument((node.isCall() || node.isArrayLit() || node.isNew() ? 1 : 0) != 0);
        ArrayList<Node> groups = new ArrayList<Node>();
        Node currGroup = null;
        Node callee = node.isArrayLit() ? null : node.removeFirstChild();
        Node currElement = node.removeFirstChild();
        while (currElement != null) {
            if (currElement.isSpread()) {
                if (currGroup != null) {
                    groups.add(currGroup);
                    currGroup = null;
                }
                groups.add(currElement.removeFirstChild());
            } else {
                if (currGroup == null) {
                    currGroup = IR.arraylit(new Node[0]);
                }
                currGroup.addChildToBack(currElement);
            }
            currElement = node.removeFirstChild();
        }
        if (currGroup != null) {
            groups.add(currGroup);
        }
        Node result = null;
        Node joinedGroups = IR.call(IR.getprop(IR.arraylit(new Node[0]), IR.string("concat")), groups.toArray(new Node[groups.size()]));
        if (node.isArrayLit()) {
            result = joinedGroups;
        } else if (node.isCall()) {
            if (NodeUtil.mayHaveSideEffects(callee) && callee.isGetProp()) {
                Node statement = node;
                while (!NodeUtil.isStatement(statement)) {
                    statement = statement.getParent();
                }
                Node freshVar = IR.name(FRESH_SPREAD_VAR + this.freshSpreadVarCounter++);
                Node n = IR.var(freshVar.cloneTree());
                n.useSourceInfoIfMissingFromForTree(statement);
                statement.getParent().addChildBefore(n, statement);
                callee.addChildToFront(IR.assign(freshVar.cloneTree(), callee.removeFirstChild()));
                result = IR.call(IR.getprop(callee, IR.string("apply")), freshVar, joinedGroups);
            } else {
                Node context = callee.isGetProp() ? callee.getFirstChild().cloneTree() : IR.nullNode();
                result = IR.call(IR.getprop(callee, IR.string("apply")), context, joinedGroups);
            }
        } else {
            Node bindApply = NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), "Function.prototype.bind.apply");
            result = IR.newNode(bindApply, callee, joinedGroups);
        }
        result.useSourceInfoIfMissingFromForTree(node);
        parent.replaceChild(node, result);
        this.compiler.reportCodeChange();
    }

    private void visitObjectWithComputedProperty(Node obj, Node parent) {
        Preconditions.checkArgument((boolean)obj.isObjectLit());
        List props = new ArrayList<Node>();
        Node currElement = obj.getFirstChild();
        while (currElement != null) {
            if (currElement.isGetterDef() || currElement.isSetterDef()) {
                currElement = currElement.getNext();
                continue;
            }
            Node nextNode = currElement.getNext();
            obj.removeChild(currElement);
            props.add(currElement);
            currElement = nextNode;
        }
        String objName = FRESH_COMP_PROP_VAR + this.freshPropVarCounter++;
        props = Lists.reverse(props);
        Node result = IR.name(objName);
        for (Node propdef : props) {
            if (propdef.isComputedProp()) {
                Node propertyExpression = propdef.removeFirstChild();
                Node value = propdef.removeFirstChild();
                result = IR.comma(IR.assign(IR.getelem(IR.name(objName), propertyExpression), value), result);
                continue;
            }
            if (!propdef.hasChildren()) {
                Node name = IR.name(propdef.getString()).copyInformationFrom(propdef);
                propdef.addChildToBack(name);
            }
            Node val = propdef.removeFirstChild();
            propdef.setType(40);
            int type = propdef.isQuotedString() ? 35 : 33;
            Node access = new Node(type, IR.name(objName), propdef);
            result = IR.comma(IR.assign(access, val), result);
        }
        Node statement = obj;
        while (!NodeUtil.isStatement(statement)) {
            statement = statement.getParent();
        }
        result.useSourceInfoIfMissingFromForTree(obj);
        parent.replaceChild(obj, result);
        Node var = IR.var(IR.name(objName), obj);
        var.useSourceInfoIfMissingFromForTree(statement);
        statement.getParent().addChildBefore(var, statement);
        this.compiler.reportCodeChange();
    }

    private void checkClassSuperReferences(Node classNode) {
        Node className = classNode.getFirstChild();
        Node superClassName = className.getNext();
        if (NodeUtil.referencesSuper(classNode) && superClassName.isEmpty()) {
            this.compiler.report(JSError.make(classNode, NO_SUPERTYPE, new String[0]));
        }
    }

    private void visitClass(Node classNode, Node parent) {
        Node var;
        JSDocInfo classJSDoc;
        Node insertionPoint;
        boolean anonymous;
        this.checkClassReassignment(classNode);
        Node className = classNode.getFirstChild();
        Node superClassName = className.getNext();
        Node classMembers = classNode.getLastChild();
        if (!superClassName.isEmpty() && !superClassName.isQualifiedName()) {
            this.compiler.report(JSError.make(superClassName, DYNAMIC_EXTENDS_TYPE, new String[0]));
            return;
        }
        String fullClassName = null;
        if (NodeUtil.isStatement(classNode)) {
            fullClassName = className.getString();
            anonymous = false;
            insertionPoint = classNode;
        } else if (parent.isAssign() && parent.getParent().isExprResult()) {
            fullClassName = parent.getFirstChild().getQualifiedName();
            if (fullClassName == null) {
                this.cannotConvert(parent, "Can only convert classes that are declarations or the right hand side of a simple assignment.");
                return;
            }
            anonymous = true;
            insertionPoint = parent.getParent();
        } else if (parent.isName()) {
            fullClassName = parent.getString();
            anonymous = true;
            insertionPoint = parent.getParent();
        } else {
            this.cannotConvert(parent, "Can only convert classes that are declarations or the right hand side of a simple assignment.");
            return;
        }
        boolean useUnique = NodeUtil.isStatement(classNode) && !Es6ToEs3Converter.isInFunction(classNode);
        String uniqueFullClassName = useUnique ? Es6ToEs3Converter.getUniqueClassName(fullClassName) : fullClassName;
        String superClassString = superClassName.getQualifiedName();
        Verify.verify((boolean)NodeUtil.isStatement(insertionPoint));
        className.detachFromParent();
        Node constructor = null;
        JSDocInfo ctorJSDocInfo = null;
        for (Node member : classMembers.children()) {
            if (member.getString().equals("constructor")) {
                ctorJSDocInfo = member.getJSDocInfo();
                constructor = member.getFirstChild().detachFromParent();
                if (anonymous) continue;
                constructor.replaceChild(constructor.getFirstChild(), className);
                continue;
            }
            String qualifiedMemberName = member.isStaticMember() ? Joiner.on((String)".").join((Object)uniqueFullClassName, (Object)member.getString(), new Object[0]) : Joiner.on((String)".").join((Object)uniqueFullClassName, (Object)"prototype", new Object[]{member.getString()});
            Node assign = IR.assign(NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), qualifiedMemberName, member, member.getString()), member.getFirstChild().detachFromParent());
            assign.srcref(member);
            JSDocInfo info = member.getJSDocInfo();
            if (info != null) {
                info.setAssociatedNode(assign);
                assign.setJSDocInfo(info);
            }
            Node newNode = NodeUtil.newExpr(assign);
            insertionPoint.getParent().addChildAfter(newNode, insertionPoint);
            insertionPoint = newNode;
        }
        if (constructor == null) {
            Node name = anonymous ? IR.name("").srcref(className) : className;
            constructor = IR.function(name, IR.paramList().srcref(classNode), IR.block().srcref(classNode));
        }
        JSDocInfoBuilder newInfo = (classJSDoc = classNode.getJSDocInfo()) != null ? JSDocInfoBuilder.copyFrom(classJSDoc) : new JSDocInfoBuilder(true);
        newInfo.recordConstructor();
        if (!superClassName.isEmpty()) {
            if (newInfo.isInterfaceRecorded()) {
                newInfo.recordExtendedInterface(new JSTypeExpression(new Node(306, IR.string(superClassString)), superClassName.getSourceFileName()));
            } else {
                Node inherits = IR.call(IR.name(INHERITS), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), fullClassName), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), superClassString));
                inherits.putBooleanProp(50, true);
                Node inheritsCall = IR.exprResult(inherits);
                inheritsCall.useSourceInfoIfMissingFromForTree(classNode);
                Node enclosingStatement = NodeUtil.getEnclosingStatement(classNode);
                enclosingStatement.getParent().addChildAfter(inheritsCall, enclosingStatement);
                newInfo.recordBaseType(new JSTypeExpression(new Node(306, IR.string(superClassString)), superClassName.getSourceFileName()));
                Node copyProps = IR.call(IR.name(COPY_PROP).srcref(classNode), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), fullClassName), NodeUtil.newQualifiedNameNode(this.compiler.getCodingConvention(), superClassString));
                copyProps.useSourceInfoIfMissingFromForTree(classNode);
                copyProps.putBooleanProp(50, true);
                enclosingStatement.getParent().addChildAfter(IR.exprResult(copyProps).srcref(classNode), inheritsCall);
            }
        }
        if (!(newInfo.isUnrestrictedRecorded() || newInfo.isDictRecorded() || newInfo.isStructRecorded())) {
            newInfo.recordStruct();
        }
        if (ctorJSDocInfo != null) {
            newInfo.recordSuppressions(ctorJSDocInfo.getSuppressions());
            for (String param : ctorJSDocInfo.getParameterNames()) {
                newInfo.recordParameter(param, ctorJSDocInfo.getParameterType(param));
            }
        }
        if (useUnique) {
            constructor.removeFirstChild();
            Node uniqueName = IR.name(uniqueFullClassName);
            constructor = IR.var(uniqueName.cloneTree(), IR.function(IR.name(""), constructor.removeFirstChild(), constructor.removeFirstChild()));
            constructor.useSourceInfoIfMissingFromForTree(classNode);
            constructor.setJSDocInfo(newInfo.build(constructor));
            newInfo = JSDocInfoBuilder.copyFrom(constructor.getJSDocInfo());
            Node reassign = IR.var(IR.name(fullClassName), uniqueName);
            reassign.useSourceInfoIfMissingFromForTree(classNode);
            classNode.getParent().addChildAfter(reassign, classNode);
            insertionPoint = reassign;
        } else {
            insertionPoint = constructor;
        }
        if (NodeUtil.isStatement(classNode) && Es6ToEs3Converter.isInFunction(classNode)) {
            Node ctorVar = IR.var(IR.name(fullClassName), constructor);
            ctorVar.useSourceInfoIfMissingFromForTree(classNode);
            parent.replaceChild(classNode, ctorVar);
        } else {
            parent.replaceChild(classNode, constructor);
        }
        if (NodeUtil.isStatement(constructor)) {
            insertionPoint.setJSDocInfo(newInfo.build(insertionPoint));
        } else if (parent.isName()) {
            var = parent.getParent();
            var.setJSDocInfo(newInfo.build(var));
        } else if (constructor.getParent().isName()) {
            var = constructor.getParent().getParent();
            var.setJSDocInfo(newInfo.build(var));
        } else if (parent.isAssign()) {
            parent.setJSDocInfo(newInfo.build(parent));
        } else {
            throw new IllegalStateException("Unexpected parent node " + parent);
        }
        this.compiler.reportCodeChange();
    }

    private void visitArrowFunction(NodeTraversal t, Node n) {
        n.setIsArrowFunction(false);
        Node body = n.getLastChild();
        if (!body.isBlock()) {
            body.detachFromParent();
            Node newBody = IR.block(IR.returnNode(body).srcref(body)).srcref(body);
            n.addChildToBack(newBody);
        }
        UpdateThisNodes thisUpdater = new UpdateThisNodes();
        NodeTraversal.traverse(this.compiler, body, thisUpdater);
        if (thisUpdater.changed) {
            this.addThisVar(t);
        }
        this.compiler.reportCodeChange();
    }

    private void addThisVar(NodeTraversal t) {
        Scope scope = t.getScope();
        if (scope.isDeclared(THIS_VAR, false)) {
            return;
        }
        Node parent = t.getScopeRoot();
        if (parent.isFunction()) {
            parent = parent.getLastChild();
        }
        if (parent.isSyntheticBlock()) {
            parent = parent.getFirstChild();
        }
        Node name = IR.name(THIS_VAR).srcref(parent);
        Node thisVar = IR.var(name, IR.thisNode().srcref(parent));
        thisVar.srcref(parent);
        parent.addChildToFront(thisVar);
        scope.declare(THIS_VAR, name, null, this.compiler.getInput(parent.getInputId()));
    }

    private static String getUniqueClassName(String qualifiedName) {
        return (FRESH_CLASS_NAME_BASE + qualifiedName).replace(".", "$");
    }

    private static Node getEnclosingFunction(Node n) {
        return NodeUtil.getEnclosingType(n, 105);
    }

    private static boolean isInFunction(Node n) {
        return Es6ToEs3Converter.getEnclosingFunction(n) != null;
    }

    private void visitTemplateLiteral(NodeTraversal t, Node n) {
        if (!n.getFirstChild().isName()) {
            this.createDefaultTemplateLiteral(n);
        } else {
            this.cannotConvertYet(n, "Tagged template literals are not supported yet.");
        }
        this.compiler.reportCodeChange();
    }

    private void createDefaultTemplateLiteral(Node n) {
        int length = n.getChildCount();
        if (length == 0) {
            n.getParent().replaceChild(n, IR.string("\"\""));
        } else {
            Node first = n.removeFirstChild();
            if (length == 1) {
                n.getParent().replaceChild(n, first);
            } else {
                Node add = IR.add(first, n.removeFirstChild().removeFirstChild());
                for (int i = 2; i < length; ++i) {
                    Node child = n.removeFirstChild();
                    if (child.isString()) {
                        if (child.getString().isEmpty()) continue;
                        if (i == 2 && first.getString().isEmpty()) {
                            add = add.getChildAtIndex(1).detachFromParent();
                        }
                    }
                    add = IR.add(add, child.isString() ? child : child.removeFirstChild());
                }
                n.getParent().replaceChild(n, add.useSourceInfoIfMissingFromForTree(n));
            }
        }
    }

    private void cannotConvert(Node n, String message) {
        this.compiler.report(JSError.make(n, CANNOT_CONVERT, message));
    }

    private void cannotConvertYet(Node n, String feature) {
        this.compiler.report(JSError.make(n, CANNOT_CONVERT_YET, feature));
    }

    private class CheckClassAssignments
    extends NodeTraversal.AbstractPostOrderCallback {
        private Node className;

        public CheckClassAssignments(Node className) {
            this.className = className;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isAssign() || n.getFirstChild() == this.className) {
                return;
            }
            if (this.className.matchesQualifiedName(n.getFirstChild())) {
                Es6ToEs3Converter.this.compiler.report(JSError.make(n, CLASS_REASSIGNMENT, new String[0]));
            }
        }
    }

    private static class UpdateThisNodes
    implements NodeTraversal.Callback {
        private boolean changed = false;

        private UpdateThisNodes() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isThis()) {
                Node name = IR.name(Es6ToEs3Converter.THIS_VAR).srcref(n);
                parent.replaceChild(n, name);
                this.changed = true;
            }
        }

        @Override
        public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
            return !n.isFunction() || n.isArrowFunction();
        }
    }
}

