/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.VarCheck;
import com.google.javascript.rhino.Node;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class VariableReferenceCheck
implements HotSwapCompilerPass {
    static final DiagnosticType UNDECLARED_REFERENCE = DiagnosticType.warning("JSC_REFERENCE_BEFORE_DECLARE", "Variable referenced before declaration: {0}");
    static final DiagnosticType REDECLARED_VARIABLE = DiagnosticType.warning("JSC_REDECLARED_VARIABLE", "Redeclared variable: {0}");
    static final DiagnosticType AMBIGUOUS_FUNCTION_DECL = DiagnosticType.disabled("AMBIGUOUS_FUNCTION_DECL", "Ambiguous use of a named function: {0}.");
    static final DiagnosticType UNDECLARED_REFERENCE_ERROR = DiagnosticType.error("JSC_REFERENCE_BEFORE_DECLARE_ERROR", "Illegal variable reference before declaration: {0}");
    static final DiagnosticType REASSIGNED_CONSTANT = DiagnosticType.error("JSC_REASSIGNED_CONSTANT", "Constant reassigned: {0}");
    static final DiagnosticType REDECLARED_VARIABLE_ERROR = DiagnosticType.error("JSC_REDECLARED_VARIABLE_ERROR", "Redeclared variable: {0}");
    static final DiagnosticType PARAMETER_SHADOWED_ERROR = DiagnosticType.error("JSC_PARAMETER_SHADOWED_ERROR", "Only var and function declaration can shadow parameters");
    static final DiagnosticType DECLARATION_NOT_DIRECTLY_IN_BLOCK = DiagnosticType.error("JSC_DECLARATION_NOT_DIRECTLY_IN_BLOCK", "Block-scoped declaration not directly within block: {0}");
    private final AbstractCompiler compiler;
    private final CheckLevel checkLevel;
    private final Set<ReferenceCollectingCallback.BasicBlock> blocksWithDeclarations = Sets.newHashSet();

    public VariableReferenceCheck(AbstractCompiler compiler, CheckLevel checkLevel) {
        this.compiler = compiler;
        this.checkLevel = checkLevel;
    }

    @Override
    public void process(Node externs, Node root) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, new ReferenceCheckingBehavior());
        callback.process(externs, root);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        ReferenceCollectingCallback callback = new ReferenceCollectingCallback(this.compiler, new ReferenceCheckingBehavior());
        callback.hotSwapScript(scriptRoot, originalRoot);
    }

    private class ReferenceCheckingBehavior
    implements ReferenceCollectingCallback.Behavior {
        private ReferenceCheckingBehavior() {
        }

        @Override
        public void afterExitScope(NodeTraversal t, ReferenceCollectingCallback.ReferenceMap referenceMap) {
            Scope scope = t.getScope();
            Iterator<Scope.Var> it = scope.getVars();
            while (it.hasNext()) {
                Scope.Var v = it.next();
                ReferenceCollectingCallback.ReferenceCollection referenceCollection = referenceMap.getReferences(v);
                if (referenceCollection == null) continue;
                if (scope.isBlockScope() && !scope.isGlobal() && scope.getParent().getRootNode().isFunction()) {
                    this.checkShadowParam(v, scope, referenceCollection.references);
                }
                this.checkVar(v, referenceCollection.references);
            }
        }

        private void checkShadowParam(Scope.Var v, Scope scope, List<ReferenceCollectingCallback.Reference> references) {
            Scope functionScope = scope.getParent();
            Scope.Var maybeParam = functionScope.getVar(v.getName());
            if (maybeParam != null && maybeParam.isParam()) {
                for (ReferenceCollectingCallback.Reference r : references) {
                    if (!r.isDeclaration() || r.getScope() != scope) continue;
                    VariableReferenceCheck.this.compiler.report(JSError.make(NodeUtil.getSourceName(r.getNode()), r.getNode(), VariableReferenceCheck.this.checkLevel, (r.isVarDeclaration() || r.isHoistedFunction()) && !maybeParam.getNode().hasChildren() && !maybeParam.getNode().isRest() ? REDECLARED_VARIABLE : PARAMETER_SHADOWED_ERROR, v.name));
                }
            }
        }

        private void checkVar(Scope.Var v, List<ReferenceCollectingCallback.Reference> references) {
            VariableReferenceCheck.this.blocksWithDeclarations.clear();
            boolean isDeclaredInScope = false;
            boolean isUnhoistedNamedFunction = false;
            ReferenceCollectingCallback.Reference hoistedFn = null;
            for (ReferenceCollectingCallback.Reference reference : references) {
                if (reference.isHoistedFunction()) {
                    VariableReferenceCheck.this.blocksWithDeclarations.add(reference.getBasicBlock());
                    isDeclaredInScope = true;
                    hoistedFn = reference;
                    break;
                }
                if (!NodeUtil.isFunctionDeclaration(reference.getNode().getParent())) continue;
                isUnhoistedNamedFunction = true;
            }
            for (ReferenceCollectingCallback.Reference reference : references) {
                if (reference == hoistedFn) continue;
                ReferenceCollectingCallback.BasicBlock basicBlock = reference.getBasicBlock();
                boolean isDeclaration = reference.isDeclaration();
                Node referenceNode = reference.getNode();
                boolean allowDupe = VarCheck.hasDuplicateDeclarationSuppression(referenceNode, v);
                boolean letConstShadowsVar = v.getParentNode().isVar() && (reference.isLetDeclaration() || reference.isConstDeclaration());
                boolean shadowCatchVar = VariableReferenceCheck.this.compiler.getLanguageMode().isEs6OrHigher() && v.getParentNode().isCatch() && reference.isDeclaration() && reference.getNode() != v.getNode();
                boolean shadowDetected = false;
                if (isDeclaration && !allowDupe) {
                    for (ReferenceCollectingCallback.BasicBlock declaredBlock : VariableReferenceCheck.this.blocksWithDeclarations) {
                        if (!declaredBlock.provablyExecutesBefore(basicBlock)) continue;
                        shadowDetected = true;
                        DiagnosticType diagnosticType = v.isLet() || v.isConst() || letConstShadowsVar || shadowCatchVar ? REDECLARED_VARIABLE_ERROR : REDECLARED_VARIABLE;
                        VariableReferenceCheck.this.compiler.report(JSError.make(NodeUtil.getSourceName(referenceNode), referenceNode, VariableReferenceCheck.this.checkLevel, diagnosticType, v.name));
                        break;
                    }
                }
                if (!shadowDetected && isDeclaration && (letConstShadowsVar || shadowCatchVar) && v.getScope() == reference.getScope()) {
                    VariableReferenceCheck.this.compiler.report(JSError.make(NodeUtil.getSourceName(referenceNode), referenceNode, VariableReferenceCheck.this.checkLevel, REDECLARED_VARIABLE_ERROR, v.name));
                }
                if (isUnhoistedNamedFunction && !isDeclaration && isDeclaredInScope) {
                    for (ReferenceCollectingCallback.BasicBlock declaredBlock : VariableReferenceCheck.this.blocksWithDeclarations) {
                        if (declaredBlock.provablyExecutesBefore(basicBlock)) continue;
                        VariableReferenceCheck.this.compiler.report(JSError.make(NodeUtil.getSourceName(referenceNode), referenceNode, AMBIGUOUS_FUNCTION_DECL, v.name));
                        break;
                    }
                }
                boolean isUndeclaredReference = false;
                if (!(isDeclaration || isDeclaredInScope || referenceNode.isFromExterns())) {
                    Node grandparent = reference.getGrandparent();
                    if (v.isVar() && grandparent.isName() && grandparent.getString().equals(v.name)) continue;
                    if (reference.getScope() == v.scope) {
                        isUndeclaredReference = true;
                        VariableReferenceCheck.this.compiler.report(JSError.make(NodeUtil.getSourceName(referenceNode), reference.getNode(), VariableReferenceCheck.this.checkLevel, v.isLet() || v.isConst() ? UNDECLARED_REFERENCE_ERROR : UNDECLARED_REFERENCE, v.name));
                    }
                }
                if (!isDeclaration && !isUndeclaredReference && v.isConst() && reference.isLvalue()) {
                    VariableReferenceCheck.this.compiler.report(JSError.make(NodeUtil.getSourceName(referenceNode), referenceNode, VariableReferenceCheck.this.checkLevel, REASSIGNED_CONSTANT, v.name));
                }
                if (isDeclaration && !v.isVar() && reference.getGrandparent().isAddedBlock()) {
                    VariableReferenceCheck.this.compiler.report(JSError.make(NodeUtil.getSourceName(referenceNode), referenceNode, VariableReferenceCheck.this.checkLevel, DECLARATION_NOT_DIRECTLY_IN_BLOCK, v.name));
                }
                if (!isDeclaration) continue;
                VariableReferenceCheck.this.blocksWithDeclarations.add(basicBlock);
                isDeclaredInScope = true;
            }
        }
    }
}

