/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.QualifiedName;

abstract class TypeWithProperties {
    TypeWithProperties() {
    }

    protected abstract JSType getProp(QualifiedName var1);

    protected abstract JSType getDeclaredProp(QualifiedName var1);

    protected abstract boolean mayHaveProp(QualifiedName var1);

    protected abstract boolean hasProp(QualifiedName var1);

    protected abstract boolean hasConstantProp(QualifiedName var1);

    static JSType getProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return null;
        }
        JSType ptype = JSType.BOTTOM;
        for (TypeWithProperties t : types) {
            if (!t.mayHaveProp(qname)) continue;
            ptype = JSType.join(ptype, t.getProp(qname));
        }
        return ptype.isBottom() ? null : ptype;
    }

    static JSType getDeclaredProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return null;
        }
        JSType ptype = JSType.BOTTOM;
        for (TypeWithProperties t : types) {
            JSType declType;
            if (!t.mayHaveProp(qname) || (declType = t.getDeclaredProp(qname)) == null) continue;
            ptype = JSType.join(ptype, declType);
        }
        return ptype.isBottom() ? null : ptype;
    }

    static boolean mayHaveProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return false;
        }
        for (TypeWithProperties t : types) {
            if (!t.mayHaveProp(qname)) continue;
            return true;
        }
        return false;
    }

    static boolean hasProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return false;
        }
        for (TypeWithProperties t : types) {
            if (t.hasProp(qname)) continue;
            return false;
        }
        return true;
    }

    static boolean hasConstantProp(ImmutableSet<? extends TypeWithProperties> types, QualifiedName qname) {
        if (types == null) {
            return false;
        }
        for (TypeWithProperties t : types) {
            if (!t.hasConstantProp(qname)) continue;
            return true;
        }
        return false;
    }
}

