/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.ObjectType;

final class UnionType
extends JSType {
    private final int mask;
    private final ImmutableSet<ObjectType> objs;
    private final String typeVar;
    private final ImmutableSet<EnumType> enums;
    private final String location;

    UnionType(int mask, String location, ImmutableSet<ObjectType> objs, String typeVar, ImmutableSet<EnumType> enums) {
        if (enums == null) {
            this.enums = null;
        } else if (enums.isEmpty()) {
            mask &= 0xFFFFFFFB;
            this.enums = null;
        } else {
            mask |= 4;
            this.enums = enums;
        }
        if (objs == null) {
            this.objs = null;
        } else if (objs.isEmpty()) {
            mask &= 0xFFFFFFFD;
            this.objs = null;
        } else {
            mask |= 2;
            this.objs = objs;
        }
        if (typeVar != null) {
            mask |= 1;
        }
        this.typeVar = typeVar;
        this.location = location;
        this.mask = mask;
        Preconditions.checkState((boolean)this.isValidType(), (String)"Cannot create type with bits <<<%s>>>, objs <<<%s>>>, typeVar <<<%s>>>, enums <<<%s>>>", (Object[])new Object[]{mask, objs, typeVar, enums});
    }

    UnionType(int mask) {
        this(mask, null, null, null, null);
    }

    @Override
    protected int getMask() {
        return this.mask;
    }

    @Override
    protected ImmutableSet<ObjectType> getObjs() {
        return this.objs;
    }

    @Override
    protected String getTypeVar() {
        return this.typeVar;
    }

    @Override
    protected ImmutableSet<EnumType> getEnums() {
        return this.enums;
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

