/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.GlobalNamespace;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ReferenceCollectingCallback;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class CollapseProperties
implements CompilerPass {
    static final DiagnosticType UNSAFE_NAMESPACE_WARNING = DiagnosticType.warning("JSC_UNSAFE_NAMESPACE", "incomplete alias created for namespace {0}");
    static final DiagnosticType NAMESPACE_REDEFINED_WARNING = DiagnosticType.warning("JSC_NAMESPACE_REDEFINED", "namespace {0} should not be redefined");
    static final DiagnosticType UNSAFE_THIS = DiagnosticType.warning("JSC_UNSAFE_THIS", "dangerous use of 'this' in static method {0}");
    private AbstractCompiler compiler;
    private List<GlobalNamespace.Name> globalNames;
    private Map<String, GlobalNamespace.Name> nameMap;
    private final boolean collapsePropertiesOnExternTypes;
    private final boolean inlineAliases;

    CollapseProperties(AbstractCompiler compiler, boolean collapsePropertiesOnExternTypes, boolean inlineAliases) {
        this.compiler = compiler;
        this.collapsePropertiesOnExternTypes = collapsePropertiesOnExternTypes;
        this.inlineAliases = inlineAliases;
    }

    @Override
    public void process(Node externs, Node root) {
        GlobalNamespace namespace = this.collapsePropertiesOnExternTypes ? new GlobalNamespace(this.compiler, externs, root) : new GlobalNamespace(this.compiler, root);
        if (this.inlineAliases) {
            this.inlineAliases(namespace);
        }
        this.nameMap = namespace.getNameIndex();
        this.globalNames = namespace.getNameForest();
        this.checkNamespaces();
        for (GlobalNamespace.Name name : this.globalNames) {
            this.flattenReferencesToCollapsibleDescendantNames(name, name.getBaseName());
        }
        for (GlobalNamespace.Name name : this.globalNames) {
            this.collapseDeclarationOfNameAndDescendants(name, name.getBaseName());
        }
    }

    private void inlineAliases(GlobalNamespace namespace) {
        ArrayDeque<GlobalNamespace.Name> workList = new ArrayDeque<GlobalNamespace.Name>(namespace.getNameForest());
        while (!workList.isEmpty()) {
            GlobalNamespace.Name name = (GlobalNamespace.Name)workList.pop();
            if (name.type == GlobalNamespace.Name.Type.GET || name.type == GlobalNamespace.Name.Type.SET) continue;
            if (!name.inExterns && name.globalSets == 1 && name.localSets == 0 && name.aliasingGets > 0) {
                ArrayList refs = Lists.newArrayList(name.getRefs());
                for (GlobalNamespace.Ref ref : refs) {
                    if (ref.type == GlobalNamespace.Ref.Type.ALIASING_GET && ref.scope.isLocal()) {
                        if (!this.inlineAliasIfPossible(ref, namespace)) continue;
                        name.removeRef(ref);
                        continue;
                    }
                    if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET || !ref.scope.isGlobal() || ref.getTwin() != null || !this.inlineGlobalAliasIfPossible(ref, namespace)) continue;
                    name.removeRef(ref);
                }
            }
            if (name.type != GlobalNamespace.Name.Type.OBJECTLIT && name.type != GlobalNamespace.Name.Type.FUNCTION || name.aliasingGets != 0 || name.props == null) continue;
            workList.addAll(name.props);
        }
    }

    private boolean inlineGlobalAliasIfPossible(GlobalNamespace.Ref alias, GlobalNamespace namespace) {
        GlobalNamespace.Name name;
        Node aliasParent = alias.node.getParent();
        if (aliasParent.isAssign() && NodeUtil.isExecutedExactlyOnce(aliasParent) && aliasParent.getFirstChild().isQualifiedName() && (name = namespace.getSlot(aliasParent.getFirstChild().getQualifiedName())) != null && CollapseProperties.isInlinableGlobalAlias(name)) {
            ArrayList newNodes = Lists.newArrayList();
            ArrayList refs = Lists.newArrayList(name.getRefs());
            block4: for (GlobalNamespace.Ref ref : refs) {
                switch (ref.type) {
                    case SET_FROM_GLOBAL: {
                        continue block4;
                    }
                    case DIRECT_GET: 
                    case ALIASING_GET: {
                        Node newNode = alias.node.cloneTree();
                        Node node = ref.node;
                        node.getParent().replaceChild(node, newNode);
                        newNodes.add(new GlobalNamespace.AstChange(ref.module, ref.scope, newNode));
                        name.removeRef(ref);
                        continue block4;
                    }
                }
                throw new IllegalStateException();
            }
            CollapseProperties.rewriteAliasProps(name, alias.node, 0, newNodes);
            aliasParent.replaceChild(alias.node, IR.nullNode());
            this.compiler.reportCodeChange();
            namespace.scanNewNodes(newNodes);
            return true;
        }
        return false;
    }

    private static void rewriteAliasProps(GlobalNamespace.Name name, Node value, int depth, List<GlobalNamespace.AstChange> newNodes) {
        if (name.props != null) {
            Preconditions.checkState((!value.matchesQualifiedName(name.getFullName()) ? 1 : 0) != 0);
            for (GlobalNamespace.Name prop : name.props) {
                CollapseProperties.rewriteAliasProps(prop, value, depth + 1, newNodes);
                ArrayList refs = Lists.newArrayList(prop.getRefs());
                for (GlobalNamespace.Ref ref : refs) {
                    Node target = ref.node;
                    for (int i = 0; i <= depth; ++i) {
                        if (target.isGetProp()) {
                            target = target.getFirstChild();
                            continue;
                        }
                        if (NodeUtil.isObjectLitKey(target)) {
                            Node gparent = target.getParent().getParent();
                            if (gparent.isAssign()) {
                                target = gparent.getFirstChild();
                                continue;
                            }
                            Preconditions.checkState((boolean)NodeUtil.isObjectLitKey(gparent));
                            target = gparent;
                            continue;
                        }
                        throw new IllegalStateException("unexpected: " + target.toString());
                    }
                    Preconditions.checkState((target.isGetProp() || target.isName() ? 1 : 0) != 0);
                    target.getParent().replaceChild(target, value.cloneTree());
                    prop.removeRef(ref);
                    newNodes.add(new GlobalNamespace.AstChange(ref.module, ref.scope, ref.node));
                }
            }
        }
    }

    private static boolean isInlinableGlobalAlias(GlobalNamespace.Name name) {
        if (name.inExterns || name.globalSets != 1 || name.localSets != 0 || !name.canCollapse()) {
            return false;
        }
        block6: for (GlobalNamespace.Ref ref : name.getRefs()) {
            switch (ref.type) {
                case SET_FROM_GLOBAL: {
                    continue block6;
                }
                case SET_FROM_LOCAL: {
                    throw new IllegalStateException();
                }
                case DIRECT_GET: 
                case ALIASING_GET: {
                    continue block6;
                }
                case PROTOTYPE_GET: 
                case CALL_GET: 
                case DELETE_PROP: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }
        return true;
    }

    private boolean inlineAliasIfPossible(GlobalNamespace.Ref alias, GlobalNamespace namespace) {
        Node aliasParent = alias.node.getParent();
        if (aliasParent.isName()) {
            Scope scope = alias.scope;
            Scope.Var aliasVar = scope.getVar(aliasParent.getString());
            ReferenceCollectingCallback collector = new ReferenceCollectingCallback(this.compiler, ReferenceCollectingCallback.DO_NOTHING_BEHAVIOR, (Predicate<Scope.Var>)Predicates.equalTo((Object)aliasVar));
            collector.processScope(scope);
            ReferenceCollectingCallback.ReferenceCollection aliasRefs = collector.getReferences(aliasVar);
            ArrayList newNodes = Lists.newArrayList();
            if (aliasRefs.isWellDefined() && aliasRefs.firstReferenceIsAssigningDeclaration() && aliasRefs.isAssignedOnceInLifetime()) {
                int size = aliasRefs.references.size();
                for (int i = 1; i < size; ++i) {
                    ReferenceCollectingCallback.Reference aliasRef = aliasRefs.references.get(i);
                    Node newNode = alias.node.cloneTree();
                    aliasRef.getParent().replaceChild(aliasRef.getNode(), newNode);
                    newNodes.add(new GlobalNamespace.AstChange(this.getRefModule(aliasRef), aliasRef.getScope(), newNode));
                }
                aliasParent.replaceChild(alias.node, IR.nullNode());
                this.compiler.reportCodeChange();
                namespace.scanNewNodes(newNodes);
                return true;
            }
        }
        return false;
    }

    JSModule getRefModule(ReferenceCollectingCallback.Reference ref) {
        CompilerInput input = this.compiler.getInput(ref.getInputId());
        return input == null ? null : input.getModule();
    }

    private void checkNamespaces() {
        for (GlobalNamespace.Name name : this.nameMap.values()) {
            if (!name.isNamespace() || name.aliasingGets <= 0 && name.localSets + name.globalSets <= 1 && name.deleteProps <= 0) continue;
            boolean initialized = name.getDeclaration() != null;
            for (GlobalNamespace.Ref ref : name.getRefs()) {
                if (ref == name.getDeclaration()) continue;
                if (ref.type == GlobalNamespace.Ref.Type.DELETE_PROP) {
                    if (!initialized) continue;
                    this.warnAboutNamespaceRedefinition(name, ref);
                    continue;
                }
                if (ref.type == GlobalNamespace.Ref.Type.SET_FROM_GLOBAL || ref.type == GlobalNamespace.Ref.Type.SET_FROM_LOCAL) {
                    if (initialized) {
                        this.warnAboutNamespaceRedefinition(name, ref);
                    }
                    initialized = true;
                    continue;
                }
                if (ref.type != GlobalNamespace.Ref.Type.ALIASING_GET) continue;
                this.warnAboutNamespaceAliasing(name, ref);
            }
        }
    }

    private void warnAboutNamespaceAliasing(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.node, UNSAFE_NAMESPACE_WARNING, nameObj.getFullName()));
    }

    private void warnAboutNamespaceRedefinition(GlobalNamespace.Name nameObj, GlobalNamespace.Ref ref) {
        this.compiler.report(JSError.make(ref.node, NAMESPACE_REDEFINED_WARNING, nameObj.getFullName()));
    }

    private void flattenReferencesToCollapsibleDescendantNames(GlobalNamespace.Name n, String alias) {
        if (n.props == null) {
            return;
        }
        for (GlobalNamespace.Name p : n.props) {
            String propAlias = CollapseProperties.appendPropForAlias(alias, p.getBaseName());
            if (p.canCollapse()) {
                this.flattenReferencesTo(p, propAlias);
            } else if (p.isSimpleStubDeclaration()) {
                this.flattenSimpleStubDeclaration(p, propAlias);
            }
            this.flattenReferencesToCollapsibleDescendantNames(p, propAlias);
        }
    }

    private void flattenSimpleStubDeclaration(GlobalNamespace.Name name, String alias) {
        GlobalNamespace.Ref ref = (GlobalNamespace.Ref)Iterables.getOnlyElement(name.getRefs());
        Node nameNode = NodeUtil.newName(this.compiler.getCodingConvention(), alias, ref.node, name.getFullName());
        Node varNode = IR.var(nameNode).copyInformationFrom(nameNode);
        Preconditions.checkState((boolean)ref.node.getParent().isExprResult());
        Node parent = ref.node.getParent();
        Node gramps = parent.getParent();
        gramps.replaceChild(parent, varNode);
        this.compiler.reportCodeChange();
    }

    private void flattenReferencesTo(GlobalNamespace.Name n, String alias) {
        String originalName = n.getFullName();
        for (GlobalNamespace.Ref r : n.getRefs()) {
            if (r == n.getDeclaration()) continue;
            Node rParent = r.node.getParent();
            if (NodeUtil.isObjectLitKey(r.node) || r.getTwin() != null && !r.isSet()) continue;
            this.flattenNameRef(alias, r.node, rParent, originalName);
        }
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                this.flattenPrefixes(alias, p, 1);
            }
        }
    }

    private void flattenPrefixes(String alias, GlobalNamespace.Name n, int depth) {
        String originalName = n.getFullName();
        GlobalNamespace.Ref decl = n.getDeclaration();
        if (decl != null && decl.node != null && decl.node.isGetProp()) {
            this.flattenNameRefAtDepth(alias, decl.node, depth, originalName);
        }
        for (GlobalNamespace.Ref r : n.getRefs()) {
            if (r == decl || r.getTwin() != null && !r.isSet()) continue;
            this.flattenNameRefAtDepth(alias, r.node, depth, originalName);
        }
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                this.flattenPrefixes(alias, p, depth + 1);
            }
        }
    }

    private void flattenNameRefAtDepth(String alias, Node n, int depth, String originalName) {
        int nType = n.getType();
        boolean isQName = nType == 38 || nType == 33;
        boolean isObjKey = NodeUtil.isObjectLitKey(n);
        Preconditions.checkState((isObjKey || isQName ? 1 : 0) != 0);
        if (isQName) {
            for (int i = 1; i < depth && n.hasChildren(); ++i) {
                n = n.getFirstChild();
            }
            if (n.hasChildren()) {
                this.flattenNameRef(alias, n.getFirstChild(), n, originalName);
            }
        }
    }

    private void flattenNameRef(String alias, Node n, Node parent, String originalName) {
        JSType type;
        Node ref = NodeUtil.newName(this.compiler.getCodingConvention(), alias, n, originalName);
        NodeUtil.copyNameAnnotations(n.getLastChild(), ref);
        if (parent.isCall() && n == parent.getFirstChild()) {
            parent.putBooleanProp(50, true);
        }
        if ((type = n.getJSType()) != null) {
            ref.setJSType(type);
        }
        parent.replaceChild(n, ref);
        this.compiler.reportCodeChange();
    }

    private void collapseDeclarationOfNameAndDescendants(GlobalNamespace.Name n, String alias) {
        boolean canCollapseChildNames = n.canCollapseUnannotatedChildNames();
        if (n.canCollapse()) {
            this.updateObjLitOrFunctionDeclaration(n, alias, canCollapseChildNames);
        }
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                this.collapseDeclarationOfNameAndDescendants(p, CollapseProperties.appendPropForAlias(alias, p.getBaseName()));
                if (p.inExterns || !canCollapseChildNames || p.getDeclaration() == null || !p.canCollapse() || p.getDeclaration().node == null || p.getDeclaration().node.getParent() == null || !p.getDeclaration().node.getParent().isAssign()) continue;
                this.updateSimpleDeclaration(CollapseProperties.appendPropForAlias(alias, p.getBaseName()), p, p.getDeclaration());
            }
        }
    }

    private void updateSimpleDeclaration(String alias, GlobalNamespace.Name refName, GlobalNamespace.Ref ref) {
        Node rvalue = ref.node.getNext();
        Node parent = ref.node.getParent();
        Node gramps = parent.getParent();
        Node greatGramps = gramps.getParent();
        if (rvalue != null && rvalue.isFunction()) {
            this.checkForHosedThisReferences(rvalue, refName.docInfo, refName);
        }
        Node nameNode = NodeUtil.newName(this.compiler.getCodingConvention(), alias, gramps.getFirstChild(), refName.getFullName());
        NodeUtil.copyNameAnnotations(ref.node.getLastChild(), nameNode);
        if (gramps.isExprResult()) {
            parent.removeChild(rvalue);
            nameNode.addChildToFront(rvalue);
            Node varNode = IR.var(nameNode);
            greatGramps.replaceChild(gramps, varNode);
        } else {
            Preconditions.checkNotNull((Object)ref.getTwin());
            Node current = gramps;
            Node currentParent = gramps.getParent();
            while (!currentParent.isScript() && !currentParent.isBlock()) {
                current = currentParent;
                currentParent = currentParent.getParent();
            }
            Node stubVar = IR.var(nameNode.cloneTree()).copyInformationFrom(nameNode);
            currentParent.addChildBefore(stubVar, current);
            parent.replaceChild(ref.node, nameNode);
        }
        this.compiler.reportCodeChange();
    }

    private void updateObjLitOrFunctionDeclaration(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
        GlobalNamespace.Ref decl = n.getDeclaration();
        if (decl == null) {
            return;
        }
        if (decl.getTwin() != null) {
            return;
        }
        switch (decl.node.getParent().getType()) {
            case 86: {
                this.updateObjLitOrFunctionDeclarationAtAssignNode(n, alias, canCollapseChildNames);
                break;
            }
            case 118: {
                this.updateObjLitOrFunctionDeclarationAtVarNode(n, canCollapseChildNames);
                break;
            }
            case 105: {
                this.updateFunctionDeclarationAtFunctionNode(n, canCollapseChildNames);
            }
        }
    }

    private void updateObjLitOrFunctionDeclarationAtAssignNode(GlobalNamespace.Name n, String alias, boolean canCollapseChildNames) {
        GlobalNamespace.Ref ref = n.getDeclaration();
        Node rvalue = ref.node.getNext();
        Node varNode = new Node(118);
        Node varParent = ref.node.getAncestor(3);
        Node gramps = ref.node.getAncestor(2);
        boolean isObjLit = rvalue.isObjectLit();
        boolean insertedVarNode = false;
        if (isObjLit && n.canEliminate()) {
            varParent.replaceChild(gramps, varNode);
            ref.node = null;
            insertedVarNode = true;
        } else if (!n.isSimpleName()) {
            if (rvalue.isFunction()) {
                this.checkForHosedThisReferences(rvalue, n.docInfo, n);
            }
            ref.node.getParent().removeChild(rvalue);
            Node nameNode = NodeUtil.newName(this.compiler.getCodingConvention(), alias, ref.node.getAncestor(2), n.getFullName());
            JSDocInfo info = ref.node.getParent().getJSDocInfo();
            if (ref.node.getLastChild().getBooleanProp(43) || info != null && info.isConstant()) {
                nameNode.putBooleanProp(43, true);
            }
            if (info != null) {
                varNode.setJSDocInfo(info);
            }
            varNode.addChildToBack(nameNode);
            nameNode.addChildToFront(rvalue);
            varParent.replaceChild(gramps, varNode);
            ref.node = nameNode;
            insertedVarNode = true;
        }
        if (canCollapseChildNames) {
            if (isObjLit) {
                this.declareVarsForObjLitValues(n, alias, rvalue, varNode, varParent.getChildBefore(varNode), varParent);
            }
            this.addStubsForUndeclaredProperties(n, alias, varParent, varNode);
        }
        if (insertedVarNode) {
            if (!varNode.hasChildren()) {
                varParent.removeChild(varNode);
            }
            this.compiler.reportCodeChange();
        }
    }

    private void checkForHosedThisReferences(Node function, JSDocInfo docInfo, final GlobalNamespace.Name name) {
        if (docInfo == null || !docInfo.isConstructor() && !docInfo.hasThisType()) {
            NodeTraversal.traverse(this.compiler, function.getLastChild(), new NodeTraversal.AbstractShallowCallback(){

                @Override
                public void visit(NodeTraversal t, Node n, Node parent) {
                    if (n.isThis()) {
                        CollapseProperties.this.compiler.report(JSError.make(n, UNSAFE_THIS, name.getFullName()));
                    }
                }
            });
        }
    }

    private void updateObjLitOrFunctionDeclarationAtVarNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String name = ref.node.getString();
        Node rvalue = ref.node.getFirstChild();
        Node varNode = ref.node.getParent();
        Node gramps = varNode.getParent();
        boolean isObjLit = rvalue.isObjectLit();
        int numChanges = 0;
        if (isObjLit) {
            numChanges += this.declareVarsForObjLitValues(n, name, rvalue, varNode, gramps.getChildBefore(varNode), gramps);
        }
        numChanges += this.addStubsForUndeclaredProperties(n, name, gramps, varNode);
        if (isObjLit && n.canEliminate()) {
            varNode.removeChild(ref.node);
            if (!varNode.hasChildren()) {
                gramps.removeChild(varNode);
            }
            ++numChanges;
            ref.node = null;
        }
        if (numChanges > 0) {
            this.compiler.reportCodeChange();
        }
    }

    private void updateFunctionDeclarationAtFunctionNode(GlobalNamespace.Name n, boolean canCollapseChildNames) {
        if (!canCollapseChildNames) {
            return;
        }
        GlobalNamespace.Ref ref = n.getDeclaration();
        String fnName = ref.node.getString();
        this.addStubsForUndeclaredProperties(n, fnName, ref.node.getAncestor(2), ref.node.getParent());
    }

    private int declareVarsForObjLitValues(GlobalNamespace.Name objlitName, String alias, Node objlit, Node varNode, Node nameToAddAfter, Node varParent) {
        int numVars = 0;
        int arbitraryNameCounter = 0;
        boolean discardKeys = !objlitName.shouldKeepKeys();
        Node key = objlit.getFirstChild();
        while (key != null) {
            Node value = key.getFirstChild();
            Node nextKey = key.getNext();
            if (!key.isGetterDef() && !key.isSetterDef()) {
                boolean isJsIdentifier = !key.isNumber() && TokenStream.isJSIdentifier(key.getString());
                String propName = isJsIdentifier ? key.getString() : String.valueOf(++arbitraryNameCounter);
                String qName = objlitName.getFullName() + '.' + propName;
                GlobalNamespace.Name p = this.nameMap.get(qName);
                if (p == null || p.canCollapse()) {
                    String propAlias = CollapseProperties.appendPropForAlias(alias, propName);
                    Node refNode = null;
                    if (discardKeys) {
                        objlit.removeChild(key);
                        value.detachFromParent();
                    } else {
                        refNode = IR.name(propAlias);
                        if (key.getBooleanProp(43)) {
                            refNode.putBooleanProp(43, true);
                        }
                        key.replaceChild(value, refNode);
                    }
                    Node nameNode = IR.name(propAlias);
                    nameNode.addChildToFront(value);
                    if (key.getBooleanProp(43)) {
                        nameNode.putBooleanProp(43, true);
                    }
                    Node newVar = IR.var(nameNode).copyInformationFromForTree(key);
                    if (nameToAddAfter != null) {
                        varParent.addChildAfter(newVar, nameToAddAfter);
                    } else {
                        varParent.addChildBefore(newVar, varNode);
                    }
                    this.compiler.reportCodeChange();
                    nameToAddAfter = newVar;
                    if (isJsIdentifier && p != null) {
                        if (!discardKeys) {
                            GlobalNamespace.Ref newAlias = p.getDeclaration().cloneAndReclassify(GlobalNamespace.Ref.Type.ALIASING_GET);
                            newAlias.node = refNode;
                            p.addRef(newAlias);
                        }
                        p.getDeclaration().node = nameNode;
                        if (value.isFunction()) {
                            this.checkForHosedThisReferences(value, value.getJSDocInfo(), p);
                        }
                    }
                    ++numVars;
                }
            }
            key = nextKey;
        }
        return numVars;
    }

    private int addStubsForUndeclaredProperties(GlobalNamespace.Name n, String alias, Node parent, Node addAfter) {
        Preconditions.checkState((boolean)n.canCollapseUnannotatedChildNames());
        Preconditions.checkArgument((boolean)NodeUtil.isStatementBlock(parent));
        Preconditions.checkNotNull((Object)addAfter);
        int numStubs = 0;
        if (n.props != null) {
            for (GlobalNamespace.Name p : n.props) {
                if (!p.needsToBeStubbed()) continue;
                String propAlias = CollapseProperties.appendPropForAlias(alias, p.getBaseName());
                Node nameNode = IR.name(propAlias);
                Node newVar = IR.var(nameNode).copyInformationFromForTree(addAfter);
                parent.addChildAfter(newVar, addAfter);
                addAfter = newVar;
                ++numStubs;
                this.compiler.reportCodeChange();
                if (!p.getRefs().get((int)0).node.getLastChild().getBooleanProp(43)) continue;
                nameNode.putBooleanProp(43, true);
            }
        }
        return numStubs;
    }

    private static String appendPropForAlias(String root, String prop) {
        if (prop.indexOf(36) != -1) {
            prop = prop.replace("$", "$0");
        }
        return root + '$' + prop;
    }
}

