/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Es6RewriteGenerators
extends NodeTraversal.AbstractPostOrderCallback
implements HotSwapCompilerPass {
    private final AbstractCompiler compiler;
    private Node enclosingCase;
    private Node hoistRoot;
    private Node originalGeneratorBody;
    private Node currentStatement;
    private static final String ITER_KEY = "$$iterator";
    private static final String GENERATOR_STATE = "$jscomp$generator$state";
    private static int generatorCaseCount;
    private static final String GENERATOR_DO_WHILE_INITIAL = "$jscomp$generator$first$do";
    private static final String GENERATOR_YIELD_ALL_NAME = "$jscomp$generator$yield$all";
    private static final String GENERATOR_YIELD_ALL_ENTRY = "$jscomp$generator$yield$entry";
    private static final String GENERATOR_ARGUMENTS = "$jscomp$generator$arguments";
    private static final String GENERATOR_NEXT_ARG = "$jscomp$generator$next$arg";
    private Supplier<String> generatorCounter;
    private static final String GENERATOR_SWITCH_ENTERED = "$jscomp$generator$switch$entered";
    private static final String GENERATOR_SWITCH_VAL = "$jscomp$generator$switch$val";
    private List<Integer> currentLoopEndCase;
    private List<Node> currentLoopContinueStatement;
    private List<Boolean> currentBreakCaptureIsSwitch;

    public Es6RewriteGenerators(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.currentLoopEndCase = new ArrayList<Integer>();
        this.currentLoopContinueStatement = new ArrayList<Node>();
        this.currentBreakCaptureIsSwitch = new ArrayList<Boolean>();
        this.generatorCounter = compiler.getUniqueNameIdSupplier();
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        NodeTraversal.traverse(this.compiler, scriptRoot, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getType()) {
            case 105: {
                if (!n.isGeneratorFunction()) break;
                generatorCaseCount = 0;
                this.visitGenerator(n, parent);
                break;
            }
            case 38: {
                Node enclosing = NodeUtil.getEnclosingFunction(n);
                if (enclosing == null || !enclosing.isGeneratorFunction() || !n.matchesQualifiedName("arguments")) break;
                n.setString(GENERATOR_ARGUMENTS);
                break;
            }
            case 164: {
                if (n.isYieldFor()) {
                    this.visitYieldFor(n, parent);
                    break;
                }
                if (parent.isExprResult()) break;
                this.visitYieldExpr(n, parent);
                break;
            }
            case 126: {
                Node enclosing = NodeUtil.getEnclosingFunction(n);
                if (enclosing == null || !enclosing.isGeneratorFunction()) break;
                this.compiler.report(JSError.make(n, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Labels in generator functions"));
            }
        }
    }

    private void visitYieldFor(Node n, Node parent) {
        Node enclosingStatement = NodeUtil.getEnclosingStatement(n);
        Node generator = IR.var(IR.name(GENERATOR_YIELD_ALL_NAME), n.removeFirstChild());
        Node entryDecl = IR.var(IR.name(GENERATOR_YIELD_ALL_ENTRY));
        Node assignIterResult = IR.assign(IR.name(GENERATOR_YIELD_ALL_ENTRY), IR.call(IR.getprop(IR.name(GENERATOR_YIELD_ALL_NAME), IR.string("next")), new Node[0]));
        Node loopCondition = IR.not(IR.getprop(assignIterResult, IR.string("done")));
        Node elemValue = IR.getprop(IR.name(GENERATOR_YIELD_ALL_ENTRY), IR.string("value"));
        Node loop = IR.whileNode(loopCondition, IR.block(IR.exprResult(IR.yield(elemValue.cloneTree()))));
        enclosingStatement.getParent().addChildBefore(generator, enclosingStatement);
        enclosingStatement.getParent().addChildBefore(entryDecl, enclosingStatement);
        enclosingStatement.getParent().addChildBefore(loop, enclosingStatement);
        if (parent.isExprResult()) {
            parent.detachFromParent();
        } else {
            parent.replaceChild(n, elemValue);
        }
    }

    private void visitYieldExpr(Node n, Node parent) {
        Node enclosingStatement = NodeUtil.getEnclosingStatement(n);
        Node yieldStatement = IR.exprResult(n.hasChildren() ? IR.yield(n.removeFirstChild()) : IR.yield());
        Node yieldResult = IR.name(GENERATOR_NEXT_ARG + (String)this.generatorCounter.get());
        Node yieldResultDecl = IR.var(yieldResult.cloneTree(), IR.name(GENERATOR_NEXT_ARG));
        parent.replaceChild(n, yieldResult);
        enclosingStatement.getParent().addChildBefore(yieldStatement, enclosingStatement);
        enclosingStatement.getParent().addChildBefore(yieldResultDecl, enclosingStatement);
        this.compiler.reportCodeChange();
    }

    private void visitGenerator(Node n, Node parent) {
        Node genBlock = this.compiler.parseSyntheticCode(Joiner.on((char)'\n').join((Object)"{", (Object)("  var $jscomp$generator$state = " + generatorCaseCount + ";"), new Object[]{"  return {", "    $$iterator: function() { return this; },", "    next: function($jscomp$generator$next$arg) {", "      while (1) switch ($jscomp$generator$state) {", "        case " + generatorCaseCount + ":", "        default:", "          return {value: undefined, done: true};", "      }", "    }", "  }", "}"})).removeFirstChild();
        ++generatorCaseCount;
        Node genFunc = IR.var(n.removeFirstChild(), IR.function(IR.name(""), n.removeFirstChild(), genBlock));
        JSDocInfoBuilder genDoc = n.getJSDocInfo() == null ? new JSDocInfoBuilder(true) : JSDocInfoBuilder.copyFrom(n.getJSDocInfo());
        genDoc.recordSuppressions((Set<String>)ImmutableSet.of((Object)"uselessCode"));
        JSDocInfo genInfo = genDoc.build(genFunc);
        genFunc.setJSDocInfo(genInfo);
        this.originalGeneratorBody = n.getFirstChild();
        this.originalGeneratorBody.addChildToBack(IR.exprResult(IR.assign(IR.name(GENERATOR_STATE), IR.number(-1.0))));
        this.enclosingCase = this.getUnique(genBlock, 111);
        this.hoistRoot = this.getUnique(genBlock, 118);
        if (NodeUtil.isNameReferenced(n, GENERATOR_ARGUMENTS)) {
            this.hoistRoot.getParent().addChildAfter(IR.var(IR.name(GENERATOR_ARGUMENTS), IR.name("arguments")), this.hoistRoot);
        }
        while (this.originalGeneratorBody.hasChildren()) {
            this.currentStatement = this.originalGeneratorBody.removeFirstChild();
            boolean advanceCase = this.translateStatementInOriginalBody();
            if (!advanceCase) continue;
            int caseNumber = this.currentStatement.isGeneratorMarker() ? (int)this.currentStatement.getDouble() : generatorCaseCount++;
            Node newCase = IR.caseNode(IR.number(caseNumber), IR.block());
            this.enclosingCase.getParent().addChildAfter(newCase, this.enclosingCase);
            this.enclosingCase = newCase;
        }
        parent.replaceChild(n, genFunc);
        parent.useSourceInfoIfMissingFromForTree(parent);
        this.compiler.reportCodeChange();
    }

    private boolean translateStatementInOriginalBody() {
        if (this.currentStatement.isExprResult() && this.currentStatement.getFirstChild().isYield()) {
            this.visitYieldExprResult();
            return true;
        }
        if (this.currentStatement.isVar()) {
            this.visitVar();
            return false;
        }
        if (NodeUtil.isForIn(this.currentStatement) && Es6RewriteGenerators.yieldsOrReturns(this.currentStatement)) {
            this.compiler.report(JSError.make(this.currentStatement, Es6ToEs3Converter.CANNOT_CONVERT_YET, "For...in loops containing yield or return"));
            return false;
        }
        if (NodeUtil.isLoopStructure(this.currentStatement) && Es6RewriteGenerators.yieldsOrReturns(this.currentStatement)) {
            this.visitLoop();
            return false;
        }
        if (this.currentStatement.isSwitch() && Es6RewriteGenerators.yieldsOrReturns(this.currentStatement)) {
            this.visitSwitch();
            return false;
        }
        if (this.currentStatement.isIf() && (Es6RewriteGenerators.yieldsOrReturns(this.currentStatement) || Es6RewriteGenerators.jumpsOut(this.currentStatement)) && !this.currentStatement.isGeneratorSafe()) {
            this.visitIf();
            return false;
        }
        if (this.currentStatement.isBlock()) {
            this.visitBlock();
            return false;
        }
        if (this.currentStatement.isGeneratorMarker()) {
            this.visitGeneratorMarker();
            return true;
        }
        if (this.currentStatement.isReturn()) {
            this.visitReturn();
            return false;
        }
        if (this.currentStatement.isContinue()) {
            this.visitContinue();
            return false;
        }
        if (this.currentStatement.isBreak() && !this.currentStatement.isGeneratorSafe()) {
            this.visitBreak();
            return false;
        }
        if (this.currentStatement.isThrow()) {
            this.compiler.report(JSError.make(this.currentStatement, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Throws are not yet allowed if their enclosing control structure contains a yield or return."));
            return false;
        }
        this.enclosingCase.getLastChild().addChildToBack(this.currentStatement);
        return false;
    }

    private void visitContinue() {
        int nested = 0;
        while (!this.currentBreakCaptureIsSwitch.isEmpty() && this.currentBreakCaptureIsSwitch.get(nested).booleanValue()) {
            ++nested;
        }
        if (!this.currentLoopContinueStatement.get(nested).isEmpty()) {
            this.enclosingCase.getLastChild().addChildToBack(this.currentLoopContinueStatement.get(nested).cloneTree());
        }
        this.enclosingCase.getLastChild().addChildToBack(this.createStateUpdate(this.currentLoopEndCase.get(nested) - 1));
        this.enclosingCase.getLastChild().addChildToBack(Es6RewriteGenerators.createSafeBreak());
    }

    private void visitBreak() {
        this.enclosingCase.getLastChild().addChildToBack(this.createStateUpdate(this.currentLoopEndCase.get(0)));
        this.enclosingCase.getLastChild().addChildToBack(Es6RewriteGenerators.createSafeBreak());
    }

    private void visitGeneratorMarker() {
        if (!this.currentLoopEndCase.isEmpty() && (double)this.currentLoopEndCase.get(0).intValue() == this.currentStatement.getDouble()) {
            this.currentLoopEndCase.remove(0);
            this.currentLoopContinueStatement.remove(0);
            this.currentBreakCaptureIsSwitch.remove(0);
        }
    }

    private void visitIf() {
        Node condition = this.currentStatement.removeFirstChild();
        Node ifBody = this.currentStatement.removeFirstChild();
        boolean hasElse = this.currentStatement.hasChildren();
        int ifEndState = generatorCaseCount++;
        Node invertedConditional = IR.ifNode(IR.not(condition), IR.block(this.createStateUpdate(ifEndState), Es6RewriteGenerators.createSafeBreak()));
        invertedConditional.setGeneratorSafe(true);
        Node endIf = IR.number(ifEndState);
        endIf.setGeneratorMarker(true);
        this.originalGeneratorBody.addChildToFront(invertedConditional);
        this.originalGeneratorBody.addChildAfter(ifBody, invertedConditional);
        this.originalGeneratorBody.addChildAfter(endIf, ifBody);
        if (hasElse) {
            Node elseBlock = this.currentStatement.removeFirstChild();
            int elseEndState = generatorCaseCount++;
            Node endElse = IR.number(elseEndState);
            endElse.setGeneratorMarker(true);
            ifBody.addChildToBack(this.createStateUpdate(elseEndState));
            ifBody.addChildToBack(Es6RewriteGenerators.createSafeBreak());
            this.originalGeneratorBody.addChildAfter(elseBlock, endIf);
            this.originalGeneratorBody.addChildAfter(endElse, elseBlock);
        }
    }

    private void visitSwitch() {
        Node didEnter = IR.name(GENERATOR_SWITCH_ENTERED + (String)this.generatorCounter.get());
        Node didEnterDecl = IR.var(didEnter.cloneTree(), IR.falseNode());
        Node switchVal = IR.name(GENERATOR_SWITCH_VAL + (String)this.generatorCounter.get());
        Node switchValDecl = IR.var(switchVal.cloneTree(), this.currentStatement.removeFirstChild());
        this.originalGeneratorBody.addChildToFront(didEnterDecl);
        this.originalGeneratorBody.addChildAfter(switchValDecl, didEnterDecl);
        Node insertionPoint = switchValDecl;
        while (this.currentStatement.hasChildren()) {
            Node equivBlock;
            Node currCase = this.currentStatement.removeFirstChild();
            currCase.getLastChild().addChildToFront(IR.exprResult(IR.assign(didEnter.cloneTree(), IR.trueNode())));
            if (currCase.isDefaultCase()) {
                if (this.currentStatement.hasChildren()) {
                    this.compiler.report(JSError.make(this.currentStatement, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Default case as intermediate case"));
                }
                equivBlock = IR.block(currCase.removeFirstChild());
            } else {
                equivBlock = IR.ifNode(IR.or(didEnter.cloneTree(), IR.sheq(switchVal.cloneTree(), currCase.removeFirstChild())), currCase.removeFirstChild());
            }
            this.originalGeneratorBody.addChildAfter(equivBlock, insertionPoint);
            insertionPoint = equivBlock;
        }
        int breakTarget = generatorCaseCount++;
        this.currentLoopEndCase.add(0, breakTarget);
        this.currentLoopContinueStatement.add(0, IR.empty());
        this.currentBreakCaptureIsSwitch.add(0, true);
        Node breakCase = IR.number(breakTarget);
        breakCase.setGeneratorMarker(true);
        this.originalGeneratorBody.addChildAfter(breakCase, insertionPoint);
    }

    private void visitBlock() {
        Node insertionPoint = this.currentStatement.removeFirstChild();
        this.originalGeneratorBody.addChildToFront(insertionPoint);
        Node child = this.currentStatement.removeFirstChild();
        while (child != null) {
            this.originalGeneratorBody.addChildAfter(child, insertionPoint);
            insertionPoint = child;
            child = this.currentStatement.removeFirstChild();
        }
    }

    private void visitLoop() {
        Node postExpression;
        Node initializer;
        Node body;
        Node condition;
        if (this.currentStatement.isWhile()) {
            condition = this.currentStatement.removeFirstChild();
            body = this.currentStatement.removeFirstChild();
            initializer = IR.empty();
            postExpression = IR.empty();
        } else if (this.currentStatement.isFor()) {
            initializer = this.currentStatement.removeFirstChild();
            condition = this.currentStatement.removeFirstChild();
            postExpression = this.currentStatement.removeFirstChild();
            body = this.currentStatement.removeFirstChild();
        } else {
            Preconditions.checkState((boolean)this.currentStatement.isDo());
            Node firstEntry = IR.name(GENERATOR_DO_WHILE_INITIAL);
            initializer = IR.var(firstEntry.cloneTree(), IR.trueNode());
            postExpression = IR.assign(firstEntry.cloneTree(), IR.falseNode());
            body = this.currentStatement.removeFirstChild();
            condition = IR.or(firstEntry, this.currentStatement.removeFirstChild());
        }
        postExpression = postExpression.isEmpty() ? postExpression : IR.exprResult(postExpression);
        int loopBeginState = generatorCaseCount++;
        this.currentLoopEndCase.add(0, generatorCaseCount);
        this.currentBreakCaptureIsSwitch.add(0, false);
        this.currentLoopContinueStatement.add(0, postExpression);
        if (!postExpression.isEmpty()) {
            body.addChildToBack(postExpression);
        }
        Node beginCase = IR.number(loopBeginState);
        beginCase.setGeneratorMarker(true);
        Node conditionalBranch = IR.ifNode(condition, body);
        Node setStateLoopStart = this.createStateUpdate(loopBeginState);
        Node breakToStart = Es6RewriteGenerators.createSafeBreak();
        this.originalGeneratorBody.addChildToFront(beginCase);
        if (!initializer.isEmpty()) {
            this.originalGeneratorBody.addChildToFront(initializer);
        }
        this.originalGeneratorBody.addChildAfter(conditionalBranch, beginCase);
        body.addChildToBack(setStateLoopStart);
        body.addChildToBack(breakToStart);
    }

    private void visitVar() {
        Node name = this.currentStatement.removeFirstChild();
        while (name != null) {
            if (name.hasChildren()) {
                this.enclosingCase.getLastChild().addChildToBack(IR.exprResult(IR.assign(name, name.removeFirstChild())));
            }
            this.hoistRoot.getParent().addChildAfter(IR.var(name.cloneTree()), this.hoistRoot);
            name = this.currentStatement.removeFirstChild();
        }
    }

    private void visitYieldExprResult() {
        this.enclosingCase.getLastChild().addChildToBack(this.createStateUpdate());
        Node yield = this.currentStatement.getFirstChild();
        Node value = yield.hasChildren() ? yield.removeFirstChild() : IR.name("undefined");
        this.enclosingCase.getLastChild().addChildToBack(IR.returnNode(this.createIteratorResult(value, false)));
    }

    private void visitReturn() {
        this.enclosingCase.getLastChild().addChildToBack(this.createStateUpdate(-1));
        this.enclosingCase.getLastChild().addChildToBack(IR.returnNode(this.createIteratorResult(this.currentStatement.removeFirstChild(), true)));
    }

    private Node createStateUpdate() {
        return IR.exprResult(IR.assign(IR.name(GENERATOR_STATE), IR.number(generatorCaseCount)));
    }

    private Node createStateUpdate(int state) {
        return IR.exprResult(IR.assign(IR.name(GENERATOR_STATE), IR.number(state)));
    }

    private Node createIteratorResult(Node value, boolean done) {
        return IR.objectlit(IR.propdef(IR.stringKey("value"), value), IR.propdef(IR.stringKey("done"), done ? IR.trueNode() : IR.falseNode()));
    }

    private static Node createSafeBreak() {
        Node breakNode = IR.breakNode();
        breakNode.setGeneratorSafe(true);
        return breakNode;
    }

    private static boolean yieldsOrReturns(Node n) {
        return NodeUtil.referencesYield(n) || NodeUtil.referencesReturn(n);
    }

    private static boolean jumpsOut(Node n) {
        return NodeUtil.referencesContinue(n) || NodeUtil.referencesBreak(n);
    }

    private Node getUnique(Node node, int type) {
        ArrayList<Node> matches = new ArrayList<Node>();
        this.insertAll(node, type, matches);
        Preconditions.checkState((matches.size() == 1 ? 1 : 0) != 0);
        return (Node)matches.get(0);
    }

    private void insertAll(Node node, int type, List<Node> matchingNodes) {
        if (node.getType() == type) {
            matchingNodes.add(node);
        }
        for (Node c = node.getFirstChild(); c != null; c = c.getNext()) {
            this.insertAll(c, type, matchingNodes);
        }
    }
}

