/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;

class Es6TemplateLiterals {
    private static final String TEMPLATELIT_VAR = "$jscomp$templatelit$";

    Es6TemplateLiterals() {
    }

    static void visitTemplateLiteral(NodeTraversal t, Node n) {
        if (n.getFirstChild().isString()) {
            Es6TemplateLiterals.createUntaggedTemplateLiteral(n);
        } else {
            Es6TemplateLiterals.createTaggedTemplateLiteral(t, n);
        }
        t.getCompiler().reportCodeChange();
    }

    private static void createUntaggedTemplateLiteral(Node n) {
        int length = n.getChildCount();
        if (length == 0) {
            n.getParent().replaceChild(n, IR.string("\"\""));
        } else {
            Node first = n.removeFirstChild();
            if (length == 1) {
                n.getParent().replaceChild(n, first);
            } else {
                Node add = IR.add(first, n.removeFirstChild().removeFirstChild());
                for (int i = 2; i < length; ++i) {
                    Node child = n.removeFirstChild();
                    if (child.isString()) {
                        if (child.getString().isEmpty()) continue;
                        if (i == 2 && first.getString().isEmpty()) {
                            add = add.getChildAtIndex(1).detachFromParent();
                        }
                    }
                    add = IR.add(add, child.isString() ? child : child.removeFirstChild());
                }
                n.getParent().replaceChild(n, add.useSourceInfoIfMissingFromForTree(n));
            }
        }
    }

    private static void createTaggedTemplateLiteral(NodeTraversal t, Node n) {
        Node call;
        Node raw = Es6TemplateLiterals.createRawStringArray(n);
        Node cooked = Es6TemplateLiterals.createCookedStringArray(n);
        Node callsiteId = IR.name(TEMPLATELIT_VAR + (String)t.getCompiler().getUniqueNameIdSupplier().get());
        Node var = IR.var(callsiteId, cooked).useSourceInfoIfMissingFromForTree(n);
        Node script = NodeUtil.getEnclosingType(n, 132);
        script.addChildrenToFront(var);
        Node defineRaw = IR.exprResult(IR.assign(IR.getelem(callsiteId.cloneNode(), IR.string("raw")), raw)).useSourceInfoIfMissingFromForTree(n);
        script.addChildAfter(defineRaw, var);
        Node[] args = new Node[n.getChildCount() / 2];
        args[0] = callsiteId.cloneNode();
        int i = 1;
        int j = 2;
        while (i < args.length) {
            args[i] = n.getChildAtIndex(j).removeFirstChild();
            ++i;
            j += 2;
        }
        call.putBooleanProp(50, !(call = IR.call(n.removeFirstChild(), args).useSourceInfoIfMissingFromForTree(n)).getFirstChild().isGetProp());
        n.getParent().replaceChild(n, call);
    }

    private static Node createRawStringArray(Node n) {
        Node[] items = new Node[n.getChildCount() / 2];
        int i = 0;
        int j = 1;
        while (i < items.length) {
            items[i] = IR.string((String)n.getChildAtIndex(j).getProp(71));
            ++i;
            j += 2;
        }
        return IR.arraylit(items);
    }

    private static Node createCookedStringArray(Node n) {
        Node[] items = new Node[n.getChildCount() / 2];
        int i = 0;
        int j = 1;
        while (i < items.length) {
            items[i] = IR.string(Es6TemplateLiterals.cookString((String)n.getChildAtIndex(j).getProp(71)));
            items[i].putBooleanProp(70, true);
            ++i;
            j += 2;
        }
        return IR.arraylit(items);
    }

    private static String cookString(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        block8: while (i < s.length()) {
            char c = s.charAt(i++);
            switch (c) {
                case '\\': {
                    char c2 = s.charAt(i++);
                    switch (c2) {
                        case '\n': 
                        case '\u2028': 
                        case '\u2029': {
                            continue block8;
                        }
                        case '\r': {
                            if (s.charAt(i + 1) != '\n') continue block8;
                            ++i;
                            continue block8;
                        }
                    }
                    sb.append(c);
                    sb.append(c2);
                    continue block8;
                }
                case '\r': {
                    if (s.charAt(i) == '\n') {
                        ++i;
                    }
                    sb.append('\n');
                    continue block8;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

