/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashSet;
import java.util.Set;

public class Es6ToEs3ClassSideInheritance
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    final AbstractCompiler compiler;
    private final Multimap<String, String> staticMembers = ArrayListMultimap.create();
    static final DiagnosticType DUPLICATE_CLASS = DiagnosticType.error("DUPLICATE_CLASS", "Multiple classes cannot share the same name.");
    private final Set<String> multiplyDefinedClasses = new HashSet<String>();

    public Es6ToEs3ClassSideInheritance(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new FindStaticMembers());
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (!n.isCall()) {
            return;
        }
        if (n.getFirstChild().matchesQualifiedName("$jscomp$copy$properties")) {
            Node superClassName = n.getLastChild();
            Node subClassName = n.getChildBefore(superClassName);
            String key = superClassName.getQualifiedName();
            if (this.multiplyDefinedClasses.contains(key)) {
                this.compiler.report(JSError.make(n, DUPLICATE_CLASS, new String[0]));
                return;
            }
            if (this.staticMembers.containsKey((Object)key)) {
                for (String staticMember : this.staticMembers.get((Object)key)) {
                    Node sAssign = IR.exprResult(IR.assign(IR.getprop(subClassName.cloneTree(), IR.string(staticMember)), IR.getprop(superClassName.cloneTree(), IR.string(staticMember))));
                    sAssign.useSourceInfoIfMissingFromForTree(n);
                    parent.getParent().addChildAfter(sAssign, parent);
                    this.staticMembers.put((Object)subClassName.getQualifiedName(), (Object)staticMember);
                }
                parent.detachFromParent();
            }
        }
    }

    private class FindStaticMembers
    extends NodeTraversal.AbstractPostOrderCallback {
        private final Set<String> classNames = new HashSet<String>();

        private FindStaticMembers() {
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node n, Node parent) {
            switch (n.getType()) {
                case 86: {
                    this.visitAssign(n);
                    break;
                }
                case 105: {
                    this.visitFunctionClassDef(n);
                }
            }
        }

        public void visitFunctionClassDef(Node n) {
            JSDocInfo classInfo = NodeUtil.getBestJSDocInfo(n);
            if (classInfo != null && classInfo.isConstructor()) {
                String name = NodeUtil.getFunctionName(n);
                if (this.classNames.contains(name)) {
                    Es6ToEs3ClassSideInheritance.this.multiplyDefinedClasses.add(name);
                } else {
                    this.classNames.add(name);
                }
            }
        }

        public void visitAssign(Node n) {
            if (!n.hasChildren() || !n.getFirstChild().isGetProp()) {
                return;
            }
            Node potentialClassName = n.getFirstChild().getFirstChild();
            if (this.classNames.contains(potentialClassName.getQualifiedName())) {
                Es6ToEs3ClassSideInheritance.this.staticMembers.put((Object)potentialClassName.getQualifiedName(), (Object)n.getFirstChild().getLastChild().getString());
            }
        }
    }
}

