/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.ES6ModuleLoader;
import com.google.javascript.jscomp.JSModule;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.SyntacticScopeCreator;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.List;
import java.util.regex.Pattern;

public class ProcessCommonJSModules
implements CompilerPass {
    private static final String MODULE_SLASH = "/";
    public static final String DEFAULT_FILENAME_PREFIX = "./";
    private static final String MODULE_NAME_SEPARATOR = "\\$";
    private static final String MODULE_NAME_PREFIX = "module$";
    private static final String EXPORTS = "exports";
    static final DiagnosticType LOAD_ERROR = DiagnosticType.error("JSC_ES6_MODULE_LOAD_ERROR", "Failed to load module \"{0}\"");
    private final Compiler compiler;
    private final ES6ModuleLoader loader;
    private final boolean reportDependencies;
    private final boolean overrideModule;
    private JSModule module;
    private boolean dontProcess;

    ProcessCommonJSModules(Compiler compiler, ES6ModuleLoader loader) {
        this(compiler, loader, true, true);
    }

    ProcessCommonJSModules(Compiler compiler, ES6ModuleLoader loader, boolean reportDependencies, boolean overrideModule) {
        this.compiler = compiler;
        this.loader = loader;
        this.reportDependencies = reportDependencies;
        this.overrideModule = overrideModule;
    }

    @Override
    public void process(Node externs, Node root) {
        this.dontProcess = false;
        NodeTraversal.traverse(this.compiler, root, new FindGoogProvideAndGoogModule());
        if (this.dontProcess) {
            return;
        }
        NodeTraversal.traverse(this.compiler, root, new ProcessCommonJsModulesCallback());
    }

    JSModule getModule() {
        return this.module;
    }

    public static String toModuleName(String filename) {
        return MODULE_NAME_PREFIX + filename.replaceAll("^\\." + Pattern.quote(MODULE_SLASH), "").replaceAll(Pattern.quote(MODULE_SLASH), MODULE_NAME_SEPARATOR).replaceAll(Pattern.quote("\\"), MODULE_NAME_SEPARATOR).replaceAll("\\.js$", "").replaceAll("-", "_").replaceAll(":", "_").replaceAll("\\.", "");
    }

    private class SuffixVarsCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String suffix;

        SuffixVarsCallback(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            JSDocInfo info = n.getJSDocInfo();
            if (info != null) {
                for (Node typeNode : info.getTypeNodes()) {
                    this.fixTypeNode(t, typeNode);
                }
            }
            if (n.isName()) {
                String name = n.getString();
                if (this.suffix.equals(name)) {
                    return;
                }
                if (ProcessCommonJSModules.EXPORTS.equals(name)) {
                    return;
                }
                if (((ProcessCommonJSModules)ProcessCommonJSModules.this).compiler.getOptions().exportTestFunctions && name.startsWith("test")) {
                    return;
                }
                Scope.Var var = t.getScope().getVar(name);
                if (var != null && var.isGlobal()) {
                    n.setString(name + "$$" + this.suffix);
                    n.putProp(40, name);
                }
            }
        }

        private void fixTypeNode(NodeTraversal t, Node typeNode) {
            if (typeNode.isString()) {
                String name = typeNode.getString();
                if (ES6ModuleLoader.isRelativeIdentifier(name)) {
                    int lastSlash = name.lastIndexOf(ProcessCommonJSModules.MODULE_SLASH);
                    int endIndex = name.indexOf(46, lastSlash);
                    String localTypeName = null;
                    if (endIndex == -1) {
                        endIndex = name.length();
                    } else {
                        localTypeName = name.substring(endIndex);
                    }
                    String moduleName = name.substring(0, endIndex);
                    String loadAddress = ProcessCommonJSModules.this.loader.locate(moduleName, t.getInput());
                    if (loadAddress == null) {
                        t.makeError(typeNode, LOAD_ERROR, moduleName);
                        return;
                    }
                    String globalModuleName = ProcessCommonJSModules.toModuleName(loadAddress);
                    typeNode.setString(localTypeName == null ? globalModuleName : globalModuleName + localTypeName);
                } else {
                    int endIndex = name.indexOf(46);
                    if (endIndex == -1) {
                        endIndex = name.length();
                    }
                    String baseName = name.substring(0, endIndex);
                    Scope.Var var = t.getScope().getVar(baseName);
                    if (var != null && var.isGlobal()) {
                        typeNode.setString(baseName + "$$" + this.suffix + name.substring(endIndex));
                        typeNode.putProp(40, name);
                    }
                }
            }
            for (Node child = typeNode.getFirstChild(); child != null; child = child.getNext()) {
                this.fixTypeNode(t, child);
            }
        }
    }

    private class ProcessCommonJsModulesCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private int scriptNodeCount = 0;
        private List<Node> moduleExportRefs = Lists.newArrayList();
        private List<Node> exportRefs = Lists.newArrayList();

        private ProcessCommonJsModulesCallback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            Scope.Var v;
            if (n.isCall() && n.getChildCount() == 2 && n.getFirstChild().matchesQualifiedName("require") && n.getChildAtIndex(1).isString()) {
                this.visitRequireCall(t, n, parent);
            }
            if (n.isScript()) {
                ++this.scriptNodeCount;
                this.visitScript(t, n);
            }
            if (n.isGetProp() && "module.exports".equals(n.getQualifiedName())) {
                this.moduleExportRefs.add(n);
            }
            if (n.isName() && ProcessCommonJSModules.EXPORTS.equals(n.getString()) && ((v = t.getScope().getVar(n.getString())) == null || v.isGlobal())) {
                this.exportRefs.add(n);
            }
        }

        private void visitRequireCall(NodeTraversal t, Node require, Node parent) {
            String requireName = require.getChildAtIndex(1).getString();
            String loadAddress = ProcessCommonJSModules.this.loader.locate(requireName, t.getInput());
            try {
                ProcessCommonJSModules.this.loader.load(loadAddress);
            }
            catch (ES6ModuleLoader.LoadFailedException e) {
                t.makeError(require, LOAD_ERROR, requireName);
            }
            String moduleName = ProcessCommonJSModules.toModuleName(loadAddress);
            Node moduleRef = IR.name(moduleName).srcref(require);
            parent.replaceChild(require, moduleRef);
            Node script = this.getCurrentScriptNode(parent);
            if (ProcessCommonJSModules.this.reportDependencies) {
                t.getInput().addRequire(moduleName);
            }
            script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("require")), IR.string(moduleName))).copyInformationFromForTree(require));
            ProcessCommonJSModules.this.compiler.reportCodeChange();
        }

        private void visitScript(NodeTraversal t, Node script) {
            Preconditions.checkArgument((this.scriptNodeCount == 1 ? 1 : 0) != 0, (Object)"ProcessCommonJSModules supports only one invocation per CompilerInput / script node");
            String moduleName = ProcessCommonJSModules.toModuleName(ProcessCommonJSModules.this.loader.getLoadAddress(t.getInput()));
            NodeTraversal.traverse(ProcessCommonJSModules.this.compiler, script, new SuffixVarsCallback(moduleName));
            this.processExports(script, moduleName);
            this.moduleExportRefs.clear();
            this.exportRefs.clear();
            if (ProcessCommonJSModules.this.reportDependencies) {
                CompilerInput ci = t.getInput();
                ci.addProvide(moduleName);
                JSModule m = new JSModule(moduleName);
                if (ProcessCommonJSModules.this.overrideModule) {
                    m.addAndOverrideModule(ci);
                }
                ProcessCommonJSModules.this.module = m;
            }
            script.addChildToFront(IR.exprResult(IR.call(IR.getprop(IR.name("goog"), IR.string("provide")), IR.string(moduleName))).copyInformationFromForTree(script));
            ProcessCommonJSModules.this.compiler.reportCodeChange();
        }

        private void processExports(Node script, String moduleName) {
            if (this.hasOneTopLevelModuleExportAssign()) {
                Node ref = this.moduleExportRefs.get(0);
                Node newName = IR.name(moduleName);
                newName.putProp(40, ref.getQualifiedName());
                Node newVar = IR.var(newName).copyInformationFromForTree(ref.getParent());
                Node rhsValue = ref.getNext().detachFromParent();
                newVar.getFirstChild().addChildToFront(rhsValue);
                newVar.setJSDocInfo(NodeUtil.createConstantJsDoc());
                if (rhsValue.isObjectLit()) {
                    Scope globalScope = new SyntacticScopeCreator(ProcessCommonJSModules.this.compiler).createScope(script, null);
                    for (Node key = rhsValue.getFirstChild(); key != null; key = key.getNext()) {
                        JSDocInfo info;
                        if (key.getJSDocInfo() != null || !key.getFirstChild().isName()) continue;
                        Scope.Var aliasedVar = globalScope.getVar(key.getFirstChild().getString());
                        JSDocInfo jSDocInfo = info = aliasedVar == null ? null : aliasedVar.getJSDocInfo();
                        if (info == null || info.getVisibility() == JSDocInfo.Visibility.PRIVATE) continue;
                        key.setJSDocInfo(info);
                    }
                }
                Node assign = ref.getParent();
                Node exprResult = assign.getParent();
                script.replaceChild(exprResult, newVar);
                return;
            }
            if (!this.hasExportLValues()) {
                Node newVar = this.injectExportsObject(script, moduleName);
                newVar.setJSDocInfo(NodeUtil.createConstantJsDoc());
                for (Node ref : Iterables.concat(this.moduleExportRefs, this.exportRefs)) {
                    Node newRef = IR.name(moduleName).copyInformationFrom(ref);
                    newRef.putProp(40, ref.getQualifiedName());
                    ref.getParent().replaceChild(ref, newRef);
                }
                return;
            }
            Node exportsNode = this.injectExportsObject(script, moduleName);
            for (Node ref : this.moduleExportRefs) {
                Node newRef = IR.name(moduleName).copyInformationFrom(ref);
                ref.getParent().replaceChild(ref, newRef);
            }
            if (!this.exportRefs.isEmpty()) {
                String aliasName = "exports$$" + moduleName;
                Node aliasNode = IR.var(IR.name(aliasName), IR.name(moduleName)).copyInformationFromForTree(script);
                script.addChildAfter(aliasNode, exportsNode);
                for (Node ref : this.exportRefs) {
                    ref.putProp(40, ref.getString());
                    ref.setString(aliasName);
                }
            }
        }

        private Node injectExportsObject(Node script, String moduleName) {
            Node varNode = IR.var(IR.name(moduleName), IR.objectlit(new Node[0])).copyInformationFromForTree(script);
            script.addChildToFront(varNode);
            return varNode;
        }

        private boolean hasOneTopLevelModuleExportAssign() {
            return this.moduleExportRefs.size() == 1 && this.exportRefs.isEmpty() && this.isTopLevelAssignLhs(this.moduleExportRefs.get(0));
        }

        private boolean isTopLevelAssignLhs(Node n) {
            Node parent = n.getParent();
            return parent.isAssign() && n == parent.getFirstChild() && parent.getParent().isExprResult() && parent.getParent().getParent().isScript();
        }

        private boolean hasExportLValues() {
            for (Node ref : Iterables.concat(this.moduleExportRefs, this.exportRefs)) {
                if (!NodeUtil.isLValue(ref)) continue;
                return true;
            }
            return false;
        }

        private Node getCurrentScriptNode(Node n) {
            while (!n.isScript()) {
                n = n.getParent();
            }
            return n;
        }
    }

    private class FindGoogProvideAndGoogModule
    extends NodeTraversal.AbstractPreOrderCallback {
        private FindGoogProvideAndGoogModule() {
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (parent == null || !parent.isFunction() || n == parent.getFirstChild()) {
                Node maybeGetProp;
                if (n.isExprResult() && (maybeGetProp = n.getFirstChild().getFirstChild()) != null && (maybeGetProp.matchesQualifiedName("goog.provide") || maybeGetProp.matchesQualifiedName("goog.module"))) {
                    ProcessCommonJSModules.this.dontProcess = true;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

