/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.Lists;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsMessage;
import com.google.javascript.jscomp.JsMessageDefinition;
import com.google.javascript.jscomp.JsMessageVisitor;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.Collections;

class ReplaceMessagesForChrome
extends JsMessageVisitor {
    ReplaceMessagesForChrome(AbstractCompiler compiler, JsMessage.IdGenerator idGenerator, boolean checkDuplicatedMessages, JsMessage.Style style) {
        super(compiler, checkDuplicatedMessages, style, idGenerator);
    }

    private static Node getChromeI18nGetMessageNode(String messageId) {
        Node chromeI18n = IR.getprop(IR.name("chrome"), IR.string("i18n"));
        Node getMessage = IR.getprop(chromeI18n, IR.string("getMessage"));
        return IR.call(getMessage, IR.string(messageId));
    }

    @Override
    protected void processJsMessage(JsMessage message, JsMessageDefinition definition) {
        try {
            Node msgNode = definition.getMessageNode();
            Node newValue = this.getNewValueNode(msgNode, message);
            newValue.copyInformationFromForTree(msgNode);
            definition.getMessageParentNode().replaceChild(msgNode, newValue);
            this.compiler.reportCodeChange();
        }
        catch (JsMessageVisitor.MalformedException e) {
            this.compiler.report(JSError.make(e.getNode(), MESSAGE_TREE_MALFORMED, e.getMessage()));
        }
    }

    private Node getNewValueNode(Node origNode, JsMessage message) throws JsMessageVisitor.MalformedException {
        Node newValueNode = ReplaceMessagesForChrome.getChromeI18nGetMessageNode(message.getId());
        if (!message.placeholders().isEmpty()) {
            Node placeholderValues = origNode.getLastChild();
            this.checkNode(placeholderValues, 64);
            ArrayList placeholderNames = Lists.newArrayList(message.placeholders());
            Collections.sort(placeholderNames);
            Node placeholderValueArray = IR.arraylit(new Node[0]);
            for (String name : placeholderNames) {
                Node value = ReplaceMessagesForChrome.getPlaceholderValue(placeholderValues, name);
                if (value == null) {
                    throw new JsMessageVisitor.MalformedException("No value was provided for placeholder " + name, origNode);
                }
                placeholderValueArray.addChildToBack(value);
            }
            newValueNode.addChildToBack(placeholderValueArray);
        }
        newValueNode.copyInformationFromForTree(origNode);
        return newValueNode;
    }

    private static Node getPlaceholderValue(Node placeholderValues, String placeholderName) {
        for (Node key : placeholderValues.children()) {
            if (!key.getString().equals(placeholderName)) continue;
            return key.getFirstChild().cloneTree();
        }
        return null;
    }
}

