/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.Es6ToEs3Converter;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import java.util.LinkedHashMap;
import java.util.Map;

public class TransformEs6ModuleToCjsModule
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private final Compiler compiler;
    private int scriptNodeCount = 0;
    private Map<String, String> exportMap = new LinkedHashMap<String, String>();

    TransformEs6ModuleToCjsModule(Compiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, this);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        if (n.isImport()) {
            this.visitImport(t, n, parent);
        } else if (n.isExport()) {
            this.visitExport(t, n, parent);
        } else if (n.isScript()) {
            ++this.scriptNodeCount;
            this.visitScript(t, n);
        }
    }

    private void visitImport(NodeTraversal t, Node n, Node parent) {
        String module = n.getLastChild().getString();
        LinkedHashMap<String, String> nameMap = new LinkedHashMap<String, String>();
        for (Node node : n.children()) {
            if (node.isEmpty() || node.isString()) continue;
            if (node.isName()) {
                nameMap.put(node.getString(), node.getString());
                continue;
            }
            for (Node grandChild : node.children()) {
                Node origName = grandChild.getFirstChild();
                nameMap.put(origName.getString(), grandChild.getChildCount() == 2 ? grandChild.getLastChild().getString() : origName.getString());
            }
        }
        for (Map.Entry entry : nameMap.entrySet()) {
            Node call = IR.call(IR.name("require"), IR.string(module));
            call.putBooleanProp(50, true);
            parent.addChildBefore(IR.var(IR.name((String)entry.getValue()), IR.getprop(call, IR.string((String)entry.getKey()))).useSourceInfoIfMissingFromForTree(n), n);
        }
        parent.removeChild(n);
        this.compiler.reportCodeChange();
    }

    private void visitExport(NodeTraversal t, Node n, Node parent) {
        if (n.getBooleanProp(62)) {
            this.compiler.report(JSError.make(n, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Default export"));
        } else if (n.getBooleanProp(63)) {
            this.compiler.report(JSError.make(n, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Wildcard export"));
        } else {
            if (n.getChildCount() == 2) {
                this.compiler.report(JSError.make(n, Es6ToEs3Converter.CANNOT_CONVERT_YET, "Export with FromClause"));
                return;
            }
            if (n.getFirstChild().getType() == 169) {
                for (Node grandChild : n.getFirstChild().children()) {
                    Node origName = grandChild.getFirstChild();
                    this.exportMap.put(grandChild.getChildCount() == 2 ? grandChild.getLastChild().getString() : origName.getString(), origName.getString());
                }
                parent.removeChild(n);
            } else {
                for (Node grandChild : n.getFirstChild().children()) {
                    if (!grandChild.isName()) break;
                    String name = grandChild.getString();
                    Scope.Var v = t.getScope().getVar(name);
                    if (v != null && !v.isGlobal()) continue;
                    this.exportMap.put(name, name);
                }
                parent.replaceChild(n, n.removeFirstChild());
            }
            this.compiler.reportCodeChange();
        }
    }

    private void visitScript(NodeTraversal t, Node script) {
        Preconditions.checkArgument((this.scriptNodeCount == 1 ? 1 : 0) != 0, (Object)"ProcessEs6Modules supports only one invocation per CompilerInput / script node");
        if (this.exportMap.isEmpty()) {
            return;
        }
        Node objectlit = IR.objectlit(new Node[0]);
        for (String name : this.exportMap.keySet()) {
            objectlit.addChildToBack(IR.stringKey(name, IR.name(this.exportMap.get(name))));
        }
        script.addChildToBack(IR.exprResult(IR.assign(IR.getprop(IR.name("module"), IR.string("exports")), objectlit)).useSourceInfoIfMissingFromForTree(script));
        this.compiler.reportCodeChange();
        this.exportMap.clear();
    }
}

