/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.parsing.TypeTransformationParser;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.ArrayList;

class TypeTransformation {
    private Compiler compiler;
    private JSTypeRegistry typeRegistry;

    TypeTransformation(Compiler compiler) {
        this.compiler = compiler;
        this.typeRegistry = compiler.getTypeRegistry();
    }

    private static boolean isTypeVar(Node n) {
        return n.isName();
    }

    private static boolean isCallTo(Node n, TypeTransformationParser.Keywords keyword) {
        if (!n.isCall()) {
            return false;
        }
        return n.getFirstChild().getString().equals(keyword.name);
    }

    private static boolean isTypePredicate(Node n) {
        return TypeTransformation.isCallTo(n, TypeTransformationParser.Keywords.TYPE);
    }

    private boolean isUnionType(Node n) {
        return TypeTransformation.isCallTo(n, TypeTransformationParser.Keywords.UNION);
    }

    private boolean isEqtype(Node n) {
        return TypeTransformation.isCallTo(n, TypeTransformationParser.Keywords.EQTYPE);
    }

    private boolean isSubtype(Node n) {
        return TypeTransformation.isCallTo(n, TypeTransformationParser.Keywords.SUBTYPE);
    }

    private boolean isConditional(Node n) {
        return TypeTransformation.isCallTo(n, TypeTransformationParser.Keywords.COND);
    }

    private JSType getUnknownType() {
        return this.typeRegistry.getNativeObjectType(JSTypeNative.UNKNOWN_TYPE);
    }

    private JSType typeOrUnknown(JSType type) {
        return type == null ? this.getUnknownType() : type;
    }

    private ArrayList<Node> getParameters(Node operation) {
        ArrayList<Node> params = new ArrayList<Node>();
        for (int i = 1; i < operation.getChildCount(); ++i) {
            params.add(operation.getChildAtIndex(i));
        }
        return params;
    }

    JSType eval(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        if (TypeTransformation.isTypeVar(ttlAst)) {
            return this.evalTypeVariable(ttlAst, typeVars);
        }
        if (TypeTransformation.isTypePredicate(ttlAst)) {
            return this.evalTypePredicate(ttlAst);
        }
        if (this.isUnionType(ttlAst)) {
            return this.evalUnionType(ttlAst, typeVars);
        }
        if (this.isConditional(ttlAst)) {
            return this.evalConditional(ttlAst, typeVars);
        }
        throw new IllegalStateException("Could not evaluate the type transformation expression");
    }

    private JSType evalTypePredicate(Node ttlAst) {
        String typeName = ttlAst.getChildAtIndex(1).getString();
        JSType resultingType = this.typeRegistry.getType(typeName);
        return this.typeOrUnknown(resultingType);
    }

    private JSType evalTypeVariable(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        String typeVar = ttlAst.getString();
        JSType resultingType = (JSType)typeVars.get((Object)typeVar);
        return this.typeOrUnknown(resultingType);
    }

    private JSType evalUnionType(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ArrayList<Node> params = this.getParameters(ttlAst);
        int paramCount = params.size();
        JSType[] basicTypes = new JSType[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            basicTypes[i] = this.eval(params.get(i), typeVars);
        }
        return this.typeRegistry.createUnionType(basicTypes);
    }

    private boolean evalBoolean(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ArrayList<Node> params = this.getParameters(ttlAst);
        JSType type0 = this.eval(params.get(0), typeVars);
        JSType type1 = this.eval(params.get(1), typeVars);
        if (this.isEqtype(ttlAst)) {
            return type0.isEquivalentTo(type1);
        }
        if (this.isSubtype(ttlAst)) {
            return type0.isSubtype(type1);
        }
        throw new IllegalStateException("Invalid boolean predicate in the type transformation");
    }

    private JSType evalConditional(Node ttlAst, ImmutableMap<String, JSType> typeVars) {
        ArrayList<Node> params = this.getParameters(ttlAst);
        if (this.evalBoolean(params.get(0), typeVars)) {
            return this.eval(params.get(1), typeVars);
        }
        return this.eval(params.get(2), typeVars);
    }
}

