/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FunctionType {
    private final ImmutableList<JSType> requiredFormals;
    private final ImmutableList<JSType> optionalFormals;
    private final JSType restFormals;
    private final JSType returnType;
    private final boolean isLoose;
    private final ImmutableMap<String, JSType> outerVarPreconditions;
    private final NominalType nominalType;
    private final ImmutableList<String> typeParameters;
    private static final boolean DEBUGGING = false;
    public static final FunctionType TOP_FUNCTION = new FunctionType(null, null, null, null, null, null, null, false);
    public static final FunctionType LOOSE_TOP_FUNCTION = new FunctionType(null, null, null, null, null, null, null, true);
    static final FunctionType QMARK_FUNCTION = FunctionType.normalized(null, null, JSType.UNKNOWN, JSType.UNKNOWN, null, null, null, false);

    private FunctionType(ImmutableList<JSType> requiredFormals, ImmutableList<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType nominalType, ImmutableMap<String, JSType> outerVars, ImmutableList<String> typeParameters, boolean isLoose) {
        this.requiredFormals = requiredFormals;
        this.optionalFormals = optionalFormals;
        this.restFormals = restFormals;
        this.returnType = retType;
        this.nominalType = nominalType;
        this.outerVarPreconditions = outerVars;
        this.typeParameters = typeParameters;
        this.isLoose = isLoose;
    }

    void checkValid() {
        if (this.isTopFunction()) {
            return;
        }
        for (JSType formal : this.requiredFormals) {
            Preconditions.checkState((formal != null ? 1 : 0) != 0);
        }
        for (JSType formal : this.optionalFormals) {
            Preconditions.checkState((formal != null ? 1 : 0) != 0);
        }
        Preconditions.checkState((this.returnType != null ? 1 : 0) != 0);
    }

    public boolean isLoose() {
        return this.isLoose;
    }

    FunctionType withLoose() {
        if (this.isTopFunction()) {
            return LOOSE_TOP_FUNCTION;
        }
        return new FunctionType(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.outerVarPreconditions, this.typeParameters, true);
    }

    static FunctionType normalized(List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, NominalType nominalType, Map<String, JSType> outerVars, ImmutableList<String> typeParameters, boolean isLoose) {
        if (requiredFormals == null) {
            requiredFormals = ImmutableList.of();
        }
        if (optionalFormals == null) {
            optionalFormals = ImmutableList.of();
        }
        if (outerVars == null) {
            outerVars = ImmutableMap.of();
        }
        if (restFormals != null) {
            for (int i = optionalFormals.size() - 1; i >= 0 && restFormals.equals(optionalFormals.get(i)); --i) {
                optionalFormals.remove(i);
            }
        }
        return new FunctionType((ImmutableList<JSType>)ImmutableList.copyOf((Collection)requiredFormals), (ImmutableList<JSType>)ImmutableList.copyOf((Collection)optionalFormals), restFormals, retType, nominalType, (ImmutableMap<String, JSType>)ImmutableMap.copyOf((Map)outerVars), typeParameters, isLoose);
    }

    @VisibleForTesting
    static JSType makeJSType(ImmutableList<JSType> requiredFormals, ImmutableList<JSType> optionalFormals, JSType restFormals, JSType retType) {
        return JSType.fromFunctionType(FunctionType.normalized(requiredFormals, optionalFormals, restFormals, retType, null, null, null, false));
    }

    public boolean isTopFunction() {
        if (this.requiredFormals == null) {
            Preconditions.checkState((this == TOP_FUNCTION || this == LOOSE_TOP_FUNCTION ? 1 : 0) != 0);
        }
        return this == TOP_FUNCTION || this == LOOSE_TOP_FUNCTION;
    }

    public boolean isConstructor() {
        return this.nominalType != null && !this.nominalType.isInterface();
    }

    public boolean isQmarkFunction() {
        return this == QMARK_FUNCTION;
    }

    boolean isInterfaceDefinition() {
        return this.nominalType != null && this.nominalType.isInterface();
    }

    public JSType getFormalType(int argpos) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        this.checkValid();
        int numReqFormals = this.requiredFormals.size();
        if (argpos < numReqFormals) {
            Preconditions.checkState((null != this.requiredFormals.get(argpos) ? 1 : 0) != 0);
            return (JSType)this.requiredFormals.get(argpos);
        }
        if (argpos < numReqFormals + this.optionalFormals.size()) {
            Preconditions.checkState((null != this.optionalFormals.get(argpos - numReqFormals) ? 1 : 0) != 0);
            return (JSType)this.optionalFormals.get(argpos - numReqFormals);
        }
        return this.restFormals;
    }

    public JSType getReturnType() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        if (this.isConstructor()) {
            return this.getTypeOfThis();
        }
        return this.returnType;
    }

    public JSType getOuterVarPrecondition(String name) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return (JSType)this.outerVarPreconditions.get((Object)name);
    }

    public int getMinArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return this.requiredFormals.size();
    }

    public int getMaxArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        if (this.restFormals != null) {
            return Integer.MAX_VALUE;
        }
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public JSType getTypeOfThis() {
        Preconditions.checkNotNull((Object)this.nominalType);
        return JSType.fromObjectType(ObjectType.fromNominalType(this.nominalType));
    }

    public JSType createConstructorObject() {
        Preconditions.checkState((this.nominalType != null ? 1 : 0) != 0);
        return this.nominalType.createConstructorObject(this);
    }

    private static JSType nullAcceptingMeet(JSType t1, JSType t2) {
        Preconditions.checkArgument((t1 != null || t2 != null ? 1 : 0) != 0);
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        return JSType.meet(t1, t2);
    }

    private static FunctionType looseJoin(FunctionType f1, FunctionType f2) {
        Preconditions.checkArgument((f1.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.getMinArity(), f2.getMinArity());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; i < maxTotalArity; ++i) {
            builder.addOptFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        return builder.addRetType(JSType.nullAcceptingJoin(f1.returnType, f2.returnType)).addLoose().buildFunction();
    }

    public boolean isSubtypeOf(FunctionType other) {
        if (other.isTopFunction() || other.isQmarkFunction() || this.isQmarkFunction()) {
            return true;
        }
        if (this.isTopFunction()) {
            return false;
        }
        if (this.isGeneric()) {
            return true;
        }
        Preconditions.checkState((!other.isGeneric() ? 1 : 0) != 0);
        Preconditions.checkState((!this.isLoose && !other.isLoose ? 1 : 0) != 0);
        if (this.requiredFormals.size() > other.requiredFormals.size()) {
            return false;
        }
        int otherMaxTotalArity = other.requiredFormals.size() + other.optionalFormals.size();
        for (int i = 0; i < otherMaxTotalArity; ++i) {
            JSType thisFormal = this.getFormalType(i);
            JSType otherFormal = other.getFormalType(i);
            if (thisFormal == null || thisFormal.isUnknown() || otherFormal.isUnknown() || otherFormal.isSubtypeOf(thisFormal)) continue;
            return false;
        }
        if (other.restFormals != null) {
            int thisMaxTotalArity = this.requiredFormals.size() + this.optionalFormals.size();
            if (this.restFormals != null) {
                ++thisMaxTotalArity;
            }
            for (int i = otherMaxTotalArity; i < thisMaxTotalArity; ++i) {
                JSType thisFormal = this.getFormalType(i);
                JSType otherFormal = other.getFormalType(i);
                if (thisFormal == null || thisFormal.isUnknown() || otherFormal.isUnknown() || otherFormal.isSubtypeOf(thisFormal)) continue;
                return false;
            }
        }
        if (this.nominalType == null && other.nominalType != null || this.nominalType != null && other.nominalType == null || this.nominalType != null && other.nominalType != null && !this.nominalType.isSubclassOf(other.nominalType)) {
            return false;
        }
        return this.returnType.isUnknown() || other.returnType.isUnknown() || this.returnType.isSubtypeOf(other.returnType);
    }

    static FunctionType join(FunctionType f1, FunctionType f2) {
        if (f1 == null) {
            return f2;
        }
        if (f2 == null || f1.equals(f2)) {
            return f1;
        }
        if (f1.isTopFunction() || f2.isTopFunction()) {
            return TOP_FUNCTION;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int maxRequiredArity = Math.max(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < maxRequiredArity; ++i) {
            JSType reqFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            builder.addReqFormal(reqFormal);
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = maxRequiredArity; i < maxTotalArity; ++i) {
            JSType optFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            builder.addOptFormal(optFormal);
        }
        if (f1.restFormals != null && f2.restFormals != null) {
            builder.addRestFormals(FunctionType.nullAcceptingMeet(f1.restFormals, f2.restFormals));
        }
        builder.addRetType(JSType.join(f1.returnType, f2.returnType));
        builder.addNominalType(NominalType.pickSuperclass(f1.nominalType, f2.nominalType));
        return builder.buildFunction();
    }

    FunctionType specialize(FunctionType other) {
        if (other == null || !this.isLoose() && other.isLoose()) {
            return this;
        }
        return FunctionType.meet(this, other);
    }

    static FunctionType meet(FunctionType f1, FunctionType f2) {
        if (f1 == null || f2 == null) {
            return null;
        }
        if (f2.isTopFunction() || f1.equals(f2)) {
            return f1;
        }
        if (f1.isTopFunction()) {
            return f2;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; i < maxTotalArity; ++i) {
            builder.addOptFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        if (f1.restFormals != null || f2.restFormals != null) {
            builder.addRestFormals(JSType.nullAcceptingJoin(f1.restFormals, f2.restFormals));
        }
        builder.addRetType(JSType.meet(f1.returnType, f2.returnType));
        builder.addNominalType(NominalType.pickSubclass(f1.nominalType, f2.nominalType));
        return builder.buildFunction();
    }

    boolean isLooseSubtypeOf(FunctionType f2) {
        Preconditions.checkState((this.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        if (this.isTopFunction() || f2.isTopFunction()) {
            return true;
        }
        int maxRequiredArity = Math.max(this.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < maxRequiredArity; ++i) {
            if (!JSType.meet(this.getFormalType(i), f2.getFormalType(i)).isBottom()) continue;
            return false;
        }
        return this.getReturnType().isBottom() || f2.getReturnType().isBottom() || !JSType.meet(this.getReturnType(), f2.getReturnType()).isBottom();
    }

    public boolean isGeneric() {
        return this.typeParameters != null;
    }

    public List<String> getTypeParameters() {
        return this.typeParameters;
    }

    boolean unifyWith(FunctionType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap) {
        Preconditions.checkState((this.nominalType == null ? 1 : 0) != 0);
        Preconditions.checkState((this.typeParameters == null ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.outerVarPreconditions.isEmpty());
        if (this.requiredFormals.size() != other.requiredFormals.size()) {
            return false;
        }
        UnmodifiableIterator thisReqFormals = this.requiredFormals.iterator();
        UnmodifiableIterator otherReqFormals = other.requiredFormals.iterator();
        while (thisReqFormals.hasNext()) {
            JSType otherReqFormal;
            JSType reqFormal = (JSType)thisReqFormals.next();
            if (reqFormal.unifyWith(otherReqFormal = (JSType)otherReqFormals.next(), typeParameters, typeMultimap)) continue;
            return false;
        }
        if (this.optionalFormals.size() != other.optionalFormals.size()) {
            return false;
        }
        UnmodifiableIterator thisOptFormals = this.optionalFormals.iterator();
        UnmodifiableIterator otherOptFormals = other.optionalFormals.iterator();
        while (thisOptFormals.hasNext()) {
            JSType otherOptFormal;
            JSType optFormal = (JSType)thisOptFormals.next();
            if (optFormal.unifyWith(otherOptFormal = (JSType)otherOptFormals.next(), typeParameters, typeMultimap)) continue;
            return false;
        }
        if (this.restFormals == null && other.restFormals != null || this.restFormals != null && other.restFormals == null) {
            return false;
        }
        if (this.restFormals != null && !this.restFormals.unifyWith(other.restFormals, typeParameters, typeMultimap)) {
            return false;
        }
        return this.returnType.unifyWith(other.returnType, typeParameters, typeMultimap);
    }

    private FunctionType applyInstantiation(boolean keepTypeParams, Map<String, JSType> typeMap) {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (JSType reqFormal : this.requiredFormals) {
            builder.addReqFormal(reqFormal.substituteGenerics(typeMap));
        }
        for (JSType optFormal : this.optionalFormals) {
            builder.addOptFormal(optFormal.substituteGenerics(typeMap));
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals.substituteGenerics(typeMap));
        }
        builder.addRetType(this.returnType.substituteGenerics(typeMap));
        if (this.isLoose) {
            builder.addLoose();
        }
        if (this.nominalType != null) {
            builder.addNominalType(this.nominalType.instantiateGenerics(typeMap));
        }
        for (String var : this.outerVarPreconditions.keySet()) {
            builder.addOuterVarPrecondition(var, (JSType)this.outerVarPreconditions.get((Object)var));
        }
        if (keepTypeParams) {
            builder.addTypeParameters(this.typeParameters);
        }
        return builder.buildFunction();
    }

    FunctionType substituteGenerics(Map<String, JSType> concreteTypes) {
        Preconditions.checkState((boolean)this.outerVarPreconditions.isEmpty());
        ImmutableMap typeMap = concreteTypes;
        if (this.typeParameters != null) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<String, JSType> concreteTypeEntry : concreteTypes.entrySet()) {
                if (this.typeParameters.contains((Object)concreteTypeEntry.getKey())) continue;
                builder.put((Object)concreteTypeEntry.getKey(), (Object)concreteTypeEntry.getValue());
            }
            typeMap = builder.build();
        }
        return this.applyInstantiation(true, (Map<String, JSType>)typeMap);
    }

    public FunctionType instantiateGenerics(Map<String, JSType> typeMap) {
        for (String typeParam : typeMap.keySet()) {
            Preconditions.checkState((boolean)this.typeParameters.contains((Object)typeParam));
        }
        return this.applyInstantiation(false, typeMap);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Preconditions.checkArgument((boolean)(obj instanceof FunctionType), (String)"obj is: %s", (Object[])new Object[]{obj});
        FunctionType f2 = (FunctionType)obj;
        return Objects.equals(this.requiredFormals, f2.requiredFormals) && Objects.equals(this.optionalFormals, f2.optionalFormals) && Objects.equals(this.restFormals, f2.restFormals) && Objects.equals(this.returnType, f2.returnType) && Objects.equals(this.nominalType, f2.nominalType);
    }

    public int hashCode() {
        return Objects.hash(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (this.isTopFunction()) {
            if (this.isLoose) {
                return builder.append("LOOSE_TOP_FUNCTION");
            }
            return builder.append("TOP_FUNCTION");
        }
        builder.append("function(");
        if (this.nominalType != null) {
            builder.append("new:");
            builder.append(this.nominalType.getName());
            builder.append(',');
        }
        for (i = 0; i < this.requiredFormals.size(); ++i) {
            ((JSType)this.requiredFormals.get(i)).appendTo(builder);
            builder.append(',');
        }
        for (i = 0; i < this.optionalFormals.size(); ++i) {
            ((JSType)this.optionalFormals.get(i)).appendTo(builder);
            builder.append("=,");
        }
        if (this.restFormals != null) {
            builder.append("...");
            this.restFormals.appendTo(builder);
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(')');
        if (this.returnType != null) {
            builder.append(':');
            this.returnType.appendTo(builder);
        }
        if (this.isLoose) {
            builder.append(" (loose)");
        }
        return builder;
    }
}

