/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.newtypes.DeclaredTypeRegistry;
import com.google.javascript.jscomp.newtypes.EnumType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.Typedef;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SimpleErrorReporter;
import com.google.javascript.rhino.Token;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSTypeCreatorFromJSDoc {
    private int howmanyTypeVars = 0;
    private static final JSType UNKNOWN_FUNCTION_OR_NULL = JSType.join(JSType.qmarkFunction(), JSType.NULL);
    private static final JSType OBJECT_OR_NULL = JSType.join(JSType.TOP_OBJECT, JSType.NULL);
    private SimpleErrorReporter reporter = new SimpleErrorReporter();
    private Map<Node, String> unknownTypeNames = Maps.newHashMap();

    public JSType getNodeTypeDeclaration(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry) {
        return this.getNodeTypeDeclaration(jsdoc, ownerType, registry, null);
    }

    private JSType getNodeTypeDeclaration(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (jsdoc == null) {
            return null;
        }
        return this.getTypeFromJSTypeExpression(jsdoc.getType(), ownerType, registry, typeParameters);
    }

    public Set<String> getWarnings() {
        HashSet warnings = Sets.newHashSet();
        if (this.reporter.warnings() != null) {
            warnings.addAll(this.reporter.warnings());
        }
        return warnings;
    }

    public Map<Node, String> getUnknownTypesMap() {
        return this.unknownTypeNames;
    }

    private JSType getTypeFromJSTypeExpression(JSTypeExpression expr, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        if (expr == null) {
            return null;
        }
        JSType result = this.getTypeFromNode(expr.getRootNode(), ownerType, registry, typeParameters);
        return result;
    }

    @VisibleForTesting
    JSType getTypeFromNode(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        try {
            return this.getTypeFromNodeHelper(n, ownerType, registry, typeParameters);
        }
        catch (UnknownTypeException e) {
            return JSType.UNKNOWN;
        }
    }

    private JSType getTypeFromNodeHelper(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        Preconditions.checkNotNull((Object)n);
        switch (n.getType()) {
            case 309: {
                return this.getRecordTypeHelper(n, ownerType, registry, typeParameters);
            }
            case 124: {
                return JSType.UNKNOWN;
            }
            case 122: {
                return JSType.UNDEFINED;
            }
            case 308: {
                this.warn("The [] type syntax is no longer supported. Please use Array.<T> instead.", n);
                return JSType.UNKNOWN;
            }
            case 40: {
                return this.getNamedTypeHelper(n, ownerType, registry, typeParameters);
            }
            case 301: {
                JSType union = JSType.BOTTOM;
                for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                    union = JSType.join(union, this.getTypeFromNodeHelper(child, ownerType, registry, typeParameters));
                }
                return union;
            }
            case 306: {
                return this.getTypeFromNodeHelper(n.getFirstChild(), ownerType, registry, typeParameters).removeType(JSType.NULL);
            }
            case 304: {
                Node child = n.getFirstChild();
                if (child == null) {
                    return JSType.UNKNOWN;
                }
                return JSType.join(JSType.NULL, this.getTypeFromNodeHelper(child, ownerType, registry, typeParameters));
            }
            case 302: {
                return JSType.TOP;
            }
            case 105: {
                return this.getFunTypeHelper(n, ownerType, registry, typeParameters);
            }
        }
        throw new IllegalArgumentException("Unsupported type exp: " + Token.name(n.getType()) + " " + n.toStringTree());
    }

    private JSType getRecordTypeHelper(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        HashMap fields = Maps.newHashMap();
        for (Node fieldTypeNode = n.getFirstChild().getFirstChild(); fieldTypeNode != null; fieldTypeNode = fieldTypeNode.getNext()) {
            boolean isFieldTypeDeclared = fieldTypeNode.getType() == 310;
            Node fieldNameNode = isFieldTypeDeclared ? fieldTypeNode.getFirstChild() : fieldTypeNode;
            String fieldName = fieldNameNode.getString();
            if (fieldName.startsWith("'") || fieldName.startsWith("\"")) {
                fieldName = fieldName.substring(1, fieldName.length() - 1);
            }
            JSType fieldType = !isFieldTypeDeclared ? JSType.UNKNOWN : this.getTypeFromNodeHelper(fieldTypeNode.getLastChild(), ownerType, registry, typeParameters);
            fields.put(fieldName, fieldType);
        }
        return JSType.fromObjectType(ObjectType.fromProperties(fields));
    }

    private static boolean isNonnullAndContains(ImmutableList<String> collection, String str) {
        return collection != null && collection.contains((Object)str);
    }

    private static boolean hasTypeVariable(ImmutableList<String> typeParameters, NominalType.RawNominalType ownerType, String typeName) {
        return JSTypeCreatorFromJSDoc.isNonnullAndContains(typeParameters, typeName) || ownerType != null && JSTypeCreatorFromJSDoc.isNonnullAndContains(ownerType.getTypeParameters(), typeName);
    }

    private JSType getNamedTypeHelper(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> outerTypeParameters) throws UnknownTypeException {
        String typeName;
        switch (typeName = n.getString()) {
            case "boolean": {
                return JSType.BOOLEAN;
            }
            case "null": {
                return JSType.NULL;
            }
            case "number": {
                return JSType.NUMBER;
            }
            case "string": {
                return JSType.STRING;
            }
            case "undefined": 
            case "void": {
                return JSType.UNDEFINED;
            }
            case "Function": {
                return UNKNOWN_FUNCTION_OR_NULL;
            }
            case "Object": {
                return OBJECT_OR_NULL;
            }
        }
        if (JSTypeCreatorFromJSDoc.hasTypeVariable(outerTypeParameters, ownerType, typeName)) {
            return JSType.fromTypeVar(typeName);
        }
        if (registry.getTypedef(typeName) != null) {
            return this.getTypedefType(typeName, registry);
        }
        if (registry.getEnum(typeName) != null) {
            return this.getEnumPropType(typeName, registry);
        }
        JSType namedType = registry.lookupTypeByName(typeName);
        if (namedType == null) {
            this.unknownTypeNames.put(n, typeName);
            throw new UnknownTypeException("Unhandled type: " + typeName);
        }
        if (namedType.isTypeVariable()) {
            ++this.howmanyTypeVars;
            return namedType;
        }
        return this.getNominalTypeHelper(namedType, n, ownerType, registry, outerTypeParameters);
    }

    private JSType getTypedefType(String name, DeclaredTypeRegistry registry) {
        this.resolveTypedef(name, registry);
        return registry.getTypedef(name).getType();
    }

    public void resolveTypedef(String name, DeclaredTypeRegistry registry) {
        JSType tdType;
        Typedef td = registry.getTypedef(name);
        Preconditions.checkState((td != null ? 1 : 0) != 0, (Object)"getTypedef should only be called when we know that the typedef is defined");
        if (td.isResolved()) {
            return;
        }
        JSTypeExpression texp = td.getTypeExpr();
        if (texp == null) {
            this.warn("Circular type definitions are not allowed.", td.getTypeExprForErrorReporting().getRootNode());
            tdType = JSType.UNKNOWN;
        } else {
            tdType = this.getTypeFromJSTypeExpression(texp, null, registry, null);
        }
        td.resolveTypedef(tdType);
    }

    private JSType getEnumPropType(String name, DeclaredTypeRegistry registry) {
        this.resolveEnum(name, registry);
        return registry.getEnum(name).getPropType();
    }

    public void resolveEnum(String name, DeclaredTypeRegistry registry) {
        JSType enumeratedType;
        EnumType e = registry.getEnum(name);
        Preconditions.checkState((e != null ? 1 : 0) != 0, (Object)"getEnum should only be called when we know that the enum is defined");
        if (e.isResolved()) {
            return;
        }
        JSTypeExpression texp = e.getTypeExpr();
        if (texp == null) {
            this.warn("Circular type definitions are not allowed.", e.getTypeExprForErrorReporting().getRootNode());
            enumeratedType = JSType.UNKNOWN;
        } else {
            int numTypeVars = this.howmanyTypeVars;
            enumeratedType = this.getTypeFromJSTypeExpression(texp, null, registry, null);
            if (this.howmanyTypeVars > numTypeVars) {
                this.warn("An enum type cannot include type variables.", texp.getRootNode());
                enumeratedType = JSType.UNKNOWN;
                this.howmanyTypeVars = numTypeVars;
            } else if (enumeratedType.isTop()) {
                this.warn("An enum type cannot be *. Use ? if you do not want the elements checked.", texp.getRootNode());
                enumeratedType = JSType.UNKNOWN;
            } else if (enumeratedType.isUnion()) {
                this.warn("An enum type cannot be a union type.", texp.getRootNode());
                enumeratedType = JSType.UNKNOWN;
            }
        }
        e.resolveEnum(enumeratedType);
    }

    private JSType getNominalTypeHelper(JSType namedType, Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> outerTypeParameters) throws UnknownTypeException {
        NominalType uninstantiated = namedType.getNominalTypeIfUnique();
        NominalType.RawNominalType rawType = uninstantiated.getRawNominalType();
        if (!rawType.isGeneric() && !n.hasChildren()) {
            return rawType.getInstanceAsNullableJSType();
        }
        if (!n.hasChildren()) {
            ImmutableList.Builder typeList = ImmutableList.builder();
            for (String unused : rawType.getTypeParameters()) {
                typeList.add((Object)JSType.UNKNOWN);
            }
            return JSType.join(JSType.NULL, JSType.fromObjectType(ObjectType.fromNominalType(uninstantiated.instantiateGenerics((List<JSType>)typeList.build()))));
        }
        Preconditions.checkState((boolean)n.getFirstChild().isBlock());
        ImmutableList.Builder typeList = ImmutableList.builder();
        for (Node child : n.getFirstChild().children()) {
            JSType childType = this.getTypeFromNodeHelper(child, ownerType, registry, outerTypeParameters);
            typeList.add((Object)childType);
        }
        ImmutableList typeArguments = typeList.build();
        ImmutableList<String> typeParameters = rawType.getTypeParameters();
        if (typeArguments.size() != typeParameters.size()) {
            this.warn("Invalid generics instantiation.\nExpected " + typeParameters.size() + " type arguments, but " + typeArguments.size() + " were passed.", n);
            return JSType.join(JSType.NULL, JSType.fromObjectType(ObjectType.fromNominalType(uninstantiated.instantiateGenerics(JSType.fixLengthOfTypeList(typeParameters.size(), (List<JSType>)typeArguments)))));
        }
        return JSType.join(JSType.NULL, JSType.fromObjectType(ObjectType.fromNominalType(uninstantiated.instantiateGenerics((List<JSType>)typeArguments))));
    }

    private JSType getFunTypeHelper(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        return this.getFunTypeBuilder(n, ownerType, registry, typeParameters).buildType();
    }

    private FunctionTypeBuilder getFunTypeBuilder(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) throws UnknownTypeException {
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        Node child = n.getFirstChild();
        if (child.getType() == 42) {
            builder.addReceiverType(this.getNominalType(child.getFirstChild(), ownerType, registry, typeParameters));
            child = child.getNext();
        } else if (child.getType() == 30) {
            builder.addNominalType(this.getNominalType(child.getFirstChild(), ownerType, registry, typeParameters));
            child = child.getNext();
        }
        if (child.getType() == 83) {
            for (Node arg = child.getFirstChild(); arg != null; arg = arg.getNext()) {
                try {
                    switch (arg.getType()) {
                        case 307: {
                            builder.addOptFormal(this.getTypeFromNodeHelper(arg.getFirstChild(), ownerType, registry, typeParameters));
                            break;
                        }
                        case 305: {
                            Node restNode = arg.getFirstChild();
                            builder.addRestFormals(restNode == null ? JSType.UNKNOWN : this.getTypeFromNodeHelper(restNode, ownerType, registry, typeParameters));
                            break;
                        }
                        default: {
                            builder.addReqFormal(this.getTypeFromNodeHelper(arg, ownerType, registry, typeParameters));
                            break;
                        }
                    }
                    continue;
                }
                catch (FunctionTypeBuilder.WrongParameterOrderException e) {
                    this.warn("Wrong parameter order: required parameters are first, then optional, then varargs", n);
                }
            }
            child = child.getNext();
        }
        builder.addRetType(this.getTypeFromNodeHelper(child, ownerType, registry, typeParameters));
        return builder;
    }

    public boolean hasKnownType(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        try {
            this.getTypeFromNodeHelper(n, ownerType, registry, typeParameters);
        }
        catch (UnknownTypeException e) {
            return false;
        }
        return true;
    }

    public NominalType getNominalType(Node n, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        JSType wrappedClass = this.getTypeFromNode(n, ownerType, registry, typeParameters);
        if (wrappedClass == null) {
            return null;
        }
        return wrappedClass.getNominalTypeIfUnique();
    }

    public ImmutableSet<NominalType> getImplementedInterfaces(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getInterfacesHelper(jsdoc, ownerType, registry, typeParameters, true);
    }

    public ImmutableSet<NominalType> getExtendedInterfaces(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters) {
        return this.getInterfacesHelper(jsdoc, ownerType, registry, typeParameters, false);
    }

    private ImmutableSet<NominalType> getInterfacesHelper(JSDocInfo jsdoc, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, ImmutableList<String> typeParameters, boolean implementedIntfs) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (JSTypeExpression texp : implementedIntfs ? jsdoc.getImplementedInterfaces() : jsdoc.getExtendedInterfaces()) {
            Node expRoot = texp.getRootNode();
            if (!this.hasKnownType(expRoot, ownerType, registry, typeParameters)) continue;
            NominalType nt = this.getNominalType(expRoot, ownerType, registry, typeParameters);
            if (nt != null && nt.isInterface()) {
                builder.add((Object)nt);
                continue;
            }
            String errorMsg = implementedIntfs ? "Cannot implement non-interface" : "Cannot extend non-interface";
            this.warn(errorMsg, jsdoc.getAssociatedNode());
        }
        return builder.build();
    }

    private static boolean isQmarkFunction(Node jsdocNode) {
        if (jsdocNode.getType() == 306) {
            jsdocNode = jsdocNode.getFirstChild();
        }
        return jsdocNode.isString() && jsdocNode.getString().equals("Function");
    }

    public FunctionTypeBuilder getFunctionType(JSDocInfo jsdoc, Node declNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry) {
        try {
            if (jsdoc != null && jsdoc.getType() != null) {
                Node jsdocNode = jsdoc.getType().getRootNode();
                int tokenType = jsdocNode.getType();
                if (tokenType == 105) {
                    if (declNode.isFunction()) {
                        return this.getFunTypeFromAtTypeJsdoc(jsdoc, declNode, ownerType, registry);
                    }
                    try {
                        return this.getFunTypeBuilder(jsdocNode, ownerType, registry, null);
                    }
                    catch (UnknownTypeException e) {
                        return FunctionTypeBuilder.qmarkFunctionBuilder();
                    }
                }
                if (JSTypeCreatorFromJSDoc.isQmarkFunction(jsdocNode)) {
                    return FunctionTypeBuilder.qmarkFunctionBuilder();
                }
                this.warn("The function is annotated with a non-function jsdoc. Ignoring jsdoc.", declNode);
            }
            return this.getFunTypeFromTypicalFunctionJsdoc(jsdoc, declNode, ownerType, registry, false);
        }
        catch (FunctionTypeBuilder.WrongParameterOrderException e) {
            this.warn("Wrong parameter order: required parameters are first, then optional, then varargs. Ignoring jsdoc.", declNode);
            return this.getFunTypeFromTypicalFunctionJsdoc(null, declNode, ownerType, registry, true);
        }
    }

    private FunctionTypeBuilder getFunTypeFromAtTypeJsdoc(JSDocInfo jsdoc, Node funNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry) {
        Node paramType;
        Preconditions.checkArgument((boolean)funNode.isFunction());
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        Node childJsdoc = jsdoc.getType().getRootNode().getFirstChild();
        Node param = funNode.getFirstChild().getNext().getFirstChild();
        boolean warnedForMissingTypes = false;
        boolean warnedForInlineJsdoc = false;
        if (childJsdoc.getType() == 42) {
            builder.addReceiverType(this.getNominalType(childJsdoc.getFirstChild(), ownerType, registry, null));
            childJsdoc = childJsdoc.getNext();
        } else if (childJsdoc.getType() == 30) {
            builder.addNominalType(this.getNominalType(childJsdoc.getFirstChild(), ownerType, registry, null));
            childJsdoc = childJsdoc.getNext();
        }
        if (childJsdoc.getType() == 83) {
            paramType = childJsdoc.getFirstChild();
            childJsdoc = childJsdoc.getNext();
        } else {
            paramType = null;
        }
        while (param != null) {
            if (paramType == null) {
                if (!warnedForMissingTypes) {
                    this.warn("The function has more formal parameters than the types declared in the JSDoc", funNode);
                    warnedForMissingTypes = true;
                }
                builder.addOptFormal(JSType.UNKNOWN);
            } else {
                if (!warnedForInlineJsdoc && param.getJSDocInfo() != null) {
                    this.warn("The function cannot have both an @type jsdoc and inline jsdocs. Ignoring inline jsdocs.", param);
                    warnedForInlineJsdoc = true;
                }
                switch (paramType.getType()) {
                    case 307: {
                        builder.addOptFormal(this.getTypeFromNode(paramType.getFirstChild(), ownerType, registry, null));
                        break;
                    }
                    case 305: {
                        if (warnedForMissingTypes) break;
                        this.warn("The function has more formal parameters than the types declared in the JSDoc", funNode);
                        warnedForMissingTypes = true;
                        builder.addOptFormal(JSType.UNKNOWN);
                        break;
                    }
                    default: {
                        builder.addReqFormal(this.getTypeFromNode(paramType, ownerType, registry, null));
                    }
                }
                paramType = paramType.getNext();
            }
            param = param.getNext();
        }
        if (paramType != null) {
            if (paramType.getType() == 305) {
                builder.addRestFormals(this.getTypeFromNode(paramType.getFirstChild(), ownerType, registry, null));
            } else {
                this.warn("The function has fewer formal parameters than the types declared in the JSDoc", funNode);
            }
        }
        if (!warnedForInlineJsdoc && funNode.getFirstChild().getJSDocInfo() != null) {
            this.warn("The function cannot have both an @type jsdoc and inline jsdocs. Ignoring the inline return jsdoc.", funNode);
        }
        if (jsdoc.getReturnType() != null) {
            this.warn("The function cannot have both an @type jsdoc and @return jsdoc. Ignoring @return jsdoc.", funNode);
        }
        if (funNode.getParent().isSetterDef()) {
            if (childJsdoc != null) {
                this.warn("Cannot declare a return type on a setter", funNode);
            }
            builder.addRetType(JSType.UNDEFINED);
        } else {
            builder.addRetType(this.getTypeFromNode(childJsdoc, ownerType, registry, null));
        }
        return builder;
    }

    private FunctionTypeBuilder getFunTypeFromTypicalFunctionJsdoc(JSDocInfo jsdoc, Node funNode, NominalType.RawNominalType ownerType, DeclaredTypeRegistry registry, boolean ignoreJsdoc) {
        JSTypeExpression retTypeExp;
        Preconditions.checkArgument((!ignoreJsdoc || jsdoc == null ? 1 : 0) != 0);
        if (!funNode.isFunction()) {
            return FunctionTypeBuilder.qmarkFunctionBuilder();
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        Node params = funNode.getFirstChild().getNext();
        ImmutableList<String> typeParameters = null;
        Node parent = funNode.getParent();
        if (jsdoc != null && !(typeParameters = jsdoc.getTemplateTypeNames()).isEmpty()) {
            if (parent.isSetterDef() || parent.isGetterDef()) {
                ignoreJsdoc = true;
                jsdoc = null;
                this.warn("@template can't be used with getters/setters", funNode);
            } else {
                builder.addTypeParameters(typeParameters);
            }
        }
        for (Node param = params.getFirstChild(); param != null; param = param.getNext()) {
            Node jsdocNode;
            String pname = param.getString();
            JSType inlineParamType = ignoreJsdoc ? null : this.getNodeTypeDeclaration(param.getJSDocInfo(), ownerType, registry, typeParameters);
            boolean isRequired = true;
            boolean isRestFormals = false;
            JSTypeExpression texp = jsdoc == null ? null : jsdoc.getParameterType(pname);
            Node node = jsdocNode = texp == null ? null : texp.getRootNode();
            if (jsdocNode != null && jsdocNode.getType() == 307) {
                isRequired = false;
                jsdocNode = jsdocNode.getFirstChild();
            } else if (jsdocNode != null && jsdocNode.getType() == 305) {
                isRequired = false;
                isRestFormals = true;
                jsdocNode = jsdocNode.getFirstChild();
            }
            JSType fnParamType = null;
            if (jsdocNode != null) {
                fnParamType = this.getTypeFromNode(jsdocNode, ownerType, registry, typeParameters);
            }
            if (inlineParamType != null) {
                builder.addReqFormal(inlineParamType);
                if (fnParamType == null) continue;
                this.warn("Found two JsDoc comments for formal parameter " + pname, param);
                continue;
            }
            if (isRequired) {
                builder.addReqFormal(fnParamType);
                continue;
            }
            if (isRestFormals) {
                builder.addRestFormals(fnParamType);
                continue;
            }
            builder.addOptFormal(fnParamType);
        }
        JSDocInfo inlineRetJsdoc = ignoreJsdoc ? null : funNode.getFirstChild().getJSDocInfo();
        JSTypeExpression jSTypeExpression = retTypeExp = jsdoc == null ? null : jsdoc.getReturnType();
        if (parent.isSetterDef()) {
            JSDocInfo jSDocInfo = inlineRetJsdoc = ignoreJsdoc ? null : funNode.getLastChild().getJSDocInfo();
            if (retTypeExp != null || inlineRetJsdoc != null) {
                this.warn("Cannot declare a return type on a setter", funNode);
            }
            builder.addRetType(JSType.UNDEFINED);
        } else if (inlineRetJsdoc != null) {
            builder.addRetType(this.getNodeTypeDeclaration(inlineRetJsdoc, ownerType, registry, typeParameters));
            if (retTypeExp != null) {
                this.warn("Found two JsDoc comments for the return type", funNode);
            }
        } else {
            builder.addRetType(this.getTypeFromJSTypeExpression(retTypeExp, ownerType, registry, typeParameters));
        }
        return builder;
    }

    public static boolean isRestArg(JSDocInfo funJsdoc, String formalParamName) {
        if (funJsdoc == null) {
            return false;
        }
        JSTypeExpression texp = funJsdoc.getParameterType(formalParamName);
        Node jsdocNode = texp == null ? null : texp.getRootNode();
        return jsdocNode != null && jsdocNode.getType() == 305;
    }

    void warn(String msg, Node faultyNode) {
        this.reporter.warning(msg, faultyNode.getSourceFileName(), faultyNode.getLineno(), faultyNode.getCharno());
    }

    public static class UnknownTypeException
    extends Exception {
        UnknownTypeException(String cause) {
            super(cause);
        }
    }
}

